/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.collection;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetMap<K, V> {
    private final Map<K, SetImpl> map = new HashMap<K, SetImpl>();

    public Set<V> peek(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.map.get(key);
    }

    public Set<V> get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Set set = this.map.get(key);
        if (set == null) {
            set = new SetImpl(key);
        }
        return set;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public String toString() {
        return this.map.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetImpl
    extends AbstractSet<V> {
        private final K key;
        private HashSet<V> set;
        private boolean added;

        private SetImpl(K key) {
            this.key = key;
            this.set = new HashSet();
            this.added = false;
        }

        @Override
        public boolean add(V e) {
            if (!this.added) {
                if (SetMap.this.map.containsKey(this.key)) {
                    throw new IllegalStateException();
                }
                SetMap.this.map.put(this.key, this);
                this.added = true;
            }
            return this.set.add(e);
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                final Iterator<V> iterator;
                {
                    this.iterator = SetImpl.this.set.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public V next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    this.iterator.remove();
                    if (SetImpl.this.set.size() == 0) {
                        if (SetMap.this.map.containsKey(SetImpl.this.key)) {
                            SetMap.this.map.remove(SetImpl.this.key);
                        } else {
                            throw new IllegalStateException();
                        }
                    }
                }
            };
        }

        @Override
        public int size() {
            return this.set.size();
        }
    }
}

