/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.bench;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import java.io.IOException;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.exoplatform.mail.service.MailService;
import org.picocontainer.Startable;

public class SimpleMailServerInitializer
implements Startable {
    private GreenMail greenMail = new GreenMail();
    private String host = "localhost";

    private MimeMessage newMimeMessage(String to, String from, String subject, String body, byte[] attachment, String contentType, String filename, String description) throws MessagingException {
        InternetAddress[] froms = new InternetAddress[]{new InternetAddress(from)};
        MimeMessage mimeMessage = new MimeMessage(this.getSmtpSession());
        mimeMessage.setSubject(subject);
        mimeMessage.setFrom((Address)froms[0]);
        mimeMessage.setSentDate(new Date());
        MimeMultipart multipPartContent = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)body, "text/html; charset=utf-8");
        multipPartContent.addBodyPart((BodyPart)mimeBodyPart);
        mimeBodyPart = new MimeBodyPart();
        ByteArrayDataSource source = new ByteArrayDataSource(attachment, contentType);
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)source));
        mimeBodyPart.setDisposition("attachment");
        mimeBodyPart.setFileName(filename);
        multipPartContent.addBodyPart((BodyPart)mimeBodyPart);
        mimeMessage.setContent((Multipart)multipPartContent);
        return mimeMessage;
    }

    public SimpleMailServerInitializer(MailService mailService) {
    }

    public Session getSmtpSession() {
        return GreenMailUtil.getSession((ServerSetup)ServerSetupTest.SMTP);
    }

    public Session getImapSession() {
        return GreenMailUtil.getSession((ServerSetup)ServerSetupTest.IMAP);
    }

    public Session getPop3Session() {
        return GreenMailUtil.getSession((ServerSetup)ServerSetupTest.POP3);
    }

    public void addUser(String email, String password) {
        this.greenMail.setUser(email, password);
    }

    public void addUser(String email, String username, String password) {
        this.greenMail.setUser(email, username, password);
    }

    public void sendMailMessage(String to, String from, String subject, String body, byte[] attachment, String filename, String description) throws MessagingException, IOException {
        MimeMessage message = this.newMimeMessage(to, from, subject, body, attachment, "text/html; charset=utf-8", filename, description);
        InternetAddress[] tos = new InternetAddress[]{new InternetAddress(to)};
        Transport.send((Message)message, (Address[])tos);
    }

    public void sendMailMessage(String to, String from, String subject, String body) {
        GreenMailUtil.sendTextEmail((String)to, (String)from, (String)subject, (String)body, (ServerSetup)ServerSetupTest.SMTP);
    }

    public String getImapPort() {
        return String.valueOf(ServerSetupTest.IMAP.getPort());
    }

    public String getImapProtocol() {
        return ServerSetupTest.IMAP.getProtocol();
    }

    public String getPop3Port() {
        return String.valueOf(ServerSetupTest.POP3.getPort());
    }

    public String getPop3Protocol() {
        return ServerSetupTest.POP3.getProtocol();
    }

    public String getSmtpPort() {
        return String.valueOf(ServerSetupTest.SMTP.getPort());
    }

    public String getSmtpProtocol() {
        return ServerSetupTest.SMTP.getProtocol();
    }

    public String getHost() {
        return this.host;
    }

    public void start() {
        this.greenMail.start();
    }

    public void stop() {
        this.greenMail.stop();
    }
}

