/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.Collection;
import java.util.LinkedList;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeQueue;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/navigation/UIPageNodeSelector.gtmpl")
public class UIPageNodeSelector
extends UIContainer {
    private UserNode rootNode;
    private UserNode selectedNode;
    private UserPortal userPortal;
    private UserNodeFilterConfig userFilterConfig;

    public UIPageNodeSelector() throws Exception {
        UITree uiTree = (UITree)this.addChild(UITree.class, null, "TreePageSelector");
        uiTree.setIcon("DefaultPageIcon");
        uiTree.setSelectedIcon("DefaultPageIcon");
        uiTree.setBeanIdField("URI");
        uiTree.setBeanLabelField("encodedResolvedLabel");
        uiTree.setBeanIconField("icon");
        uiTree.setBeanChildCountField("childrenCount");
        this.userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
        filterConfigBuilder.withReadWriteCheck();
        this.userFilterConfig = filterConfigBuilder.build();
    }

    public void configure(UserNode node) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("node can't be null");
        }
        this.rootNode = node;
        while (this.rootNode.getParent() != null) {
            this.rootNode = this.rootNode.getParent();
        }
        this.setSelectedNode(node);
    }

    private void setSelectedNode(UserNode node) throws Exception {
        if ((node = this.updateNode(node)) == null) {
            node = this.getRootNode();
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        tree.setSelected((Object)node);
        UserNode parent = node.getParent();
        if (parent != null) {
            tree.setChildren(node.getChildren());
            tree.setSibbling(this.getChildren(parent));
            tree.setParentSelected((Object)parent);
        } else {
            tree.setChildren(null);
            tree.setSibbling(this.getChildren(node));
            tree.setParentSelected((Object)node);
        }
        this.selectedNode = node;
    }

    private Collection<UserNode> getChildren(UserNode parent) throws Exception {
        Collection children = parent.getChildren();
        LinkedList<UserNode> holder = new LinkedList<UserNode>();
        for (UserNode child : children) {
            UserNode nodeResolved = this.resolveNode(child, this.userFilterConfig);
            if (nodeResolved == null) continue;
            holder.add(nodeResolved);
        }
        return holder;
    }

    private UserNode resolveNode(UserNode selectedNode, UserNodeFilterConfig filterConfig) throws Exception {
        UserNavigation currNav = selectedNode.getNavigation();
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        if (currNav.getKey().getType().equals((Object)SiteType.USER)) {
            return userPortal.getNode(currNav, Scope.CHILDREN, filterConfig, null);
        }
        return userPortal.resolvePath(currNav, filterConfig, selectedNode.getURI());
    }

    private UserNode updateNode(UserNode node) throws Exception {
        if (node == null) {
            return null;
        }
        NodeChangeQueue queue = new NodeChangeQueue();
        this.userPortal.updateNode(node, Scope.GRANDCHILDREN, (NodeChangeListener)queue);
        for (NodeChange change : queue) {
            UserNode deletedNode;
            if (!(change instanceof NodeChange.Removed) || this.findUserNodeByURI(deletedNode = (UserNode)((NodeChange.Removed)change).getTarget(), node.getURI()) == null) continue;
            return null;
        }
        UserNavigation nav = this.userPortal.getNavigation(node.getNavigation().getKey());
        return this.userPortal.resolvePath(nav, null, node.getURI());
    }

    public void setSelectedURI(String uri) throws Exception {
        if (this.selectedNode == null) {
            throw new IllegalStateException("selectedNode is null, configure method must be called first");
        }
        UserNode node = this.selectedNode.getParent() != null ? this.findUserNodeByURI(this.selectedNode.getParent(), uri) : this.findUserNodeByURI(this.selectedNode, uri);
        this.setSelectedNode(node);
    }

    private UserNode findUserNodeByURI(UserNode rootNode, String uri) {
        if (rootNode.getURI().equals(uri)) {
            return rootNode;
        }
        for (UserNode next : rootNode.getChildren()) {
            UserNode node = this.findUserNodeByURI(next, uri);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.getChild(UIRightClickPopupMenu.class);
        if (uiPopupMenu != null) {
            uiPopupMenu.setRendered(true);
        }
        super.processRender(context);
    }

    private UserNode getRootNode() {
        return this.rootNode;
    }

    public UserNode getSelectedNode() {
        return this.selectedNode;
    }

    public UserNavigation getNavigation() {
        return this.selectedNode.getNavigation();
    }
}

