/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceURL;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeQueue;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.navigation.TreeNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPortalNavigation
extends UIComponent {
    private boolean useAJAX = true;
    private boolean showUserNavigation = true;
    private TreeNode treeNode_;
    private String cssClassName = "";
    private String template;
    private final UserNodeFilterConfig NAVIGATION_FILTER_CONFIG;
    private Scope navigationScope;
    private Log log = ExoLogger.getExoLogger(UIPortalNavigation.class);

    public UIPortalNavigation() {
        UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
        filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
        filterConfigBuilder.withTemporalCheck();
        this.NAVIGATION_FILTER_CONFIG = filterConfigBuilder.build();
    }

    public String getTemplate() {
        return this.template != null ? this.template : super.getTemplate();
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public UIComponent getViewModeUIComponent() {
        return null;
    }

    public void setUseAjax(boolean bl) {
        this.useAJAX = bl;
    }

    public boolean isUseAjax() {
        return this.useAJAX;
    }

    public boolean isShowUserNavigation() {
        return this.showUserNavigation;
    }

    public void setShowUserNavigation(boolean showUserNavigation) {
        this.showUserNavigation = showUserNavigation;
    }

    public void setCssClassName(String cssClassName) {
        this.cssClassName = cssClassName;
    }

    public String getCssClassName() {
        return this.cssClassName;
    }

    public List<UserNode> getNavigations() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ArrayList<UserNode> nodes = new ArrayList<UserNode>();
        if (context.getRemoteUser() != null) {
            UserNode currRootNode = this.getCurrentNavigation();
            if (currRootNode != null) {
                nodes.add(currRootNode);
            }
        } else {
            UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
            List navigations = userPortal.getNavigations();
            for (UserNavigation userNav : navigations) {
                UserNode rootNode;
                if (!this.showUserNavigation && userNav.getKey().getType().equals((Object)SiteType.USER) || (rootNode = userPortal.getNode(userNav, this.navigationScope, this.NAVIGATION_FILTER_CONFIG, null)) == null) continue;
                nodes.add(rootNode);
            }
        }
        return nodes;
    }

    public void loadTreeNodes() throws Exception {
        this.treeNode_ = new TreeNode();
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        List listNavigations = userPortal.getNavigations();
        LinkedList<UserNode> childNodes = new LinkedList<UserNode>();
        for (UserNavigation nav : this.rearrangeNavigations(listNavigations)) {
            if (!this.showUserNavigation && nav.getKey().getType().equals((Object)SiteType.USER)) continue;
            try {
                UserNode rootNode = userPortal.getNode(nav, this.navigationScope, this.NAVIGATION_FILTER_CONFIG, null);
                if (rootNode == null) continue;
                childNodes.addAll(rootNode.getChildren());
            }
            catch (Exception ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        this.treeNode_.setChildren(childNodes);
    }

    public UserNode resolvePath(String path) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        UserNode node = context.getRemoteUser() != null ? userPortal.resolvePath(Util.getUIPortal().getUserNavigation(), this.NAVIGATION_FILTER_CONFIG, path) : userPortal.resolvePath(this.NAVIGATION_FILTER_CONFIG, path);
        if (node != null && !node.getURI().equals(path)) {
            return null;
        }
        return this.updateNode(node);
    }

    public UserNode updateNode(UserNode node) throws Exception {
        if (node == null) {
            return null;
        }
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        NodeChangeQueue queue = new NodeChangeQueue();
        userPortal.updateNode(node, this.navigationScope, (NodeChangeListener)queue);
        for (NodeChange change : queue) {
            UserNode deletedNode;
            if (!(change instanceof NodeChange.Removed) || !this.hasRelationship(deletedNode = (UserNode)((NodeChange.Removed)change).getTarget(), node)) continue;
            return null;
        }
        return node;
    }

    private boolean hasRelationship(UserNode parent, UserNode userNode) {
        if (parent.getId().equals(userNode.getId())) {
            return true;
        }
        for (UserNode child : parent.getChildren()) {
            if (!this.hasRelationship(child, userNode)) continue;
            return true;
        }
        return false;
    }

    private List<UserNavigation> rearrangeNavigations(List<UserNavigation> listNavigation) {
        ArrayList<UserNavigation> returnNavs = new ArrayList<UserNavigation>();
        ArrayList<UserNavigation> portalNavs = new ArrayList<UserNavigation>();
        ArrayList<UserNavigation> groupNavs = new ArrayList<UserNavigation>();
        ArrayList<UserNavigation> userNavs = new ArrayList<UserNavigation>();
        for (UserNavigation nav : listNavigation) {
            SiteType siteType = nav.getKey().getType();
            switch (siteType) {
                case PORTAL: {
                    portalNavs.add(nav);
                    break;
                }
                case GROUP: {
                    groupNavs.add(nav);
                    break;
                }
                case USER: {
                    userNavs.add(nav);
                }
            }
        }
        returnNavs.addAll(portalNavs);
        returnNavs.addAll(groupNavs);
        returnNavs.addAll(userNavs);
        return returnNavs;
    }

    public TreeNode getTreeNodes() {
        return this.treeNode_;
    }

    public UserNode getSelectedNode() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        if (uiPortal != null) {
            return uiPortal.getSelectedUserNode();
        }
        return null;
    }

    private UserNode getCurrentNavigation() throws Exception {
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        UserNavigation userNavigation = Util.getUIPortal().getUserNavigation();
        try {
            UserNode rootNode = userPortal.getNode(userNavigation, this.navigationScope, this.NAVIGATION_FILTER_CONFIG, null);
            return rootNode;
        }
        catch (Exception ex) {
            this.log.error((Object)"Navigation has been deleted");
            return null;
        }
    }

    public String createServeResourceURL(String nodeUri) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        MimeResponse response = (MimeResponse)context.getResponse();
        ResourceURL resourceUrl = response.createResourceURL();
        resourceUrl.setResourceID(nodeUri);
        StringWriter w = new StringWriter();
        resourceUrl.write((Writer)w, true);
        return ((Object)w).toString();
    }

    public void setScope(Scope scope) {
        this.navigationScope = scope;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollapseAllNodeActionListener
    extends EventListener<UIPortalNavigation> {
        public void execute(Event<UIPortalNavigation> event) throws Exception {
            UIPortalNavigation uiNavigation = (UIPortalNavigation)((Object)event.getSource());
            uiNavigation.loadTreeNodes();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNavigation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollapseNodeActionListener
    extends EventListener<UIPortalNavigation> {
        public void execute(Event<UIPortalNavigation> event) throws Exception {
            String treePath = event.getRequestContext().getRequestParameter("objectId");
            UIPortalNavigation uiNavigation = (UIPortalNavigation)((Object)event.getSource());
            TreeNode rootNode = uiNavigation.getTreeNodes();
            TreeNode collapseTree = rootNode.findNodes(treePath);
            if (collapseTree != null) {
                collapseTree.setExpanded(false);
            }
            Util.getPortalRequestContext().setResponseComplete(true);
        }
    }
}

