/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.webui.application.WebuiRequestContext;

public abstract class UIPageFactory {
    public static String DEFAULT_FACTORY_ID = "Default";
    protected static Map<String, UIPageFactory> pageFactory = new HashMap<String, UIPageFactory>();

    public static UIPageFactory getInstance(String type) {
        UIPageFactory factory = type == null ? pageFactory.get(DEFAULT_FACTORY_ID) : pageFactory.get(type);
        if (factory == null) {
            throw new UnsupportedOperationException("The " + type + " page factory is not supported or not loaded");
        }
        return factory;
    }

    public abstract UIPage createUIPage(WebuiRequestContext var1) throws Exception;

    public abstract String getType();

    static {
        ServiceLoader<UIPageFactory> loader = ServiceLoader.load(UIPageFactory.class);
        for (UIPageFactory factory : loader) {
            pageFactory.put(factory.getType(), factory);
        }
    }
}

