/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.idm.IDMUserListAccess;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.picketlink.idm.api.Group;

public class IntegrationCache {
    private static Logger log = Logger.getLogger(IntegrationCache.class.getName());
    private Cache cache;
    public static final String NODE_GTN_GROUP_ID = "NODE_GTN_GROUP_ID";
    public static final String NODE_PLIDM_ROOT_GROUP = "NODE_PLIDM_ROOT_GROUP";
    public static final String NULL_NS_NODE = "GTN_IC_COMMON_NS";
    public static final String USER_QUERY_NODE = "GTN_USER_QUERY_LAZY_LIST";
    public static final String MAIN_ROOT = "NODE_GTN_ORG_SERVICE_INT_CACHE_MAIN_ROOT";
    public static final String NODE_OBJECT_KEY = "object";
    private int expiration = -1;

    private Fqn getRootNode() {
        return Fqn.fromString((String)"/NODE_GTN_ORG_SERVICE_INT_CACHE_MAIN_ROOT");
    }

    private Fqn getNamespacedFqn(String ns) {
        String namespace = ns != null ? ns : NULL_NS_NODE;
        namespace = namespace.replaceAll("/", "_");
        return Fqn.fromString((String)(this.getRootNode() + "/" + namespace));
    }

    private Fqn getFqn(String ns, String node, Object o) {
        return Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + node + "/" + o));
    }

    private Fqn getFqn(String ns, String node) {
        return Fqn.fromString((String)(this.getNamespacedFqn(ns) + "/" + node));
    }

    public void initialize(InputStream jbossCacheConfiguration) {
        DefaultCacheFactory factory = new DefaultCacheFactory();
        if (jbossCacheConfiguration == null) {
            throw new IllegalArgumentException("JBoss Cache configuration InputStream is null");
        }
        this.cache = factory.createCache(jbossCacheConfiguration);
        this.cache.create();
        this.cache.start();
    }

    public void initialize(Cache cache) {
        this.cache = cache;
        CacheStatus status = cache.getCacheStatus();
        if (status.createAllowed()) {
            this.cache.create();
        }
        if (status.startAllowed()) {
            this.cache.start();
        }
    }

    Cache getCache() {
        return this.cache;
    }

    public void invalidate(String ns) {
        boolean success = this.cache.getRoot().removeChild(this.getNamespacedFqn(ns));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating namespace:" + ns + "; success=" + success);
        }
    }

    public void invalidateAll() {
        boolean success = this.cache.getRoot().removeChild(this.getRootNode());
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + "Invalidating whole cache - success=" + success);
        }
    }

    void putGtnGroupId(String ns, String pLIDMId, String id) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GTN_GROUP_ID, pLIDMId);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)id);
            this.setExpiration(ioNode);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "GateIn group id cached. PLIDM group id: " + pLIDMId + "GateIn group id: " + id + ";namespace=" + ns);
            }
        }
    }

    String getGtnGroupId(String ns, String pLIDMId) {
        Fqn nodeFqn = this.getFqn(ns, NODE_GTN_GROUP_ID, pLIDMId);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            String id = (String)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && id != null) {
                log.finer(this.toString() + "GateIn group id found in cache. PLIDM group id: " + pLIDMId + "GateIn group id: " + id + ";namespace=" + ns);
            }
            return id;
        }
        return null;
    }

    void putGtnUserLazyPageList(String ns, Query query, IDMUserListAccess list) {
        Fqn nodeFqn = this.getFqn(ns, USER_QUERY_NODE, this.getQueryKey(query));
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)list);
            this.setExpiration(ioNode);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "GateIn user query list cached. Query: " + this.getQueryKey(query) + ";namespace=" + ns);
            }
        }
    }

    IDMUserListAccess getGtnUserLazyPageList(String ns, Query query) {
        Fqn nodeFqn = this.getFqn(ns, USER_QUERY_NODE, this.getQueryKey(query));
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            IDMUserListAccess list = (IDMUserListAccess)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && list != null) {
                log.finer(this.toString() + "GateIn user query list found in cache. Query: " + this.getQueryKey(query) + ";namespace=" + ns);
            }
            return list;
        }
        return null;
    }

    void putRootGroup(String ns, Group rootGroup) {
        Fqn nodeFqn = this.getFqn(ns, NODE_PLIDM_ROOT_GROUP);
        Node ioNode = this.getCache().getRoot().addChild(nodeFqn);
        if (ioNode != null) {
            this.setExpiration(ioNode);
            ioNode.put((Object)NODE_OBJECT_KEY, (Object)rootGroup);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.toString() + "GateIn root group stored in cache" + ";namespace=" + ns);
            }
        }
    }

    Group getRootGroup(String ns) {
        Fqn nodeFqn = this.getFqn(ns, NODE_PLIDM_ROOT_GROUP);
        Node node = this.getCache().getRoot().getChild(nodeFqn);
        if (node != null) {
            Group rootGroup = (Group)node.get((Object)NODE_OBJECT_KEY);
            if (log.isLoggable(Level.FINER) && rootGroup != null) {
                log.finer(this.toString() + "GateIn root group found in cache" + ";namespace=" + ns);
            }
            return rootGroup;
        }
        return null;
    }

    public void setExpiration(Node node) {
        if (this.expiration != -1 && this.expiration > 0) {
            Long future = new Long(System.currentTimeMillis() + (long)this.expiration);
            node.put((Object)"expiration", (Object)future);
        }
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    String getQueryKey(Query query) {
        StringBuilder sb = new StringBuilder();
        String SEP = ":::";
        sb.append(query.getEmail()).append(SEP).append(query.getFirstName()).append(SEP).append(query.getLastName()).append(SEP).append(query.getUserName()).append(SEP).append(query.getFromLoginDate()).append(SEP).append(query.getToLoginDate()).append(SEP);
        return sb.toString();
    }
}

