/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.organization.BaseOrganizationService;
import org.exoplatform.services.organization.idm.Config;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.MembershipDAOImpl;
import org.exoplatform.services.organization.idm.MembershipTypeDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.idm.UserProfileDAOImpl;
import org.picketlink.idm.api.Group;
import org.picocontainer.Startable;

public class PicketLinkIDMOrganizationServiceImpl
extends BaseOrganizationService
implements Startable,
ComponentRequestLifecycle {
    private PicketLinkIDMServiceImpl idmService_;
    public static final String CONFIGURATION_OPTION = "configuration";
    private Config configuration = new Config();

    public PicketLinkIDMOrganizationServiceImpl(InitParams params, PicketLinkIDMService idmService) throws Exception {
        ObjectParameter configurationParam;
        this.groupDAO_ = new GroupDAOImpl(this, idmService);
        this.userDAO_ = new UserDAOImpl(this, idmService);
        this.userProfileDAO_ = new UserProfileDAOImpl(this, idmService);
        this.membershipDAO_ = new MembershipDAOImpl(this, idmService);
        this.membershipTypeDAO_ = new MembershipTypeDAOImpl(this, idmService);
        this.idmService_ = (PicketLinkIDMServiceImpl)idmService;
        if (params != null && (configurationParam = params.getObjectParam(CONFIGURATION_OPTION)) != null) {
            this.configuration = (Config)configurationParam.getObject();
        }
    }

    public final Group getJBIDMGroup(String groupId) throws Exception {
        String[] ids = groupId.split("/");
        String name = ids[ids.length - 1];
        String parentId = null;
        if (groupId.contains("/")) {
            parentId = groupId.substring(0, groupId.lastIndexOf("/"));
        }
        String plGroupName = this.configuration.getPLIDMGroupName(name);
        return this.idmService_.getIdentitySession().getPersistenceManager().findGroup(plGroupName, this.getConfiguration().getGroupType(parentId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            RequestLifeCycle.begin((ComponentRequestLifecycle)this);
            super.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public void startRequest(ExoContainer container) {
        try {
            if (this.configuration.isUseJTA()) {
                UserTransaction tx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                if (tx.getStatus() == 6) {
                    tx.begin();
                }
            } else if (!this.idmService_.getIdentitySession().getTransaction().isActive()) {
                this.idmService_.getIdentitySession().beginTransaction();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            if (this.configuration.isUseJTA()) {
                UserTransaction tx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                if (tx.getStatus() != 6) {
                    tx.commit();
                }
                if (tx.getStatus() == 6) {
                    tx.begin();
                }
            } else if (this.idmService_.getIdentitySession().getTransaction().isActive()) {
                this.idmService_.getIdentitySession().save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endRequest(ExoContainer container) {
        try {
            if (this.configuration.isUseJTA()) {
                UserTransaction tx = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                if (tx.getStatus() == 0) {
                    tx.commit();
                }
            } else if (this.idmService_.getIdentitySession().getTransaction().isActive()) {
                this.idmService_.getIdentitySession().getTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Config configuration) {
        this.configuration = configuration;
    }
}

