/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.util.Pair;
import com.google.caja.util.TestUtil;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public final class CharProducerTest
extends TestCase {
    private static final InputSource STRING_SOURCE = new InputSource(URI.create("file:///CharProducerTest.java"));
    private static final Pattern ESCAPED = Pattern.compile("[^\\p{javaLetterOrDigit} \\.\\-\\:\\;\\'\\\",/\\?&\\#]");

    public final void testFromReader() throws Exception {
        InputSource src = new InputSource(TestUtil.getResource(CharProducerTest.class, "testinput1.txt"));
        CharProducerTest.testProducer(CharProducer.Factory.create(new StringReader(TestUtil.readResource(CharProducerTest.class, "testinput1.txt")), src), "The quick brown fox\njumps over\nthe lazy dog\n", CharProducerTest.ss(0, "testinput1.txt:1+1@1"), CharProducerTest.ss(3, "testinput1.txt:1+4@4"), CharProducerTest.ss(19, "testinput1.txt:1+20@20"), CharProducerTest.ss(20, "testinput1.txt:2+1@21"), CharProducerTest.ss(43, "testinput1.txt:3+13@44"), CharProducerTest.ss(44, "testinput1.txt:4+1@45"));
    }

    public final void testFromString() {
        String s = "but was shocked to learn\n\rthe lazy dog had\r\na fox-seeking missle.";
        CharProducerTest.testProducer(CharProducerTest.fromString(s), s, CharProducerTest.ss(0, "CharProducerTest.java:1+1@1"), CharProducerTest.ss(24, "CharProducerTest.java:1+25@25"), CharProducerTest.ss(25, "CharProducerTest.java:2+1@26"), CharProducerTest.ss(26, "CharProducerTest.java:3+1@27"), CharProducerTest.ss(42, "CharProducerTest.java:3+17@43"), CharProducerTest.ss(43, "CharProducerTest.java:3+18@44"), CharProducerTest.ss(44, "CharProducerTest.java:4+1@45"), CharProducerTest.ss(65, "CharProducerTest.java:4+22@66"));
        CharProducerTest.testProducer(CharProducerTest.fromString(""), "", new StreamState[0]);
    }

    public final void testChaining() throws Exception {
        String input2 = "but was shocked to learn\n\rthe lazy dog had\r\na fox-seeking missle.";
        StringReader r = new StringReader(input2);
        CharProducer prod1 = TestUtil.getResourceAsProducer(CharProducerTest.class, "testinput1.txt");
        CharProducer prod2 = CharProducer.Factory.create((Reader)r, STRING_SOURCE);
        String golden1 = "The quick brown fox\njumps over\nthe lazy dog\n";
        String golden2 = input2;
        String chainedGolden = golden1 + golden2;
        CharProducer chained = CharProducer.Factory.chain(prod1, prod2);
        CharProducerTest.testProducer(chained, chainedGolden, CharProducerTest.ss(0, "testinput1.txt:1+1@1"), CharProducerTest.ss(3, "testinput1.txt:1+4@4"), CharProducerTest.ss(19, "testinput1.txt:1+20@20"), CharProducerTest.ss(20, "testinput1.txt:2+1@21"), CharProducerTest.ss(43, "testinput1.txt:3+13@44"), CharProducerTest.ss(44, "testinput1.txt:4+1@45"), CharProducerTest.ss(68, "CharProducerTest.java:1+25@25"), CharProducerTest.ss(69, "CharProducerTest.java:2+1@26"), CharProducerTest.ss(70, "CharProducerTest.java:3+1@27"), CharProducerTest.ss(86, "CharProducerTest.java:3+17@43"), CharProducerTest.ss(87, "CharProducerTest.java:3+18@44"), CharProducerTest.ss(88, "CharProducerTest.java:4+1@45"), CharProducerTest.ss(109, "CharProducerTest.java:4+22@66"));
    }

    public final void testJsUnEscaping() {
        String js = "The quick\\u0020brown fox\\njumps\\40over\\r\\nthe lazy dog\\n";
        String golden = "The quick brown fox\njumps over\r\nthe lazy dog\n";
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString(js)), golden, CharProducerTest.ss(0, "CharProducerTest.java:1+1@1"));
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\\\u000a")), "\\u000a", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\u00ziggy")), "u00ziggy", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\u\\u000a")), "u\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\u0\\u000a")), "u0\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\u00\\u000a")), "u00\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\u0")), "u0", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\u000")), "u000", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\u")), "u", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\uffff")), "\uffff", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\")), "\\", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\\\x0a")), "\\x0a", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\x0ziggy")), "x0ziggy", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\x\\u000a")), "x\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\x0\\u000a")), "x0\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\s0")), "s0", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\x")), "x", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\0")), "\u0000", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\11")), "\t", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\011")), "\t", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\009")), "\u00009", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\09")), "\u00009", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\9")), "9", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\00")), "\u0000", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\000")), "\u0000", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\0000")), "\u00000", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\37")), "\u001f", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\037")), "\u001f", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\040")), " ", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\40")), " ", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\400")), " 0", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\380")), "\u000380", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\n")), "\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\r")), "\r", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\r\\n")), "\r\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\t")), "\t", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\b")), "\b", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\f")), "\f", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromJsString(CharProducerTest.fromString("\\v")), "\u000b", new StreamState[0]);
    }

    private static CharProducer fromString(String js) {
        return CharProducer.Factory.create(new StringReader(js), STRING_SOURCE);
    }

    public final void testHtmlUnEscaping() {
        String html = "The quick&nbsp;brown fox&#xa;jumps over&#xd;&#10;the lazy dog&#x000a;";
        String golden = "The quick\u00a0brown fox\njumps over\r\nthe lazy dog\n";
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString(html)), golden, CharProducerTest.ss(0, "CharProducerTest.java:1+1@1"), CharProducerTest.ss(10, "CharProducerTest.java:1+16@16"), CharProducerTest.ss(20, "CharProducerTest.java:1+30@30"), CharProducerTest.ss(30, "CharProducerTest.java:1+40@40"), CharProducerTest.ss(40, "CharProducerTest.java:1+58@58"));
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("\\\\u000a")), "\\\\u000a", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x000a;")), "\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x00a;")), "\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x0a;")), "\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#xa;")), "\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x10000;")), String.valueOf(Character.toChars(65536)), new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#xa")), "&#xa", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x00ziggy")), "&#x00ziggy", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#xa00z;")), "&#xa00z;", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#&#x000a;")), "&#\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x&#x000a;")), "&#x\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#xa&#x000a;")), "&#xa\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#&#xa;")), "&#\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x")), "&#x", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x0")), "&#x0", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#")), "&#", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("\\")), "\\", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&")), "&", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#000a;")), "&#000a;", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#10;")), "\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#010;")), "\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#0010;")), "\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#9;")), "\t", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#10")), "&#10", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#00ziggy")), "&#00ziggy", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#&#010;")), "&#\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#0&#010;")), "&#0\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#01&#10;")), "&#01\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#&#10;")), "&#\n", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#1")), "&#1", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#10")), "&#10", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&lt;")), "<", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&gt;")), ">", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&quot;")), "\"", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&apos;")), "'", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#39;")), "'", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&#x27;")), "'", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&amp;")), "&", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&amp;lt;")), "&lt;", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&AMP;")), "&", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&AMP")), "&AMP", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&AmP;")), "&", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&Alpha;")), "\u0391", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&alpha;")), "\u03b1", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&;")), "&;", new StreamState[0]);
        CharProducerTest.testProducer(CharProducer.Factory.fromHtmlAttribute(CharProducerTest.fromString("&bogus;")), "&bogus;", new StreamState[0]);
    }

    public final void testChainingAndUnescaping() throws Exception {
        InputSource src = STRING_SOURCE;
        StringReader r1 = new StringReader("hiThere(");
        StringReader r2 = new StringReader(", now);");
        CharProducer prod1 = CharProducer.Factory.create((Reader)r1, FilePosition.startOfFile(src));
        CharProducer prod2 = CharProducer.Factory.create((Reader)r2, FilePosition.instance(src, 2, 30, 1));
        String golden = "hiThere(, now);";
        CharProducer chained = CharProducer.Factory.fromHtmlAttribute(CharProducer.Factory.chain(prod1, prod2));
        CharProducerTest.testProducer(chained, golden, CharProducerTest.ss(0, "CharProducerTest.java:1+1@1"), CharProducerTest.ss(1, "CharProducerTest.java:1+2@2"), CharProducerTest.ss(2, "CharProducerTest.java:1+3@3"), CharProducerTest.ss(3, "CharProducerTest.java:1+4@4"), CharProducerTest.ss(4, "CharProducerTest.java:1+5@5"), CharProducerTest.ss(5, "CharProducerTest.java:1+6@6"), CharProducerTest.ss(6, "CharProducerTest.java:1+7@7"), CharProducerTest.ss(7, "CharProducerTest.java:1+8@8"), CharProducerTest.ss(8, "CharProducerTest.java:1+9@9"), CharProducerTest.ss(9, "CharProducerTest.java:2+2@31"), CharProducerTest.ss(10, "CharProducerTest.java:2+3@32"), CharProducerTest.ss(11, "CharProducerTest.java:2+4@33"), CharProducerTest.ss(12, "CharProducerTest.java:2+5@34"), CharProducerTest.ss(13, "CharProducerTest.java:2+6@35"), CharProducerTest.ss(14, "CharProducerTest.java:2+7@36"), CharProducerTest.ss(15, "CharProducerTest.java:2+8@37"));
    }

    private static void testProducer(CharProducer p, String golden, StreamState ... positions) {
        ArrayList<Pair<String, FilePosition>> actualPositions = new ArrayList<Pair<String, FilePosition>>();
        StringBuilder sb = new StringBuilder();
        char[] buf = p.getBuffer();
        int k = p.getOffset();
        while (true) {
            int offset = p.getOffset();
            if (k < positions.length && sb.length() == positions[k].charsRead) {
                FilePosition pos = p.getSourceBreaks(offset).toFilePosition(p.getCharInFile(offset));
                actualPositions.add(Pair.pair(sb.toString(), pos));
                ++k;
            }
            if (offset == p.getLimit()) break;
            sb.append(buf[p.getOffset()]);
            p.consume(1);
        }
        String actual = sb.toString();
        CharProducerTest.assertEquals((String)("golden:[" + CharProducerTest.escape(golden) + "]\nactual:[" + CharProducerTest.escape(actual) + "]"), (String)golden, (String)actual);
        for (int k2 = 0; k2 < Math.min(positions.length, actualPositions.size()); ++k2) {
            Pair actualPos = (Pair)actualPositions.get(k2);
            String posStr = ((FilePosition)actualPos.b).toString();
            CharProducerTest.assertEquals((String)("Read so far [" + (String)actualPos.a + "] : [" + golden.substring(0, Math.min(((String)actualPos.a).length(), golden.length())) + "]"), (String)positions[k2].pos, (String)posStr);
        }
        CharProducerTest.assertEquals((int)positions.length, (int)actualPositions.size());
    }

    private static final String decodeUri(String uriPart) {
        return CharProducer.Factory.fromUri(CharProducer.Factory.fromString((CharSequence)uriPart, InputSource.UNKNOWN)).toString();
    }

    public final void testFromUri() {
        CharProducerTest.assertEquals((String)"", (String)CharProducerTest.decodeUri(""));
        CharProducerTest.assertEquals((String)"foo", (String)CharProducerTest.decodeUri("foo"));
        CharProducerTest.assertEquals((String)"foo+bar", (String)CharProducerTest.decodeUri("foo+bar"));
        CharProducerTest.assertEquals((String)"foo+bar", (String)CharProducerTest.decodeUri("foo%2bbar"));
        CharProducerTest.assertEquals((String)"foo@bar", (String)CharProducerTest.decodeUri("foo%40bar"));
        CharProducerTest.assertEquals((String)"\u00a0", (String)CharProducerTest.decodeUri("%A0"));
        CharProducerTest.assertEquals((String)"foo\u0123bar", (String)CharProducerTest.decodeUri("foo%C4%a3bar"));
        CharProducerTest.assertEquals((String)"foo\u20acbar", (String)CharProducerTest.decodeUri("foo%e2%82%Acbar"));
        String supplemental = String.valueOf(Character.toChars(119070));
        CharProducerTest.assertEquals((String)supplemental, (String)CharProducerTest.decodeUri("%ed%a0%B4%eD%b4%9E"));
        CharProducerTest.assertEquals((String)supplemental, (String)CharProducerTest.decodeUri("%F0%9d%84%9E"));
        CharProducerTest.assertEquals((String)supplemental, (String)CharProducerTest.decodeUri("%f0%9D%84%9e"));
        CharProducerTest.assertEquals((String)supplemental, (String)CharProducerTest.decodeUri(UriUtil.encode(supplemental)));
        CharProducerTest.assertEquals((String)"%", (String)CharProducerTest.decodeUri("%"));
        CharProducerTest.assertEquals((String)"%2", (String)CharProducerTest.decodeUri("%2"));
        CharProducerTest.assertEquals((String)"%z", (String)CharProducerTest.decodeUri("%z"));
        CharProducerTest.assertEquals((String)"%", (String)CharProducerTest.decodeUri("%25"));
        CharProducerTest.assertEquals((String)"%2", (String)CharProducerTest.decodeUri("%252"));
        CharProducerTest.assertEquals((String)"%25", (String)CharProducerTest.decodeUri("%2525"));
    }

    private static String escape(String s) {
        Matcher m = ESCAPED.matcher(s);
        if (!m.find()) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + 16);
        char[] hex = new char[]{'\u0000', '\u0000', '\u0000', '\u0000'};
        do {
            int ch = m.group().charAt(0);
            int i = hex.length;
            while (--i >= 0) {
                hex[i] = "0123456789abcdef".charAt(ch & 0xF);
                ch >>= 4;
            }
            m.appendReplacement(sb, "<" + new String(hex, 0, 4) + ">");
        } while (m.find());
        return m.appendTail(sb).toString();
    }

    private static StreamState ss(int charsRead, String p) {
        return new StreamState(charsRead, p);
    }

    static class StreamState {
        final int charsRead;
        final String pos;

        StreamState(int charsRead, String pos) {
            this.charsRead = charsRead;
            this.pos = pos;
        }
    }
}

