/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;

public abstract class TopScoreDocCollector
extends TopDocsCollector {
    ScoreDoc pqTop = (ScoreDoc)this.pq.top();
    int docBase = 0;
    Scorer scorer;
    static /* synthetic */ Class class$org$apache$lucene$search$TopScoreDocCollector;

    public static TopScoreDocCollector create(int numHits, boolean docsScoredInOrder) {
        if (docsScoredInOrder) {
            return new InOrderTopScoreDocCollector(numHits);
        }
        return new OutOfOrderTopScoreDocCollector(numHits);
    }

    private TopScoreDocCollector(int numHits) {
        super(new HitQueue(numHits, true));
    }

    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            return EMPTY_TOPDOCS;
        }
        float maxScore = Float.NaN;
        if (start == 0) {
            maxScore = results[0].score;
        } else {
            for (int i = this.pq.size(); i > 1; --i) {
                this.pq.pop();
            }
            maxScore = ((ScoreDoc)this.pq.pop()).score;
        }
        return new TopDocs(this.totalHits, results, maxScore);
    }

    public void setNextReader(IndexReader reader, int base) {
        this.docBase = base;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    private static class OutOfOrderTopScoreDocCollector
    extends TopScoreDocCollector {
        static final /* synthetic */ boolean $assertionsDisabled;

        private OutOfOrderTopScoreDocCollector(int numHits) {
            super(numHits);
        }

        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            if (!$assertionsDisabled && Float.isNaN(score)) {
                throw new AssertionError();
            }
            ++this.totalHits;
            if (score < this.pqTop.score || score == this.pqTop.score && (doc += this.docBase) > this.pqTop.doc) {
                return;
            }
            this.pqTop.doc = doc;
            this.pqTop.score = score;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$search$TopScoreDocCollector == null ? (class$org$apache$lucene$search$TopScoreDocCollector = TopScoreDocCollector.class$("org.apache.lucene.search.TopScoreDocCollector")) : class$org$apache$lucene$search$TopScoreDocCollector).desiredAssertionStatus();
        }
    }

    private static class InOrderTopScoreDocCollector
    extends TopScoreDocCollector {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InOrderTopScoreDocCollector(int numHits) {
            super(numHits);
        }

        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            if (!$assertionsDisabled && score == Float.NEGATIVE_INFINITY) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && Float.isNaN(score)) {
                throw new AssertionError();
            }
            ++this.totalHits;
            if (score <= this.pqTop.score) {
                return;
            }
            this.pqTop.doc = doc + this.docBase;
            this.pqTop.score = score;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$search$TopScoreDocCollector == null ? (class$org$apache$lucene$search$TopScoreDocCollector = TopScoreDocCollector.class$("org.apache.lucene.search.TopScoreDocCollector")) : class$org$apache$lucene$search$TopScoreDocCollector).desiredAssertionStatus();
        }
    }
}

