/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.util.Function;
import java.io.File;
import java.io.IOException;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UriToFile
implements Function<URI, File> {
    final File directory;

    public UriToFile(File directory) throws IOException {
        assert (directory.isDirectory());
        this.directory = directory.getCanonicalFile();
    }

    @Override
    public File apply(URI uri) {
        return this.toFileUnderSameDirectory(uri);
    }

    private File toFileUnderSameDirectory(URI uri) {
        File f;
        if (uri.isOpaque()) {
            return null;
        }
        if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
            return null;
        }
        if (uri.getAuthority() != null || uri.getFragment() != null || uri.getQuery() != null) {
            return null;
        }
        if (uri.getPath() == null) {
            return null;
        }
        for (File tmp = f = new File(new File(this.directory, ".").toURI().resolve(uri)); tmp != null; tmp = tmp.getParentFile()) {
            if (!this.directory.equals(tmp)) continue;
            return f;
        }
        return null;
    }
}

