/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.InputStream;
import java.net.URL;
import javax.naming.InitialContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.organization.idm.IntegrationCache;
import org.exoplatform.services.organization.idm.PicketLinkIDMCacheService;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.cfg.IdentityConfiguration;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.common.exception.IdentityConfigurationException;
import org.picketlink.idm.impl.cache.JBossCacheAPICacheProviderImpl;
import org.picketlink.idm.impl.cache.JBossCacheIdentityStoreCacheProviderImpl;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picocontainer.Startable;

public class PicketLinkIDMServiceImpl
implements PicketLinkIDMService,
Startable {
    private static Log log = ExoLogger.getLogger(PicketLinkIDMServiceImpl.class);
    public static final String PARAM_CONFIG_OPTION = "config";
    public static final String PARAM_HIBERNATE_PROPS = "hibernate.properties";
    public static final String PARAM_HIBERNATE_MAPPINGS = "hibernate.mappings";
    public static final String PARAM_HIBERNATE_ANNOTATIONS = "hibernate.annotations";
    public static final String PARAM_JNDI_NAME_OPTION = "jndiName";
    public static final String REALM_NAME_OPTION = "portalRealm";
    public static final String CACHE_CONFIG_API_OPTION = "apiCacheConfig";
    public static final String CACHE_CONFIG_STORE_OPTION = "storeCacheConfig";
    public static final String JGROUPS_CONFIG = "jgroups-configuration";
    public static final String JGROUPS_MUX_ENABLED = "jgroups-multiplexer-stack";
    public static final String CACHE_EXPIRATION = "cacheExpiration";
    private IdentitySessionFactory identitySessionFactory;
    private String config;
    private String realmName = "idm_realm";
    private IdentityConfiguration identityConfiguration;
    private IntegrationCache integrationCache;
    private static final JChannelFactory CHANNEL_FACTORY = new JChannelFactory();
    private HibernateService hibernateService;

    private PicketLinkIDMServiceImpl() {
    }

    public PicketLinkIDMServiceImpl(InitParams initParams, HibernateService hibernateService, ConfigurationManager confManager, PicketLinkIDMCacheService picketLinkIDMCache, InitialContextInitializer dependency) throws Exception {
        ValueParam config = initParams.getValueParam(PARAM_CONFIG_OPTION);
        ValueParam jndiName = initParams.getValueParam(PARAM_JNDI_NAME_OPTION);
        ValueParam realmName = initParams.getValueParam(REALM_NAME_OPTION);
        ValueParam apiCacheConfig = initParams.getValueParam(CACHE_CONFIG_API_OPTION);
        ValueParam storeCacheConfig = initParams.getValueParam(CACHE_CONFIG_STORE_OPTION);
        ValueParam jgroupsStack = initParams.getValueParam(JGROUPS_MUX_ENABLED);
        ValueParam jgroupsConfig = initParams.getValueParam(JGROUPS_CONFIG);
        ValueParam cacheExpirationParam = initParams.getValueParam(CACHE_EXPIRATION);
        this.hibernateService = hibernateService;
        if (config == null && jndiName == null) {
            throw new IllegalStateException("Either 'config' or 'jndiName' parameter must be specified");
        }
        if (realmName != null) {
            this.realmName = realmName.getValue();
        }
        if (config != null) {
            Cache cache;
            DefaultCacheFactory factory;
            InputStream configStream;
            this.config = config.getValue();
            URL configURL = confManager.getURL(this.config);
            if (configURL == null) {
                throw new IllegalStateException("Cannot fine resource: " + this.config);
            }
            IdentityConfigurationMetaData configMD = JAXB2IdentityConfiguration.createConfigurationMetaData((InputStream)confManager.getInputStream(this.config));
            this.identityConfiguration = new IdentityConfigurationImpl().configure(configMD);
            this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)hibernateService.getSessionFactory(), "hibernateSessionFactory");
            int expiration = -1;
            if (cacheExpirationParam != null && cacheExpirationParam.getValue() != null && cacheExpirationParam.getValue().length() > 0) {
                expiration = Integer.decode(cacheExpirationParam.getValue());
            }
            if (apiCacheConfig != null) {
                configStream = confManager.getInputStream(apiCacheConfig.getValue());
                factory = new DefaultCacheFactory();
                if (configStream == null) {
                    throw new IllegalArgumentException("JBoss Cache configuration InputStream is null");
                }
                cache = factory.createCache(configStream);
                this.applyJGroupsConfig(cache, confManager, jgroupsStack, jgroupsConfig);
                cache.create();
                cache.start();
                configStream.close();
                JBossCacheAPICacheProviderImpl apiCacheProvider = new JBossCacheAPICacheProviderImpl();
                apiCacheProvider.setExpiration(expiration);
                apiCacheProvider.initialize(cache);
                picketLinkIDMCache.register((APICacheProvider)apiCacheProvider);
                this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)apiCacheProvider, "apiCacheProvider");
                this.integrationCache = new IntegrationCache();
                this.integrationCache.setExpiration(expiration);
                this.integrationCache.initialize(cache);
                picketLinkIDMCache.register(this.integrationCache);
            }
            if (storeCacheConfig != null) {
                configStream = confManager.getInputStream(storeCacheConfig.getValue());
                factory = new DefaultCacheFactory();
                if (configStream == null) {
                    throw new IllegalArgumentException("JBoss Cache configuration InputStream is null");
                }
                cache = factory.createCache(configStream);
                this.applyJGroupsConfig(cache, confManager, jgroupsStack, jgroupsConfig);
                cache.create();
                cache.start();
                configStream.close();
                JBossCacheIdentityStoreCacheProviderImpl storeCacheProvider = new JBossCacheIdentityStoreCacheProviderImpl();
                storeCacheProvider.setExpiration(expiration);
                storeCacheProvider.initialize(cache);
                picketLinkIDMCache.register((IdentityStoreCacheProvider)storeCacheProvider);
                this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)storeCacheProvider, "storeCacheProvider");
                configStream.close();
            }
        } else {
            this.identitySessionFactory = (IdentitySessionFactory)new InitialContext().lookup(jndiName.getValue());
        }
    }

    public void start() {
        if (this.identitySessionFactory == null) {
            try {
                this.identitySessionFactory = this.identityConfiguration.buildIdentitySessionFactory();
            }
            catch (IdentityConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stop() {
    }

    public IdentitySessionFactory getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    public IdentitySession getIdentitySession() throws Exception {
        return this.getIdentitySessionFactory().getCurrentIdentitySession(this.realmName);
    }

    public IdentitySession getIdentitySession(String realm) throws Exception {
        if (realm == null) {
            throw new IllegalArgumentException("Realm name cannot be null");
        }
        return this.getIdentitySessionFactory().getCurrentIdentitySession(realm);
    }

    public IntegrationCache getIntegrationCache() {
        return this.integrationCache;
    }

    public String getRealmName() {
        return this.realmName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyJGroupsConfig(Cache cache, ConfigurationManager configurationManager, ValueParam jgroupsEnabledParam, ValueParam jgroupsConfigurationParam) {
        String jgroupsConfiguration;
        String jgroupsEnabled = jgroupsEnabledParam != null ? jgroupsEnabledParam.getValue() : null;
        String string = jgroupsConfiguration = jgroupsConfigurationParam != null ? jgroupsConfigurationParam.getValue() : null;
        if (jgroupsEnabled != null && jgroupsEnabled.equalsIgnoreCase("true")) {
            try {
                if (jgroupsConfiguration == null) return;
                CHANNEL_FACTORY.setMultiplexerConfig(configurationManager.getResource(jgroupsConfiguration));
                cache.getConfiguration().getRuntimeConfig().setMuxChannelFactory((ChannelFactory)CHANNEL_FACTORY);
                log.info((Object)"Multiplexer stack successfully enabled for the cache.");
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException("Error setting multiplexer configuration.", e);
            }
        }
        if (jgroupsConfiguration == null) return;
        try {
            cache.getConfiguration().setJgroupsConfigFile(configurationManager.getResource(jgroupsConfiguration));
            log.info((Object)("Custom JGroups configuration set:" + configurationManager.getResource(jgroupsConfiguration)));
            return;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error setting JGroups configuration.", e);
        }
    }

    public HibernateService getHibernateService() {
        return this.hibernateService;
    }
}

