/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.valve;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.ServerCookies;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebdavLoggingValve
extends ValveBase {
    private static final Log LOG = ExoLogger.getLogger(WebdavLoggingValve.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        block23: {
            block22: {
                UUID reqUuid;
                block21: {
                    if (!LOG.isDebugEnabled()) break block22;
                    reqUuid = UUID.randomUUID();
                    try {
                        LOG.debug("[{}] URI: {} - Method {}", new Object[]{reqUuid, request.getRequestURI(), request.getMethod()});
                        Enumeration paramNames = request.getParameterNames();
                        while (paramNames.hasMoreElements()) {
                            String p = (String)paramNames.nextElement();
                            LOG.debug("[{}] - Request Param: {}: {}", new Object[]{reqUuid, p, StringUtils.join((Object[])request.getParameterValues(p), (String)", ")});
                        }
                        Enumeration headerNames = request.getHeaderNames();
                        while (headerNames.hasMoreElements()) {
                            String h = (String)headerNames.nextElement();
                            LOG.debug("[{}] - Request Header: {}: {}", new Object[]{reqUuid, h, request.getHeader(h)});
                        }
                        ByteArrayInputStream arrayInputStream = null;
                        try (ServletInputStream inputStream = request.getInputStream();){
                            arrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream));
                        }
                        if (arrayInputStream.available() > 0 && (arrayInputStream.available() < 2048 || StringUtils.contains((CharSequence)request.getContentType(), (CharSequence)"text/") || StringUtils.equals((CharSequence)request.getContentType(), (CharSequence)"application/xml") || StringUtils.equals((CharSequence)request.getContentType(), (CharSequence)"application.json/"))) {
                            byte[] bytes = arrayInputStream.readAllBytes();
                            arrayInputStream.reset();
                            LOG.debug("[{}] + Request Body: {}", new Object[]{reqUuid, new String(bytes)});
                        }
                        RequestWrapper wrappedRequest = new RequestWrapper(this, request, arrayInputStream);
                        ResponseWrapper wrappedResponse = new ResponseWrapper(this, response);
                        this.getNext().invoke((Request)wrappedRequest, (org.apache.catalina.connector.Response)wrappedResponse);
                        byte[] responseBytes = wrappedResponse.getBufferedContent();
                        if (LOG.isTraceEnabled() && StringUtils.contains((CharSequence)response.getContentType(), (CharSequence)"text/") && responseBytes.length > 0) {
                            LOG.trace("[{}] + Response Body: {}", new Object[]{reqUuid, new String(responseBytes)});
                        }
                        if (responseBytes.length <= 0) break block21;
                        try (ServletOutputStream responseOutputStream = response.getOutputStream();){
                            responseOutputStream.write(responseBytes);
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.debug("[{}] - Response Status: {}", new Object[]{reqUuid, response.getStatus()});
                        Collection headerNames = response.getHeaderNames();
                        for (String h : headerNames) {
                            LOG.debug("[{}] - Response Header: {}: {}", new Object[]{reqUuid, h, response.getHeader(h)});
                        }
                        throw throwable;
                    }
                }
                LOG.debug("[{}] - Response Status: {}", new Object[]{reqUuid, response.getStatus()});
                Collection headerNames = response.getHeaderNames();
                for (String h : headerNames) {
                    LOG.debug("[{}] - Response Header: {}: {}", new Object[]{reqUuid, h, response.getHeader(h)});
                }
                break block23;
            }
            this.getNext().invoke(request, response);
        }
    }

    private class RequestWrapper
    extends Request {
        private Request request;
        private ByteArrayInputStream arrayInputStream;

        public RequestWrapper(WebdavLoggingValve webdavLoggingValve, Request request, ByteArrayInputStream arrayInputStream) {
            super(request.getConnector());
            this.request = request;
            this.arrayInputStream = arrayInputStream;
        }

        public void setCoyoteRequest(org.apache.coyote.Request coyoteRequest) {
            this.request.setCoyoteRequest(coyoteRequest);
        }

        public org.apache.coyote.Request getCoyoteRequest() {
            return this.request.getCoyoteRequest();
        }

        public void addPathParameter(String name, String value) {
            this.request.addPathParameter(name, value);
        }

        public String getPathParameter(String name) {
            return this.request.getPathParameter(name);
        }

        public void setAsyncSupported(boolean asyncSupported) {
            this.request.setAsyncSupported(asyncSupported);
        }

        public void recycle() {
            this.request.recycle();
        }

        public Connector getConnector() {
            return this.request.getConnector();
        }

        public Context getContext() {
            return this.request.getContext();
        }

        public boolean getDiscardFacades() {
            return this.request.getDiscardFacades();
        }

        public FilterChain getFilterChain() {
            return this.request.getFilterChain();
        }

        public void setFilterChain(FilterChain filterChain) {
            this.request.setFilterChain(filterChain);
        }

        public Host getHost() {
            return this.request.getHost();
        }

        public MappingData getMappingData() {
            return this.request.getMappingData();
        }

        public HttpServletRequest getRequest() {
            return this.newHttpServletRequestWrapper(this.request.getRequest(), this.arrayInputStream);
        }

        public void setRequest(HttpServletRequest applicationRequest) {
            this.request.setRequest(applicationRequest);
        }

        public org.apache.catalina.connector.Response getResponse() {
            return this.request.getResponse();
        }

        public void setResponse(org.apache.catalina.connector.Response response) {
            this.request.setResponse(response);
        }

        public InputStream getStream() {
            return this.request.getStream();
        }

        public Wrapper getWrapper() {
            return this.request.getWrapper();
        }

        public ServletInputStream createInputStream() throws IOException {
            return this.request.createInputStream();
        }

        public void finishRequest() throws IOException {
            this.request.finishRequest();
        }

        public Object getNote(String name) {
            return this.request.getNote(name);
        }

        public void removeNote(String name) {
            this.request.removeNote(name);
        }

        public void setLocalPort(int port) {
            this.request.setLocalPort(port);
        }

        public void setNote(String name, Object value) {
            this.request.setNote(name, value);
        }

        public void setRemoteAddr(String remoteAddr) {
            this.request.setRemoteAddr(remoteAddr);
        }

        public void setRemoteHost(String remoteHost) {
            this.request.setRemoteHost(remoteHost);
        }

        public void setSecure(boolean secure) {
            this.request.setSecure(secure);
        }

        public void setServerPort(int port) {
            this.request.setServerPort(port);
        }

        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        public long getContentLengthLong() {
            return this.request.getContentLengthLong();
        }

        public Enumeration<String> getAttributeNames() {
            return this.request.getAttributeNames();
        }

        public String getCharacterEncoding() {
            return this.request.getCharacterEncoding();
        }

        public int getContentLength() {
            return this.request.getContentLength();
        }

        public String getContentType() {
            return this.request.getContentType();
        }

        public void setContentType(String contentType) {
            this.request.setContentType(contentType);
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        public Locale getLocale() {
            return this.request.getLocale();
        }

        public Enumeration<Locale> getLocales() {
            return this.request.getLocales();
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.request.getParameterMap();
        }

        public Enumeration<String> getParameterNames() {
            return this.request.getParameterNames();
        }

        public String[] getParameterValues(String name) {
            return this.request.getParameterValues(name);
        }

        public String getProtocol() {
            return this.request.getProtocol();
        }

        public BufferedReader getReader() throws IOException {
            return this.request.getReader();
        }

        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        public String getPeerAddr() {
            return this.request.getPeerAddr();
        }

        public String getRemoteHost() {
            return this.request.getRemoteHost();
        }

        public int getRemotePort() {
            return this.request.getRemotePort();
        }

        public String getLocalName() {
            return this.request.getLocalName();
        }

        public String getLocalAddr() {
            return this.request.getLocalAddr();
        }

        public int getLocalPort() {
            return this.request.getLocalPort();
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.request.getRequestDispatcher(path);
        }

        public String getScheme() {
            return this.request.getScheme();
        }

        public String getServerName() {
            return this.request.getServerName();
        }

        public int getServerPort() {
            return this.request.getServerPort();
        }

        public boolean isSecure() {
            return this.request.isSecure();
        }

        public void removeAttribute(String name) {
            this.request.removeAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.request.setAttribute(name, value);
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this.request.setCharacterEncoding(enc);
        }

        public ServletContext getServletContext() {
            return this.request.getServletContext();
        }

        public AsyncContext startAsync() {
            return this.request.startAsync();
        }

        public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
            return request.startAsync(request, response);
        }

        public boolean isAsyncStarted() {
            return this.request.isAsyncStarted();
        }

        public boolean isAsyncDispatching() {
            return this.request.isAsyncDispatching();
        }

        public boolean isAsyncCompleting() {
            return this.request.isAsyncCompleting();
        }

        public boolean isAsync() {
            return this.request.isAsync();
        }

        public boolean isAsyncSupported() {
            return this.request.isAsyncSupported();
        }

        public AsyncContext getAsyncContext() {
            return this.request.getAsyncContext();
        }

        public AsyncContextImpl getAsyncContextInternal() {
            return this.request.getAsyncContextInternal();
        }

        public DispatcherType getDispatcherType() {
            return this.request.getDispatcherType();
        }

        public String getRequestId() {
            return this.request.getRequestId();
        }

        public String getProtocolRequestId() {
            return this.request.getProtocolRequestId();
        }

        public ServletConnection getServletConnection() {
            return this.request.getServletConnection();
        }

        public void addCookie(Cookie cookie) {
            this.request.addCookie(cookie);
        }

        public void addLocale(Locale locale) {
            this.request.addLocale(locale);
        }

        public void clearCookies() {
            this.request.clearCookies();
        }

        public void clearLocales() {
            this.request.clearLocales();
        }

        public void setAuthType(String type) {
            this.request.setAuthType(type);
        }

        public void setPathInfo(String path) {
            this.request.setPathInfo(path);
        }

        public void setRequestedSessionCookie(boolean flag) {
            this.request.setRequestedSessionCookie(flag);
        }

        public void setRequestedSessionId(String id) {
            this.request.setRequestedSessionId(id);
        }

        public void setRequestedSessionURL(boolean flag) {
            this.request.setRequestedSessionURL(flag);
        }

        public void setRequestedSessionSSL(boolean flag) {
            this.request.setRequestedSessionSSL(flag);
        }

        public String getDecodedRequestURI() {
            return this.request.getDecodedRequestURI();
        }

        public MessageBytes getDecodedRequestURIMB() {
            return this.request.getDecodedRequestURIMB();
        }

        public void setUserPrincipal(Principal principal) {
            this.request.setUserPrincipal(principal);
        }

        public boolean isTrailerFieldsReady() {
            return this.request.isTrailerFieldsReady();
        }

        public Map<String, String> getTrailerFields() {
            return this.request.getTrailerFields();
        }

        public PushBuilder newPushBuilder() {
            return this.request.newPushBuilder();
        }

        public PushBuilder newPushBuilder(HttpServletRequest httpServletRequest) {
            return this.request.newPushBuilder(httpServletRequest);
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
            return (T)this.request.upgrade(httpUpgradeHandlerClass);
        }

        public String getAuthType() {
            return this.request.getAuthType();
        }

        public String getContextPath() {
            return this.request.getContextPath();
        }

        public Cookie[] getCookies() {
            return this.request.getCookies();
        }

        public ServerCookies getServerCookies() {
            return this.request.getServerCookies();
        }

        public long getDateHeader(String name) {
            return this.request.getDateHeader(name);
        }

        public String getHeader(String name) {
            return this.request.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            return this.request.getHeaders(name);
        }

        public Enumeration<String> getHeaderNames() {
            return this.request.getHeaderNames();
        }

        public int getIntHeader(String name) {
            return this.request.getIntHeader(name);
        }

        public HttpServletMapping getHttpServletMapping() {
            return this.request.getHttpServletMapping();
        }

        public String getMethod() {
            return this.request.getMethod();
        }

        public String getPathInfo() {
            return this.request.getPathInfo();
        }

        public String getPathTranslated() {
            return this.request.getPathTranslated();
        }

        public String getQueryString() {
            return this.request.getQueryString();
        }

        public String getRemoteUser() {
            return this.request.getRemoteUser();
        }

        public MessageBytes getRequestPathMB() {
            return this.request.getRequestPathMB();
        }

        public String getRequestedSessionId() {
            return this.request.getRequestedSessionId();
        }

        public String getRequestURI() {
            return this.request.getRequestURI();
        }

        public StringBuffer getRequestURL() {
            return this.request.getRequestURL();
        }

        public String getServletPath() {
            return this.request.getServletPath();
        }

        public HttpSession getSession() {
            return this.request.getSession();
        }

        public HttpSession getSession(boolean create) {
            return this.request.getSession(create);
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.request.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.request.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdValid() {
            return this.request.isRequestedSessionIdValid();
        }

        public boolean isUserInRole(String role) {
            return this.request.isUserInRole(role);
        }

        public Principal getPrincipal() {
            return this.request.getPrincipal();
        }

        public Principal getUserPrincipal() {
            return this.request.getUserPrincipal();
        }

        public Session getSessionInternal() {
            return this.request.getSessionInternal();
        }

        public void changeSessionId(String newSessionId) {
            this.request.changeSessionId(newSessionId);
        }

        public String changeSessionId() {
            return this.request.changeSessionId();
        }

        public Session getSessionInternal(boolean create) {
            return this.request.getSessionInternal(create);
        }

        public boolean isParametersParsed() {
            return this.request.isParametersParsed();
        }

        public boolean isFinished() {
            return this.request.isFinished();
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            return this.request.authenticate(response);
        }

        public void login(String username, String password) throws ServletException {
            this.request.login(username, password);
        }

        public void logout() throws ServletException {
            this.request.logout();
        }

        public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
            return this.request.getParts();
        }

        public Part getPart(String name) throws IOException, IllegalStateException, ServletException {
            return this.request.getPart(name);
        }

        private HttpServletRequestWrapper newHttpServletRequestWrapper(HttpServletRequest httpRequest, final ByteArrayInputStream arrayInputStream) {
            return new HttpServletRequestWrapper(httpRequest){

                public ServletInputStream getInputStream() throws IOException {
                    return RequestWrapper.this.newServletInputStreamWrapper(arrayInputStream);
                }
            };
        }

        private ServletInputStream newServletInputStreamWrapper(final ByteArrayInputStream arrayInputStream) {
            return new ServletInputStream(this){

                public boolean isFinished() {
                    return arrayInputStream.available() == 0;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() throws IOException {
                    return arrayInputStream.read();
                }

                public int available() throws IOException {
                    return arrayInputStream.available();
                }
            };
        }
    }

    private class ResponseWrapper
    extends org.apache.catalina.connector.Response {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private final ServletOutputStream bufferOutputStream = this.newServletOutputStreamWrapper();
        private PrintWriter bufferWriter;
        private HttpServletResponseWrapper bufferResponse;
        private org.apache.catalina.connector.Response response;

        public ResponseWrapper(WebdavLoggingValve webdavLoggingValve, org.apache.catalina.connector.Response response) {
            this.response = response;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.bufferOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.bufferWriter == null) {
                this.bufferWriter = new PrintWriter(this.buffer);
            }
            return this.bufferWriter;
        }

        public void setCoyoteResponse(Response coyoteResponse) {
            this.response.setCoyoteResponse(coyoteResponse);
        }

        public Response getCoyoteResponse() {
            return this.response.getCoyoteResponse();
        }

        public Context getContext() {
            return this.response.getContext();
        }

        public void recycle() {
            this.response.recycle();
        }

        public List<Cookie> getCookies() {
            return this.response.getCookies();
        }

        public long getContentWritten() {
            return this.response.getContentWritten();
        }

        public long getBytesWritten(boolean flush) {
            return this.response.getBytesWritten(flush);
        }

        public void setAppCommitted(boolean appCommitted) {
            this.response.setAppCommitted(appCommitted);
        }

        public boolean isAppCommitted() {
            return this.response.isAppCommitted();
        }

        public Request getRequest() {
            return this.response.getRequest();
        }

        public void setRequest(Request request) {
            this.response.setRequest(request);
        }

        public HttpServletResponse getResponse() {
            if (this.bufferResponse == null) {
                this.bufferResponse = this.newHttpServletResponseWrapper(this.response.getResponse());
            }
            return this.bufferResponse;
        }

        public void setResponse(HttpServletResponse applicationResponse) {
            this.response.setResponse(applicationResponse);
        }

        public void setSuspended(boolean suspended) {
            this.response.setSuspended(suspended);
        }

        public boolean isSuspended() {
            return this.response.isSuspended();
        }

        public boolean isClosed() {
            return this.response.isClosed();
        }

        public boolean setError() {
            return this.response.setError();
        }

        public String toString() {
            return this.response.toString();
        }

        public boolean isError() {
            return this.response.isError();
        }

        public boolean isErrorReportRequired() {
            return this.response.isErrorReportRequired();
        }

        public boolean setErrorReported() {
            return this.response.setErrorReported();
        }

        public void resetError() {
            this.response.resetError();
        }

        public void finishResponse() throws IOException {
            this.response.finishResponse();
        }

        public int getContentLength() {
            return this.response.getContentLength();
        }

        public String getContentType() {
            return this.response.getContentType();
        }

        public PrintWriter getReporter() throws IOException {
            return this.response.getReporter();
        }

        public void flushBuffer() throws IOException {
            this.response.flushBuffer();
        }

        public int getBufferSize() {
            return this.response.getBufferSize();
        }

        public String getCharacterEncoding() {
            return this.response.getCharacterEncoding();
        }

        public Locale getLocale() {
            return this.response.getLocale();
        }

        public boolean isCommitted() {
            return this.response.isCommitted();
        }

        public void reset() {
            this.response.reset();
        }

        public void resetBuffer() {
            this.response.resetBuffer();
        }

        public void resetBuffer(boolean resetWriterStreamFlags) {
            this.response.resetBuffer(resetWriterStreamFlags);
        }

        public void setBufferSize(int size) {
            this.response.setBufferSize(size);
        }

        public void setContentLength(int length) {
            this.response.setContentLength(length);
        }

        public void setContentLengthLong(long length) {
            this.response.setContentLengthLong(length);
        }

        public void setContentType(String type) {
            this.response.setContentType(type);
        }

        public void setCharacterEncoding(String encoding) {
            this.response.setCharacterEncoding(encoding);
        }

        public void setLocale(Locale locale) {
            this.response.setLocale(locale);
        }

        public String getHeader(String name) {
            return this.response.getHeader(name);
        }

        public Collection<String> getHeaderNames() {
            return this.response.getHeaderNames();
        }

        public Collection<String> getHeaders(String name) {
            return this.response.getHeaders(name);
        }

        public String getMessage() {
            return this.response.getMessage();
        }

        public int getStatus() {
            return this.response.getStatus();
        }

        public void addCookie(Cookie cookie) {
            this.response.addCookie(cookie);
        }

        public void addSessionCookieInternal(Cookie cookie) {
            this.response.addSessionCookieInternal(cookie);
        }

        public String generateCookieString(Cookie cookie) {
            return this.response.generateCookieString(cookie);
        }

        public void addDateHeader(String name, long value) {
            this.response.addDateHeader(name, value);
        }

        public void addHeader(String name, String value) {
            this.response.addHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            this.response.addIntHeader(name, value);
        }

        public boolean containsHeader(String name) {
            return this.response.containsHeader(name);
        }

        public void setTrailerFields(Supplier<Map<String, String>> supplier) {
            this.response.setTrailerFields(supplier);
        }

        public Supplier<Map<String, String>> getTrailerFields() {
            return this.response.getTrailerFields();
        }

        public String encodeRedirectURL(String url) {
            return this.response.encodeRedirectURL(url);
        }

        public String encodeURL(String url) {
            return this.response.encodeURL(url);
        }

        public void sendAcknowledgement(ContinueResponseTiming continueResponseTiming) throws IOException {
            this.response.sendAcknowledgement(continueResponseTiming);
        }

        public void sendEarlyHints() {
            this.response.sendEarlyHints();
        }

        public void sendError(int status) throws IOException {
            this.response.sendError(status);
        }

        public void sendError(int status, String message) throws IOException {
            this.response.sendError(status, message);
        }

        public void sendRedirect(String location) throws IOException {
            this.response.sendRedirect(location);
        }

        public void sendRedirect(String location, int status) throws IOException {
            this.response.sendRedirect(location, status);
        }

        public void setDateHeader(String name, long value) {
            this.response.setDateHeader(name, value);
        }

        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            this.response.setIntHeader(name, value);
        }

        public void setStatus(int status) {
            this.response.setStatus(status);
        }

        public byte[] getBufferedContent() {
            return this.buffer.toByteArray();
        }

        private HttpServletResponseWrapper newHttpServletResponseWrapper(HttpServletResponse httpResponse) {
            return new HttpServletResponseWrapper(httpResponse){

                public ServletOutputStream getOutputStream() throws IOException {
                    return ResponseWrapper.this.getOutputStream();
                }

                public PrintWriter getWriter() throws IOException {
                    return ResponseWrapper.this.getWriter();
                }
            };
        }

        private ServletOutputStream newServletOutputStreamWrapper() {
            return new ServletOutputStream(){

                public void write(int b) throws IOException {
                    ResponseWrapper.this.buffer.write(b);
                }

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                }
            };
        }
    }
}

