/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.filter;

import io.meeds.web.security.plugin.RootWebappFilterPlugin;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class WebDavRootWebappFilterPlugin
implements RootWebappFilterPlugin {
    private static final Predicate<String> WINDOWS_MINIREDIR = Pattern.compile("^Microsoft-WebDAV-MiniRedir/[0-9.]+$").asMatchPredicate();
    private static final Predicate<String> LINUX_CADAVER = Pattern.compile("^cadaver/[0-9.]+ neon/[0-9.]+$").asMatchPredicate();
    private static final Predicate<String> LINUX_DAVFS2 = Pattern.compile("^davfs2/[0-9.]+ neon/[0-9.]+$").asMatchPredicate();
    private static final Predicate<String> LINUX_GVFS = Pattern.compile("^gvfs/[0-9.]+$").asMatchPredicate();
    private static final Predicate<String> LINUX_CURL = Pattern.compile("^curl/[0-9.]+.*").asMatchPredicate();
    private static final Predicate<String> MACOS_WEBDAVFS = Pattern.compile("^WebDAVFS/[0-9.]+ .*Darwin/[0-9.]+.*").asMatchPredicate();
    private static final Predicate<String> MACOS_CYBERDUCK = Pattern.compile("^Cyberduck/[0-9.]+ \\(Mac OS X/[0-9.]+\\).*").asMatchPredicate();
    private static final Predicate<String> MACOS_TRANSMIT = Pattern.compile("^Transmit/[0-9.]+ \\(Mac OS X/[0-9.]+\\).*").asMatchPredicate();
    private static final List<Predicate<String>> WEBDAV_PREDICATES = Arrays.asList(WINDOWS_MINIREDIR, LINUX_CADAVER, LINUX_DAVFS2, LINUX_GVFS, LINUX_CURL, MACOS_WEBDAVFS, MACOS_CYBERDUCK, MACOS_TRANSMIT);

    public boolean matches(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        return httpRequest.getRequestURI().equals("/") && this.isWebDav(httpRequest.getHeader("User-Agent"));
    }

    public void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
        httpResponse.sendRedirect("/webdav/drives");
    }

    private boolean isWebDav(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return WEBDAV_PREDICATES.stream().anyMatch(p -> p.test(userAgent));
    }
}

