/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr;

import io.meeds.portal.thumbnail.model.FileContent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.comparators.NaturalComparator;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.ActionData;
import org.exoplatform.documents.model.ActionStatus;
import org.exoplatform.documents.model.ActionType;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.DownloadItem;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FolderNode;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.PermissionEntry;
import org.exoplatform.documents.model.PermissionRole;
import org.exoplatform.documents.model.SymlinkNavigation;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.jcr.bulkactions.BulkStorageActionService;
import org.exoplatform.documents.storage.jcr.search.DocumentFileSearchResult;
import org.exoplatform.documents.storage.jcr.search.DocumentSearchServiceConnector;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.utils.VersionHistoryUtils;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagObject;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class JCRDocumentFileStorage
implements DocumentFileStorage {
    private static final String COLLABORATION = "collaboration";
    private static final List<String> FOLDER_NODE_TYPES = List.of("nt:unstructured", "nt:folder", "exo:symlink", "exo:cssFolder", "exo:jsFolder", "exo:linkFolder", "exo:webFolder");
    private static final List<String> FILE_MIME_TYPES = List.of("image/bmp", "image/jpeg", "image/webp", "image/png", "image/gif", "image/avif", "image/tiff", "application/pdf", "application/zip", "application/vnd.rar", "video/mp4", "video/mpeg", "video/ogg", "video/webm", "video/3gpp", "video/x-msvideo", "text/plain", "application/rtf", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.document.form", "application/vnd.oasis.opendocument.text", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    private final SpaceService spaceService;
    private final RepositoryService repositoryService;
    private final IdentityManager identityManager;
    private final NodeHierarchyCreator nodeHierarchyCreator;
    private final DocumentSearchServiceConnector documentSearchServiceConnector;
    private final ListenerService listenerService;
    private final UploadService uploadService;
    private final IdentityRegistry identityRegistry;
    private final ActivityManager activityManager;
    private final BulkStorageActionService bulkStorageActionService;
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final String SPACE_PATH_PREFIX = "/Groups/spaces/";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final String GROUP_ADMINISTRATORS = "*:/platform/administrators";
    private static final String SPACE_PROVIDER_ID = "space";
    private static final String SHARED_FOLDER_NAME = "Shared";
    private static final String EOO_COMMENT_ID = "eoo:commentId";
    private static final String ADD_TAG_DOCUMENT = "add_tag_document";
    private static final String KEEP_BOTH = "keepBoth";
    private static final String CREATE_NEW_VERSION = "createNewVersion";
    private static final String ZIP_PREFIX = "downloadzip";
    public static final String TEMP_DOWNLOAD_FOLDER_PREFIX = "temp_download";
    public static final String TEMP_IMPORT_FOLDER_PREFIX = "temp_import";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private static Map<Long, List<SymlinkNavigation>> symlinksNavHistory = new HashMap<Long, List<SymlinkNavigation>>();
    private static final Log LOG = ExoLogger.getLogger(JCRDocumentFileStorage.class);

    public JCRDocumentFileStorage(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, DocumentSearchServiceConnector documentSearchServiceConnector, IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService, UploadService uploadService, IdentityRegistry identityRegistry, ActivityManager activityManager, BulkStorageActionService bulkStorageActionService) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.repositoryService = repositoryService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.documentSearchServiceConnector = documentSearchServiceConnector;
        this.listenerService = listenerService;
        this.uploadService = uploadService;
        this.identityRegistry = identityRegistry;
        this.activityManager = activityManager;
        this.bulkStorageActionService = bulkStorageActionService;
    }

    public List<FileNode> getFilesTimeline(DocumentTimelineFilter filter, Identity aclIdentity, int offset, int limit) throws ObjectNotFoundException {
        List<FileNode> files = null;
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        boolean showHiddenFiles = filter.isIncludeHiddenFiles();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode;
            Object manageableRepository;
            if (StringUtils.isNotBlank((CharSequence)filter.getParentFolderId())) {
                manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository);
                identityRootNode = JCRDocumentsUtil.getNodeByIdentifier(session, filter.getParentFolderId());
                if (identityRootNode != null && identityRootNode.isNodeType("exo:symlink")) {
                    String sourceNodeId = identityRootNode.getProperty("exo:uuid").getString();
                    identityRootNode = JCRDocumentsUtil.getNodeByIdentifier(session, sourceNodeId);
                }
            } else {
                identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
            }
            if (identityRootNode == null) {
                manageableRepository = Collections.emptyList();
                return manageableRepository;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            if (StringUtils.isBlank((CharSequence)filter.getQuery()) && BooleanUtils.isNotTrue((Boolean)filter.getFavorites()) && StringUtils.isEmpty((CharSequence)filter.getFileTypes()) && filter.getAfterDate() == null && filter.getBeforeDate() == null && filter.getMaxSize() == null && filter.getMinSize() == null) {
                String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, true);
                String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                String statement = this.getTimeLineQueryStatement(rootPath, sortField, sortDirection, filter, showHiddenFiles);
                Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                ((QueryImpl)jcrQuery).setOffset((long)offset);
                ((QueryImpl)jcrQuery).setLimit((long)limit);
                QueryResult queryResult = jcrQuery.execute();
                NodeIterator nodeIterator = queryResult.getNodes();
                List<FileNode> list = files = JCRDocumentsUtil.toFileNodes(this.identityManager, nodeIterator, aclIdentity, session, this.spaceService, showHiddenFiles);
                return list;
            }
            String workspace = session.getWorkspace().getName();
            String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, false);
            String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
            Collection<DocumentFileSearchResult> filesSearchList = this.documentSearchServiceConnector.search(aclIdentity, workspace, rootPath, (DocumentNodeFilter)filter, offset, limit, sortField, sortDirection);
            List<FileNode> list = filesSearchList.stream().map(result -> JCRDocumentsUtil.toFileNode(this.identityManager, session, aclIdentity, result, this.spaceService)).filter(item -> item != null && (!item.isHidden() || filter.isIncludeHiddenFiles())).collect(Collectors.toList());
            return list;
        }
    }

    public List<String> getFavoriteFileIds(DocumentNodeFilter filter, Identity aclIdentity, int offset, int limit) {
        String sortField = JCRDocumentsUtil.getSortField(filter, false);
        String sortDirection = JCRDocumentsUtil.getSortDirection(filter);
        Collection<DocumentFileSearchResult> filesSearchList = this.documentSearchServiceConnector.search(aclIdentity, COLLABORATION, "/", filter, offset, limit, sortField, sortDirection);
        return filesSearchList.stream().map(DocumentFileSearchResult::getId).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileNode> search(String keyword, Identity identity, int offset, int limit) {
        List<FileNode> list;
        block6: {
            SessionProvider sessionProvider = null;
            try {
                sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity);
                ManageableRepository repository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                DocumentTimelineFilter filter = new DocumentTimelineFilter();
                filter.setQuery(keyword);
                filter.setMimeTypes(FILE_MIME_TYPES);
                Collection<DocumentFileSearchResult> results = this.documentSearchServiceConnector.search(identity, COLLABORATION, "/", (DocumentNodeFilter)filter, offset, limit, "_score", "DESC");
                list = results.stream().map(result -> JCRDocumentsUtil.toFileNode(this.identityManager, session, identity, result, this.spaceService)).filter(Objects::nonNull).filter(FileNode.class::isInstance).map(FileNode.class::cast).toList();
                if (sessionProvider == null) break block6;
            }
            catch (Throwable throwable) {
                if (sessionProvider != null) {
                    sessionProvider.close();
                }
                throw throwable;
            }
            sessionProvider.close();
        }
        return list;
    }

    public List<AbstractNode> getBiggestDocuments(Long ownerId, Identity aclIdentity, int offset, int limit) throws ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
            if (identityRootNode == null) {
                ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
                return arrayList;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            String workspace = session.getWorkspace().getName();
            DocumentTimelineFilter filter = new DocumentTimelineFilter();
            Collection<DocumentFileSearchResult> results = this.documentSearchServiceConnector.search(aclIdentity, workspace, rootPath, (DocumentNodeFilter)filter, offset, limit, "fileSizeWithVersions", "DESC");
            List<AbstractNode> list = results.stream().map(result -> JCRDocumentsUtil.toFileNode(this.identityManager, session, aclIdentity, result, this.spaceService)).filter(item -> item != null && (!item.isHidden() || filter.isIncludeHiddenFiles())).toList();
            return list;
        }
    }

    public long calculateFilesSize(Long ownerId, Identity aclIdentity) throws ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
            if (identityRootNode == null) {
                long l = 0L;
                return l;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            String workspace = session.getWorkspace().getName();
            long l = this.documentSearchServiceConnector.getTotalSize(aclIdentity, workspace, rootPath);
            return l;
        }
    }

    public DocumentGroupsSize getGroupDocumentsCount(DocumentTimelineFilter filter, Identity aclIdentity) throws ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        DocumentGroupsSize documentGroupsSize = new DocumentGroupsSize();
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
            if (identityRootNode == null) {
                DocumentGroupsSize documentGroupsSize2 = documentGroupsSize;
                return documentGroupsSize2;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            if (StringUtils.isBlank((CharSequence)filter.getQuery())) {
                String statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, null, new Date());
                Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult queryResult = jcrQuery.execute();
                documentGroupsSize.setThisDay(queryResult.getRows().getSize());
                Calendar thisWeek = GregorianCalendar.getInstance();
                thisWeek.set(7, 1);
                Calendar thisMonth = GregorianCalendar.getInstance();
                thisMonth.set(5, 0);
                Calendar thisYear = GregorianCalendar.getInstance();
                thisYear.set(6, 0);
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, new Date(), thisWeek.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisWeek(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisWeek.getTime(), thisMonth.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisMonth(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisMonth.getTime(), thisYear.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisYear(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisYear.getTime(), null);
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setBeforeThisYear(queryResult.getRows().getSize());
                DocumentGroupsSize documentGroupsSize3 = documentGroupsSize;
                return documentGroupsSize3;
            }
            DocumentGroupsSize documentGroupsSize4 = documentGroupsSize;
            return documentGroupsSize4;
        }
    }

    public List<AbstractNode> getFolderChildNodes(DocumentFolderFilter filter, Identity aclIdentity, int offset, int limit) throws IllegalAccessException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        String parentFolderId = filter.getParentFolderId();
        Object folderPath = filter.getFolderPath();
        boolean includeHiddenFiles = filter.isIncludeHiddenFiles();
        try (SessionProvider sessionProvider = null;){
            Node parent = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)parentFolderId)) {
                Long ownerId = filter.getOwnerId();
                String userId = filter.getUserId();
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = null;
                if (StringUtils.isNotBlank((CharSequence)folderPath) && !((String)folderPath).startsWith("/")) {
                    folderPath = "/" + (String)folderPath;
                }
                if (StringUtils.isNotEmpty((CharSequence)filter.getUserId())) {
                    ownerIdentity = this.identityManager.getOrCreateUserIdentity(userId);
                    parent = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                } else {
                    ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                    parent = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, ownerIdentity, session);
                }
                parentFolderId = ((NodeImpl)parent).getIdentifier();
            } else {
                parent = JCRDocumentsUtil.getNodeByIdentifier(session, parentFolderId);
                if (parent != null && parent.isNodeType("exo:symlink")) {
                    String sourceNodeId = parent.getProperty("exo:uuid").getString();
                    parent = JCRDocumentsUtil.getNodeByIdentifier(session, sourceNodeId);
                }
                if (filter.getSymlinkId() != null && !filter.getSymlinkId().isEmpty()) {
                    List<SymlinkNavigation> history = symlinksNavHistory.get(filter.getOwnerId());
                    SymlinkNavigation newEntry = new SymlinkNavigation(filter.getSymlinkId(), parentFolderId);
                    if (history == null) {
                        history = new ArrayList<SymlinkNavigation>();
                        history.add(newEntry);
                    } else if (!history.contains(newEntry)) {
                        history.add(newEntry);
                    }
                    symlinksNavHistory.put(filter.getOwnerId(), history);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                parent = this.getNodeByPath(parent, (String)folderPath, sessionProvider);
            }
            if (parent != null) {
                if (StringUtils.isBlank((CharSequence)filter.getQuery()) && BooleanUtils.isNotTrue((Boolean)filter.getFavorites()) && StringUtils.isEmpty((CharSequence)filter.getFileTypes()) && filter.getAfterDate() == null && filter.getBeforeDate() == null && filter.getMaxSize() == null && filter.getMinSize() == null) {
                    String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, true);
                    String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                    String statementOfFolders = this.getFolderDocumentsQuery(parent.getPath(), sortField, sortDirection, FOLDER_NODE_TYPES, filter.getCategoryIds(), filter.getExcludedCategoryIds(), includeHiddenFiles);
                    Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statementOfFolders, "sql");
                    ((QueryImpl)jcrQuery).setOffset((long)offset);
                    ((QueryImpl)jcrQuery).setLimit((long)limit);
                    QueryResult queryResult = jcrQuery.execute();
                    NodeIterator nodeIterator = queryResult.getNodes();
                    ArrayList<AbstractNode> fileItems = new ArrayList<AbstractNode>(JCRDocumentsUtil.toNodes(this.identityManager, session, nodeIterator, aclIdentity, this.spaceService, includeHiddenFiles, filter).stream().filter(AbstractNode::isFolder).toList());
                    int itemsSize = fileItems.size();
                    if (itemsSize < limit) {
                        String statementOfSymlinks = this.getFolderDocumentsQuery(parent.getPath(), sortField, sortDirection, List.of("nt:file", "exo:symlink"), filter.getCategoryIds(), filter.getExcludedCategoryIds(), includeHiddenFiles);
                        jcrQuery = session.getWorkspace().getQueryManager().createQuery(statementOfSymlinks, "sql");
                        ((QueryImpl)jcrQuery).setOffset(0L);
                        ((QueryImpl)jcrQuery).setLimit((long)limit);
                        queryResult = jcrQuery.execute();
                        nodeIterator = queryResult.getNodes();
                        List<AbstractNode> fileItemsToAdd = JCRDocumentsUtil.toNodes(this.identityManager, session, nodeIterator, aclIdentity, this.spaceService, includeHiddenFiles, filter).stream().filter(f -> !f.isFolder()).toList();
                        int limitToAdd = limit - itemsSize;
                        if (fileItemsToAdd.size() > limitToAdd) {
                            fileItems.addAll(fileItemsToAdd.subList(0, limit - itemsSize));
                        } else {
                            fileItems.addAll(fileItemsToAdd);
                        }
                    }
                    ArrayList<AbstractNode> arrayList = fileItems;
                    return arrayList;
                }
                String workspace = session.getWorkspace().getName();
                String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, false);
                String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                Collection<DocumentFileSearchResult> filesSearchList = this.documentSearchServiceConnector.search(aclIdentity, workspace, parent.getPath(), (DocumentNodeFilter)filter, offset, limit, sortField, sortDirection);
                List<AbstractNode> list = filesSearchList.stream().map(result -> JCRDocumentsUtil.toFileNode(this.identityManager, session, aclIdentity, result, this.spaceService)).filter(item -> item != null && (!item.isHidden() || filter.isIncludeHiddenFiles())).collect(Collectors.toList());
                return list;
            }
            try {
                throw new ObjectNotFoundException("Folder with Id : " + parentFolderId + " isn't found");
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving User '" + username + "' parent node", e);
            }
        }
    }

    public List<BreadCrumbItem> getBreadcrumb(long ownerId, String folderId, String folderPath, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        ArrayList<BreadCrumbItem> parents;
        block18: {
            String username = aclIdentity.getUserId();
            parents = new ArrayList<BreadCrumbItem>();
            try (SessionProvider sessionProvider = null;){
                Node node = null;
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
                Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                    node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                    folderId = ((NodeImpl)node).getIdentifier();
                } else {
                    node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
                }
                if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                    node = this.getNodeByPath(node, folderPath, sessionProvider);
                }
                Object homePath = "";
                if (node == null) break block18;
                String nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getName(), node.getPath(), node.isNodeType("exo:symlink"), this.countNodeAccessList(node, aclIdentity)));
                if (node.getPath().contains("/Groups/spaces/")) {
                    String[] pathParts = node.getPath().split("/Groups/spaces/")[1].split("/");
                    homePath = "/Groups/spaces/" + pathParts[0] + "/" + pathParts[1];
                }
                String userPrivatePathPrefix = username + "/Private";
                String userPublicPathPrefix = username + "/Public";
                if (node.getPath().contains(userPrivatePathPrefix)) {
                    homePath = node.getPath().substring(0, node.getPath().lastIndexOf(userPrivatePathPrefix) + userPrivatePathPrefix.length());
                }
                if (node.getPath().contains(userPublicPathPrefix)) {
                    homePath = node.getPath().substring(0, node.getPath().lastIndexOf(userPublicPathPrefix) + userPublicPathPrefix.length());
                }
                while (node != null && (!node.getPath().equals(homePath) || node.getName().equals("Public"))) {
                    try {
                        Node parentNode;
                        if (node.getName().equals("Public")) {
                            node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                            if (node != null) {
                                nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                                parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getName(), node.getPath(), node.isNodeType("exo:symlink"), this.countNodeAccessList(node, aclIdentity)));
                            }
                            break;
                        }
                        node = parentNode = node.getParent();
                        if ((node = this.checkSymlinkHistory(node, session, ownerId)) == null) continue;
                        nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                        String identifier = ((NodeImpl)node).getIdentifier();
                        if (parents.stream().anyMatch(breadCrumbItem -> breadCrumbItem.isSymlink() && breadCrumbItem.getId().equals(identifier))) {
                            node = parentNode;
                        }
                        parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getName(), node.getPath(), node.isNodeType("exo:symlink"), this.countNodeAccessList(node, aclIdentity)));
                    }
                    catch (RepositoryException repositoryException) {
                        node = null;
                    }
                }
            }
        }
        return parents;
    }

    Node checkSymlinkHistory(Node node, Session session, Long ownerId) throws RepositoryException {
        List<SymlinkNavigation> history = symlinksNavHistory.get(ownerId);
        if (node != null && history != null && !history.isEmpty()) {
            String id = ((NodeImpl)node).getIdentifier();
            SymlinkNavigation symlink = history.stream().filter(item -> id.equals(item.getSourceId())).findAny().orElse(null);
            if (symlink != null) {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, symlink.getSymlinkId());
            }
        }
        return node;
    }

    public List<FullTreeItem> getFullTreeData(long ownerId, String folderId, String destinationFolderPath, Identity aclIdentity, boolean withChildren, boolean showHidden) {
        String username = aclIdentity.getUserId();
        ArrayList<FullTreeItem> parents = new ArrayList<FullTreeItem>();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            Node destinationNode = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                folderId = ((NodeImpl)node).getIdentifier();
                if (StringUtils.isNotEmpty((CharSequence)destinationFolderPath)) {
                    if ((destinationFolderPath = URLDecoder.decode(destinationFolderPath, StandardCharsets.UTF_8)).contains(node.getName()) && !destinationFolderPath.endsWith(node.getName())) {
                        destinationFolderPath = destinationFolderPath.split(node.getName())[1];
                    }
                    if (node.hasNode(destinationFolderPath)) {
                        destinationNode = node.getNode(destinationFolderPath);
                    }
                }
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
            }
            if (node != null) {
                String nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                List<FullTreeItem> children = this.getAllFolderInNode(node, session, destinationNode, withChildren, showHidden);
                parents.add(new FullTreeItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath(), children, showHidden && node.isNodeType("exo:hiddenable"), null));
            }
        }
        return parents;
    }

    private List<FullTreeItem> getAllFolderInNode(Node node, Session session, Node destinationNode, boolean withChildren, boolean showHidden) throws RepositoryException {
        ArrayList<FullTreeItem> folderListNodes = new ArrayList<FullTreeItem>();
        NodeIterator nodeIter = node.getNodes();
        while (nodeIter.hasNext()) {
            String nodeName;
            Node childNode = nodeIter.nextNode();
            if (!showHidden && (childNode.isNodeType("exo:hiddenable") || !childNode.isNodeType("nt:unstructured") && !childNode.isNodeType("nt:folder") && !childNode.isNodeType("exo:symlink"))) continue;
            String string = nodeName = childNode.hasProperty("exo:title") ? childNode.getProperty("exo:title").getString() : childNode.getName();
            if (childNode.isNodeType("exo:symlink")) {
                Node parentNode = JCRDocumentsUtil.getNodeByIdentifier(session, childNode.getProperty("exo:uuid").getString());
                if (parentNode != null && (!parentNode.isNodeType("nt:unstructured") && !parentNode.isNodeType("nt:folder") || childNode.getPath().contains(parentNode.getPath()))) continue;
                childNode = parentNode;
            }
            if (childNode == null) continue;
            List<Object> folderChildListNodes = new ArrayList();
            if (withChildren || destinationNode != null && destinationNode.getPath().contains(childNode.getPath())) {
                folderChildListNodes = this.getAllFolderInNode(childNode, session, destinationNode, withChildren, showHidden);
            } else if (!this.hasFolderNodes(childNode, showHidden)) {
                folderChildListNodes = null;
            }
            folderListNodes.add(new FullTreeItem(((NodeImpl)childNode).getIdentifier(), nodeName, childNode.getPath(), folderChildListNodes, showHidden && childNode.isNodeType("exo:hiddenable"), null));
        }
        return folderListNodes.stream().sorted((fullTreeItem1, fullTreeItem2) -> new NaturalComparator().compare(fullTreeItem1.getName(), fullTreeItem2.getName())).toList();
    }

    public AbstractNode createFolder(long ownerId, String folderId, String folderPath, String title, Identity aclIdentity) throws ObjectAlreadyExistsException, IllegalAccessException {
        if (!JCRDocumentsUtil.isValidDocumentTitle(title)) {
            throw new IllegalArgumentException("folder title is not valid");
        }
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            String canEdit;
            Map<String, Boolean> nodeAccessList;
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                folderId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                try {
                    node = node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
                }
                catch (RepositoryException repositoryException) {
                    throw new ObjectNotFoundException("Folder with path : " + folderPath + " isn't found");
                }
            }
            if ((nodeAccessList = this.countNodeAccessList(node, aclIdentity)).containsKey(canEdit = "canEdit") && !nodeAccessList.get(canEdit).booleanValue()) {
                throw new IllegalAccessException("Permission to add folder is missing");
            }
            nodeAccessList = null;
            String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(title.toLowerCase(), "nt:folder"));
            if (node.hasNode(name)) {
                throw new ObjectAlreadyExistsException((Object)("Folder'" + name + "' already exist"));
            }
            Node addedNode = node.addNode(name, "nt:folder");
            addedNode.setProperty("exo:title", title);
            if (addedNode.canAddMixin("mix:referenceable")) {
                addedNode.addMixin("mix:referenceable");
            }
            node.save();
            FolderNode folderNode = JCRDocumentsUtil.toFolderNode(this.identityManager, aclIdentity, addedNode, "", this.spaceService);
            return folderNode;
        }
    }

    public String getNewName(long ownerId, String folderId, String folderPath, String title) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        try (SessionProvider systemSessionProvider = null;){
            Node node = null;
            systemSessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = systemSessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, ownerIdentity, systemSession);
                folderId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(systemSession, folderId);
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                try {
                    node = node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
                }
                catch (RepositoryException repositoryException) {
                    throw new ObjectNotFoundException("Folder with path : " + folderPath + " isn't found");
                }
            }
            String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(title.toLowerCase(), "nt:folder"));
            int i = 0;
            String newName = name;
            Object newTitle = title;
            while (node.hasNode(newName)) {
                newTitle = title + " (" + ++i + ")";
                newName = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(((String)newTitle).toLowerCase(), "nt:folder"));
            }
            String string = newTitle;
            return string;
        }
    }

    public void renameDocument(long ownerId, String documentID, String title, Identity aclIdentity) throws ObjectAlreadyExistsException {
        if (!JCRDocumentsUtil.isValidDocumentTitle(title)) {
            throw new IllegalArgumentException("document title is not valid");
        }
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)documentID) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                documentID = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            }
            String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(title.toLowerCase(), node.getPrimaryNodeType().getName()));
            name = JCRDocumentsUtil.cleanNameWithAccents(name, node.getPrimaryNodeType().getName());
            name = URLDecoder.decode(name, "UTF-8");
            if (name.indexOf(46) == -1) {
                String oldName;
                String string = oldName = node.getName().indexOf(46) == -1 && node.isNodeType("nt:file") && node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                if (oldName.indexOf(46) != -1 && node.isNodeType("nt:file")) {
                    String ext = oldName.substring(oldName.lastIndexOf(46));
                    title = title.concat(ext);
                    name = name.concat(ext);
                }
            }
            this.checkNodeExistence(session, node, name);
            if (node.canAddMixin("exo:modify")) {
                node.addMixin("exo:modify");
            }
            Calendar now = Calendar.getInstance();
            node.setProperty("exo:dateModified", now);
            node.setProperty("exo:lastModifiedDate", now);
            node.setProperty("exo:lastModifier", username);
            if (node.canAddMixin("exo:sortable")) {
                node.addMixin("exo:sortable");
            }
            node.save();
            Node parent = node.getParent();
            String srcPath = node.getPath();
            String destPath = (parent.getPath().equals("/") ? "" : parent.getPath()).concat("/").concat(name);
            if (!srcPath.equals(destPath)) {
                node.getSession().getWorkspace().move(srcPath, destPath);
            }
            if (!node.isNodeType("exo:rss-enable") && node.canAddMixin("exo:rss-enable")) {
                node.addMixin("exo:rss-enable");
            }
            node.setProperty("exo:title", title);
            node.setProperty("exo:name", name);
            node.save();
        }
    }

    public void setDocumentVisibility(long ownerId, String documentID, Boolean hidden, Identity aclIdentity) throws ObjectAlreadyExistsException {
        if (hidden == null) {
            throw new IllegalArgumentException("Hidden value should not be null");
        }
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)documentID) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                documentID = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            }
            boolean isAlreadyHidden = node.isNodeType("exo:hiddenable");
            if (hidden.booleanValue() && !isAlreadyHidden) {
                node.addMixin("exo:hiddenable");
            } else {
                if (hidden.booleanValue()) {
                    LOG.warn((Object)"current element is aleady hidden, nothing to do");
                    return;
                }
                if (isAlreadyHidden) {
                    node.removeMixin("exo:hiddenable");
                } else {
                    LOG.warn((Object)"current element is not hidden, nothing to do");
                    return;
                }
            }
            if (node.canAddMixin("exo:modify")) {
                node.addMixin("exo:modify");
            }
            Calendar now = Calendar.getInstance();
            node.setProperty("exo:dateModified", now);
            node.setProperty("exo:lastModifiedDate", now);
            node.setProperty("exo:lastModifier", username);
            node.save();
            try {
                this.listenerService.broadcast("hide_folder_event", (Object)node, (Object)hidden);
            }
            catch (Exception e) {
                LOG.error((Object)"cannot broadcast hide folder event");
            }
        }
    }

    private void checkNodeExistence(Session session, Node node, String title) throws RepositoryException, ObjectAlreadyExistsException {
        Node current = node;
        if (current != null && current.isNodeType("exo:symlink")) {
            current = JCRDocumentsUtil.getNodeByIdentifier(session, current.getProperty("exo:uuid").getString());
        }
        if (current != null && node.getParent() != null && node.getParent().hasNode(title)) {
            Node existNode = node.getParent().getNode(title);
            Node existCurrent = existNode;
            if (existCurrent.isNodeType("exo:symlink")) {
                existCurrent = JCRDocumentsUtil.getNodeByIdentifier(session, existCurrent.getProperty("exo:uuid").getString());
            }
            if (existCurrent != null) {
                String primaryType = existCurrent.getPrimaryNodeType().getName();
                if (node != existNode && current.getPrimaryNodeType().getName().equals(primaryType)) {
                    throw new ObjectAlreadyExistsException((Object)"Document with same name already exist");
                }
            }
        }
    }

    public AbstractNode duplicateDocument(long ownerId, String fileId, String prefixClone, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node oldNode = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)fileId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                oldNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                fileId = ((NodeImpl)oldNode).getIdentifier();
            } else {
                oldNode = JCRDocumentsUtil.getNodeByIdentifier(session, fileId);
            }
            Node parentNode = oldNode.getParent();
            Node newNode = null;
            if (oldNode != null) {
                newNode = this.duplicateItem(oldNode, parentNode, parentNode, prefixClone);
                parentNode.save();
            }
            VersionHistoryUtils.createVersion(newNode);
            FileNode fileNode = JCRDocumentsUtil.toFileNode(this.identityManager, aclIdentity, parentNode, "", this.spaceService);
            return fileNode;
        }
    }

    public AbstractNode copyDocument(String nodeId, String destintionNodeId, Identity aclIdentity) throws ObjectNotFoundException {
        try (SessionProvider sessionProvider = null;){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            Node sourceNode = JCRDocumentsUtil.getNodeByIdentifier(session, nodeId);
            if (sourceNode == null) {
                throw new ObjectNotFoundException("Source node with id '" + nodeId + "' not found");
            }
            Node destintionNode = JCRDocumentsUtil.getNodeByIdentifier(session, destintionNodeId);
            if (destintionNode == null) {
                throw new ObjectNotFoundException("Destintion node with id '" + nodeId + "' not found");
            }
            Node newNode = null;
            newNode = this.duplicateItem(sourceNode, destintionNode, sourceNode.getParent(), "");
            destintionNode.save();
            VersionHistoryUtils.createVersion((Node)newNode);
            FileNode fileNode = JCRDocumentsUtil.toFileNode(this.identityManager, aclIdentity, destintionNode, "", this.spaceService);
            return fileNode;
        }
    }

    public void moveDocument(Session session, long ownerId, String fileId, String destPath, Identity aclIdentity, String conflictAction) throws Exception {
        Node node;
        String username = aclIdentity.getUserId();
        if (StringUtils.isBlank((CharSequence)fileId) && ownerId > 0L) {
            org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
            SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
        } else {
            node = JCRDocumentsUtil.getNodeByIdentifier(session, fileId);
        }
        if (node == null) {
            return;
        }
        if (node.canAddMixin("exo:modify")) {
            node.addMixin("exo:modify");
        }
        Calendar now = Calendar.getInstance();
        node.setProperty("exo:dateModified", now);
        node.setProperty("exo:lastModifiedDate", now);
        node.setProperty("exo:lastModifier", username);
        node.save();
        String srcPath = node.getPath();
        if (session.itemExists(destPath + "/" + node.getName())) {
            this.handleMoveDocConflict(session, node, srcPath, destPath, conflictAction);
        } else {
            node.getSession().getWorkspace().move(srcPath, destPath + "/" + node.getName());
            node.save();
        }
    }

    public void moveDocument(long ownerId, String fileId, String destPath, Identity aclIdentity, String conflictAction) throws ObjectAlreadyExistsException {
        try (SessionProvider sessionProvider = null;){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            this.moveDocument(session, ownerId, fileId, destPath, aclIdentity, conflictAction);
        }
    }

    public List<Long> getDocumentCategoryIds(long ownerId, Identity aclIdentity) {
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(ownerId);
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, ownerIdentity.getRemoteId(), ownerIdentity, sessionProvider);
            if (identityRootNode == null) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            String query = "SELECT exo:categoryIds FROM nt:base WHERE 'mix:documentsCategory' IN jcr:mixinTypes AND jcr:path LIKE '" + rootPath + "/%' AND (jcr:primaryType = 'nt:file' OR jcr:primaryType = 'exo:symlink')";
            Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(query, "sql");
            QueryResult result = jcrQuery.execute();
            HashSet<Long> ids = new HashSet<Long>();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Value[] values;
                Node node = nodes.nextNode();
                if (!node.hasProperty("exo:categoryIds")) continue;
                for (Value value : values = node.getProperty("exo:categoryIds").getValues()) {
                    try {
                        ids.add(Long.parseLong(value.getString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ArrayList<Long> arrayList = new ArrayList<Long>(ids);
            return arrayList;
        }
    }

    private void handleMoveDocConflict(Session session, Node node, String srcPath, String destPath, String conflictAction) throws RepositoryException, ObjectAlreadyExistsException {
        String originName;
        int count = 0;
        String name = originName = node.getName();
        if (Objects.equals(conflictAction, KEEP_BOTH)) {
            while (session.itemExists((String)destPath + "/" + name)) {
                name = JCRDocumentsUtil.increaseNameIndex(originName, ++count);
            }
            destPath = (String)destPath + "/" + name;
            node.getSession().getWorkspace().move(srcPath, (String)destPath);
            Node destNode = (Node)session.getItem((String)destPath);
            if (destNode.hasProperty("exo:title")) {
                String exoTitle = JCRDocumentsUtil.getNewIndexedName(destNode.getProperty("exo:title").getString(), "(" + count + ")");
                destNode.setProperty("exo:title", exoTitle);
            }
            destNode.getSession().save();
        } else if (Objects.equals(conflictAction, CREATE_NEW_VERSION)) {
            Node destNode = (Node)session.getItem((String)destPath + "/" + name);
            Node scrNode = (Node)session.getItem(srcPath);
            if (destNode.isNodeType("mix:versionable")) {
                Node destContentNode = destNode.getNode("jcr:content");
                Node scrContentNode = scrNode.getNode("jcr:content");
                destContentNode.setProperty("jcr:data", scrContentNode.getProperty("jcr:data").getStream());
                destContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                if (destNode.isNodeType("exo:modify")) {
                    destNode.setProperty("exo:dateModified", Calendar.getInstance());
                    destNode.setProperty("exo:lastModifiedDate", Calendar.getInstance());
                }
                destNode.save();
                scrNode.remove();
                if (!destNode.isCheckedOut()) {
                    destNode.checkout();
                }
                destNode.checkin();
                destNode.checkout();
                destNode.getSession().save();
            }
        } else {
            Node destNode = (Node)session.getItem((String)destPath + "/" + name);
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("versionable", destNode.isNodeType("mix:versionable"));
            throw new ObjectAlreadyExistsException(map);
        }
    }

    private Node duplicateItem(Node oldNode, Node destinationNode, Node parentNode, String prefixClone) throws RepositoryException, UnsupportedEncodingException {
        Object title;
        if (oldNode.isNodeType("exo:thumbnails")) {
            return null;
        }
        if ((oldNode.isNodeType("nt:unstructured") || oldNode.isNodeType("nt:folder")) && !oldNode.getParent().getPath().equals(destinationNode.getPath()) && oldNode.getPath().contains(destinationNode.getPath())) {
            throw new IllegalStateException("Cannot duplicate a node into its own child");
        }
        Node newNode = null;
        String name = oldNode.getName();
        Object object = title = oldNode.hasProperty("exo:title") ? oldNode.getProperty("exo:title").getString() : oldNode.getName();
        if (((NodeImpl)destinationNode).getIdentifier().equals(((NodeImpl)parentNode).getIdentifier())) {
            if (StringUtils.isNotEmpty((CharSequence)prefixClone)) {
                name = prefixClone.concat(" ").concat(name);
                title = prefixClone.concat(" ").concat((String)title);
            }
            Object newName = name;
            int i = 0;
            while (destinationNode.hasNode((String)newName)) {
                newName = name + " (" + ++i + ")";
            }
            name = ((String)newName).toLowerCase();
            if (i > 0) {
                title = (String)title + " (" + i + ")";
            }
        }
        name = URLDecoder.decode(name, "UTF-8");
        if (oldNode.isNodeType("nt:folder")) {
            newNode = destinationNode.addNode(name.toLowerCase(), "nt:folder");
            newNode.setProperty("exo:title", (String)title);
            NodeIterator nodeIterator = oldNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                this.duplicateItem(node, newNode, parentNode, prefixClone);
            }
        } else {
            newNode = destinationNode.addNode(name, oldNode.getPrimaryNodeType().getName());
            this.addProperties(oldNode, newNode, (String)title);
        }
        return newNode;
    }

    private void addProperties(Node oldNode, Node newNode, String title) throws RepositoryException {
        if (oldNode.isNodeType("mix:versionable") && !newNode.isNodeType("mix:versionable")) {
            newNode.addMixin("mix:versionable");
        }
        if (oldNode.isNodeType("mix:referenceable") && !newNode.isNodeType("mix:referenceable")) {
            newNode.addMixin("mix:referenceable");
        }
        if (oldNode.isNodeType("mix:commentable") && !newNode.isNodeType("mix:commentable")) {
            newNode.addMixin("mix:commentable");
        }
        if (oldNode.isNodeType("mix:votable") && !newNode.isNodeType("mix:votable")) {
            newNode.addMixin("mix:votable");
        }
        if (oldNode.isNodeType("mix:i18n") && !newNode.isNodeType("mix:i18n")) {
            newNode.addMixin("mix:i18n");
        }
        newNode.setProperty("exo:title", title);
        if (oldNode.hasNode("jcr:content")) {
            Node resourceNode = newNode.addNode("jcr:content", "nt:resource");
            Calendar now = Calendar.getInstance();
            resourceNode.setProperty("jcr:lastModified", now);
            resourceNode.setProperty("jcr:data", oldNode.getNode("jcr:content").getProperty("jcr:data").getStream());
            resourceNode.setProperty("jcr:mimeType", oldNode.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            resourceNode.setProperty("exo:dateModified", now);
        }
        if (oldNode.isNodeType("exo:symlink")) {
            newNode.setProperty("exo:workspace", oldNode.getSession().getWorkspace().getName());
            newNode.setProperty("exo:primaryType", oldNode.getPrimaryNodeType().getName());
            newNode.setProperty("exo:uuid", oldNode.getProperty("exo:uuid").getString());
        }
    }

    private String getTimeLineQueryStatement(String rootPath, String sortField, String sortDirection, DocumentTimelineFilter filter, boolean includeHiddenFiles) {
        String hiddenableQuery;
        String string = hiddenableQuery = includeHiddenFiles ? " " : " AND NOT jcr:mixinTypes LIKE 'exo:hiddenable'";
        if (CollectionUtils.isNotEmpty((Collection)filter.getCategoryIds()) && CollectionUtils.isNotEmpty((Collection)filter.getExcludedCategoryIds())) {
            filter.getCategoryIds().removeAll(filter.getExcludedCategoryIds());
        }
        StringBuilder categoryFilter = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)filter.getCategoryIds())) {
            String joinedConditions = filter.getCategoryIds().stream().map(id -> "exo:categoryIds = '" + id + "'").collect(Collectors.joining(" OR "));
            categoryFilter.append(" AND 'mix:documentsCategory' IN jcr:mixinTypes AND (").append(joinedConditions).append(")");
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getExcludedCategoryIds())) {
            String joinedExclude = filter.getExcludedCategoryIds().stream().map(id -> "NOT exo:categoryIds = '" + id + "'").collect(Collectors.joining(" AND "));
            categoryFilter.append(" AND (").append(joinedExclude).append(")");
        }
        return "SELECT * FROM " + "nt:base" + " WHERE jcr:path LIKE '" + rootPath + "/%' " + " AND ( jcr:primaryType='exo:symlink' OR jcr:primaryType='nt:file')" + hiddenableQuery + categoryFilter + " ORDER BY " + sortField + " " + sortDirection;
    }

    private String getFolderDocumentsQuery(String folderPath, String sortField, String sortDirection, List<String> types, List<Long> categoryIds, List<Long> excludedCategoryIds, boolean includeHiddenFiles) {
        String hiddenableQuery;
        String string = hiddenableQuery = includeHiddenFiles ? " " : " AND NOT jcr:mixinTypes LIKE 'exo:hiddenable' ";
        if (CollectionUtils.isNotEmpty(categoryIds) && CollectionUtils.isNotEmpty(excludedCategoryIds)) {
            categoryIds.removeAll(excludedCategoryIds);
        }
        StringBuilder categoryFilter = new StringBuilder();
        if (CollectionUtils.isNotEmpty(categoryIds)) {
            String joinedConditions = categoryIds.stream().map(id -> "exo:categoryIds = '" + id + "'").collect(Collectors.joining(" OR "));
            categoryFilter.append(" AND 'mix:documentsCategory' IN jcr:mixinTypes AND (").append(joinedConditions).append(")");
        }
        if (CollectionUtils.isNotEmpty(excludedCategoryIds)) {
            String joinedExclude = excludedCategoryIds.stream().map(id -> "NOT exo:categoryIds = '" + id + "'").collect(Collectors.joining(" AND "));
            categoryFilter.append(" AND (").append(joinedExclude).append(")");
        }
        String typesStatement = " and (jcr:primaryType ='" + String.join((CharSequence)"' OR jcr:primaryType ='", types) + "') ";
        Object sortQuery = StringUtils.isEmpty((CharSequence)sortField) && StringUtils.isEmpty((CharSequence)sortDirection) ? " " : " ORDER BY " + sortField + " " + sortDirection;
        return "SELECT * FROM nt:base" + " WHERE jcr:path LIKE '" + folderPath + "/%'" + " AND NOT jcr:path LIKE '" + folderPath + "/%/%' " + typesStatement + hiddenableQuery + categoryFilter + (String)sortQuery;
    }

    private String getTimeLineGroupeSizeQueryStatement(String rootPath, Date before, Date after) {
        StringBuilder sb = new StringBuilder().append("SELECT * FROM ").append("nt:file").append(" WHERE jcr:path LIKE '").append(rootPath).append("/%'");
        if (before != null) {
            sb.append(" AND (").append("exo:dateModified").append(" < TIMESTAMP '").append(this.formatter.format(before)).append("T00:00:00.000')");
        }
        if (after != null) {
            sb.append(" AND (").append("exo:dateModified").append(" > TIMESTAMP '").append(this.formatter.format(after)).append("T00:00:00.000')");
        }
        return sb.toString();
    }

    private Node getNodeByPath(Node node, String folderPath, SessionProvider sessionProvider) throws ObjectNotFoundException {
        block17: {
            String parentPath = "";
            try {
                parentPath = node.getPath();
                String cleanedFolderPath = URLDecoder.decode(folderPath.startsWith("/") ? folderPath.substring(1) : folderPath, StandardCharsets.UTF_8).replace("%", "%25");
                if ((node.getName().equals("Private") || node.getName().equals("Public")) && node.hasNode(cleanedFolderPath)) {
                    return node.getNode(cleanedFolderPath);
                }
                if (node.getName().equals("Private")) {
                    if (folderPath.startsWith("Private")) {
                        folderPath = folderPath.split("Private/")[1];
                        if (node.hasNode(folderPath = URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"))) {
                            return node.getNode(folderPath);
                        }
                        return node.getNode(folderPath.toLowerCase());
                    }
                    if (folderPath.startsWith("Public")) {
                        SessionProvider systemSessionProvides = SessionProvider.createSystemProvider();
                        Session systemSession = systemSessionProvides.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
                        Node selectedNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, ((NodeImpl)node).getIdentifier());
                        folderPath = URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25");
                        if (selectedNode != null) {
                            Node parent = selectedNode.getParent();
                            if (parent.hasNode(folderPath)) {
                                return parent.getNode(folderPath);
                            }
                            return parent.getNode(folderPath.toLowerCase());
                        }
                    }
                    break block17;
                }
                if (node.getName().equals("Public")) {
                    if (folderPath.startsWith("Private/Public")) {
                        folderPath = folderPath.split("Private/Public/")[1];
                        if (node.hasNode(folderPath = URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"))) {
                            return node.getNode(folderPath);
                        }
                        return node.getNode(folderPath.toLowerCase());
                    }
                    if (folderPath.startsWith("Public")) {
                        folderPath = folderPath.split("Public/")[1];
                        if (node.hasNode(folderPath = URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"))) {
                            return node.getNode(folderPath);
                        }
                        return node.getNode(folderPath.toLowerCase());
                    }
                    break block17;
                }
                String[] splittedNodePath = folderPath.split("/");
                if (splittedNodePath.length == 0) {
                    return node;
                }
                Node currentNode = node;
                for (String nodeName : splittedNodePath) {
                    if (!StringUtils.isNotBlank((CharSequence)nodeName) || currentNode == null) continue;
                    if (currentNode.isNodeType("exo:symlink")) {
                        String sourceNodeId = currentNode.getProperty("exo:uuid").getString();
                        currentNode = JCRDocumentsUtil.getNodeByIdentifier(currentNode.getSession(), sourceNodeId);
                    }
                    nodeName = URLDecoder.decode(nodeName, StandardCharsets.UTF_8).replace("%", "%25");
                    if (currentNode == null) continue;
                    currentNode = currentNode.hasNode(nodeName) ? currentNode.getNode(nodeName) : currentNode.getNode(nodeName.toLowerCase());
                }
                return currentNode;
            }
            catch (RepositoryException repositoryException) {
                throw new ObjectNotFoundException("Folder with path : " + parentPath + folderPath + " isn't found");
            }
        }
        return null;
    }

    public void updatePermissions(String documentID, NodePermission nodePermissionEntity, Identity aclIdentity) {
        try (SessionProvider sessionProvider = null;){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            HashMap<Object, String[]> permissions = new HashMap<Object, String[]>();
            List permissionsList = nodePermissionEntity.getPermissions();
            if (node.hasProperty("exo:owner")) {
                String owner = node.getProperty("exo:owner").getString();
                permissions.put(owner, PermissionType.ALL);
            }
            permissions.put(GROUP_ADMINISTRATORS, PermissionType.ALL);
            if (nodePermissionEntity.isPublic()) {
                permissions.put("any", new String[]{"read"});
            }
            for (PermissionEntry permission : permissionsList) {
                if (permission.getIdentity().getProviderId().equals(SPACE_PROVIDER_ID)) {
                    Space space = this.spaceService.getSpaceByPrettyName(permission.getIdentity().getRemoteId());
                    String groupId = space.getGroupId();
                    if (permission.getPermission().equals("edit")) {
                        if (permission.getRole().equals(PermissionRole.ALL.name())) {
                            permissions.put("*:" + groupId, PermissionType.ALL);
                        }
                        if (permission.getRole().equals(PermissionRole.MANAGERS_REDACTORS.name())) {
                            permissions.put("manager:" + groupId, PermissionType.ALL);
                            permissions.put("redactor:" + groupId, PermissionType.ALL);
                        }
                    }
                    if (!permission.getPermission().equals("read")) continue;
                    if (permission.getRole().equals(PermissionRole.ALL.name())) {
                        permissions.put("*:" + groupId, new String[]{"read"});
                    }
                    if (!permission.getRole().equals(PermissionRole.MANAGERS_REDACTORS.name())) continue;
                    permissions.put("manager:" + groupId, new String[]{"read"});
                    permissions.put("redactor:" + groupId, new String[]{"read"});
                    continue;
                }
                if (permission.getIdentity().getProviderId().equals("group")) {
                    String groupId = permission.getIdentity().getRemoteId();
                    if (permission.getPermission().equals("edit")) {
                        permissions.put("*:" + groupId, PermissionType.ALL);
                    }
                    if (!permission.getPermission().equals("read")) continue;
                    permissions.put("*:" + groupId, new String[]{"read"});
                    continue;
                }
                if (permission.getPermission().equals("edit")) {
                    permissions.put(permission.getIdentity().getRemoteId(), PermissionType.ALL);
                }
                if (!permission.getPermission().equals("read")) continue;
                permissions.put(permission.getIdentity().getRemoteId(), new String[]{"read"});
            }
            if (node.canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            Calendar now = Calendar.getInstance();
            node.setProperty("exo:dateModified", now);
            node.setProperty("exo:lastModifiedDate", now);
            node.save();
            HashMap toUnShare = new HashMap();
            ((ExtendedNode)node).getACL().getPermissionEntries().forEach(accessControlEntry -> {
                if (!permissions.containsKey(accessControlEntry.getIdentity())) {
                    Space space;
                    if (!(accessControlEntry.getIdentity().startsWith("*:") || accessControlEntry.getIdentity().startsWith("redactor:/") || accessControlEntry.getIdentity().startsWith("manager:/"))) {
                        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(accessControlEntry.getIdentity());
                        if (userIdentity != null) {
                            toUnShare.put(Long.valueOf(userIdentity.getId()), accessControlEntry.getPermission());
                        }
                    } else if (accessControlEntry.getIdentity().startsWith("*:/spaces") && (space = this.spaceService.getSpaceByGroupId(accessControlEntry.getIdentity().substring(2))) != null) {
                        toUnShare.put(Long.valueOf(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId()), accessControlEntry.getPermission());
                    }
                }
            });
            nodePermissionEntity.setToUnShare(toUnShare);
            ((ExtendedNode)node).setPermissions(permissions);
            session.save();
        }
    }

    public void shareDocument(String documentId, long destId, Identity aclIdentity, boolean notifyMember) {
        Node rootNode = null;
        Node shared = null;
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node currentNode = JCRDocumentsUtil.getNodeByIdentifier(session, documentId);
            org.exoplatform.social.core.identity.model.Identity destIdentity = this.identityManager.getIdentity(String.valueOf(destId));
            rootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, destIdentity, session);
            if (!destIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                rootNode = rootNode.getNode("Documents");
            }
            if (!rootNode.hasNode(SHARED_FOLDER_NAME)) {
                shared = rootNode.addNode(SHARED_FOLDER_NAME);
                rootNode.save();
            } else {
                shared = rootNode.getNode(SHARED_FOLDER_NAME);
            }
            if (destIdentity.isSpace()) {
                sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
                session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                shared = JCRDocumentsUtil.getNodeByIdentifier(session, ((ExtendedNode)shared).getIdentifier());
            }
            if (currentNode.isNodeType("exo:symlink")) {
                String sourceNodeId = currentNode.getProperty("exo:uuid").getString();
                currentNode = JCRDocumentsUtil.getNodeByIdentifier(session, sourceNodeId);
            }
            Node linkNode = null;
            if (shared.hasNode(currentNode.getName())) {
                linkNode = shared.getNode(currentNode.getName());
                if (this.isDocumentSharedWithSamePermissions(currentNode, linkNode, destIdentity)) {
                    return;
                }
            } else {
                linkNode = shared.addNode(currentNode.getName(), "exo:symlink");
            }
            linkNode.setProperty("exo:workspace", repository.getConfiguration().getDefaultWorkspaceName());
            linkNode.setProperty("exo:primaryType", currentNode.getPrimaryNodeType().getName());
            linkNode.setProperty("exo:uuid", ((ExtendedNode)currentNode).getIdentifier());
            if (linkNode.canAddMixin("exo:sortable")) {
                linkNode.addMixin("exo:sortable");
            }
            if (currentNode.hasProperty("exo:title")) {
                linkNode.setProperty("exo:title", currentNode.getProperty("exo:title").getString());
            }
            linkNode.setProperty("exo:name", currentNode.getName());
            String nodeMimeType = JCRDocumentsUtil.getMimeType(currentNode);
            linkNode.addMixin("mix:fileType");
            linkNode.setProperty("exo:fileType", nodeMimeType);
            session.save();
            HashMap permissions = new HashMap();
            if (destIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                Space space = this.spaceService.getSpaceByPrettyName(destIdentity.getRemoteId());
                String groupId = space.getGroupId();
                List acc = ((ExtendedNode)currentNode).getACL().getPermissionEntries();
                ArrayList accessControlEntryPermession = new ArrayList();
                acc.stream().forEach(accessControlEntry -> {
                    accessControlEntryPermession.add(accessControlEntry.getPermission());
                    permissions.put(accessControlEntry.getIdentity(), accessControlEntryPermession.toArray(new String[accessControlEntryPermession.size()]));
                });
            } else {
                List acc = ((ExtendedNode)currentNode).getACL().getPermissionEntries();
                ArrayList accessControlEntryPermession = new ArrayList();
                acc.stream().filter(accessControlEntry -> accessControlEntry.getIdentity().equals(destIdentity.getRemoteId())).toList().forEach(accessControlEntry -> {
                    accessControlEntryPermession.add(accessControlEntry.getPermission());
                    permissions.put(accessControlEntry.getIdentity(), accessControlEntryPermession.toArray(new String[accessControlEntryPermession.size()]));
                });
            }
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)linkNode).setPermissions(permissions);
            session.save();
            if (notifyMember) {
                this.notifyMember(documentId, destId);
            } else {
                Utils.broadcast(this.listenerService, "share_document_event", destIdentity, linkNode);
            }
        }
    }

    public boolean isDocumentSharedWithSamePermissions(Node currentNode, Node linkNode, org.exoplatform.social.core.identity.model.Identity destinationIdentity) throws RepositoryException {
        Object destinationRemoteId = destinationIdentity.getProviderId().equals(SPACE_PROVIDER_ID) ? "*:" + this.spaceService.getSpaceByPrettyName(destinationIdentity.getRemoteId()).getGroupId() : destinationIdentity.getRemoteId();
        List<AccessControlEntry> currentNodeAcc = ((ExtendedNode)currentNode).getACL().getPermissionEntries().stream().filter(arg_0 -> JCRDocumentFileStorage.lambda$isDocumentSharedWithSamePermissions$19((String)destinationRemoteId, arg_0)).toList();
        List<AccessControlEntry> linkNodeAcc = ((ExtendedNode)linkNode).getACL().getPermissionEntries().stream().filter(arg_0 -> JCRDocumentFileStorage.lambda$isDocumentSharedWithSamePermissions$20((String)destinationRemoteId, arg_0)).toList();
        return currentNodeAcc.equals(linkNodeAcc);
    }

    public void notifyMember(String documentId, long destId) {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            org.exoplatform.social.core.identity.model.Identity destIdentity = this.identityManager.getIdentity(String.valueOf(destId));
            Node currentNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, documentId);
            Utils.broadcast(this.listenerService, "share_document_event", destIdentity, currentNode);
        }
    }

    public boolean canAccess(String documentID, Identity aclIdentity) {
        try (SessionProvider sessionProvider = null;){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            if (node == null) {
                boolean bl = false;
                return bl;
            }
            String userId = aclIdentity.getUserId();
            List permsList = ((ExtendedNode)node).getACL().getPermissionEntries();
            boolean canAccess = false;
            for (AccessControlEntry accessControlEntry : permsList) {
                String nodeAclIdentity = accessControlEntry.getIdentity();
                MembershipEntry membershipEntry = accessControlEntry.getMembershipEntry();
                if (!StringUtils.equals((CharSequence)nodeAclIdentity, (CharSequence)userId) && !StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)userId) && (membershipEntry == null || !aclIdentity.isMemberOf(membershipEntry) || StringUtils.equals((CharSequence)membershipEntry.toString(), (CharSequence)GROUP_ADMINISTRATORS))) continue;
                canAccess = true;
            }
            boolean bl = canAccess;
            return bl;
        }
    }

    public void updateDocumentDescription(long ownerId, String documentId, String description, Identity aclIdentity) throws RepositoryException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            node = JCRDocumentsUtil.getNodeByIdentifier(session, documentId);
            if (!JCRDocumentsUtil.hasEditPermission(session, node)) {
                throw new AccessDeniedException();
            }
            if (node.canAddMixin("exo:modify")) {
                node.addMixin("exo:modify");
            }
            Calendar now = Calendar.getInstance();
            node.setProperty("exo:dateModified", now);
            node.setProperty("exo:lastModifiedDate", now);
            node.setProperty("exo:lastModifier", username);
            if (node.canAddMixin("dc:elementSet") && !node.hasProperty("dc:description")) {
                node.addMixin("dc:elementSet");
            }
            try {
                node.setProperty("dc:description", description);
            }
            catch (ValueFormatException e) {
                node.setProperty("dc:description", new String[]{description});
            }
            if (node.hasNode("jcr:content")) {
                Node content = node.getNode("jcr:content");
                try {
                    content.setProperty("dc:description", description);
                }
                catch (ValueFormatException e) {
                    content.setProperty("dc:description", new String[]{description});
                }
            }
            node.getSession().save();
            TagService tagService = (TagService)CommonsUtils.getService(TagService.class);
            Set tagNames = tagService.detectTagNames(description);
            if (!tagNames.isEmpty()) {
                org.exoplatform.social.core.identity.model.Identity audienceIdentity = JCRDocumentsUtil.getOwnerIdentityFromNodePath(node.getPath(), this.identityManager, this.spaceService);
                long spaceId = 0L;
                if (audienceIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                    Space space = this.spaceService.getSpaceByPrettyName(audienceIdentity.getRemoteId());
                    spaceId = Long.parseLong(space.getId());
                }
                tagService.saveTags(new TagObject("file", ((ExtendedNode)node).getIdentifier(), null, spaceId), tagNames, Long.parseLong(audienceIdentity.getId()), Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId()));
                this.listenerService.broadcast(ADD_TAG_DOCUMENT, (Object)new TagObject("Document", ((ExtendedNode)node).getIdentifier(), null, spaceId), (Object)tagNames);
            }
        }
    }

    public void createShortcut(String documentId, String destPath, String aclIdentity, String conflictAction) throws IllegalAccessException, ObjectAlreadyExistsException {
        Identity identity = this.identityRegistry.getIdentity(aclIdentity);
        try (SessionProvider sessionProvider = null;){
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity);
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(COLLABORATION, repository);
            Node currentNode = JCRDocumentsUtil.getNodeByIdentifier(session, documentId);
            Node rootNode = (Node)session.getItem(destPath);
            if (currentNode != null && currentNode.isNodeType("exo:symlink")) {
                String sourceNodeId = currentNode.getProperty("exo:uuid").getString();
                currentNode = JCRDocumentsUtil.getNodeByIdentifier(session, sourceNodeId);
            }
            if (!currentNode.isNodeType("mix:referenceable") && currentNode.canAddMixin("mix:referenceable")) {
                currentNode.addMixin("mix:referenceable");
                currentNode.save();
            }
            Node linkNode = currentNode != null && rootNode.hasNode(currentNode.getName()) ? this.handleShortcutDocConflict(rootNode, currentNode, conflictAction) : rootNode.addNode(currentNode.getName(), "exo:symlink");
            linkNode.setProperty("exo:workspace", COLLABORATION);
            linkNode.setProperty("exo:primaryType", currentNode.getPrimaryNodeType().getName());
            linkNode.setProperty("exo:uuid", ((ExtendedNode)currentNode).getIdentifier());
            if (linkNode.canAddMixin("exo:sortable")) {
                linkNode.addMixin("exo:sortable");
            }
            if (currentNode.hasProperty("exo:title") && StringUtils.isBlank((CharSequence)conflictAction)) {
                linkNode.setProperty("exo:title", currentNode.getProperty("exo:title").getString());
            }
            linkNode.setProperty("exo:name", currentNode.getName());
            String nodeMimeType = JCRDocumentsUtil.getMimeType(currentNode);
            linkNode.addMixin("mix:fileType");
            linkNode.setProperty("exo:fileType", nodeMimeType);
            rootNode.save();
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
            }
            HashMap<String, String[]> perMap = new HashMap<String, String[]>();
            ArrayList<String> idList = new ArrayList<String>();
            for (AccessControlEntry accessEntry : ((ExtendedNode)currentNode).getACL().getPermissionEntries()) {
                if (idList.contains(accessEntry.getIdentity())) continue;
                idList.add(accessEntry.getIdentity());
                List permsList = ((ExtendedNode)currentNode).getACL().getPermissions(accessEntry.getIdentity());
                perMap.put(accessEntry.getIdentity(), permsList.toArray(new String[0]));
            }
            ((ExtendedNode)linkNode).setPermissions(perMap);
            session.save();
        }
    }

    private Node handleShortcutDocConflict(Node rootNode, Node currentNode, String conflictAction) throws ObjectAlreadyExistsException, RepositoryException {
        String originName;
        Node linkNode = null;
        boolean created = false;
        int count = 0;
        String name = originName = currentNode.getName();
        boolean doIndexName = rootNode.hasNode(originName);
        if (Objects.equals(conflictAction, KEEP_BOTH)) {
            String path;
            String index;
            do {
                try {
                    linkNode = rootNode.addNode(name, "exo:symlink");
                    created = true;
                }
                catch (ItemExistsException e) {
                    name = JCRDocumentsUtil.increaseNameIndex(originName, ++count);
                    doIndexName = false;
                }
            } while (!created);
            if (doIndexName && StringUtils.isNotBlank((CharSequence)(index = (path = linkNode.getPath()).substring(StringUtils.lastIndexOf((CharSequence)path, (CharSequence)name) + name.length())))) {
                count = Integer.parseInt(index.substring(1, index.lastIndexOf("]"))) - 1;
            }
            if (linkNode.hasProperty("exo:title")) {
                String exoTitle = JCRDocumentsUtil.getNewIndexedName(currentNode.getProperty("exo:title").getString(), "(" + count + ")");
                linkNode.setProperty("exo:title", exoTitle);
            }
        } else {
            throw new ObjectAlreadyExistsException((Object)"Document with same name already exists");
        }
        return linkNode;
    }

    public List<FileVersion> getFileVersions(String fileNodeId, String aclIdentity) {
        ArrayList<FileVersion> fileVersions = new ArrayList<FileVersion>();
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(aclIdentity));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Node node = session.getNodeByUUID(fileNodeId);
            Version rootVersion = node.getVersionHistory().getRootVersion();
            VersionIterator versionIterator = node.getVersionHistory().getAllVersions();
            while (versionIterator.hasNext()) {
                Version version = versionIterator.nextVersion();
                if (version.getUUID().equals(rootVersion.getUUID())) continue;
                fileVersions.add(JCRDocumentsUtil.toFileVersion(version, node, this.identityManager));
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while getting file versions", e);
        }
        fileVersions.sort(Collections.reverseOrder());
        return fileVersions;
    }

    public AbstractNode getDocumentById(String documentId, String username) throws ObjectNotFoundException, IllegalAccessException {
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(username));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, documentId);
            if (node == null) {
                throw new ObjectNotFoundException(String.format("Node with id %s not found", documentId));
            }
            if (node.isNodeType("nt:unstructured") || node.isNodeType("nt:folder")) {
                return JCRDocumentsUtil.toFolderNode(this.identityManager, identity, node, "", this.spaceService);
            }
            return JCRDocumentsUtil.toFileNode(this.identityManager, identity, node, "", this.spaceService);
        }
        catch (ItemNotFoundException e) {
            throw new ObjectNotFoundException(String.format("Node with id %s not found", documentId));
        }
        catch (RepositoryException e) {
            throw new IllegalAccessException(String.format("Node with id %s not accessible to user %s", documentId, username));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNode getDocumentById(String documentId) {
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            Node node = session.getNodeByUUID(documentId);
            FileNode fileNode = node == null ? null : JCRDocumentsUtil.toFileNode(this.identityManager, null, node, "", this.spaceService);
            return fileNode;
        }
    }

    public FileContent getDocumentContent(String documentId, String aclIdentity) throws ObjectNotFoundException {
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(aclIdentity));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, documentId);
            if (node == null) {
                return null;
            }
            if (node.isNodeType("exo:symlink") && (node = JCRDocumentsUtil.getNodeByIdentifier(session, node.getProperty("exo:uuid").getString())) == null) {
                return null;
            }
            Node content = node.getNode("jcr:content");
            return new FileContent(documentId, node.getProperty("exo:title").getString(), content.getProperty("jcr:mimeType").getString(), content.getProperty("jcr:data").getStream(), node.getProperty("exo:dateModified").getDate().getTime());
        }
        catch (ItemNotFoundException e) {
            throw new ObjectNotFoundException("Document with id : " + documentId + " isn't found");
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Cannot get content from document with id : " + documentId, e);
        }
    }

    private static String addVersionLabel(Node node, String label, Version version) throws RepositoryException {
        String[] olLabels;
        for (String oldLabel : olLabels = node.getVersionHistory().getVersionLabels(version)) {
            if (label.equals(oldLabel)) continue;
            node.getVersionHistory().removeVersionLabel(oldLabel);
        }
        node.getVersionHistory().addVersionLabel(version.getName(), label, false);
        return label;
    }

    public FileVersion updateVersionSummary(String originFileId, String versionId, String summary, String aclIdentity) {
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(aclIdentity));
        FileVersion versionFileNode = new FileVersion();
        try {
            ExoSocialActivity activity;
            String commentId;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Node node = session.getNodeByUUID(originFileId);
            Version version = (Version)session.getNodeByUUID(versionId);
            versionFileNode.setId(versionId);
            Node frozen = version.getNode("jcr:frozenNode");
            if (frozen.hasProperty(EOO_COMMENT_ID) && StringUtils.isNotBlank((CharSequence)(commentId = frozen.getProperty(EOO_COMMENT_ID).getString())) && (activity = this.activityManager.getActivity(commentId)) != null) {
                activity.setTitle(summary);
                this.activityManager.updateActivity(activity);
            }
            JCRDocumentFileStorage.addVersionLabel(node, summary, version);
            versionFileNode.setSummary(summary);
            session.save();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while adding or updating version summary", e);
        }
        return versionFileNode;
    }

    public FileVersion restoreVersion(String versionId, String aclIdentity) {
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(aclIdentity));
        FileVersion versionFileNode = new FileVersion();
        try {
            String frozenUuid;
            Node node;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Version version = (Version)session.getNodeByUUID(versionId);
            Node frozen = version.getNode("jcr:frozenNode");
            if (frozen != null && (node = session.getNodeByUUID(frozenUuid = Utils.getStringProperty(frozen, "jcr:frozenUuid"))) != null) {
                node.restore(version, true);
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                Version newVersion = node.checkin();
                versionFileNode = JCRDocumentsUtil.toFileVersion(newVersion, node, this.identityManager);
                node.checkout();
                if (node.isNodeType("exo:modify")) {
                    node.setProperty("exo:dateModified", Calendar.getInstance());
                    node.setProperty("exo:lastModifiedDate", Calendar.getInstance());
                }
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while restoring version", e);
        }
        return versionFileNode;
    }

    public Map<String, Boolean> countNodeAccessList(Node node, Identity aclIdentity) throws RepositoryException {
        HashMap<String, Boolean> keyValuePermission = new HashMap<String, Boolean>();
        if (node == null) {
            return keyValuePermission;
        }
        boolean canAccess = false;
        boolean canEdit = false;
        boolean canDelete = false;
        String userId = aclIdentity.getUserId();
        try {
            ExtendedNode extendedNode = (ExtendedNode)node;
            List permsList = extendedNode.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                String nodeAclIdentity = accessControlEntry.getIdentity();
                MembershipEntry membershipEntry = accessControlEntry.getMembershipEntry();
                if (StringUtils.equals((CharSequence)nodeAclIdentity, (CharSequence)userId) || StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)userId) || membershipEntry != null && aclIdentity.isMemberOf(membershipEntry)) {
                    canEdit = canEdit || accessControlEntry.getPermission().contains("add_node") || accessControlEntry.getPermission().contains("set_property");
                    canDelete = canDelete || accessControlEntry.getPermission().contains("remove");
                    boolean bl = canAccess = canAccess || accessControlEntry.getPermission().contains("read");
                }
                if (!StringUtils.equals((CharSequence)nodeAclIdentity, (CharSequence)userId) && !StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)userId) && (membershipEntry == null || !aclIdentity.isMemberOf(membershipEntry) || StringUtils.equals((CharSequence)membershipEntry.toString(), (CharSequence)GROUP_ADMINISTRATORS))) continue;
                canAccess = true;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error checking access permission for node'" + node.getUUID() + " for user " + aclIdentity.getUserId(), e);
        }
        keyValuePermission.put("canAccess", canAccess);
        keyValuePermission.put("canEdit", canEdit);
        keyValuePermission.put("canDelete", canDelete);
        return keyValuePermission;
    }

    public void downloadDocuments(int actionId, List<AbstractNode> documents, Identity identity, long authenticatedUserId) {
        SessionProvider sessionProvider = null;
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity);
            Session session = sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository);
            ActionData actionData = new ActionData();
            actionData.setActionId(String.valueOf(actionId));
            actionData.setActionType(ActionType.DOWNLOAD.name());
            actionData.setNumberOfItems(documents.size());
            actionData.setIdentity(identity);
            this.bulkStorageActionService.executeBulkAction(session, this, null, this.listenerService, null, documents, actionData, null, null, authenticatedUserId);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error execute download", (Throwable)e);
        }
    }

    public byte[] getDownloadZipBytes(int actionId, String userName) throws IOException {
        ActionData actionData = this.bulkStorageActionService.getActionDataById(String.valueOf(actionId));
        if (actionData != null) {
            if (!actionData.getIdentity().getUserId().equals(userName)) {
                throw new IOException("Current user is not allowed to get zip file");
            }
            File zipped = new File(actionData.getDownloadZipPath());
            byte[] filesBytes = FileUtils.readFileToByteArray((File)zipped);
            Files.delete(Path.of(actionData.getDownloadZipPath(), new String[0]));
            actionData = this.bulkStorageActionService.getActionDataById(actionData.getActionId());
            if (actionData.getStatus().equals(ActionStatus.CANCELED.name())) {
                try {
                    this.listenerService.broadcast("bulk_actions_document_event", (Object)actionData.getIdentity(), (Object)actionData);
                }
                catch (Exception e) {
                    LOG.error((Object)"cannot broadcast bulk action event");
                }
                return new byte[0];
            }
            this.bulkStorageActionService.removeActionData(actionData);
            return filesBytes;
        }
        return new byte[0];
    }

    public void cancelBulkAction(String actionId, String userName) throws IOException {
        ActionData actionData = this.bulkStorageActionService.getActionDataById(actionId);
        if (!actionData.getIdentity().getUserId().equals(userName)) {
            throw new IOException("Current user is not allowed to cancel the download action");
        }
        actionData.setStatus(ActionStatus.CANCELED.name());
    }

    public FileVersion createNewVersion(String nodeId, String aclIdentity, InputStream newContent) {
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(aclIdentity));
        FileVersion fileVersion = new FileVersion();
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Node node = session.getNodeByUUID(nodeId);
            if (node.isNodeType("mix:versionable") && node.getNode("jcr:content") != null) {
                Node contentNode = node.getNode("jcr:content");
                if (contentNode.hasProperty("jcr:data")) {
                    contentNode.setProperty("jcr:data", newContent);
                    contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                }
                if (node.isNodeType("exo:modify")) {
                    node.setProperty("exo:dateModified", Calendar.getInstance());
                    node.setProperty("exo:lastModifiedDate", Calendar.getInstance());
                }
                node.save();
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                Version version = node.checkin();
                node.checkout();
                node.getSession().save();
                fileVersion = JCRDocumentsUtil.toFileVersion(version, node, this.identityManager);
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while creating new version", e);
        }
        return fileVersion;
    }

    public void moveDocuments(int actionId, long ownerId, List<AbstractNode> documents, String destPath, Identity userIdentity, long identityId) {
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, userIdentity);
            Session session = sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("destPath", destPath);
            params.put("ownerId", ownerId);
            ActionData actionData = new ActionData();
            actionData.setActionId(String.valueOf(actionId));
            actionData.setActionType(ActionType.MOVE.name());
            actionData.setNumberOfItems(documents.size());
            actionData.setIdentity(userIdentity);
            this.bulkStorageActionService.executeBulkAction(session, this, null, this.listenerService, null, documents, actionData, null, params, identityId);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Error execute move", (Throwable)e);
        }
    }

    public boolean hasEditPermissions(String nodeId, Identity aclUserIdentity) {
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclUserIdentity);
            Session session = sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, nodeId);
            return JCRDocumentsUtil.hasEditPermission(session, node);
        }
        catch (Exception e) {
            LOG.error("Error while checking edit permissions on document {}", new Object[]{nodeId, e});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadItem getDocumentDownloadItem(String documentId) {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(systemSession, documentId);
            if (node != null) {
                DownloadItem downloadItem = JCRDocumentsUtil.toDownloadItem(node);
                return downloadItem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFolder(String folderId) {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(systemSession, folderId);
            if (node != null) {
                Path tempFolder = Files.createTempDirectory(TEMP_DOWNLOAD_FOLDER_PREFIX + System.nanoTime(), new FileAttribute[0]);
                tempFolder.toFile().deleteOnExit();
                String tempFolderPath = tempFolder.toString();
                String parentPath = node.getParent().getPath();
                JCRDocumentsUtil.createTempFilesAndFolders(node, "", "", tempFolderPath, parentPath);
                String zipName = ZIP_PREFIX + folderId + ZIP_EXTENSION;
                String zipPath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + zipName;
                JCRDocumentsUtil.zipFiles(zipPath, tempFolderPath);
                File zipped = new File(zipPath);
                File folder = new File(tempFolderPath);
                JCRDocumentsUtil.cleanFiles(folder);
                String string = zipped.getPath();
                return string;
            }
        }
        return null;
    }

    public void unShareDocument(String documentId, long destId) {
        Node rootNode = null;
        Node shared = null;
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node currentNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, documentId);
            org.exoplatform.social.core.identity.model.Identity destIdentity = this.identityManager.getIdentity(String.valueOf(destId));
            rootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, destIdentity, systemSession);
            if (!destIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                rootNode = rootNode.getNode("Documents");
            }
            if (!rootNode.hasNode(SHARED_FOLDER_NAME)) {
                return;
            }
            shared = rootNode.getNode(SHARED_FOLDER_NAME);
            if (currentNode.isNodeType("exo:symlink")) {
                String sourceNodeId = currentNode.getProperty("exo:uuid").getString();
                currentNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, sourceNodeId);
            }
            if (shared.hasNode(currentNode.getName()) && shared.getNode(currentNode.getName()).isNodeType("exo:symlink")) {
                Node link = shared.getNode(currentNode.getName());
                link.remove();
                systemSession.save();
            }
        }
    }

    public void importFiles(String importId, Space space, String userName, String folderId, String folderPath, String conflict, Identity identity, String ownerId, long authenticatedUserId) throws Exception {
        String tempFolderPath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + TEMP_IMPORT_FOLDER_PREFIX + importId;
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(ownerId);
        ActionData actionData = new ActionData();
        actionData.setActionId(importId);
        actionData.setFolderPath(folderPath);
        actionData.setTempFolderPath(tempFolderPath);
        actionData.setUserName(userName);
        actionData.setIdentity(identity);
        actionData.setConflict(conflict);
        UploadResource uploadResource = this.uploadService.getUploadResource(importId);
        actionData.setSize(uploadResource.getEstimatedSize());
        this.bulkStorageActionService.checkTotalUplaodsLimit(identity, true);
        SessionProvider sessionProvider = null;
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity);
        Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
        String path = folderPath;
        Node parent = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, userName, ownerIdentity, sessionProvider);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = path.replace("Private/Public", "Public");
            parent = parent.getNode(URLDecoder.decode(path, StandardCharsets.UTF_8).replace("%", "%25"));
        }
        if (StringUtils.isNotEmpty((CharSequence)folderId)) {
            parent = ((ExtendedSession)session).getNodeByIdentifier(folderId);
        }
        actionData.setParentFolder(JCRDocumentsUtil.getFolderLink(parent, space));
        actionData.setParentFolderName(parent.getName());
        actionData.setActionType(ActionType.IMPORT_ZIP.name());
        this.bulkStorageActionService.executeBulkAction(session, this, null, this.listenerService, this.uploadService, null, actionData, parent, null, authenticatedUserId);
    }

    public boolean canImport(Identity identity) {
        return this.bulkStorageActionService.checkTotalUplaodsLimit(identity, false);
    }

    public boolean hasFolderNodes(Node node, boolean showHidden) throws RepositoryException {
        String statementOfFolders = this.getFolderDocumentsQuery(node.getPath(), "", "", FOLDER_NODE_TYPES, null, null, showHidden);
        Query jcrQuery = node.getSession().getWorkspace().getQueryManager().createQuery(statementOfFolders, "sql");
        QueryResult queryResult = jcrQuery.execute();
        return queryResult.getNodes().getSize() > 0L;
    }

    public void clearSymlinksNavHistory() {
        symlinksNavHistory.clear();
    }

    private static /* synthetic */ boolean lambda$isDocumentSharedWithSamePermissions$20(String destinationRemoteId, AccessControlEntry accessControlEntry) {
        return accessControlEntry.getIdentity().equals(destinationRemoteId);
    }

    private static /* synthetic */ boolean lambda$isDocumentSharedWithSamePermissions$19(String destinationRemoteId, AccessControlEntry accessControlEntry) {
        return accessControlEntry.getIdentity().equals(destinationRemoteId);
    }
}

