/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;

@Configuration
public class ElasticSearchConfig
extends ElasticsearchConfiguration {
    @Value(value="${exo.es.search.server.username:}")
    private String esUsername;
    @Value(value="${exo.es.search.server.password:}")
    private String esPassword;
    @Value(value="${exo.es.search.server.url:http://127.0.0.1:9200}")
    private String esUrl;
    @Value(value="${exo.es.search.socketTimeout:20}")
    private int socketTimeout;
    @Value(value="${exo.es.search.connectTimeout:20}")
    private int connectionTimeout;
    @Value(value="${exo.es.search.connectionRetry:500}")
    private int connectionRetry;

    public ClientConfiguration clientConfiguration() {
        String hostAndPort = this.esUrl.split("//")[1];
        ClientConfiguration.ClientConfigurationBuilderWithRequiredEndpoint builder = ClientConfiguration.builder();
        ClientConfiguration.MaybeSecureClientConfigurationBuilder connectionBuilder = builder.connectedTo(hostAndPort);
        if (this.esUrl.contains("https://")) {
            connectionBuilder.usingSsl();
        }
        if (StringUtils.isNotBlank((CharSequence)this.esPassword) && StringUtils.isNotBlank((CharSequence)this.esUsername)) {
            connectionBuilder.withBasicAuth(this.esUsername, this.esPassword);
        }
        connectionBuilder.withConnectTimeout(Duration.ofSeconds(this.connectionTimeout));
        connectionBuilder.withSocketTimeout(Duration.ofSeconds(this.socketTimeout));
        return connectionBuilder.build();
    }

    public ElasticsearchOperations elasticsearchOperations(ElasticsearchConverter elasticsearchConverter, ElasticsearchClient elasticsearchClient) {
        ElasticsearchTemplate elasticsearchTemplate = new ElasticsearchTemplate(elasticsearchClient, elasticsearchConverter);
        elasticsearchTemplate.setRefreshPolicy(RefreshPolicy.IMMEDIATE);
        return elasticsearchTemplate;
    }
}

