/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class JcrNamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixes = new HashMap<String, String>();
    private Map<String, String> namespaces = new HashMap<String, String>();

    public JcrNamespaceContext(Map<String, String> prefixes, Map<String, String> namespaces) {
        this.prefixes = prefixes;
        this.namespaces = namespaces;
    }

    public static String createName(QName qName) {
        return qName.getPrefix() + ":" + qName.getLocalPart();
    }

    public QName createQName(String strName) {
        String[] parts = strName.split(":");
        if (parts.length > 1) {
            return new QName(this.getNamespaceURI(parts[0]), parts[1], parts[0]);
        }
        return new QName(parts[0]);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaces.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.prefixes.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        String prefix = this.getPrefix(namespaceURI);
        return prefix == null ? Collections.emptyIterator() : Collections.singleton(prefix).iterator();
    }
}

