/*
 * Copyright (C) 2024 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
export function initDocumentsExtensions() {
  extensionRegistry.registerComponent('favorite-file', 'favorite-drawer-item', {
    id: 'file',
    vueComponent: Vue.options.components['documents-favorite-item'],
  });
  window.require(['SHARED/eXoVueI18n'], exoi18n => initOfflineExtension(exoi18n));
}

async function initOfflineExtension(exoi18n) {
  const lang = eXo?.env?.portal?.language || 'en';
  const urls = [
    `/documents-portlet/i18n/locale.portlet.Documents?lang=${lang}`,
    `/pwa/i18n/locale.portlet.OfflineApplication?lang=${lang}`
  ];
  await exoi18n.loadLanguageAsync(lang, urls);
  extensionRegistry.registerComponent('FavoritesDrawer', 'title-icons', {
    id: 'file',
    vueComponent: Vue.options.components['documents-offline-button'],
  });
}