/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.utils;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.rest.util.EntityBuilder;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class NotificationUtils {
    public static final String JCR_CONTENT = "jcr:content";

    public static String getDocumentLink(Node node, SpaceService spaceService, IdentityManager identityManager) throws RepositoryException {
        StringBuilder stringBuilder = new StringBuilder();
        Identity identity = EntityBuilder.getOwnerIdentityFromNodePath(node.getPath(), identityManager, spaceService);
        Space space = spaceService.getSpaceByPrettyName(identity.getRemoteId());
        String groupId = space.getGroupId().replace("/", ":");
        String domain = CommonsUtils.getCurrentDomain();
        stringBuilder.append(domain).append("/").append(LinkProvider.getPortalName(null)).append("/");
        stringBuilder.append("g/").append(groupId).append("/").append(space.getPrettyName());
        if (node.hasNode(JCR_CONTENT)) {
            stringBuilder.append("/documents?documentPreviewId=");
        } else {
            stringBuilder.append("/documents?folderId=");
        }
        stringBuilder.append(((ExtendedNode)node).getIdentifier());
        return stringBuilder.toString();
    }

    public static String getSharedDocumentLink(String nodeUuid, SpaceService spaceService, String spacePrettyName) {
        StringBuilder stringBuilder = new StringBuilder();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        String domain = CommonsUtils.getCurrentDomain();
        stringBuilder.append(domain).append("/").append(LinkProvider.getPortalName(null)).append("/");
        if (spaceService != null && spacePrettyName != null) {
            Space space = spaceService.getSpaceByPrettyName(spacePrettyName);
            String groupId = space.getGroupId().replace("/", ":");
            stringBuilder.append("g/").append(groupId).append("/").append(spacePrettyName).append("/documents/Shared?documentPreviewId=");
        } else {
            stringBuilder.append(portalOwner).append("/documents/Private/Documents/Shared?documentPreviewId=");
        }
        stringBuilder.append(nodeUuid);
        return stringBuilder.toString();
    }

    public static String getDocumentTitle(Node node) throws RepositoryException {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (title == null && node.hasNode(JCR_CONTENT) && (content = node.getNode(JCR_CONTENT)).hasProperty("dc:title")) {
            title = content.getProperty("dc:title").getValue().getString();
        }
        if (title == null) {
            title = node.getName();
        }
        return title;
    }

    public static Profile getUserProfile(IdentityManager identityManager, String userName) {
        Identity identity = identityManager.getOrCreateIdentity("organization", userName);
        return identity.getProfile();
    }
}

