/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.plugin;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.notification.plugin.ImportDocumentsPlugin;
import org.exoplatform.documents.notification.utils.NotificationConstants;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ImportDocumentsPluginTest {
    private static final MockedStatic<ExoContainerContext> EXOCONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<PluginKey> PLUGIN_KEY = Mockito.mockStatic(PluginKey.class);
    @Mock
    private InitParams initParams;
    @Mock
    private SpaceService spaceService;
    private ImportDocumentsPlugin importDocumentsPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXOCONTAINER_CONTEXT.close();
        COMMONS_UTILS.close();
        PLUGIN_KEY.close();
    }

    @Before
    public void setUp() throws Exception {
        this.importDocumentsPlugin = new ImportDocumentsPlugin(this.initParams, this.spaceService);
        EXOCONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn(null);
    }

    @Test
    public void isValid() {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        Assert.assertTrue((boolean)this.importDocumentsPlugin.isValid(ctx));
    }

    @Test
    public void makeNotification() {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationConstants.FROM_USER, (Object)"root");
        ctx.append(NotificationConstants.RECEIVERS, (Object)"receiver");
        ctx.append(NotificationConstants.FOLDER_URL, (Object)"folder url");
        ctx.append(NotificationConstants.FOLDER_NAME, (Object)"folder name");
        ctx.append(NotificationConstants.DURATION, (Object)"1211");
        ctx.append(NotificationConstants.TOTAL_NUMBER, (Object)"10");
        ctx.append(NotificationConstants.FILES_CREATED, (Object)"7");
        ctx.append(NotificationConstants.FILES_DUPLICATED, (Object)"1");
        ctx.append(NotificationConstants.FILES_UPDATED, (Object)"1");
        ctx.append(NotificationConstants.FILES_IGNORED, (Object)"1");
        ctx.append(NotificationConstants.FILES_FAILED, (Object)"0");
        String[] members = new String[]{"user1", "user2"};
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("receiver")).thenReturn((Object)space);
        Mockito.when((Object)space.getMembers()).thenReturn((Object)members);
        NotificationInfo notificationInfo = this.importDocumentsPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.FROM_USER.getKey()));
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getFrom());
        Assert.assertEquals((Object)"folder url", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.FOLDER_URL.getKey()));
        Assert.assertEquals((Object)"folder name", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.FOLDER_NAME.getKey()));
        Assert.assertEquals((Object)"1211", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.DURATION.getKey()));
        Assert.assertEquals((Object)"10", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.TOTAL_NUMBER.getKey()));
        Assert.assertEquals((Object)"7", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_CREATED.getKey()));
        Assert.assertEquals((Object)"1", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_DUPLICATED.getKey()));
        Assert.assertEquals((Object)"1", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_UPDATED.getKey()));
        Assert.assertEquals((Object)"1", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_IGNORED.getKey()));
        Assert.assertEquals((Object)"0", (Object)notificationInfo.getValueOwnerParameter(NotificationConstants.FILES_FAILED.getKey()));
        Assert.assertEquals(Arrays.asList(members), (Object)notificationInfo.getSendToUserIds());
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("receiver")).thenReturn(null);
        NotificationInfo notificationInfo1 = this.importDocumentsPlugin.makeNotification(ctx);
        Assert.assertEquals(List.of("receiver"), (Object)notificationInfo1.getSendToUserIds());
    }
}

