/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.exoplatform.documents.service.ExternalDownloadService;
import org.exoplatform.documents.service.ExternalDownloadServiceImpl;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExternalDownloadServiceImplTest {
    private DocumentFileStorage documentFileStorage;
    private ExternalDownloadService externalDownloadService;

    @Before
    public void setUp() throws Exception {
        this.documentFileStorage = (DocumentFileStorage)Mockito.mock(DocumentFileStorage.class);
        this.externalDownloadService = new ExternalDownloadServiceImpl(this.documentFileStorage);
    }

    @Test
    public void getDocumentDownloadItem() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.externalDownloadService.getDocumentDownloadItem(null));
        Assert.assertEquals((Object)"document id is mandatory", (Object)exception.getMessage());
        this.externalDownloadService.getDocumentDownloadItem("123");
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).getDocumentDownloadItem("123");
    }

    @Test
    public void downloadZippedFolder() throws IOException {
        String path = Files.createTempFile("test", "test.txt", new FileAttribute[0]).toString();
        Mockito.when((Object)this.documentFileStorage.downloadFolder("123")).thenReturn((Object)path);
        byte[] folderBytes = this.externalDownloadService.downloadZippedFolder("123");
        Assert.assertNotNull((Object)folderBytes);
    }
}

