/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.listener;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.command.NotificationExecutor;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.impl.setting.NotificationPluginContainer;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.listener.ShareDocumentNotificationListener;
import org.exoplatform.documents.notification.utils.NotificationUtils;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ShareDocumentNotificationListenerTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<ConversationState> CONVERSATION_STATE = Mockito.mockStatic(ConversationState.class);
    private static final MockedStatic<NotificationContextImpl> NOTIFICATION_CONTEXT_IMPL = Mockito.mockStatic(NotificationContextImpl.class);
    private static final MockedStatic<PluginKey> PLUGIN_KEY = Mockito.mockStatic(PluginKey.class);
    private static final MockedStatic<LinkProvider> LINK_PROVIDER = Mockito.mockStatic(LinkProvider.class);
    private static final MockedStatic<NotificationUtils> NOTIFICATION_UTILS = Mockito.mockStatic(NotificationUtils.class);
    @Mock
    private NotificationService notificationService;
    @Mock
    private NotificationCompletionService notificationCompletionService;
    @Mock
    private NotificationPluginContainer notificationPluginContainer;
    @Mock
    private PluginSettingService pluginSettingService;
    @Mock
    private ChannelManager channelManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private NodeImpl nodeImpl;
    private ShareDocumentNotificationListener shareDocumentNotificationListener;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        CONVERSATION_STATE.close();
        NOTIFICATION_CONTEXT_IMPL.close();
        PLUGIN_KEY.close();
        LINK_PROVIDER.close();
        NOTIFICATION_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.shareDocumentNotificationListener = new ShareDocumentNotificationListener(this.spaceService, this.identityManager);
        ConversationState conversationState = (ConversationState)Mockito.mock(ConversationState.class);
        CONVERSATION_STATE.when(() -> ConversationState.getCurrent()).thenReturn((Object)conversationState);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)conversationState.getIdentity()).thenReturn((Object)identity);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"username");
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationService.class)).thenReturn((Object)this.notificationService);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationCompletionService.class)).thenReturn((Object)this.notificationCompletionService);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationPluginContainer.class)).thenReturn((Object)this.notificationPluginContainer);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(PluginSettingService.class)).thenReturn((Object)this.pluginSettingService);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(ChannelManager.class)).thenReturn((Object)this.channelManager);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NodeImpl.class)).thenReturn((Object)this.nodeImpl);
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentPortalOwner()).thenReturn((Object)"dw");
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentDomain()).thenReturn((Object)"http://domain/");
        LINK_PROVIDER.when(() -> LinkProvider.getPortalName(null)).thenReturn((Object)"portal");
        PluginKey pluginKey = (PluginKey)Mockito.mock(PluginKey.class);
        PLUGIN_KEY.when(() -> PluginKey.key((String)"AddDocumentCollaboratorPlugin")).thenReturn((Object)pluginKey);
    }

    @Test
    public void onEvent() throws Exception {
        Space space = new Space();
        space.setGroupId("/spaces/spacename");
        Mockito.lenient().when((Object)this.spaceService.getSpaceByPrettyName("space_name")).thenReturn((Object)space);
        Node targetNode = (Node)Mockito.mock(NodeImpl.class);
        org.exoplatform.social.core.identity.model.Identity targetIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Event event = new Event("share_document_event", (Object)targetIdentity, (Object)targetNode);
        Mockito.lenient().when((Object)targetIdentity.getProviderId()).thenReturn((Object)"USER");
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.lenient().when((Object)targetNode.getProperty("exo:uuid")).thenReturn((Object)property);
        Mockito.lenient().when((Object)((NodeImpl)targetNode).getIdentifier()).thenReturn((Object)"313445hegefezd");
        Property propertyTitle = (Property)Mockito.mock(Property.class);
        Value value = (Value)Mockito.mock(Value.class);
        Mockito.lenient().when((Object)propertyTitle.getValue()).thenReturn((Object)value);
        Mockito.lenient().when((Object)value.getString()).thenReturn((Object)"document");
        Mockito.lenient().when((Object)targetNode.hasProperty("exo:title")).thenReturn((Object)true);
        Mockito.lenient().when((Object)targetNode.getProperty("exo:title")).thenReturn((Object)propertyTitle);
        Mockito.lenient().when((Object)targetIdentity.getRemoteId()).thenReturn((Object)"user");
        Mockito.lenient().when((Object)targetNode.hasProperty("exo:uuid")).thenReturn((Object)true);
        NotificationContext notificationContext = (NotificationContext)Mockito.mock(NotificationContext.class);
        NotificationExecutor notificationExecutor = (NotificationExecutor)Mockito.mock(NotificationExecutor.class);
        NotificationCommand notificationCommand = (NotificationCommand)Mockito.mock(NotificationCommand.class);
        Mockito.when((Object)notificationContext.getNotificationExecutor()).thenReturn((Object)notificationExecutor);
        Mockito.when((Object)notificationContext.makeCommand((PluginKey)Mockito.any())).thenReturn((Object)notificationCommand);
        Mockito.when((Object)notificationExecutor.with(notificationCommand)).thenReturn((Object)notificationExecutor);
        NOTIFICATION_CONTEXT_IMPL.when(() -> NotificationContextImpl.cloneInstance()).thenReturn((Object)notificationContext);
        NOTIFICATION_UTILS.when(() -> NotificationUtils.isNodeFile((Node)((Node)Mockito.any(Node.class)))).thenReturn((Object)true);
        NOTIFICATION_UTILS.when(() -> NotificationUtils.getSharedDocumentLink((Node)((Node)Mockito.any(Node.class)), (SpaceService)((SpaceService)Mockito.any()), (String)((String)Mockito.any()))).thenReturn((Object)"document/link");
        NOTIFICATION_UTILS.when(() -> NotificationUtils.getDocumentTitle((Node)((Node)Mockito.any(Node.class)))).thenReturn((Object)"document");
        this.shareDocumentNotificationListener.onEvent(event);
        ((NotificationExecutor)Mockito.verify((Object)notificationExecutor, (VerificationMode)Mockito.times((int)1))).execute(notificationContext);
        Mockito.when((Object)targetIdentity.getProviderId()).thenReturn((Object)"space");
        this.shareDocumentNotificationListener.onEvent(event);
        ((NotificationExecutor)Mockito.verify((Object)notificationExecutor, (VerificationMode)Mockito.times((int)1))).execute(notificationContext);
    }
}

