/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.plugin;

import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "document";
    private static final String TITLE_KEY = "contentLink.document";
    private static final String ICON = "far fa-file-alt";
    private static final String COMMAND = "document";
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("document", "contentLink.document", "far fa-file-alt", "document");
    @Autowired
    private PortalContainer container;
    @Autowired
    private DocumentFileService documentFileService;

    @PostConstruct
    public void init() {
        ((ContentLinkPluginService)this.container.getComponentInstanceOfType(ContentLinkPluginService.class)).addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        List documents = this.documentFileService.search(keyword, identity, offset, limit);
        return CollectionUtils.isEmpty((Collection)documents) ? Collections.emptyList() : documents.stream().map(this::toContentLink).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        AbstractNode document = this.documentFileService.getDocumentById(objectId);
        return document instanceof FileNode ? document.getName() : null;
    }

    private ContentLinkSearchResult toContentLink(AbstractNode document) {
        if (document == null) {
            return null;
        }
        return new ContentLinkSearchResult("document", String.valueOf(document.getId()), document.getName(), EXTENSION.getIcon());
    }
}

