/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.analytics.model.filter.AnalyticsFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.constant.FileListingType;
import org.exoplatform.documents.listener.AttachmentsActivityCacheUpdater;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.TrashElementNode;
import org.exoplatform.documents.model.TrashElementNodeFilter;
import org.exoplatform.documents.rest.model.FileNodeEntity;
import org.exoplatform.documents.rest.util.EntityBuilder;
import org.exoplatform.documents.service.DocumentFileServiceImpl;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DocumentFileServiceTest {
    private DocumentFileStorage documentFileStorage;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private IdentityRegistry identityRegistry;
    private Authenticator authenticator;
    private DocumentFileServiceImpl documentFileService;
    private JCRDeleteFileStorage jcrDeleteFileStorage;
    private ActivityStorage activityStorage;
    private ListenerService listenerService;
    private ImageThumbnailService imageThumbnailService;
    private CachedActivityStorage cachedActivityStorage;
    private AnalyticsService analyticsService;
    private org.exoplatform.social.core.identity.model.Identity currentIdentity;
    String userName = "testuser";
    long currentOwnerId = 2L;

    @Before
    public void setUp() {
        this.spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        this.identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        this.identityRegistry = (IdentityRegistry)Mockito.mock(IdentityRegistry.class);
        this.authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        this.documentFileStorage = (DocumentFileStorage)Mockito.mock(DocumentFileStorage.class);
        this.activityStorage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        this.listenerService = (ListenerService)Mockito.mock(ListenerService.class);
        this.jcrDeleteFileStorage = (JCRDeleteFileStorage)Mockito.mock(JCRDeleteFileStorage.class);
        this.cachedActivityStorage = (CachedActivityStorage)Mockito.mock(CachedActivityStorage.class);
        this.analyticsService = (AnalyticsService)Mockito.mock(AnalyticsService.class);
        this.imageThumbnailService = (ImageThumbnailService)Mockito.mock(ImageThumbnailService.class);
        this.documentFileService = new DocumentFileServiceImpl(this.documentFileStorage, this.jcrDeleteFileStorage, this.authenticator, this.spaceService, this.identityManager, this.identityRegistry, this.listenerService, this.analyticsService, this.imageThumbnailService);
        this.currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", this.userName);
        this.currentIdentity.setId(String.valueOf(this.currentOwnerId));
        Identity userID = new Identity(this.userName);
        Mockito.when((Object)this.identityRegistry.getIdentity(this.userName)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(this.currentOwnerId)).thenReturn((Object)this.currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Matchers.eq((Object)"organization"), (String)Matchers.eq((Object)this.userName))).thenReturn((Object)this.currentIdentity);
    }

    @Test
    public void testClearActivityCacheWhenFileRenamed() throws Exception {
        String documentID = "2";
        Event renameFileEvent = new Event("rename_file_event", null, (Object)documentID);
        ((DocumentFileStorage)Mockito.lenient().doNothing().when((Object)this.documentFileStorage)).renameDocument(Mockito.anyLong(), Mockito.anyString(), Mockito.anyString(), (Identity)Mockito.any());
        this.documentFileService.renameDocument(1L, documentID, "newName", this.currentOwnerId);
        this.cachedActivityStorage = (CachedActivityStorage)Mockito.mock(CachedActivityStorage.class);
        AttachmentsActivityCacheUpdater attachmentsActivityCacheUpdater = new AttachmentsActivityCacheUpdater((ActivityStorage)this.cachedActivityStorage);
        attachmentsActivityCacheUpdater.onEvent(renameFileEvent);
        ((CachedActivityStorage)Mockito.verify((Object)this.cachedActivityStorage, (VerificationMode)Mockito.times((int)1))).clearActivityCachedByAttachmentId(documentID);
    }

    @Test
    public void testGetDocumentItems() throws Exception {
        DocumentFolderFilter docFilter;
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)this.userName);
        this.currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(this.userName);
        DocumentTimelineFilter filter = null;
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.getDocumentItems(FileListingType.TIMELINE, null, 0, 0, Long.valueOf(this.currentIdentity.getId()).longValue(), false));
        Assert.assertEquals((Object)exception.getMessage(), (Object)"File filter is mandatory");
        DocumentTimelineFilter finalFilter1 = filter = new DocumentTimelineFilter(Long.valueOf(0L));
        exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.getDocumentItems(FileListingType.TIMELINE, (DocumentNodeFilter)finalFilter1, 0, 0, Long.valueOf(this.currentIdentity.getId()).longValue(), false));
        Assert.assertEquals((Object)exception.getMessage(), (Object)"OwnerId is mandatory");
        DocumentTimelineFilter finalFilter = filter = new DocumentTimelineFilter(Long.valueOf(this.currentIdentity.getId()));
        exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.getDocumentItems(FileListingType.TIMELINE, (DocumentNodeFilter)finalFilter, 0, 0, 0L, false));
        Assert.assertEquals((Object)exception.getMessage(), (Object)"User Identity is mandatory");
        DocumentFolderFilter finalDocFilter = docFilter = new DocumentFolderFilter("", "", Long.valueOf(0L), "");
        exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.getDocumentItems(FileListingType.TIMELINE, (DocumentNodeFilter)finalDocFilter, 0, 0, Long.valueOf(this.currentIdentity.getId()).longValue(), false));
        Assert.assertEquals((Object)exception.getMessage(), (Object)"filter must be an instance of DocumentTimelineFilter");
        exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.getDocumentItems(FileListingType.FOLDER, (DocumentNodeFilter)finalFilter, 0, 0, Long.valueOf(this.currentIdentity.getId()).longValue(), false));
        Assert.assertEquals((Object)exception.getMessage(), (Object)"filter must be an instance of DocumentFolderFilter");
        exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.getDocumentItems(FileListingType.FOLDER, (DocumentNodeFilter)finalDocFilter, 0, 0, Long.valueOf(this.currentIdentity.getId()).longValue(), false));
        Assert.assertEquals((Object)exception.getMessage(), (Object)"ParentFolderId or OwnerId is mandatory");
        Mockito.when((Object)this.identityRegistry.getIdentity(this.userName)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(this.currentOwnerId)).thenReturn((Object)this.currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Matchers.eq((Object)"organization"), (String)Matchers.eq((Object)this.userName))).thenReturn((Object)this.currentIdentity);
        String spacePrettyName = "spacetest";
        this.currentIdentity.setRemoteId(spacePrettyName);
        Space space = new Space();
        Identity spaceID = new Identity(spacePrettyName);
        Mockito.when((Object)this.identityRegistry.getIdentity(spacePrettyName)).thenReturn((Object)spaceID);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Matchers.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, this.userName)).thenReturn((Object)true);
        ArrayList<FileNode> files = new ArrayList<FileNode>();
        FileNode file1 = new FileNode();
        FileNode file2 = new FileNode();
        FileNode file3 = new FileNode();
        FileNode file4 = new FileNode();
        files.add(file1);
        files.add(file2);
        files.add(file3);
        files.add(file4);
        Mockito.when((Object)this.documentFileStorage.getFilesTimeline(filter, spaceID, 0, 0)).thenReturn(files);
        List documentItems = this.documentFileService.getDocumentItems(FileListingType.TIMELINE, (DocumentNodeFilter)filter, 0, 0, Long.parseLong(this.currentIdentity.getId()), false);
        Assert.assertEquals((long)documentItems.size(), (long)4L);
    }

    @Test
    public void testGetFilesTimeline() throws Exception {
        DocumentTimelineFilter filter_;
        String username = "testuser";
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        DocumentTimelineFilter filter = new DocumentTimelineFilter(Long.valueOf(currentIdentity.getId()));
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Matchers.eq((Object)"organization"), (String)Matchers.eq((Object)username))).thenReturn((Object)currentIdentity);
        DocumentTimelineFilter finalFilter1 = filter_ = new DocumentTimelineFilter(Long.valueOf(0L));
        Exception exception = (Exception)Assert.assertThrows(ObjectNotFoundException.class, () -> this.documentFileService.getFilesTimeline(finalFilter1, 0, 0, Long.valueOf(currentIdentity.getId()).longValue()));
        Assert.assertEquals((Object)exception.getMessage(), (Object)("Owner Identity with id : " + finalFilter1.getOwnerId() + " isn't found"));
        String spacePrettyName = "spacetest";
        currentIdentity.setRemoteId(spacePrettyName);
        Space space = new Space();
        Identity spaceID = new Identity(spacePrettyName);
        Mockito.when((Object)this.identityRegistry.getIdentity(spacePrettyName)).thenReturn((Object)spaceID);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Matchers.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, username)).thenReturn((Object)true);
        ArrayList<FileNode> files = new ArrayList<FileNode>();
        FileNode file1 = new FileNode();
        FileNode file2 = new FileNode();
        FileNode file3 = new FileNode();
        FileNode file4 = new FileNode();
        files.add(file1);
        files.add(file2);
        files.add(file3);
        files.add(file4);
        Mockito.when((Object)this.documentFileStorage.getFilesTimeline(filter, spaceID, 0, 0)).thenReturn(files);
        List files_ = new ArrayList();
        files_ = this.documentFileService.getFilesTimeline(filter, 0, 0, Long.valueOf(currentIdentity.getId()).longValue());
        Assert.assertEquals((long)files_.size(), (long)4L);
    }

    @Test
    public void testGetGroupDocumentsCount() throws Exception {
        DocumentTimelineFilter filter_;
        String username = "testuser";
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        DocumentTimelineFilter filter = new DocumentTimelineFilter(Long.valueOf(currentIdentity.getId()));
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Matchers.eq((Object)"organization"), (String)Matchers.eq((Object)username))).thenReturn((Object)currentIdentity);
        DocumentTimelineFilter finalFilter1 = filter_ = new DocumentTimelineFilter(Long.valueOf(0L));
        Exception exception = (Exception)Assert.assertThrows(ObjectNotFoundException.class, () -> this.documentFileService.getFilesTimeline(finalFilter1, 0, 0, Long.valueOf(currentIdentity.getId()).longValue()));
        Assert.assertEquals((Object)exception.getMessage(), (Object)("Owner Identity with id : " + finalFilter1.getOwnerId() + " isn't found"));
        String spacePrettyName = "spacetest";
        currentIdentity.setRemoteId(spacePrettyName);
        Space space = new Space();
        Identity spaceID = new Identity(spacePrettyName);
        Mockito.when((Object)this.identityRegistry.getIdentity(spacePrettyName)).thenReturn((Object)spaceID);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Matchers.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, username)).thenReturn((Object)true);
        DocumentGroupsSize documentGroupsSize = new DocumentGroupsSize();
        documentGroupsSize.setThisDay(4L);
        Mockito.when((Object)this.documentFileStorage.getGroupDocumentsCount(filter, spaceID)).thenReturn((Object)documentGroupsSize);
        DocumentGroupsSize documentGroupsSize_ = new DocumentGroupsSize();
        documentGroupsSize_ = this.documentFileService.getGroupDocumentsCount(filter, Long.valueOf(currentIdentity.getId()).longValue());
        currentIdentity.setProviderId("space");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName(spacePrettyName)).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, spacePrettyName)).thenReturn((Object)true);
        DocumentGroupsSize documentGroupsSize_2 = this.documentFileService.getGroupDocumentsCount(filter, Long.valueOf(currentIdentity.getId()).longValue());
        Assert.assertEquals((long)4L, (long)documentGroupsSize_.getThisDay());
        Assert.assertEquals((long)4L, (long)documentGroupsSize_2.getThisDay());
    }

    @Test
    public void testGetFolderChildNodes() throws Exception {
        DocumentFolderFilter filter_;
        String username = "testuser";
        long currentOwnerId = 2L;
        long spaceIdentityId = 4L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        String user2name = "testuser2";
        long user2Id = 3L;
        org.exoplatform.social.core.identity.model.Identity user2Identity = new org.exoplatform.social.core.identity.model.Identity("organization", user2name);
        user2Identity.setId(String.valueOf(user2Id));
        Profile user2Profile = new Profile();
        user2Profile.setProperty("fullName", (Object)user2name);
        user2Identity.setProfile(user2Profile);
        Identity userID = new Identity(username);
        Identity user2ID = new Identity(user2name);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Matchers.eq((Object)"organization"), (String)Matchers.eq((Object)username))).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityRegistry.getIdentity(user2name)).thenReturn((Object)user2ID);
        Mockito.when((Object)this.identityManager.getIdentity(user2Id)).thenReturn((Object)user2Identity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Matchers.eq((Object)"organization"), (String)Matchers.eq((Object)user2name))).thenReturn((Object)user2Identity);
        DocumentFolderFilter finalFilter1 = filter_ = new DocumentFolderFilter(null, null, Long.valueOf(0L), "");
        Exception exception = (Exception)Assert.assertThrows(ObjectNotFoundException.class, () -> this.documentFileService.getFolderChildNodes(finalFilter1, 0, 0, Long.valueOf(currentIdentity.getId()).longValue()));
        Assert.assertEquals((Object)exception.getMessage(), (Object)("Owner Identity with id : " + finalFilter1.getOwnerId() + " isn't found"));
        String spacePrettyName = "spacetest";
        Space space = new Space();
        Identity spaceID = new Identity(spacePrettyName);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        spaceIdentity.setId(String.valueOf(spaceIdentityId));
        spaceIdentity.setRemoteId(spacePrettyName);
        spaceIdentity.setProviderId("space");
        Mockito.when((Object)this.identityRegistry.getIdentity(spacePrettyName)).thenReturn((Object)spaceID);
        Mockito.when((Object)this.identityManager.getIdentity(spaceIdentityId)).thenReturn((Object)spaceIdentity);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Matchers.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, username)).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, user2name)).thenReturn((Object)false);
        DocumentFolderFilter finalFilter2 = filter_ = new DocumentFolderFilter(null, null, Long.valueOf(spaceIdentity.getId()), "");
        ArrayList<FileNode> files = new ArrayList<FileNode>();
        FileNode file1 = new FileNode();
        FileNode file2 = new FileNode();
        FileNode file3 = new FileNode();
        FileNode file4 = new FileNode();
        files.add(file1);
        files.add(file2);
        files.add(file3);
        files.add(file4);
        exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.getFolderChildNodes(finalFilter2, 0, 0, Long.valueOf(user2Identity.getId()).longValue()));
        Assert.assertEquals((Object)exception.getMessage(), (Object)("User " + user2name + " attempts to access documents of space " + space.getDisplayName() + "while it's not a member"));
        Mockito.when((Object)this.documentFileStorage.getFolderChildNodes(finalFilter2, userID, 0, 0)).thenReturn(files);
        List files_ = new ArrayList();
        files_ = this.documentFileService.getFolderChildNodes(finalFilter2, 0, 0, Long.valueOf(currentIdentity.getId()).longValue());
        Assert.assertEquals((long)files_.size(), (long)4L);
    }

    @Test
    public void testGetBreadCrumbs() throws Exception {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        BreadCrumbItem breadCrumbItem1 = new BreadCrumbItem("1", "Folder1", "Folder1", "", false, new HashMap());
        BreadCrumbItem breadCrumbItem2 = new BreadCrumbItem("2", "Folder2", "Folder1", "", false, new HashMap());
        BreadCrumbItem breadCrumbItem3 = new BreadCrumbItem();
        breadCrumbItem3.setId("3");
        breadCrumbItem3.setName("Folder3");
        BreadCrumbItem breadCrumbItem4 = new BreadCrumbItem();
        breadCrumbItem4.setId("4");
        breadCrumbItem4.setName("Folder4");
        ArrayList<BreadCrumbItem> breadCrumbItems = new ArrayList<BreadCrumbItem>();
        breadCrumbItems.add(breadCrumbItem1);
        breadCrumbItems.add(breadCrumbItem2);
        breadCrumbItems.add(breadCrumbItem3);
        breadCrumbItems.add(breadCrumbItem4);
        List breadCrumbItems_ = new ArrayList();
        Mockito.when((Object)this.documentFileStorage.getBreadcrumb(2L, "Folder1", "", userID)).thenReturn(breadCrumbItems);
        Exception exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.getBreadcrumb(0L, "", "", 0L));
        Assert.assertEquals((Object)exception.getMessage(), (Object)"Can't find user identity with id 0");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        breadCrumbItems_ = this.documentFileService.getBreadcrumb(Long.valueOf(2L).longValue(), "Folder1", "", 2L);
        Assert.assertEquals((long)breadCrumbItems_.size(), (long)4L);
        Assert.assertEquals((Object)((BreadCrumbItem)breadCrumbItems_.get(0)).getId(), (Object)"1");
        Assert.assertEquals((Object)((BreadCrumbItem)breadCrumbItems_.get(0)).getName(), (Object)"Folder1");
    }

    @Test
    public void testUpdatePermissions() throws IllegalAccessException {
        NodePermission nodePermission = new NodePermission();
        HashMap<Long, String> toShare = new HashMap<Long, String>();
        toShare.put(1L, "read");
        nodePermission.setToShare(toShare);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity socialIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("username")).thenReturn((Object)identity);
        Mockito.when((Object)socialIdentity.getRemoteId()).thenReturn((Object)"username");
        Mockito.when((Object)this.identityManager.getIdentity(1L)).thenReturn((Object)socialIdentity);
        this.documentFileService.updatePermissions("123", nodePermission, 1L);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).updatePermissions("123", nodePermission, identity);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).shareDocument("123", 1L, identity, false);
        HashMap<Long, String> toNotify = new HashMap<Long, String>();
        toNotify.put(1L, "read");
        nodePermission.setToNotify(toNotify);
        this.documentFileService.updatePermissions("123", nodePermission, 1L);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.atLeast((int)1))).updatePermissions("123", nodePermission, identity);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.atLeast((int)1))).shareDocument("123", 1L, identity, true);
    }

    @Test
    public void testDeleteDocuments() throws IllegalAccessException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity socialIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("username")).thenReturn((Object)identity);
        Mockito.when((Object)socialIdentity.getRemoteId()).thenReturn((Object)"username");
        Mockito.when((Object)this.identityManager.getIdentity(1L)).thenReturn((Object)socialIdentity);
        FileNodeEntity file1 = new FileNodeEntity();
        file1.setId("1");
        file1.setName("oldFile");
        file1.setPath("/document/oldFile");
        file1.setDatasource("datasource");
        file1.setMimeType(":file");
        file1.setSize(50L);
        FileNodeEntity file2 = new FileNodeEntity();
        file2.setId("2");
        file2.setName("oldFile2");
        file2.setPath("/document/oldFile2");
        file2.setDatasource("datasource");
        file2.setMimeType(":file");
        file2.setSize(50L);
        FileNodeEntity file3 = new FileNodeEntity();
        file3.setId("3");
        file3.setName("oldFile3");
        file3.setPath("/document/oldFile3");
        file3.setDatasource("datasource");
        file3.setMimeType(":file");
        file3.setSize(50L);
        ArrayList<FileNodeEntity> nodeEntities = new ArrayList<FileNodeEntity>();
        nodeEntities.add(file1);
        nodeEntities.add(file2);
        nodeEntities.add(file3);
        List nodes = EntityBuilder.toAbstractNodes(nodeEntities);
        this.documentFileService.deleteDocuments(123456, nodes, 1L);
        ((JCRDeleteFileStorage)Mockito.verify((Object)this.jcrDeleteFileStorage, (VerificationMode)Mockito.times((int)1))).deleteDocuments(123456, nodes, identity, 1L);
    }

    @Test
    public void testDownloadDocuments() throws IllegalAccessException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity socialIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("username")).thenReturn((Object)identity);
        Mockito.when((Object)socialIdentity.getRemoteId()).thenReturn((Object)"username");
        Mockito.when((Object)this.identityManager.getIdentity(1L)).thenReturn((Object)socialIdentity);
        FileNodeEntity file1 = new FileNodeEntity();
        file1.setId("1");
        file1.setName("oldFile");
        file1.setPath("/document/oldFile");
        file1.setDatasource("datasource");
        file1.setMimeType(":file");
        file1.setSize(50L);
        FileNodeEntity file2 = new FileNodeEntity();
        file2.setId("2");
        file2.setName("oldFile2");
        file2.setPath("/document/oldFile2");
        file2.setDatasource("datasource");
        file2.setMimeType(":file");
        file2.setSize(50L);
        FileNodeEntity file3 = new FileNodeEntity();
        file3.setId("3");
        file3.setName("oldFile3");
        file3.setPath("/document/oldFile3");
        file3.setDatasource("datasource");
        file3.setMimeType(":file");
        file3.setSize(50L);
        ArrayList<FileNodeEntity> nodeEntities = new ArrayList<FileNodeEntity>();
        nodeEntities.add(file1);
        nodeEntities.add(file2);
        nodeEntities.add(file3);
        List nodes = EntityBuilder.toAbstractNodes(nodeEntities);
        ((DocumentFileStorage)Mockito.doNothing().when((Object)this.documentFileStorage)).downloadDocuments(123456, nodes, identity, 1L);
        this.documentFileService.downloadDocuments(123456, nodes, 1L);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).downloadDocuments(123456, nodes, identity, 1L);
    }

    @Test
    public void testGetDownloadZipBytes() throws IOException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity socialIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("username")).thenReturn((Object)identity);
        Mockito.when((Object)socialIdentity.getRemoteId()).thenReturn((Object)"username");
        Mockito.when((Object)this.identityManager.getIdentity(1L)).thenReturn((Object)socialIdentity);
        Mockito.when((Object)this.documentFileStorage.getDownloadZipBytes(123456, "userName")).thenReturn(null);
        this.documentFileService.getDownloadZipBytes(123456, "userName");
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).getDownloadZipBytes(123456, "userName");
    }

    @Test
    public void getAclUserIdentity() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn(null);
        Mockito.when((Object)this.authenticator.createIdentity("user")).thenReturn((Object)identity);
        Identity aclIdentity = this.documentFileService.getAclUserIdentity("user");
        Assert.assertNotNull((Object)aclIdentity);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        Identity aclIdentity1 = this.documentFileService.getAclUserIdentity("user");
        Assert.assertNotNull((Object)aclIdentity1);
    }

    @Test
    public void testCreateShortcut() throws Exception {
        String docId = "11111111";
        String docPath = "/Groups/spaces/test/Documents/test";
        this.documentFileService.createShortcut(docId, "/Groups/spaces/test/Documents/test", "user", "keepBoth");
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).createShortcut(docId, docPath, "user", "keepBoth");
    }

    @Test
    public void getFileVersions() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.getFileVersions(null, null));
        Assert.assertEquals((Object)"file node id is mandatory", (Object)exception.getMessage());
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)0))).getFileVersions(Mockito.anyString(), Mockito.anyString());
        this.documentFileService.getFileVersions("5456456456", "user");
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).getFileVersions("5456456456", "user");
    }

    @Test
    public void updateVersionSummary() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.updateVersionSummary("123", null, "test", "user"));
        Assert.assertEquals((Object)"version id is mandatory", (Object)exception.getMessage());
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)0))).updateVersionSummary(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.updateVersionSummary(null, "333", "test", "user"));
        Assert.assertEquals((Object)"original file id is mandatory", (Object)exception1.getMessage());
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)0))).updateVersionSummary(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        this.documentFileService.updateVersionSummary("5456456456", "333erf", "new summary", "user");
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).updateVersionSummary(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void restoreVersion() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.restoreVersion(null, "user"));
        Assert.assertEquals((Object)"version id is mandatory", (Object)exception.getMessage());
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)0))).restoreVersion(Mockito.anyString(), Mockito.anyString());
        this.documentFileService.restoreVersion("123", "user");
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).restoreVersion("123", "user");
    }

    @Test
    public void createNewVersion() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.createNewVersion(null, null, null));
        Assert.assertEquals((Object)"node id is mandatory", (Object)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.documentFileService.createNewVersion("123", null, null));
        Assert.assertEquals((Object)"User identity id is mandatory", (Object)exception.getMessage());
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)0))).createNewVersion(Mockito.anyString(), Mockito.anyString(), (InputStream)Mockito.any());
        ByteArrayInputStream newContent = new ByteArrayInputStream("test".getBytes());
        this.documentFileService.createNewVersion("123", "user", (InputStream)newContent);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).createNewVersion("123", "user", (InputStream)newContent);
    }

    @Test
    public void moveDocument() throws IllegalAccessException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        AbstractNode abstractNode = (AbstractNode)Mockito.mock(AbstractNode.class);
        List<AbstractNode> documents = List.of(abstractNode);
        Mockito.when((Object)this.identityManager.getIdentity(Mockito.anyLong())).thenReturn((Object)userIdentity);
        Mockito.when((Object)userIdentity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        this.documentFileService.moveDocuments(1, 1L, documents, "destPath", 1L);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).moveDocuments(1, 1L, documents, "destPath", identity, 1L);
    }

    @Test
    public void getDocumentsSizeStats() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Exception exception = (Exception)Assert.assertThrows(ObjectNotFoundException.class, () -> this.documentFileService.getDocumentsSizeStat(1L, 1L));
        Assert.assertEquals((Object)"Owner Identity with id : 1 isn't found", (Object)exception.getMessage());
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getIdentity(1L)).thenReturn((Object)ownerIdentity);
        Mockito.when((Object)this.identityManager.getIdentity(2L)).thenReturn((Object)currentUserIdentity);
        Mockito.when((Object)ownerIdentity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        Mockito.when((Object)ownerIdentity.isUser()).thenReturn((Object)true);
        Mockito.when((Object)ownerIdentity.isSpace()).thenReturn((Object)false);
        exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.getDocumentsSizeStat(1L, 2L));
        Assert.assertEquals((Object)"Current user with identity id : 2 attempts to get the size of private documents of user  with identity id  1", (Object)exception.getMessage());
        Mockito.when((Object)ownerIdentity.isUser()).thenReturn((Object)false);
        Mockito.when((Object)ownerIdentity.isSpace()).thenReturn((Object)true);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        Mockito.when((Object)currentUserIdentity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)ownerIdentity.getRemoteId()).thenReturn((Object)"test1");
        Space space = new Space();
        space.setPrettyName("test1");
        space.setDisplayName("test1");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("test1")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, currentUserIdentity.getRemoteId())).thenReturn((Object)false);
        exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.getDocumentsSizeStat(1L, 2L));
        Assert.assertEquals((Object)"Current user with identity id : 2 attempts to get size of documents of space with identity id 1 while it's not a member", (Object)exception.getMessage());
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, currentUserIdentity.getRemoteId())).thenReturn((Object)true);
        this.documentFileService.getDocumentsSizeStat(1L, 2L);
        ((AnalyticsService)Mockito.verify((Object)this.analyticsService, (VerificationMode)Mockito.times((int)1))).retrieveData((AnalyticsFilter)Mockito.any());
    }

    @Test
    public void addDocumentsSizeStat() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Exception exception = (Exception)Assert.assertThrows(ObjectNotFoundException.class, () -> this.documentFileService.addDocumentsSizeStat(1L, 1L));
        Assert.assertEquals((Object)"Owner Identity with id : 1 isn't found", (Object)exception.getMessage());
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getIdentity(1L)).thenReturn((Object)ownerIdentity);
        Mockito.when((Object)this.identityManager.getIdentity(2L)).thenReturn((Object)currentUserIdentity);
        Mockito.when((Object)ownerIdentity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        Mockito.when((Object)ownerIdentity.isUser()).thenReturn((Object)true);
        Mockito.when((Object)ownerIdentity.isSpace()).thenReturn((Object)false);
        exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.addDocumentsSizeStat(1L, 2L));
        Assert.assertEquals((Object)"Current user with identity id : 2 attempts to calculate the size of private documents of user  with identity id  1", (Object)exception.getMessage());
        Mockito.when((Object)ownerIdentity.isUser()).thenReturn((Object)false);
        Mockito.when((Object)ownerIdentity.isSpace()).thenReturn((Object)true);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        Mockito.when((Object)currentUserIdentity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)ownerIdentity.getRemoteId()).thenReturn((Object)"test1");
        Space space = new Space();
        space.setPrettyName("test1");
        space.setDisplayName("test1");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("test1")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, currentUserIdentity.getRemoteId())).thenReturn((Object)false);
        exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.addDocumentsSizeStat(1L, 2L));
        Assert.assertEquals((Object)"Current user with identity id : 2 attempts to calculate size of documents of space with identity id 1 while it's not a member", (Object)exception.getMessage());
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, currentUserIdentity.getRemoteId())).thenReturn((Object)true);
        this.documentFileService.addDocumentsSizeStat(1L, 2L);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).calculateFilesSize(Long.valueOf(1L), identity);
    }

    @Test
    public void hasEditPermissionOnDocument() throws IllegalAccessException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getIdentity(Mockito.anyLong())).thenReturn((Object)userIdentity);
        Mockito.when((Object)userIdentity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        Mockito.when((Object)this.documentFileStorage.hasEditPermissions("123", identity)).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertTrue((boolean)this.documentFileService.hasEditPermissionOnDocument("123", 1L));
        Assert.assertFalse((boolean)this.documentFileService.hasEditPermissionOnDocument("123", 1L));
    }

    @Test
    public void importDocuments() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Exception exception = (Exception)Assert.assertThrows(ObjectNotFoundException.class, () -> this.documentFileService.importFiles("1", null, null, "1", "ignore", identity, 1L));
        Assert.assertEquals((Object)"Owner Identity with id : 1 isn't found", (Object)exception.getMessage());
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getIdentity(Mockito.anyLong())).thenReturn((Object)ownerIdentity);
        Mockito.when((Object)ownerIdentity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        this.documentFileService.importFiles("1", null, null, "1", "ignore", identity, 1L);
        ((DocumentFileStorage)Mockito.verify((Object)this.documentFileStorage, (VerificationMode)Mockito.times((int)1))).importFiles("1", null, "", null, null, "ignore", identity, "1", 1L);
        Mockito.when((Object)ownerIdentity.isUser()).thenReturn((Object)true);
        Mockito.when((Object)ownerIdentity.getRemoteId()).thenReturn((Object)"test");
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"test1");
        exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.importFiles("1", null, null, "1", "ignore", identity, 1L));
        Assert.assertEquals((Object)"User test1 attempts to access private documents of user test", (Object)exception.getMessage());
        Mockito.when((Object)ownerIdentity.isSpace()).thenReturn((Object)true);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        Mockito.when((Object)ownerIdentity.getRemoteId()).thenReturn((Object)"test1");
        Space space = new Space();
        space.setPrettyName("test1");
        space.setDisplayName("test1");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("test1")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, identity.getUserId())).thenReturn((Object)false);
        exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.documentFileService.importFiles("1", null, null, "1", "ignore", identity, 1L));
        Assert.assertEquals((Object)"User user attempts to access documents of space test1 while it's not a member", (Object)exception.getMessage());
    }

    @Test
    public void getDeletedDocumentsTest() throws Exception {
        TrashElementNode trashElementNode = (TrashElementNode)Mockito.mock(TrashElementNode.class);
        List<TrashElementNode> trashElementNodes = Arrays.asList(trashElementNode);
        Mockito.when((Object)this.jcrDeleteFileStorage.getDeletedDocuments((TrashElementNodeFilter)Mockito.any(TrashElementNodeFilter.class))).thenReturn(trashElementNodes);
        Assert.assertEquals((long)1L, (long)this.documentFileService.getDeletedDocuments(new TrashElementNodeFilter()).size());
    }
}

