/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "document";
    private static final Log LOG = ExoLogger.getLogger(DocumentAclPlugin.class);
    @Autowired
    private DocumentFileService documentFileService;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        try {
            return switch (permissionType) {
                case "VIEW" -> this.documentFileService.canAccess(objectId, identity);
                case "EDIT", "DELETE" -> this.documentFileService.hasEditPermissionOnDocument(objectId, identity);
                default -> false;
            };
        }
        catch (Exception e) {
            LOG.warn("Error while checking permission '{}' on document '{}' for user '{}'", new Object[]{permissionType, objectId, identity == null ? "" : identity.getUserId()});
            return false;
        }
    }
}

