/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import org.exoplatform.documents.model.PublicDocumentAccess;
import org.exoplatform.documents.service.PublicDocumentAccessService;
import org.exoplatform.documents.service.PublicDocumentAccessServiceImpl;
import org.exoplatform.documents.storage.PublicDocumentAccessStorage;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PublicDocumentAccessServiceImplTest {
    private PublicDocumentAccessStorage publicDocumentAccessStorage;
    private PublicDocumentAccessService publicDocumentAccessService;
    private AbstractCodec codec;

    @Before
    public void setUp() throws Exception {
        this.publicDocumentAccessStorage = (PublicDocumentAccessStorage)Mockito.mock(PublicDocumentAccessStorage.class);
        this.codec = (AbstractCodec)Mockito.mock(AbstractCodec.class);
        CodecInitializer codecInitializer = (CodecInitializer)Mockito.mock(CodecInitializer.class);
        Mockito.when((Object)codecInitializer.getCodec()).thenReturn((Object)this.codec);
        this.publicDocumentAccessService = new PublicDocumentAccessServiceImpl(this.publicDocumentAccessStorage, codecInitializer);
    }

    @Test
    public void createDocumentPublicAccess() {
        PublicDocumentAccess publicDocumentAccess = new PublicDocumentAccess();
        publicDocumentAccess.setId(Long.valueOf(1L));
        publicDocumentAccess.setNodeId("123");
        Mockito.when((Object)this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId("123")).thenReturn((Object)publicDocumentAccess);
        Mockito.when((Object)this.publicDocumentAccessStorage.savePublicDocumentAccess((PublicDocumentAccess)Mockito.any(), Mockito.anyLong())).thenReturn((Object)publicDocumentAccess);
        this.publicDocumentAccessService.createPublicDocumentAccess(1L, "123", "12345678", Long.valueOf(new Date().getTime()), false);
        ((PublicDocumentAccessStorage)Mockito.verify((Object)this.publicDocumentAccessStorage)).savePublicDocumentAccess((PublicDocumentAccess)Mockito.any(), Mockito.anyLong());
    }

    @Test
    public void getDocumentPublicAccess() {
        PublicDocumentAccess publicDocumentAccess = new PublicDocumentAccess();
        publicDocumentAccess.setEncodedPassword("encoded");
        Mockito.when((Object)this.codec.decode("encoded")).thenReturn((Object)"decoded");
        Mockito.when((Object)this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId("123")).thenReturn((Object)publicDocumentAccess);
        this.publicDocumentAccessService.getPublicDocumentAccess("123");
        ((PublicDocumentAccessStorage)Mockito.verify((Object)this.publicDocumentAccessStorage, (VerificationMode)Mockito.times((int)1))).getPublicDocumentAccessByNodeId("123");
    }

    @Test
    public void isAccessExpired() {
        PublicDocumentAccess publicDocumentAccess = new PublicDocumentAccess();
        Date expiration = new Date(new Date().getTime() + 86400000L);
        publicDocumentAccess.setExpirationDate(expiration);
        Mockito.when((Object)this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId("123")).thenReturn(null, (Object[])new PublicDocumentAccess[]{publicDocumentAccess});
        Assert.assertTrue((boolean)this.publicDocumentAccessService.isPublicDocumentAccessExpired("123"));
        Assert.assertFalse((boolean)this.publicDocumentAccessService.isPublicDocumentAccessExpired("123"));
    }

    private String generatePasswordHash(String password) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method generatePasswordHash = this.publicDocumentAccessService.getClass().getDeclaredMethod("generatePasswordHash", String.class);
        generatePasswordHash.setAccessible(true);
        return (String)generatePasswordHash.invoke((Object)this.publicDocumentAccessService, password);
    }

    @Test
    public void isPublicDocumentAccessValid() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        PublicDocumentAccess publicDocumentAccess = new PublicDocumentAccess();
        publicDocumentAccess.setPasswordHashKey(this.generatePasswordHash("12345678"));
        Mockito.when((Object)this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId("123")).thenReturn((Object)publicDocumentAccess);
        Assert.assertFalse((boolean)this.publicDocumentAccessService.isDocumentPublicAccessValid("123", "123456"));
        Assert.assertTrue((boolean)this.publicDocumentAccessService.isDocumentPublicAccessValid("123", "12345678"));
    }

    @Test
    public void hasPublicLink() {
        Mockito.when((Object)this.publicDocumentAccessStorage.getPublicDocumentAccessByNodeId("123")).thenReturn(null, (Object[])new PublicDocumentAccess[]{new PublicDocumentAccess()});
        Assert.assertFalse((boolean)this.publicDocumentAccessService.hasDocumentPublicAccess("123"));
        Assert.assertTrue((boolean)this.publicDocumentAccessService.hasDocumentPublicAccess("123"));
    }

    @Test
    public void revokePublicAccess() {
        this.publicDocumentAccessService.revokeDocumentPublicAccess("123");
        ((PublicDocumentAccessStorage)Mockito.verify((Object)this.publicDocumentAccessStorage, (VerificationMode)Mockito.times((int)1))).removePublicDocumentAccess("123");
    }
}

