/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.PermissionEntry;
import org.exoplatform.documents.model.PermissionRole;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.jcr.search.DocumentSearchServiceConnector;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class JCRDocumentFileStorage
implements DocumentFileStorage {
    private static final String COLLABORATION = "collaboration";
    private final SpaceService spaceService;
    private final RepositoryService repositoryService;
    private final IdentityManager identityManager;
    private final NodeHierarchyCreator nodeHierarchyCreator;
    private final DocumentSearchServiceConnector documentSearchServiceConnector;
    private final ListenerService listenerService;
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final String SPACE_PATH_PREFIX = "/Groups/spaces/";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final String GROUP_ADMINISTRATORS = "*:/platform/administrators";
    private static final String SPACE_PROVIDER_ID = "space";
    private static final String SHARED_FOLDER_NAME = "Shared";

    public JCRDocumentFileStorage(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, DocumentSearchServiceConnector documentSearchServiceConnector, IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.repositoryService = repositoryService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.documentSearchServiceConnector = documentSearchServiceConnector;
        this.listenerService = listenerService;
    }

    public List<FileNode> getFilesTimeline(DocumentTimelineFilter filter, Identity aclIdentity, int offset, int limit) throws ObjectNotFoundException {
        List<FileNode> files = null;
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        boolean showHiddenFiles = filter.isIncludeHiddenFiles();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
            if (identityRootNode == null) {
                List<FileNode> list = Collections.emptyList();
                return list;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            if (ownerIdentity.isUser()) {
                rootPath = rootPath.split("/Private")[0];
            }
            if (StringUtils.isBlank((CharSequence)filter.getQuery()) && BooleanUtils.isNotTrue((Boolean)filter.getFavorites())) {
                String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, true);
                String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                String statement = this.getTimeLineQueryStatement(rootPath, "nt:file", sortField, sortDirection);
                Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult queryResult = jcrQuery.execute();
                NodeIterator nodeIterator = queryResult.getNodes();
                files = JCRDocumentsUtil.toFileNodes(this.identityManager, nodeIterator, aclIdentity, session, this.spaceService, showHiddenFiles, offset, limit);
                statement = this.getTimeLineQueryStatement(rootPath, "exo:symlink", sortField, sortDirection);
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                nodeIterator = queryResult.getNodes();
                files.addAll(JCRDocumentsUtil.toFileNodes(this.identityManager, nodeIterator, aclIdentity, session, this.spaceService, showHiddenFiles, offset, limit));
                List<FileNode> list = files;
                return list;
            }
            String workspace = session.getWorkspace().getName();
            String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, false);
            String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
            Collection<SearchResult> filesSearchList = this.documentSearchServiceConnector.appSearch(aclIdentity, workspace, rootPath, (DocumentNodeFilter)filter, offset, limit, sortField, sortDirection);
            List<FileNode> list = filesSearchList.stream().map(result -> JCRDocumentsUtil.toFileNode(this.identityManager, session, aclIdentity, result, this.spaceService)).filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
    }

    public DocumentGroupsSize getGroupDocumentsCount(DocumentTimelineFilter filter, Identity aclIdentity) throws ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        DocumentGroupsSize documentGroupsSize = new DocumentGroupsSize();
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
            if (identityRootNode == null) {
                DocumentGroupsSize documentGroupsSize2 = documentGroupsSize;
                return documentGroupsSize2;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            if (StringUtils.isBlank((CharSequence)filter.getQuery())) {
                String statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, null, new Date());
                Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult queryResult = jcrQuery.execute();
                documentGroupsSize.setThisDay(queryResult.getRows().getSize());
                Calendar thisWeek = GregorianCalendar.getInstance();
                thisWeek.set(7, 1);
                Calendar thisMonth = GregorianCalendar.getInstance();
                thisMonth.set(5, 0);
                Calendar thisYear = GregorianCalendar.getInstance();
                thisYear.set(6, 0);
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, new Date(), thisWeek.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisWeek(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisWeek.getTime(), thisMonth.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisMonth(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisMonth.getTime(), thisYear.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisYear(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisYear.getTime(), null);
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setBeforeThisYear(queryResult.getRows().getSize());
                DocumentGroupsSize documentGroupsSize3 = documentGroupsSize;
                return documentGroupsSize3;
            }
            DocumentGroupsSize documentGroupsSize4 = documentGroupsSize;
            return documentGroupsSize4;
        }
    }

    public List<AbstractNode> getFolderChildNodes(DocumentFolderFilter filter, Identity aclIdentity, int offset, int limit) throws IllegalAccessException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        String parentFolderId = filter.getParentFolderId();
        String folderPath = filter.getFolderPath();
        boolean includeHiddenFiles = filter.isIncludeHiddenFiles();
        try (SessionProvider sessionProvider = null;){
            Node parent = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)parentFolderId)) {
                Long ownerId = filter.getOwnerId();
                String userId = filter.getUserId();
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = null;
                ownerIdentity = StringUtils.isNotEmpty((CharSequence)filter.getUserId()) ? this.identityManager.getOrCreateUserIdentity(userId) : this.identityManager.getIdentity(String.valueOf(ownerId));
                parent = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                parentFolderId = ((NodeImpl)parent).getIdentifier();
            } else {
                parent = JCRDocumentsUtil.getNodeByIdentifier(session, parentFolderId);
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                parent = this.getNodeByPath(parent, folderPath, sessionProvider);
            }
            if (parent != null) {
                if (StringUtils.isBlank((CharSequence)filter.getQuery()) && BooleanUtils.isNotTrue((Boolean)filter.getFavorites())) {
                    String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, true);
                    String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                    String statement = this.getFolderDocumentsQuery(parent.getPath(), sortField, sortDirection);
                    Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                    ((QueryImpl)jcrQuery).setOffset((long)offset);
                    ((QueryImpl)jcrQuery).setLimit((long)limit);
                    QueryResult queryResult = jcrQuery.execute();
                    NodeIterator nodeIterator = queryResult.getNodes();
                    List<AbstractNode> list = JCRDocumentsUtil.toNodes(this.identityManager, session, nodeIterator, aclIdentity, this.spaceService, includeHiddenFiles);
                    return list;
                }
                String workspace = session.getWorkspace().getName();
                String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, false);
                String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                Collection<SearchResult> filesSearchList = this.documentSearchServiceConnector.appSearch(aclIdentity, workspace, parent.getPath(), (DocumentNodeFilter)filter, offset, limit, sortField, sortDirection);
                List<AbstractNode> list = filesSearchList.stream().map(result -> JCRDocumentsUtil.toFileNode(this.identityManager, session, aclIdentity, result, this.spaceService)).filter(Objects::nonNull).collect(Collectors.toList());
                return list;
            }
            try {
                throw new ObjectNotFoundException("Folder with Id : " + parentFolderId + " isn't found");
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving User '" + username + "' parent node", e);
            }
        }
    }

    public List<BreadCrumbItem> getBreadcrumb(long ownerId, String folderId, String folderPath, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        ArrayList<BreadCrumbItem> parents;
        block17: {
            String username = aclIdentity.getUserId();
            parents = new ArrayList<BreadCrumbItem>();
            try (SessionProvider sessionProvider = null;){
                Node node = null;
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
                Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                    node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                    folderId = ((NodeImpl)node).getIdentifier();
                } else {
                    node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
                }
                if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                    node = this.getNodeByPath(node, folderPath, sessionProvider);
                }
                Object homePath = "";
                if (node == null) break block17;
                String nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath()));
                if (node.getPath().contains("/Groups/spaces/")) {
                    String[] pathParts = node.getPath().split("/Groups/spaces/")[1].split("/");
                    homePath = "/Groups/spaces/" + pathParts[0] + "/" + pathParts[1];
                }
                String userPrivatePathPrefix = username + "/Private";
                String userPublicPathPrefix = username + "/Public";
                if (node.getPath().contains(userPrivatePathPrefix)) {
                    homePath = node.getPath().substring(0, node.getPath().lastIndexOf(userPrivatePathPrefix) + userPrivatePathPrefix.length());
                }
                if (node.getPath().contains(userPublicPathPrefix)) {
                    homePath = node.getPath().substring(0, node.getPath().lastIndexOf(userPublicPathPrefix) + userPublicPathPrefix.length());
                }
                while (node != null && (!node.getPath().equals(homePath) || node.getName().equals("Public"))) {
                    try {
                        if (node.getName().equals("Public")) {
                            node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                            if (node != null) {
                                nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                                parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath()));
                            }
                            break;
                        }
                        if ((node = node.getParent()) == null) continue;
                        nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                        parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath()));
                    }
                    catch (RepositoryException repositoryException) {
                        node = null;
                    }
                }
            }
        }
        return parents;
    }

    public List<FullTreeItem> getFullTreeData(long ownerId, String folderId, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        ArrayList<FullTreeItem> parents = new ArrayList<FullTreeItem>();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                folderId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
            }
            if (node != null) {
                String nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                List<Object> children = new ArrayList();
                children = this.getAllFolderInNode(node);
                parents.add(new FullTreeItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath(), children));
            }
        }
        return parents;
    }

    private List<FullTreeItem> getAllFolderInNode(Node node) throws RepositoryException {
        ArrayList<FullTreeItem> folderListNodes = new ArrayList<FullTreeItem>();
        NodeIterator nodeIter = node.getNodes();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            if (childNode.isNodeType("exo:hiddenable") || !childNode.isNodeType("nt:unstructured") && !childNode.isNodeType("nt:folder")) continue;
            String nodeName = childNode.hasProperty("exo:title") ? childNode.getProperty("exo:title").getString() : childNode.getName();
            List<FullTreeItem> folderChildListNodes = this.getAllFolderInNode(childNode);
            folderListNodes.add(new FullTreeItem(((NodeImpl)childNode).getIdentifier(), nodeName, childNode.getPath(), folderChildListNodes));
        }
        return folderListNodes;
    }

    public void createFolder(long ownerId, String folderId, String folderPath, String title, Identity aclIdentity) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            String name;
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                folderId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                try {
                    node = node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8.name()));
                }
                catch (RepositoryException repositoryException) {
                    throw new ObjectNotFoundException("Folder with path : " + folderPath + " isn't found");
                }
            }
            if (node.hasNode(name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanString(title.toLowerCase())))) {
                throw new ObjectAlreadyExistsException((Object)("Folder'" + name + "' already exist"));
            }
            Node addedNode = node.addNode(name, "nt:folder");
            addedNode.setProperty("exo:title", title);
            node.save();
        }
    }

    public String getNewName(long ownerId, String folderId, String folderPath, String title) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        try (SessionProvider systemSessionProvider = null;){
            Node node = null;
            systemSessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = systemSessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, ownerIdentity, systemSession);
                folderId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(systemSession, folderId);
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                try {
                    node = node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8.name()));
                }
                catch (RepositoryException repositoryException) {
                    throw new ObjectNotFoundException("Folder with path : " + folderPath + " isn't found");
                }
            }
            String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanString(title.toLowerCase()));
            int i = 0;
            String newName = name;
            Object newTitle = title;
            while (node.hasNode(newName)) {
                newTitle = title + " (" + ++i + ")";
                newName = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanString(((String)newTitle).toLowerCase()));
            }
            String string = newTitle;
            return string;
        }
    }

    public void renameDocument(long ownerId, String documentID, String title, Identity aclIdentity) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)documentID) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                documentID = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            }
            String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanString(title));
            name = URLDecoder.decode(name, "UTF-8");
            String oldName = node.getName();
            if (oldName.indexOf(46) != -1 && node.isNodeType("nt:file")) {
                String ext = oldName.substring(oldName.lastIndexOf(46));
                title = name.concat(ext);
                name = name.concat(ext);
            }
            if (node.getName().equals(title)) {
                throw new ObjectAlreadyExistsException((Object)("Document'" + title + "' already exist"));
            }
            if (node.canAddMixin("exo:modify")) {
                node.addMixin("exo:modify");
            }
            Calendar now = Calendar.getInstance();
            node.setProperty("exo:dateModified", now);
            node.setProperty("exo:lastModifiedDate", now);
            node.setProperty("exo:lastModifier", username);
            if (node.canAddMixin("exo:sortable")) {
                node.addMixin("exo:sortable");
            }
            if (!node.hasProperty("exo:title")) {
                node.addMixin("exo:rss-enable");
            }
            node.save();
            Node parent = node.getParent();
            String srcPath = node.getPath();
            String destPath = (parent.getPath().equals("/") ? "" : parent.getPath()).concat("/").concat(name);
            node.getSession().getWorkspace().move(srcPath, destPath);
            node.setProperty("exo:title", title);
            node.setProperty("exo:name", name);
            node.save();
        }
    }

    public AbstractNode duplicateDocument(long ownerId, String fileId, String prefixClone, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node oldNode = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)fileId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                oldNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                fileId = ((NodeImpl)oldNode).getIdentifier();
            } else {
                oldNode = JCRDocumentsUtil.getNodeByIdentifier(session, fileId);
            }
            Node parentNode = oldNode.getParent();
            if (oldNode != null) {
                this.duplicateItem(oldNode, parentNode, parentNode, prefixClone);
                parentNode.save();
            }
            FileNode fileNode = JCRDocumentsUtil.toFileNode(this.identityManager, aclIdentity, parentNode, "", this.spaceService);
            return fileNode;
        }
    }

    public void moveDocument(long ownerId, String fileId, String destPath, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)fileId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                fileId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, fileId);
            }
            String srcPath = node.getPath();
            node.getSession().getWorkspace().move(srcPath, destPath.concat("/").concat(node.getName()));
            node.save();
        }
    }

    private void duplicateItem(Node oldNode, Node destinationNode, Node parentNode, String prefixClone) throws Exception {
        if (oldNode.isNodeType("exo:thumbnails")) {
            return;
        }
        Node newNode = null;
        String name = oldNode.getName();
        Object title = oldNode.getProperty("exo:title").getString();
        if (((NodeImpl)destinationNode).getIdentifier().equals(((NodeImpl)parentNode).getIdentifier())) {
            name = prefixClone.concat(" ").concat(name);
            title = prefixClone.concat(" ").concat((String)title);
            Object newName = name;
            int i = 0;
            while (destinationNode.hasNode((String)newName)) {
                newName = name + " (" + ++i + ")";
            }
            name = ((String)newName).toLowerCase();
            if (i > 0) {
                title = (String)title + " (" + i + ")";
            }
        }
        name = URLDecoder.decode(name, "UTF-8");
        if (oldNode.isNodeType("nt:folder")) {
            newNode = destinationNode.addNode(name, "nt:folder");
            newNode.setProperty("exo:title", (String)title);
            NodeIterator nodeIterator = oldNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                this.duplicateItem(node, newNode, parentNode, prefixClone);
            }
        } else {
            newNode = destinationNode.addNode(name, oldNode.getPrimaryNodeType().getName());
            this.addProperties(oldNode, newNode, (String)title);
        }
    }

    private void addProperties(Node oldNode, Node newNode, String title) throws RepositoryException {
        if (oldNode.isNodeType("mix:versionable") && !newNode.isNodeType("mix:versionable")) {
            newNode.addMixin("mix:versionable");
        }
        if (oldNode.isNodeType("mix:referenceable") && !newNode.isNodeType("mix:referenceable")) {
            newNode.addMixin("mix:referenceable");
        }
        if (oldNode.isNodeType("mix:commentable") && !newNode.isNodeType("mix:commentable")) {
            newNode.addMixin("mix:commentable");
        }
        if (oldNode.isNodeType("mix:votable") && !newNode.isNodeType("mix:votable")) {
            newNode.addMixin("mix:votable");
        }
        if (oldNode.isNodeType("mix:i18n") && !newNode.isNodeType("mix:i18n")) {
            newNode.addMixin("mix:i18n");
        }
        newNode.setProperty("exo:title", title);
        if (oldNode.hasNode("jcr:content")) {
            Node resourceNode = newNode.addNode("jcr:content", "nt:resource");
            Calendar now = Calendar.getInstance();
            resourceNode.setProperty("jcr:lastModified", now);
            resourceNode.setProperty("jcr:data", oldNode.getNode("jcr:content").getProperty("jcr:data").getStream());
            resourceNode.setProperty("jcr:mimeType", oldNode.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            resourceNode.setProperty("exo:dateModified", now);
        }
        if (oldNode.isNodeType("exo:symlink")) {
            newNode.setProperty("exo:workspace", oldNode.getSession().getWorkspace().getName());
            newNode.setProperty("exo:primaryType", oldNode.getPrimaryNodeType().getName());
            newNode.setProperty("exo:uuid", oldNode.getProperty("exo:uuid").getString());
        }
    }

    private String getTimeLineQueryStatement(String rootPath, String nodeType, String sortField, String sortDirection) {
        return "SELECT * FROM " + nodeType + " WHERE jcr:path LIKE '" + rootPath + "/%' ORDER BY " + sortField + " " + sortDirection;
    }

    private String getFolderDocumentsQuery(String folderPath, String sortField, String sortDirection) {
        return "SELECT * FROM nt:base" + " WHERE jcr:path LIKE '" + folderPath + "/%'" + " AND NOT jcr:path LIKE '" + folderPath + "/%/%' ORDER BY " + sortField + " " + sortDirection;
    }

    private String getTimeLineGroupeSizeQueryStatement(String rootPath, Date before, Date after) {
        StringBuilder sb = new StringBuilder().append("SELECT * FROM ").append("nt:file").append(" WHERE jcr:path LIKE '").append(rootPath).append("/%'");
        if (before != null) {
            sb.append(" AND (").append("exo:dateModified").append(" < TIMESTAMP '").append(this.formatter.format(before)).append("T00:00:00.000')");
        }
        if (after != null) {
            sb.append(" AND (").append("exo:dateModified").append(" > TIMESTAMP '").append(this.formatter.format(after)).append("T00:00:00.000')");
        }
        return sb.toString();
    }

    private Node getNodeByPath(Node node, String folderPath, SessionProvider sessionProvider) throws ObjectNotFoundException {
        try {
            if (node.getName().equals("Private")) {
                if (folderPath.startsWith("Private")) {
                    folderPath = folderPath.split("Private/")[1];
                    return node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8.name()));
                }
                if (folderPath.startsWith("Public")) {
                    SessionProvider systemSessionProvides = SessionProvider.createSystemProvider();
                    Session systemSession = systemSessionProvides.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
                    Node parent = JCRDocumentsUtil.getNodeByIdentifier(systemSession, ((NodeImpl)node).getIdentifier()).getParent();
                    node = parent.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8.name()));
                    Session session = sessionProvider.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
                    if (session.itemExists(node.getPath())) {
                        return (Node)session.getItem(node.getPath());
                    }
                    return null;
                }
            }
            if (node.getName().equals("Public")) {
                if (folderPath.startsWith("Private/Public")) {
                    folderPath = folderPath.split("Private/Public/")[1];
                    return node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8.name()));
                }
                if (folderPath.startsWith("Public")) {
                    folderPath = folderPath.split("Public/")[1];
                    return node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8.name()));
                }
            }
            return node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8.name()));
        }
        catch (RepositoryException repositoryException) {
            throw new ObjectNotFoundException("Folder with path : " + folderPath + " isn't found");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Error retrieving folder'" + folderPath, e);
        }
    }

    public void updatePermissions(String documentID, NodePermission nodePermissionEntity, Identity aclIdentity) {
        try (SessionProvider sessionProvider = null;){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            HashMap<Object, String[]> permissions = new HashMap<Object, String[]>();
            List permissionsList = nodePermissionEntity.getPermissions();
            if (node.hasProperty("exo:owner")) {
                String owner = node.getProperty("exo:owner").getString();
                permissions.put(owner, PermissionType.ALL);
            }
            permissions.put(GROUP_ADMINISTRATORS, PermissionType.ALL);
            for (PermissionEntry permission : permissionsList) {
                if (permission.getIdentity().getProviderId().equals(SPACE_PROVIDER_ID)) {
                    Space space = this.spaceService.getSpaceByPrettyName(permission.getIdentity().getRemoteId());
                    String groupId = space.getGroupId();
                    if (permission.getPermission().equals("edit")) {
                        if (permission.getRole().equals(PermissionRole.ALL.name())) {
                            permissions.put("*:" + groupId, PermissionType.ALL);
                        }
                        if (permission.getRole().equals(PermissionRole.MANAGERS_REDACTORS.name())) {
                            permissions.put("manager:" + groupId, PermissionType.ALL);
                            permissions.put("redactor:" + groupId, PermissionType.ALL);
                        }
                    }
                    if (!permission.getPermission().equals("read")) continue;
                    if (permission.getRole().equals(PermissionRole.ALL.name())) {
                        permissions.put("*:" + groupId, new String[]{"read"});
                    }
                    if (!permission.getRole().equals(PermissionRole.MANAGERS_REDACTORS.name())) continue;
                    permissions.put("manager:" + groupId, new String[]{"read"});
                    permissions.put("redactor:" + groupId, new String[]{"read"});
                    continue;
                }
                if (permission.getPermission().equals("edit")) {
                    permissions.put(permission.getIdentity().getRemoteId(), PermissionType.ALL);
                }
                if (!permission.getPermission().equals("read")) continue;
                permissions.put(permission.getIdentity().getRemoteId(), new String[]{"read"});
            }
            if (node.canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)node).setPermissions(permissions);
            session.save();
        }
    }

    public void shareDocument(String documentId, long destId) {
        Node rootNode = null;
        Node shared = null;
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node currentNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, documentId);
            org.exoplatform.social.core.identity.model.Identity destIdentity = this.identityManager.getIdentity(String.valueOf(destId));
            rootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, destIdentity, systemSession);
            if (!destIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                rootNode = rootNode.getNode("Documents");
            }
            shared = !rootNode.hasNode(SHARED_FOLDER_NAME) ? rootNode.addNode(SHARED_FOLDER_NAME) : rootNode.getNode(SHARED_FOLDER_NAME);
            if (currentNode.isNodeType("exo:symlink")) {
                String sourceNodeId = currentNode.getProperty("exo:uuid").getString();
                currentNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, sourceNodeId);
            }
            Node linkNode = null;
            linkNode = shared.hasNode(currentNode.getName()) ? shared.getNode(currentNode.getName()) : shared.addNode(currentNode.getName(), "exo:symlink");
            linkNode.setProperty("exo:workspace", repository.getConfiguration().getDefaultWorkspaceName());
            linkNode.setProperty("exo:primaryType", currentNode.getPrimaryNodeType().getName());
            linkNode.setProperty("exo:uuid", currentNode.getUUID());
            if (linkNode.canAddMixin("exo:sortable")) {
                linkNode.addMixin("exo:sortable");
            }
            if (currentNode.hasProperty("exo:title")) {
                linkNode.setProperty("exo:title", currentNode.getProperty("exo:title").getString());
            }
            linkNode.setProperty("exo:name", currentNode.getName());
            String nodeMimeType = JCRDocumentsUtil.getMimeType(currentNode);
            linkNode.addMixin("mix:fileType");
            linkNode.setProperty("exo:fileType", nodeMimeType);
            rootNode.save();
            HashMap<Object, String[]> permissions = new HashMap<Object, String[]>();
            if (destIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                Space space = this.spaceService.getSpaceByPrettyName(destIdentity.getRemoteId());
                String groupId = space.getGroupId();
                permissions.put("*:" + groupId, PermissionType.ALL);
            } else {
                permissions.put(destIdentity.getRemoteId(), PermissionType.ALL);
            }
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)linkNode).setPermissions(permissions);
            systemSession.save();
            Utils.broadcast(this.listenerService, "share_document_event", destIdentity, linkNode);
        }
    }

    public boolean canAccess(String documentID, Identity aclIdentity) throws RepositoryException {
        boolean canAccess = false;
        try (SessionProvider sessionProvider = null;){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            if (node == null) {
                boolean bl = false;
                return bl;
            }
            String userId = aclIdentity.getUserId();
            ExtendedNode extendedNode = (ExtendedNode)node;
            List permsList = extendedNode.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                String nodeAclIdentity = accessControlEntry.getIdentity();
                MembershipEntry membershipEntry = accessControlEntry.getMembershipEntry();
                if (!StringUtils.equals((CharSequence)nodeAclIdentity, (CharSequence)userId) && !StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)userId) && (membershipEntry == null || !aclIdentity.isMemberOf(membershipEntry))) continue;
                canAccess = true;
            }
            boolean bl = canAccess;
            return bl;
        }
    }
}

