/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FolderNode;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.PermissionEntry;
import org.exoplatform.documents.model.PermissionRole;
import org.exoplatform.documents.model.SymlinkNavigation;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.jcr.search.DocumentSearchServiceConnector;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.utils.VersionHistoryUtils;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagObject;

public class JCRDocumentFileStorage
implements DocumentFileStorage {
    private static final String COLLABORATION = "collaboration";
    private final SpaceService spaceService;
    private final RepositoryService repositoryService;
    private final IdentityManager identityManager;
    private final NodeHierarchyCreator nodeHierarchyCreator;
    private final DocumentSearchServiceConnector documentSearchServiceConnector;
    private final ListenerService listenerService;
    private final IdentityRegistry identityRegistry;
    private final ActivityManager activityManager;
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final String SPACE_PATH_PREFIX = "/Groups/spaces/";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final String GROUP_ADMINISTRATORS = "*:/platform/administrators";
    private static final String SPACE_PROVIDER_ID = "space";
    private static final String SHARED_FOLDER_NAME = "Shared";
    private static final String EOO_COMMENT_ID = "eoo:commentId";
    private static final String ADD_TAG_DOCUMENT = "add_tag_document";
    private static final String KEEP_BOTH = "keepBoth";
    private static final String CREATE_NEW_VERSION = "createNewVersion";
    private static Map<Long, List<SymlinkNavigation>> symlinksNavHistory = new HashMap<Long, List<SymlinkNavigation>>();

    public JCRDocumentFileStorage(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, DocumentSearchServiceConnector documentSearchServiceConnector, IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService, IdentityRegistry identityRegistry, ActivityManager activityManager) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.repositoryService = repositoryService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.documentSearchServiceConnector = documentSearchServiceConnector;
        this.listenerService = listenerService;
        this.identityRegistry = identityRegistry;
        this.activityManager = activityManager;
    }

    public List<FileNode> getFilesTimeline(DocumentTimelineFilter filter, Identity aclIdentity, int offset, int limit) throws ObjectNotFoundException {
        List<FileNode> files = null;
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        boolean showHiddenFiles = filter.isIncludeHiddenFiles();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
            if (identityRootNode == null) {
                List<FileNode> list = Collections.emptyList();
                return list;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            if (StringUtils.isBlank((CharSequence)filter.getQuery()) && BooleanUtils.isNotTrue((Boolean)filter.getFavorites())) {
                String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, true);
                String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                String statement = this.getTimeLineQueryStatement(rootPath, sortField, sortDirection);
                Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                ((QueryImpl)jcrQuery).setOffset((long)offset);
                ((QueryImpl)jcrQuery).setLimit((long)limit);
                QueryResult queryResult = jcrQuery.execute();
                NodeIterator nodeIterator = queryResult.getNodes();
                List<FileNode> list = files = JCRDocumentsUtil.toFileNodes(this.identityManager, nodeIterator, aclIdentity, session, this.spaceService, showHiddenFiles);
                return list;
            }
            String workspace = session.getWorkspace().getName();
            String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, false);
            String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
            Collection<SearchResult> filesSearchList = this.documentSearchServiceConnector.search(aclIdentity, workspace, rootPath, (DocumentNodeFilter)filter, offset, limit, sortField, sortDirection);
            List<FileNode> list = filesSearchList.stream().map(result -> JCRDocumentsUtil.toFileNode(this.identityManager, session, aclIdentity, result, this.spaceService)).filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
    }

    public DocumentGroupsSize getGroupDocumentsCount(DocumentTimelineFilter filter, Identity aclIdentity) throws ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        Long ownerId = filter.getOwnerId();
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (ownerIdentity == null) {
            throw new ObjectNotFoundException("Owner Identity with id : " + ownerId + " isn't found");
        }
        DocumentGroupsSize documentGroupsSize = new DocumentGroupsSize();
        try (SessionProvider sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);){
            Node identityRootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
            if (identityRootNode == null) {
                DocumentGroupsSize documentGroupsSize2 = documentGroupsSize;
                return documentGroupsSize2;
            }
            Session session = identityRootNode.getSession();
            String rootPath = identityRootNode.getPath();
            if (StringUtils.isBlank((CharSequence)filter.getQuery())) {
                String statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, null, new Date());
                Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult queryResult = jcrQuery.execute();
                documentGroupsSize.setThisDay(queryResult.getRows().getSize());
                Calendar thisWeek = GregorianCalendar.getInstance();
                thisWeek.set(7, 1);
                Calendar thisMonth = GregorianCalendar.getInstance();
                thisMonth.set(5, 0);
                Calendar thisYear = GregorianCalendar.getInstance();
                thisYear.set(6, 0);
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, new Date(), thisWeek.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisWeek(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisWeek.getTime(), thisMonth.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisMonth(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisMonth.getTime(), thisYear.getTime());
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setThisYear(queryResult.getRows().getSize());
                statement = this.getTimeLineGroupeSizeQueryStatement(rootPath, thisYear.getTime(), null);
                jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                queryResult = jcrQuery.execute();
                documentGroupsSize.setBeforeThisYear(queryResult.getRows().getSize());
                DocumentGroupsSize documentGroupsSize3 = documentGroupsSize;
                return documentGroupsSize3;
            }
            DocumentGroupsSize documentGroupsSize4 = documentGroupsSize;
            return documentGroupsSize4;
        }
    }

    public List<AbstractNode> getFolderChildNodes(DocumentFolderFilter filter, Identity aclIdentity, int offset, int limit) throws IllegalAccessException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        String parentFolderId = filter.getParentFolderId();
        String folderPath = filter.getFolderPath();
        boolean includeHiddenFiles = filter.isIncludeHiddenFiles();
        try (SessionProvider sessionProvider = null;){
            String sourceNodeId;
            Node parent = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)parentFolderId)) {
                Long ownerId = filter.getOwnerId();
                String userId = filter.getUserId();
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = null;
                ownerIdentity = StringUtils.isNotEmpty((CharSequence)filter.getUserId()) ? this.identityManager.getOrCreateUserIdentity(userId) : this.identityManager.getIdentity(String.valueOf(ownerId));
                parent = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                parentFolderId = ((NodeImpl)parent).getIdentifier();
            } else {
                parent = JCRDocumentsUtil.getNodeByIdentifier(session, parentFolderId);
                if (parent.isNodeType("exo:symlink")) {
                    sourceNodeId = parent.getProperty("exo:uuid").getString();
                    parent = JCRDocumentsUtil.getNodeByIdentifier(session, sourceNodeId);
                }
                if (filter.getSymlinkId() != null && !filter.getSymlinkId().isEmpty()) {
                    List<SymlinkNavigation> history = symlinksNavHistory.get(filter.getOwnerId());
                    SymlinkNavigation newEntry = new SymlinkNavigation(filter.getSymlinkId(), parentFolderId);
                    if (history == null) {
                        history = new ArrayList<SymlinkNavigation>();
                        history.add(newEntry);
                    } else if (!history.contains(newEntry)) {
                        history.add(newEntry);
                    }
                    symlinksNavHistory.put(filter.getOwnerId(), history);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath) && (parent = this.getNodeByPath(parent, folderPath, sessionProvider)) != null && parent.isNodeType("exo:symlink")) {
                sourceNodeId = parent.getProperty("exo:uuid").getString();
                parent = JCRDocumentsUtil.getNodeByIdentifier(session, sourceNodeId);
            }
            if (parent != null) {
                if (StringUtils.isBlank((CharSequence)filter.getQuery()) && BooleanUtils.isNotTrue((Boolean)filter.getFavorites())) {
                    String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, true);
                    String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                    String statement = this.getFolderDocumentsQuery(parent.getPath(), sortField, sortDirection, includeHiddenFiles);
                    Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                    ((QueryImpl)jcrQuery).setOffset((long)offset);
                    ((QueryImpl)jcrQuery).setLimit((long)limit);
                    QueryResult queryResult = jcrQuery.execute();
                    NodeIterator nodeIterator = queryResult.getNodes();
                    List<AbstractNode> list = JCRDocumentsUtil.toNodes(this.identityManager, session, nodeIterator, aclIdentity, this.spaceService, includeHiddenFiles);
                    return list;
                }
                String workspace = session.getWorkspace().getName();
                String sortField = JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, false);
                String sortDirection = JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter);
                Collection<SearchResult> filesSearchList = this.documentSearchServiceConnector.search(aclIdentity, workspace, parent.getPath(), (DocumentNodeFilter)filter, offset, limit, sortField, sortDirection);
                List<AbstractNode> list = filesSearchList.stream().map(result -> JCRDocumentsUtil.toFileNode(this.identityManager, session, aclIdentity, result, this.spaceService)).filter(Objects::nonNull).collect(Collectors.toList());
                return list;
            }
            try {
                throw new ObjectNotFoundException("Folder with Id : " + parentFolderId + " isn't found");
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving User '" + username + "' parent node", e);
            }
        }
    }

    public List<BreadCrumbItem> getBreadcrumb(long ownerId, String folderId, String folderPath, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        ArrayList<BreadCrumbItem> parents;
        block17: {
            String username = aclIdentity.getUserId();
            parents = new ArrayList<BreadCrumbItem>();
            try (SessionProvider sessionProvider = null;){
                Node node = null;
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
                Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                    node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                    folderId = ((NodeImpl)node).getIdentifier();
                } else {
                    node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
                    node = this.checkSymlinkHistory(node, session, ownerId);
                }
                if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                    node = this.getNodeByPath(node, folderPath, sessionProvider);
                }
                Object homePath = "";
                if (node == null) break block17;
                String nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath(), node.isNodeType("exo:symlink")));
                if (node.getPath().contains("/Groups/spaces/")) {
                    String[] pathParts = node.getPath().split("/Groups/spaces/")[1].split("/");
                    homePath = "/Groups/spaces/" + pathParts[0] + "/" + pathParts[1];
                }
                String userPrivatePathPrefix = username + "/Private";
                String userPublicPathPrefix = username + "/Public";
                if (node.getPath().contains(userPrivatePathPrefix)) {
                    homePath = node.getPath().substring(0, node.getPath().lastIndexOf(userPrivatePathPrefix) + userPrivatePathPrefix.length());
                }
                if (node.getPath().contains(userPublicPathPrefix)) {
                    homePath = node.getPath().substring(0, node.getPath().lastIndexOf(userPublicPathPrefix) + userPublicPathPrefix.length());
                }
                while (node != null && (!node.getPath().equals(homePath) || node.getName().equals("Public"))) {
                    try {
                        if (node.getName().equals("Public")) {
                            node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                            if (node != null) {
                                nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                                parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath(), node.isNodeType("exo:symlink")));
                            }
                            break;
                        }
                        node = node.getParent();
                        if ((node = this.checkSymlinkHistory(node, session, ownerId)) == null) continue;
                        nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                        parents.add(new BreadCrumbItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath(), node.isNodeType("exo:symlink")));
                    }
                    catch (RepositoryException repositoryException) {
                        node = null;
                    }
                }
            }
        }
        return parents;
    }

    Node checkSymlinkHistory(Node node, Session session, Long ownerId) throws RepositoryException {
        List<SymlinkNavigation> history = symlinksNavHistory.get(ownerId);
        if (node != null && history != null && !history.isEmpty()) {
            String id = ((NodeImpl)node).getIdentifier();
            SymlinkNavigation symlink = history.stream().filter(item -> id.equals(item.getSourceId())).findAny().orElse(null);
            if (symlink != null) {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, symlink.getSymlinkId());
            }
        }
        return node;
    }

    public List<FullTreeItem> getFullTreeData(long ownerId, String folderId, Identity aclIdentity) {
        String username = aclIdentity.getUserId();
        ArrayList<FullTreeItem> parents = new ArrayList<FullTreeItem>();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                folderId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
            }
            if (node != null) {
                String nodeName = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                List<FullTreeItem> children = this.getAllFolderInNode(node, session);
                parents.add(new FullTreeItem(((NodeImpl)node).getIdentifier(), nodeName, node.getPath(), children));
            }
        }
        return parents;
    }

    private List<FullTreeItem> getAllFolderInNode(Node node, Session session) throws RepositoryException {
        ArrayList<FullTreeItem> folderListNodes = new ArrayList<FullTreeItem>();
        NodeIterator nodeIter = node.getNodes();
        while (nodeIter.hasNext()) {
            String nodeName;
            Node childNode = nodeIter.nextNode();
            if (childNode.isNodeType("exo:hiddenable") || !childNode.isNodeType("nt:unstructured") && !childNode.isNodeType("nt:folder") && !childNode.isNodeType("exo:symlink")) continue;
            String string = nodeName = childNode.hasProperty("exo:title") ? childNode.getProperty("exo:title").getString() : childNode.getName();
            if (childNode.isNodeType("exo:symlink")) {
                Node parentNode = JCRDocumentsUtil.getNodeByIdentifier(session, childNode.getProperty("exo:uuid").getString());
                if (parentNode != null && (!parentNode.isNodeType("nt:unstructured") && !parentNode.isNodeType("nt:folder") || childNode.getPath().contains(parentNode.getPath()))) continue;
                childNode = parentNode;
            }
            if (childNode == null) continue;
            List<FullTreeItem> folderChildListNodes = this.getAllFolderInNode(childNode, session);
            folderListNodes.add(new FullTreeItem(((NodeImpl)childNode).getIdentifier(), nodeName, childNode.getPath(), folderChildListNodes));
        }
        return folderListNodes.stream().sorted(new Comparator<FullTreeItem>(){

            @Override
            public int compare(FullTreeItem o1, FullTreeItem o2) {
                if (NumberUtils.isParsable((String)o1.getName()) && NumberUtils.isParsable((String)o2.getName())) {
                    return Integer.parseInt(o1.getName()) - Integer.parseInt(o2.getName());
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        }).collect(Collectors.toList());
    }

    public AbstractNode createFolder(long ownerId, String folderId, String folderPath, String title, Identity aclIdentity) throws ObjectAlreadyExistsException {
        if (!JCRDocumentsUtil.isValidDocumentTitle(title)) {
            throw new IllegalArgumentException("folder title is not valid");
        }
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            String name;
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                folderId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, folderId);
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                try {
                    node = node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
                }
                catch (RepositoryException repositoryException) {
                    throw new ObjectNotFoundException("Folder with path : " + folderPath + " isn't found");
                }
            }
            if (node.hasNode(name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(title.toLowerCase())))) {
                throw new ObjectAlreadyExistsException((Object)("Folder'" + name + "' already exist"));
            }
            Node addedNode = node.addNode(name, "nt:folder");
            addedNode.setProperty("exo:title", title);
            if (addedNode.canAddMixin("mix:referenceable")) {
                addedNode.addMixin("mix:referenceable");
            }
            node.save();
            FolderNode folderNode = JCRDocumentsUtil.toFolderNode(this.identityManager, aclIdentity, addedNode, "", this.spaceService);
            return folderNode;
        }
    }

    public String getNewName(long ownerId, String folderId, String folderPath, String title) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        try (SessionProvider systemSessionProvider = null;){
            Node node = null;
            systemSessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = systemSessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            if (StringUtils.isBlank((CharSequence)folderId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, ownerIdentity, systemSession);
                folderId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(systemSession, folderId);
            }
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                try {
                    node = node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
                }
                catch (RepositoryException repositoryException) {
                    throw new ObjectNotFoundException("Folder with path : " + folderPath + " isn't found");
                }
            }
            String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(title.toLowerCase()));
            int i = 0;
            String newName = name;
            Object newTitle = title;
            while (node.hasNode(newName)) {
                newTitle = title + " (" + ++i + ")";
                newName = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(((String)newTitle).toLowerCase()));
            }
            String string = newTitle;
            return string;
        }
    }

    public void renameDocument(long ownerId, String documentID, String title, Identity aclIdentity) throws ObjectAlreadyExistsException {
        if (!JCRDocumentsUtil.isValidDocumentTitle(title)) {
            throw new IllegalArgumentException("document title is not valid");
        }
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)documentID) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                documentID = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            }
            String name = Text.escapeIllegalJcrChars((String)JCRDocumentsUtil.cleanName(title));
            name = URLDecoder.decode(name, "UTF-8");
            if (name.indexOf(46) == -1) {
                String oldName;
                String string = oldName = node.getName().indexOf(46) == -1 && node.isNodeType("nt:file") && node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
                if (oldName.indexOf(46) != -1 && node.isNodeType("nt:file")) {
                    String ext = oldName.substring(oldName.lastIndexOf(46));
                    title = title.concat(ext);
                    name = name.concat(ext);
                }
            }
            this.checkNodeExistence(session, node, title);
            if (node.canAddMixin("exo:modify")) {
                node.addMixin("exo:modify");
            }
            Calendar now = Calendar.getInstance();
            node.setProperty("exo:dateModified", now);
            node.setProperty("exo:lastModifiedDate", now);
            node.setProperty("exo:lastModifier", username);
            if (node.canAddMixin("exo:sortable")) {
                node.addMixin("exo:sortable");
            }
            if (!node.hasProperty("exo:title")) {
                node.addMixin("exo:rss-enable");
            }
            node.save();
            Node parent = node.getParent();
            String srcPath = node.getPath();
            String destPath = (parent.getPath().equals("/") ? "" : parent.getPath()).concat("/").concat(name);
            node.getSession().getWorkspace().move(srcPath, destPath);
            node.setProperty("exo:title", title);
            node.setProperty("exo:name", name);
            node.save();
        }
    }

    private void checkNodeExistence(Session session, Node node, String title) throws RepositoryException, ObjectAlreadyExistsException {
        Node current = node;
        if (current != null && current.isNodeType("exo:symlink")) {
            current = JCRDocumentsUtil.getNodeByIdentifier(session, current.getProperty("exo:uuid").getString());
        }
        if (current != null && node.getParent() != null && node.getParent().hasNode(title)) {
            Node existNode = node.getParent().getNode(title);
            Node existCurrent = existNode;
            if (existCurrent.isNodeType("exo:symlink")) {
                existCurrent = JCRDocumentsUtil.getNodeByIdentifier(session, existCurrent.getProperty("exo:uuid").getString());
            }
            if (existCurrent != null) {
                String primaryType = existCurrent.getPrimaryNodeType().getName();
                if (node != existNode && current.getPrimaryNodeType().getName().equals(primaryType)) {
                    throw new ObjectAlreadyExistsException((Object)"Document with same name already exist");
                }
            }
        }
    }

    public AbstractNode duplicateDocument(long ownerId, String fileId, String prefixClone, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node oldNode = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)fileId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                oldNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                fileId = ((NodeImpl)oldNode).getIdentifier();
            } else {
                oldNode = JCRDocumentsUtil.getNodeByIdentifier(session, fileId);
            }
            Node parentNode = oldNode.getParent();
            Node newNode = null;
            if (oldNode != null) {
                newNode = this.duplicateItem(oldNode, parentNode, parentNode, prefixClone);
                parentNode.save();
            }
            VersionHistoryUtils.createVersion(newNode);
            FileNode fileNode = JCRDocumentsUtil.toFileNode(this.identityManager, aclIdentity, parentNode, "", this.spaceService);
            return fileNode;
        }
    }

    public void moveDocument(long ownerId, String fileId, String destPath, Identity aclIdentity, String conflictAction) throws ObjectAlreadyExistsException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node node;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            if (StringUtils.isBlank((CharSequence)fileId) && ownerId > 0L) {
                org.exoplatform.social.core.identity.model.Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
                node = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, username, ownerIdentity, sessionProvider);
                fileId = ((NodeImpl)node).getIdentifier();
            } else {
                node = JCRDocumentsUtil.getNodeByIdentifier(session, fileId);
            }
            if (node.canAddMixin("exo:modify")) {
                node.addMixin("exo:modify");
            }
            Calendar now = Calendar.getInstance();
            node.setProperty("exo:dateModified", now);
            node.setProperty("exo:lastModifiedDate", now);
            node.setProperty("exo:lastModifier", username);
            node.save();
            String srcPath = node.getPath();
            if (session.itemExists(destPath + "/" + node.getName())) {
                this.handleMoveDocConflict(session, node, srcPath, destPath, conflictAction);
            } else {
                node.getSession().getWorkspace().move(srcPath, destPath + "/" + node.getName());
                node.save();
            }
        }
    }

    private void handleMoveDocConflict(Session session, Node node, String srcPath, String destPath, String conflictAction) throws RepositoryException, ObjectAlreadyExistsException {
        String originName;
        int count = 0;
        String name = originName = node.getName();
        if (Objects.equals(conflictAction, KEEP_BOTH)) {
            while (session.itemExists((String)destPath + "/" + name)) {
                name = JCRDocumentsUtil.increaseNameIndex(originName, ++count);
            }
            destPath = (String)destPath + "/" + name;
            node.getSession().getWorkspace().move(srcPath, (String)destPath);
            Node destNode = (Node)session.getItem((String)destPath);
            if (destNode.hasProperty("exo:title")) {
                String exoTitle = JCRDocumentsUtil.getNewIndexedName(destNode.getProperty("exo:title").getString(), "(" + count + ")");
                destNode.setProperty("exo:title", exoTitle);
            }
            destNode.getSession().save();
        } else if (Objects.equals(conflictAction, CREATE_NEW_VERSION)) {
            Node destNode = (Node)session.getItem((String)destPath + "/" + name);
            Node scrNode = (Node)session.getItem(srcPath);
            if (destNode.isNodeType("mix:versionable")) {
                Node destContentNode = destNode.getNode("jcr:content");
                Node scrContentNode = scrNode.getNode("jcr:content");
                destContentNode.setProperty("jcr:data", scrContentNode.getProperty("jcr:data").getStream());
                destContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                if (destNode.isNodeType("exo:modify")) {
                    destNode.setProperty("exo:dateModified", Calendar.getInstance());
                    destNode.setProperty("exo:lastModifiedDate", Calendar.getInstance());
                }
                destNode.save();
                scrNode.remove();
                if (!destNode.isCheckedOut()) {
                    destNode.checkout();
                }
                destNode.checkin();
                destNode.checkout();
                destNode.getSession().save();
            }
        } else {
            Node destNode = (Node)session.getItem((String)destPath + "/" + name);
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("versionable", destNode.isNodeType("mix:versionable"));
            throw new ObjectAlreadyExistsException(map);
        }
    }

    private Node duplicateItem(Node oldNode, Node destinationNode, Node parentNode, String prefixClone) throws Exception {
        if (oldNode.isNodeType("exo:thumbnails")) {
            return null;
        }
        Node newNode = null;
        String name = oldNode.getName();
        Object title = oldNode.getProperty("exo:title").getString();
        if (((NodeImpl)destinationNode).getIdentifier().equals(((NodeImpl)parentNode).getIdentifier())) {
            name = prefixClone.concat(" ").concat(name);
            title = prefixClone.concat(" ").concat((String)title);
            Object newName = name;
            int i = 0;
            while (destinationNode.hasNode((String)newName)) {
                newName = name + " (" + ++i + ")";
            }
            name = ((String)newName).toLowerCase();
            if (i > 0) {
                title = (String)title + " (" + i + ")";
            }
        }
        name = URLDecoder.decode(name, "UTF-8");
        if (oldNode.isNodeType("nt:folder")) {
            newNode = destinationNode.addNode(name.toLowerCase(), "nt:folder");
            newNode.setProperty("exo:title", (String)title);
            NodeIterator nodeIterator = oldNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                this.duplicateItem(node, newNode, parentNode, prefixClone);
            }
        } else {
            newNode = destinationNode.addNode(name, oldNode.getPrimaryNodeType().getName());
            this.addProperties(oldNode, newNode, (String)title);
        }
        return newNode;
    }

    private void addProperties(Node oldNode, Node newNode, String title) throws RepositoryException {
        if (oldNode.isNodeType("mix:versionable") && !newNode.isNodeType("mix:versionable")) {
            newNode.addMixin("mix:versionable");
        }
        if (oldNode.isNodeType("mix:referenceable") && !newNode.isNodeType("mix:referenceable")) {
            newNode.addMixin("mix:referenceable");
        }
        if (oldNode.isNodeType("mix:commentable") && !newNode.isNodeType("mix:commentable")) {
            newNode.addMixin("mix:commentable");
        }
        if (oldNode.isNodeType("mix:votable") && !newNode.isNodeType("mix:votable")) {
            newNode.addMixin("mix:votable");
        }
        if (oldNode.isNodeType("mix:i18n") && !newNode.isNodeType("mix:i18n")) {
            newNode.addMixin("mix:i18n");
        }
        newNode.setProperty("exo:title", title);
        if (oldNode.hasNode("jcr:content")) {
            Node resourceNode = newNode.addNode("jcr:content", "nt:resource");
            Calendar now = Calendar.getInstance();
            resourceNode.setProperty("jcr:lastModified", now);
            resourceNode.setProperty("jcr:data", oldNode.getNode("jcr:content").getProperty("jcr:data").getStream());
            resourceNode.setProperty("jcr:mimeType", oldNode.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            resourceNode.setProperty("exo:dateModified", now);
        }
        if (oldNode.isNodeType("exo:symlink")) {
            newNode.setProperty("exo:workspace", oldNode.getSession().getWorkspace().getName());
            newNode.setProperty("exo:primaryType", oldNode.getPrimaryNodeType().getName());
            newNode.setProperty("exo:uuid", oldNode.getProperty("exo:uuid").getString());
        }
    }

    private String getTimeLineQueryStatement(String rootPath, String sortField, String sortDirection) {
        return "SELECT * FROM " + "nt:base" + " WHERE jcr:path LIKE '" + rootPath + "/%' " + " AND ( jcr:primaryType='exo:symlink' OR jcr:primaryType='nt:file') AND NOT jcr:mixinTypes LIKE 'exo:hiddenable' " + " ORDER BY " + sortField + " " + sortDirection;
    }

    private String getFolderDocumentsQuery(String folderPath, String sortField, String sortDirection, boolean includeHiddenFiles) {
        String hiddenableQuery = includeHiddenFiles ? " " : " AND NOT jcr:mixinTypes LIKE 'exo:hiddenable' ";
        return "SELECT * FROM nt:base" + " WHERE jcr:path LIKE '" + folderPath + "/%'" + " AND NOT jcr:path LIKE '" + folderPath + "/%/%' " + hiddenableQuery + " ORDER BY " + sortField + " " + sortDirection;
    }

    private String getTimeLineGroupeSizeQueryStatement(String rootPath, Date before, Date after) {
        StringBuilder sb = new StringBuilder().append("SELECT * FROM ").append("nt:file").append(" WHERE jcr:path LIKE '").append(rootPath).append("/%'");
        if (before != null) {
            sb.append(" AND (").append("exo:dateModified").append(" < TIMESTAMP '").append(this.formatter.format(before)).append("T00:00:00.000')");
        }
        if (after != null) {
            sb.append(" AND (").append("exo:dateModified").append(" > TIMESTAMP '").append(this.formatter.format(after)).append("T00:00:00.000')");
        }
        return sb.toString();
    }

    private Node getNodeByPath(Node node, String folderPath, SessionProvider sessionProvider) throws ObjectNotFoundException {
        try {
            if (node.getName().equals("Private")) {
                if (folderPath.startsWith("Private")) {
                    folderPath = folderPath.split("Private/")[1];
                    return node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
                }
                if (folderPath.startsWith("Public")) {
                    SessionProvider systemSessionProvides = SessionProvider.createSystemProvider();
                    Session systemSession = systemSessionProvides.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
                    Node parent = JCRDocumentsUtil.getNodeByIdentifier(systemSession, ((NodeImpl)node).getIdentifier()).getParent();
                    node = parent.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
                    Session session = sessionProvider.getSession(sessionProvider.getCurrentWorkspace(), sessionProvider.getCurrentRepository());
                    if (session.itemExists(node.getPath())) {
                        return (Node)session.getItem(node.getPath());
                    }
                    return null;
                }
            }
            if (node.getName().equals("Public")) {
                if (folderPath.startsWith("Private/Public")) {
                    folderPath = folderPath.split("Private/Public/")[1];
                    return node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
                }
                if (folderPath.startsWith("Public")) {
                    folderPath = folderPath.split("Public/")[1];
                    return node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
                }
            }
            return node.getNode(URLDecoder.decode(folderPath, StandardCharsets.UTF_8).replace("%", "%25"));
        }
        catch (RepositoryException repositoryException) {
            throw new ObjectNotFoundException("Folder with path : " + folderPath + " isn't found");
        }
    }

    public void updatePermissions(String documentID, NodePermission nodePermissionEntity, Identity aclIdentity) {
        try (SessionProvider sessionProvider = null;){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            HashMap<Object, String[]> permissions = new HashMap<Object, String[]>();
            List permissionsList = nodePermissionEntity.getPermissions();
            if (node.hasProperty("exo:owner")) {
                String owner = node.getProperty("exo:owner").getString();
                permissions.put(owner, PermissionType.ALL);
            }
            permissions.put(GROUP_ADMINISTRATORS, PermissionType.ALL);
            for (PermissionEntry permission : permissionsList) {
                if (permission.getIdentity().getProviderId().equals(SPACE_PROVIDER_ID)) {
                    Space space = this.spaceService.getSpaceByPrettyName(permission.getIdentity().getRemoteId());
                    String groupId = space.getGroupId();
                    if (permission.getPermission().equals("edit")) {
                        if (permission.getRole().equals(PermissionRole.ALL.name())) {
                            permissions.put("*:" + groupId, PermissionType.ALL);
                        }
                        if (permission.getRole().equals(PermissionRole.MANAGERS_REDACTORS.name())) {
                            permissions.put("manager:" + groupId, PermissionType.ALL);
                            permissions.put("redactor:" + groupId, PermissionType.ALL);
                        }
                    }
                    if (!permission.getPermission().equals("read")) continue;
                    if (permission.getRole().equals(PermissionRole.ALL.name())) {
                        permissions.put("*:" + groupId, new String[]{"read"});
                    }
                    if (!permission.getRole().equals(PermissionRole.MANAGERS_REDACTORS.name())) continue;
                    permissions.put("manager:" + groupId, new String[]{"read"});
                    permissions.put("redactor:" + groupId, new String[]{"read"});
                    continue;
                }
                if (permission.getPermission().equals("edit")) {
                    permissions.put(permission.getIdentity().getRemoteId(), PermissionType.ALL);
                }
                if (!permission.getPermission().equals("read")) continue;
                permissions.put(permission.getIdentity().getRemoteId(), new String[]{"read"});
            }
            if (node.canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)node).setPermissions(permissions);
            if (node.isNodeType("exo:modify")) {
                node.setProperty("exo:dateModified", Calendar.getInstance());
                node.setProperty("exo:lastModifiedDate", Calendar.getInstance());
            }
            session.save();
        }
    }

    public void shareDocument(String documentId, long destId) {
        Node rootNode = null;
        Node shared = null;
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node currentNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, documentId);
            org.exoplatform.social.core.identity.model.Identity destIdentity = this.identityManager.getIdentity(String.valueOf(destId));
            rootNode = JCRDocumentsUtil.getIdentityRootNode(this.spaceService, this.nodeHierarchyCreator, destIdentity, systemSession);
            if (!destIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                rootNode = rootNode.getNode("Documents");
            }
            shared = !rootNode.hasNode(SHARED_FOLDER_NAME) ? rootNode.addNode(SHARED_FOLDER_NAME) : rootNode.getNode(SHARED_FOLDER_NAME);
            if (currentNode.isNodeType("exo:symlink")) {
                String sourceNodeId = currentNode.getProperty("exo:uuid").getString();
                currentNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, sourceNodeId);
            }
            Node linkNode = null;
            linkNode = shared.hasNode(currentNode.getName()) ? shared.getNode(currentNode.getName()) : shared.addNode(currentNode.getName(), "exo:symlink");
            linkNode.setProperty("exo:workspace", repository.getConfiguration().getDefaultWorkspaceName());
            linkNode.setProperty("exo:primaryType", currentNode.getPrimaryNodeType().getName());
            linkNode.setProperty("exo:uuid", ((ExtendedNode)currentNode).getIdentifier());
            if (linkNode.canAddMixin("exo:sortable")) {
                linkNode.addMixin("exo:sortable");
            }
            if (currentNode.hasProperty("exo:title")) {
                linkNode.setProperty("exo:title", currentNode.getProperty("exo:title").getString());
            }
            linkNode.setProperty("exo:name", currentNode.getName());
            String nodeMimeType = JCRDocumentsUtil.getMimeType(currentNode);
            linkNode.addMixin("mix:fileType");
            linkNode.setProperty("exo:fileType", nodeMimeType);
            rootNode.save();
            HashMap<String, String[]> permissions = new HashMap<String, String[]>();
            if (destIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                Space space = this.spaceService.getSpaceByPrettyName(destIdentity.getRemoteId());
                String groupId = space.getGroupId();
                List acc = ((ExtendedNode)currentNode).getACL().getPermissionEntries();
                ArrayList accessControlEntryPermession = new ArrayList();
                acc.stream().filter(accessControlEntry -> accessControlEntry.getIdentity().equals("*:" + groupId)).toList().forEach(accessControlEntry -> {
                    accessControlEntryPermession.add(accessControlEntry.getPermission());
                    permissions.put(accessControlEntry.getIdentity(), accessControlEntryPermession.toArray(new String[accessControlEntryPermession.size()]));
                });
            } else {
                permissions.put(destIdentity.getRemoteId(), PermissionType.ALL);
            }
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)linkNode).setPermissions(permissions);
            systemSession.save();
            Utils.broadcast(this.listenerService, "share_document_event", destIdentity, linkNode);
        }
    }

    public void notifyMember(String documentId, long destId) {
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session systemSession = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            org.exoplatform.social.core.identity.model.Identity destIdentity = this.identityManager.getIdentity(String.valueOf(destId));
            Node currentNode = JCRDocumentsUtil.getNodeByIdentifier(systemSession, documentId);
            Utils.broadcast(this.listenerService, "share_document_event", destIdentity, currentNode);
        }
    }

    public boolean canAccess(String documentID, Identity aclIdentity) throws RepositoryException {
        boolean canAccess = false;
        try (SessionProvider sessionProvider = null;){
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            Node node = JCRDocumentsUtil.getNodeByIdentifier(session, documentID);
            if (node == null) {
                boolean bl = false;
                return bl;
            }
            String userId = aclIdentity.getUserId();
            ExtendedNode extendedNode = (ExtendedNode)node;
            List permsList = extendedNode.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                String nodeAclIdentity = accessControlEntry.getIdentity();
                MembershipEntry membershipEntry = accessControlEntry.getMembershipEntry();
                if (!StringUtils.equals((CharSequence)nodeAclIdentity, (CharSequence)userId) && !StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)userId) && (membershipEntry == null || !aclIdentity.isMemberOf(membershipEntry) || StringUtils.equals((CharSequence)membershipEntry.toString(), (CharSequence)GROUP_ADMINISTRATORS))) continue;
                canAccess = true;
            }
            boolean bl = canAccess;
            return bl;
        }
    }

    public void updateDocumentDescription(long ownerId, String documentId, String description, Identity aclIdentity) throws RepositoryException {
        String username = aclIdentity.getUserId();
        try (SessionProvider sessionProvider = null;){
            Node node = null;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, aclIdentity);
            Session session = sessionProvider.getSession(COLLABORATION, manageableRepository);
            node = JCRDocumentsUtil.getNodeByIdentifier(session, documentId);
            if (node.canAddMixin("exo:modify")) {
                node.addMixin("exo:modify");
            }
            Calendar now = Calendar.getInstance();
            node.setProperty("exo:dateModified", now);
            node.setProperty("exo:lastModifiedDate", now);
            node.setProperty("exo:lastModifier", username);
            if (node.canAddMixin("dc:elementSet") && !node.hasProperty("dc:description")) {
                node.addMixin("dc:elementSet");
            }
            try {
                node.setProperty("dc:description", description);
            }
            catch (ValueFormatException e) {
                node.setProperty("dc:description", new String[]{description});
            }
            if (node.hasNode("jcr:content")) {
                Node content = node.getNode("jcr:content");
                try {
                    content.setProperty("dc:description", description);
                }
                catch (ValueFormatException e) {
                    content.setProperty("dc:description", new String[]{description});
                }
            }
            node.getSession().save();
            TagService tagService = (TagService)CommonsUtils.getService(TagService.class);
            Set tagNames = tagService.detectTagNames(description);
            if (!tagNames.isEmpty()) {
                org.exoplatform.social.core.identity.model.Identity audienceIdentity = JCRDocumentsUtil.getOwnerIdentityFromNodePath(node.getPath(), this.identityManager, this.spaceService);
                long spaceId = 0L;
                if (audienceIdentity.getProviderId().equals(SPACE_PROVIDER_ID)) {
                    Space space = this.spaceService.getSpaceByPrettyName(audienceIdentity.getRemoteId());
                    spaceId = Long.parseLong(space.getId());
                }
                tagService.saveTags(new TagObject("file", ((ExtendedNode)node).getIdentifier(), null, spaceId), tagNames, Long.parseLong(audienceIdentity.getId()), Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId()));
                this.listenerService.broadcast(ADD_TAG_DOCUMENT, (Object)new TagObject("Document", ((ExtendedNode)node).getIdentifier(), null, spaceId), (Object)tagNames);
            }
        }
    }

    public void createShortcut(String documentId, String destPath, String aclIdentity, String conflictAction) throws IllegalAccessException, ObjectAlreadyExistsException {
        Identity identity = this.identityRegistry.getIdentity(aclIdentity);
        try (SessionProvider sessionProvider = null;){
            sessionProvider = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity);
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(COLLABORATION, repository);
            Node currentNode = JCRDocumentsUtil.getNodeByIdentifier(session, documentId);
            Node rootNode = (Node)session.getItem(destPath);
            if (currentNode != null && currentNode.isNodeType("exo:symlink")) {
                String sourceNodeId = currentNode.getProperty("exo:uuid").getString();
                currentNode = JCRDocumentsUtil.getNodeByIdentifier(session, sourceNodeId);
            }
            Node linkNode = currentNode != null && rootNode.hasNode(currentNode.getName()) ? this.handleShortcutDocConflict(rootNode, currentNode, conflictAction) : rootNode.addNode(currentNode.getName(), "exo:symlink");
            linkNode.setProperty("exo:workspace", COLLABORATION);
            linkNode.setProperty("exo:primaryType", currentNode.getPrimaryNodeType().getName());
            linkNode.setProperty("exo:uuid", ((ExtendedNode)currentNode).getIdentifier());
            if (linkNode.canAddMixin("exo:sortable")) {
                linkNode.addMixin("exo:sortable");
            }
            if (currentNode.hasProperty("exo:title") && StringUtils.isBlank((CharSequence)conflictAction)) {
                linkNode.setProperty("exo:title", currentNode.getProperty("exo:title").getString());
            }
            linkNode.setProperty("exo:name", currentNode.getName());
            String nodeMimeType = JCRDocumentsUtil.getMimeType(currentNode);
            linkNode.addMixin("mix:fileType");
            linkNode.setProperty("exo:fileType", nodeMimeType);
            rootNode.save();
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
            }
            HashMap<String, String[]> perMap = new HashMap<String, String[]>();
            ArrayList<String> idList = new ArrayList<String>();
            for (AccessControlEntry accessEntry : ((ExtendedNode)currentNode).getACL().getPermissionEntries()) {
                if (idList.contains(accessEntry.getIdentity())) continue;
                idList.add(accessEntry.getIdentity());
                List permsList = ((ExtendedNode)currentNode).getACL().getPermissions(accessEntry.getIdentity());
                perMap.put(accessEntry.getIdentity(), permsList.toArray(new String[0]));
            }
            ((ExtendedNode)linkNode).setPermissions(perMap);
            session.save();
        }
    }

    private Node handleShortcutDocConflict(Node rootNode, Node currentNode, String conflictAction) throws ObjectAlreadyExistsException, RepositoryException {
        String originName;
        Node linkNode = null;
        boolean created = false;
        int count = 0;
        String name = originName = currentNode.getName();
        boolean doIndexName = rootNode.hasNode(originName);
        if (Objects.equals(conflictAction, KEEP_BOTH)) {
            String path;
            String index;
            do {
                try {
                    linkNode = rootNode.addNode(name, "exo:symlink");
                    created = true;
                }
                catch (ItemExistsException e) {
                    name = JCRDocumentsUtil.increaseNameIndex(originName, ++count);
                    doIndexName = false;
                }
            } while (!created);
            if (doIndexName && StringUtils.isNotBlank((CharSequence)(index = (path = linkNode.getPath()).substring(StringUtils.lastIndexOf((CharSequence)path, (CharSequence)name) + name.length())))) {
                count = Integer.parseInt(index.substring(1, index.lastIndexOf("]"))) - 1;
            }
            if (linkNode.hasProperty("exo:title")) {
                String exoTitle = JCRDocumentsUtil.getNewIndexedName(currentNode.getProperty("exo:title").getString(), "(" + count + ")");
                linkNode.setProperty("exo:title", exoTitle);
            }
        } else {
            throw new ObjectAlreadyExistsException((Object)"Document with same name already exists");
        }
        return linkNode;
    }

    public List<FileVersion> getFileVersions(String fileNodeId, String aclIdentity) {
        ArrayList<FileVersion> fileVersions = new ArrayList<FileVersion>();
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(aclIdentity));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Node node = session.getNodeByUUID(fileNodeId);
            Version rootVersion = node.getVersionHistory().getRootVersion();
            VersionIterator versionIterator = node.getVersionHistory().getAllVersions();
            while (versionIterator.hasNext()) {
                Version version = versionIterator.nextVersion();
                if (version.getUUID().equals(rootVersion.getUUID())) continue;
                fileVersions.add(JCRDocumentsUtil.toFileVersion(version, node, this.identityManager));
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while getting file versions", e);
        }
        fileVersions.sort(Collections.reverseOrder());
        return fileVersions;
    }

    private static String addVersionLabel(Node node, String label, Version version) throws RepositoryException {
        String[] olLabels;
        for (String oldLabel : olLabels = node.getVersionHistory().getVersionLabels(version)) {
            if (label.equals(oldLabel)) continue;
            node.getVersionHistory().removeVersionLabel(oldLabel);
        }
        node.getVersionHistory().addVersionLabel(version.getName(), label, false);
        return label;
    }

    public FileVersion updateVersionSummary(String originFileId, String versionId, String summary, String aclIdentity) {
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(aclIdentity));
        FileVersion versionFileNode = new FileVersion();
        try {
            ExoSocialActivity activity;
            String commentId;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Node node = session.getNodeByUUID(originFileId);
            Version version = (Version)session.getNodeByUUID(versionId);
            versionFileNode.setId(versionId);
            Node frozen = version.getNode("jcr:frozenNode");
            if (frozen.hasProperty(EOO_COMMENT_ID) && StringUtils.isNotBlank((CharSequence)(commentId = frozen.getProperty(EOO_COMMENT_ID).getString())) && (activity = this.activityManager.getActivity(commentId)) != null) {
                activity.setTitle(summary);
                this.activityManager.updateActivity(activity);
            }
            JCRDocumentFileStorage.addVersionLabel(node, summary, version);
            versionFileNode.setSummary(summary);
            session.save();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while adding or updating version summary", e);
        }
        return versionFileNode;
    }

    public FileVersion restoreVersion(String versionId, String aclIdentity) {
        Identity identity = this.identityRegistry.getIdentity(String.valueOf(aclIdentity));
        FileVersion versionFileNode = new FileVersion();
        try {
            String frozenUuid;
            Node node;
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = JCRDocumentsUtil.getUserSessionProvider(this.repositoryService, identity).getSession(COLLABORATION, manageableRepository);
            Version version = (Version)session.getNodeByUUID(versionId);
            Node frozen = version.getNode("jcr:frozenNode");
            if (frozen != null && (node = session.getNodeByUUID(frozenUuid = Utils.getStringProperty(frozen, "jcr:frozenUuid"))) != null) {
                node.restore(version, true);
                if (!node.isCheckedOut()) {
                    node.checkout();
                }
                Version newVersion = node.checkin();
                versionFileNode = JCRDocumentsUtil.toFileVersion(newVersion, node, this.identityManager);
                node.checkout();
                if (node.isNodeType("exo:modify")) {
                    node.setProperty("exo:dateModified", Calendar.getInstance());
                    node.setProperty("exo:lastModifiedDate", Calendar.getInstance());
                }
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while restoring version", e);
        }
        return versionFileNode;
    }
}

