/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.search;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.storage.jcr.search.DocumentFileSearchResult;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DocumentSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(DocumentSearchServiceConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    public static final String SEARCH_QUERY_TERM = "\"must\":{    \"query_string\":{    \"fields\": [\"title\"],    \"query\": \"*@term@*\"  }},";
    public static final String EXTENDED_SEARCH_QUERY_TERM = "\"must\":{    \"query_string\":{    \"fields\": [\"title\",\"attachment.content\",\"dc:description\"],    \"query\": \"*@term@*\"  }},";
    public static final String QUERY_TAG_TERM = "@term@";
    private final ConfigurationManager configurationManager;
    private final IdentityManager identityManager;
    private final ElasticSearchingClient client;
    private final String index;
    private String searchQueryFilePath;
    private String searchQuery;

    public DocumentSearchServiceConnector(ConfigurationManager configurationManager, IdentityManager identityManager, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.identityManager = identityManager;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public Collection<SearchResult> search(Identity userIdentity, String workspace, String path, DocumentNodeFilter filter, int offset, int limit, String sortField, String sortDirection) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("Viewer identity is mandatory");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (StringUtils.isBlank((String)filter.getQuery()) && !filter.getFavorites().booleanValue()) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        switch (sortField) {
            case "lastUpdatedDate": {
                sortField = "lastUpdatedDate";
                break;
            }
            case "title": {
                sortField = "title.raw";
                break;
            }
            default: {
                sortField = "_score";
            }
        }
        String esQuery = this.buildQueryStatement(userIdentity, workspace, path, filter, sortField, sortDirection, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse);
    }

    private String buildQueryStatement(Identity userIdentity, String workspace, String path, DocumentNodeFilter filter, String sortField, String sortDirection, int offset, int limit) {
        Map<String, List<String>> metadataFilters = this.buildMetadatasFilter(filter, this.identityManager.getOrCreateIdentity("organization", userIdentity.getUserId()));
        String termQuery = this.buildTermQueryStatement(filter.getQuery(), filter.isExtendedSearch());
        String favoriteQuery = this.buildFavoriteQueryStatement(metadataFilters.get(FavoriteService.METADATA_TYPE.getName()));
        if (StringUtils.isNotEmpty((String)path) && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return this.retrieveSearchQuery().replace("@term_query@", termQuery).replace("@favorite_query@", favoriteQuery).replace("@permissions@", this.getPermissionFilter(userIdentity)).replace("@path@", (CharSequence)path).replace("@workspace@", workspace).replace("@sort_field@", sortField).replace("@sort_direction@", sortDirection).replace("@offset@", String.valueOf(offset)).replace("@limit@", String.valueOf(limit));
    }

    private String getPermissionFilter(Identity userIdentity) {
        StringBuilder permissionSB = new StringBuilder();
        Set<String> membershipSet = this.getUserMemberships(userIdentity);
        if (!membershipSet.isEmpty()) {
            String memberships = StringUtils.join((Object[])membershipSet.toArray(new String[membershipSet.size()]), (String)"|");
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(userIdentity.getUserId()).append("\" }\n").append("},\n").append("{\n").append("  \"term\" : { \"permissions\" : \"").append(IdentityConstants.ANY).append("\" }\n").append("},\n").append("{\n").append("  \"regexp\" : { \"permissions\" : \"").append(memberships).append("\" }\n").append("}");
        } else {
            permissionSB.append("{\n").append("  \"term\" : { \"permissions\" : \"").append(userIdentity.getUserId()).append("\" }\n").append("},\n").append("{\n").append("  \"term\" : { \"permissions\" : \"").append(IdentityConstants.ANY).append("\" }\n").append("}");
        }
        return permissionSB.toString();
    }

    private Set<String> getUserMemberships(Identity userIdentity) {
        if (userIdentity == null) {
            throw new IllegalStateException("No Identity found: ConversationState.getCurrent().getIdentity() is null");
        }
        if (userIdentity.getMemberships() == null) {
            throw new IllegalStateException("No Membership found: ConversationState.getCurrent().getIdentity().getMemberships() is null");
        }
        HashSet<String> entries = new HashSet<String>();
        for (MembershipEntry entry : userIdentity.getMemberships()) {
            if (entry.getMembershipType().equals("*")) {
                entries.add(entry.toString().replace("*", ".*"));
                continue;
            }
            entries.add(entry.toString());
            entries.add("*:" + entry.getGroup());
        }
        return entries;
    }

    protected Collection<SearchResult> buildResult(String jsonResponse) {
        JSONArray jsonHits;
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult != null && (jsonHits = (JSONArray)jsonResult.get((Object)"hits")) != null) {
            for (Object jsonHit : jsonHits) {
                results.add(this.buildHit((JSONObject)jsonHit));
            }
        }
        return results;
    }

    protected SearchResult buildHit(JSONObject jsonHit) {
        JSONObject hitSource = (JSONObject)jsonHit.get((Object)"_source");
        String title = this.getTitleFromJsonResult(hitSource);
        String url = this.getUrlFromJsonResult(hitSource);
        Long lastUpdatedDate = this.getUpdatedDateFromResult(hitSource);
        if (lastUpdatedDate == null) {
            lastUpdatedDate = new Date().getTime();
        }
        Double score = (Double)jsonHit.get((Object)"_score");
        JSONObject hitHighlight = (JSONObject)jsonHit.get((Object)"highlight");
        HashMap excerpts = new HashMap();
        StringBuilder excerpt = new StringBuilder();
        if (hitHighlight != null) {
            for (String key : hitHighlight.keySet()) {
                JSONArray highlights = (JSONArray)hitHighlight.get((Object)key);
                List excerptsList = highlights.stream().map(Object::toString).collect(Collectors.toList());
                excerpts.put(key, excerptsList);
                excerpt.append("... ").append(StringUtils.join(excerptsList, (String)"..."));
            }
        }
        LOG.debug("Excerpt extract from ES response : {}", new Object[]{excerpt.toString()});
        SearchResult searchResult = new SearchResult(url, title, excerpts, excerpt.toString(), null, null, lastUpdatedDate, score.longValue());
        String id = (String)jsonHit.get((Object)"_id");
        String workspace = (String)hitSource.get((Object)"workspace");
        String nodePath = (String)hitSource.get((Object)"path");
        return new DocumentFileSearchResult(searchResult, id, workspace, nodePath);
    }

    protected Long getUpdatedDateFromResult(JSONObject hitSource) {
        Object date = hitSource.get((Object)"lastUpdatedDate");
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date != null) {
            try {
                return Long.parseLong(date.toString());
            }
            catch (Exception ex) {
                LOG.error("Can not parse updatedDate field as Long {}", new Object[]{date});
            }
        }
        return null;
    }

    protected String getUrlFromJsonResult(JSONObject hitSource) {
        return (String)hitSource.get((Object)"url");
    }

    protected String getTitleFromJsonResult(JSONObject hitSource) {
        return (String)hitSource.get((Object)"title");
    }

    protected String escapeReservedCharacters(String query) {
        return StringUtils.isNotEmpty((String)query) ? query.replaceAll("[" + Pattern.quote("+-=&|><!(){}\\[\\]^\"*?:\\/") + "]", Matcher.quoteReplacement("\\\\") + "$0") : query;
    }

    private String buildTermQueryStatement(String term, boolean extendedSearch) {
        boolean isEscapedQueryWithAndOperator;
        if (StringUtils.isBlank((String)term)) {
            return "";
        }
        if (term.startsWith("#")) {
            term = term.substring(1);
        }
        String originalTerm = term;
        term = this.escapeReservedCharacters(term);
        String escapedQueryWithAndOperator = this.buildEscapedQueryWithAndOperator(term);
        boolean isEscapedReservedCharactersTerm = !originalTerm.equals(term);
        boolean bl = isEscapedQueryWithAndOperator = !escapedQueryWithAndOperator.equals(term);
        if (!extendedSearch) {
            return isEscapedReservedCharactersTerm && !isEscapedQueryWithAndOperator ? SEARCH_QUERY_TERM.replace("*", "\\\\*").replace(QUERY_TAG_TERM, term) : SEARCH_QUERY_TERM.replace(QUERY_TAG_TERM, escapedQueryWithAndOperator);
        }
        return isEscapedReservedCharactersTerm && !isEscapedQueryWithAndOperator ? EXTENDED_SEARCH_QUERY_TERM.replace("*", "\\\\*").replace(QUERY_TAG_TERM, term) : EXTENDED_SEARCH_QUERY_TERM.replace(QUERY_TAG_TERM, escapedQueryWithAndOperator);
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((String)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }

    private String buildFavoriteQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        return "{\"terms\":{" + "\"metadatas.favorites.metadataName.keyword\": [\"" + StringUtils.join(values, (String)"\",\"") + "\"]}},";
    }

    private Map<String, List<String>> buildMetadatasFilter(DocumentNodeFilter filter, org.exoplatform.social.core.identity.model.Identity userIdentity) {
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (filter.getFavorites().booleanValue()) {
            metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(userIdentity.getId()));
        }
        return metadataFilters;
    }

    protected String buildEscapedQueryWithAndOperator(String term) {
        List<String> queryParts = Arrays.asList(term.split(" "));
        if (queryParts.size() > 1) {
            StringBuilder escapedQueryWithAndOperator = new StringBuilder();
            String pattern = "[-+=&|><!(){}\\[\\]^\"*?:\\\\/]";
            Pattern regex = Pattern.compile(pattern);
            int i = 0;
            for (int j = 1; i < queryParts.size() && j < queryParts.size(); ++i, ++j) {
                Matcher matcher = regex.matcher(queryParts.get(i));
                Matcher nextMatcher = regex.matcher(queryParts.get(j));
                escapedQueryWithAndOperator.append(queryParts.get(i));
                if (matcher.find()) {
                    escapedQueryWithAndOperator.append("\\\\* AND ");
                } else {
                    escapedQueryWithAndOperator.append("* AND ");
                }
                if (nextMatcher.find()) {
                    escapedQueryWithAndOperator.append("\\\\*");
                } else {
                    escapedQueryWithAndOperator.append("*");
                }
                if (j != queryParts.size() - 1) continue;
                escapedQueryWithAndOperator.append(queryParts.get(j));
                if (!nextMatcher.find()) continue;
                escapedQueryWithAndOperator.append("\\\\");
            }
            return escapedQueryWithAndOperator.toString();
        }
        return term;
    }
}

