/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.documents.storage.TrashStorage;
import org.exoplatform.documents.storage.jcr.JCRDeleteFileStorageImpl;
import org.exoplatform.documents.storage.jcr.bulkactions.BulkStorageActionService;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class JCRDeleteFileStorageTest {
    private static final MockedStatic<JCRDocumentsUtil> JCR_DOCUMENTS_UTIL = Mockito.mockStatic(JCRDocumentsUtil.class);
    @Mock
    private IdentityManager identityManager;
    @Mock
    private TrashStorage trashStorage;
    @Mock
    private FavoriteService favoriteService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private PortalContainer portalContainer;
    @Mock
    private ManageableRepository repository;
    @Mock
    private RepositoryEntry repositoryEntry;
    @Mock
    private SessionProvider sessionProvider;
    @Mock
    private Session session;
    @Mock
    private ListenerService listenerService;
    @Mock
    private BulkStorageActionService bulkStorageActionService;
    private JCRDeleteFileStorageImpl jcrDeleteFileStorage;

    @AfterClass
    public static void afterRunBare() throws Exception {
        JCR_DOCUMENTS_UTIL.close();
    }

    @Test
    public void testUndoDeleteDocument() {
        String username = "testuser";
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        this.jcrDeleteFileStorage = new JCRDeleteFileStorageImpl(this.repositoryService, this.identityManager, this.trashStorage, this.favoriteService, this.portalContainer, this.sessionProviderService, this.listenerService, this.bulkStorageActionService);
        JCRDeleteFileStorageImpl.documentsToDeleteQueue.put("1", String.valueOf(2));
        this.jcrDeleteFileStorage.undoDelete("1", 3L);
        Assert.assertEquals((long)1L, (long)JCRDeleteFileStorageImpl.documentsToDeleteQueue.size());
        this.jcrDeleteFileStorage.undoDelete("1", currentOwnerId);
        Assert.assertEquals((long)0L, (long)JCRDeleteFileStorageImpl.documentsToDeleteQueue.size());
    }

    @Test
    public void testDeleteDocument() throws Exception {
        String username = "testuser";
        String currentRepository = "collaboration";
        String trashId = "123456789";
        String path = "/document/file1";
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        this.jcrDeleteFileStorage = new JCRDeleteFileStorageImpl(this.repositoryService, this.identityManager, this.trashStorage, this.favoriteService, this.portalContainer, this.sessionProviderService, this.listenerService, this.bulkStorageActionService);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(Mockito.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(Mockito.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)currentRepository);
        ExtendedSession session1 = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)userID)).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProvider.getSession((String)Mockito.any(), (ManageableRepository)Mockito.any())).thenReturn((Object)session1);
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByPath((Session)session1, (String)path)).thenReturn((Object)node);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)node.getIdentifier()).thenReturn((Object)"id123");
        Mockito.when((Object)node.getName()).thenReturn((Object)"name123");
        Mockito.when((Object)node.getPath()).thenReturn((Object)path);
        Mockito.when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        Mockito.when((Object)this.session.itemExists(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.session.getItem(Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)node.isNodeType("exo:restoreLocation")).thenReturn((Object)true);
        try {
            this.jcrDeleteFileStorage.deleteDocument(path, "1", false, true, 0L, userID, currentOwnerId);
        }
        catch (Exception e) {
            Assert.fail((String)("Error when deleting the document" + path));
        }
        this.jcrDeleteFileStorage.deleteDocument(path, "1", true, true, 0L, userID, currentOwnerId);
        Mockito.when((Object)node.isCheckedOut()).thenReturn((Object)true);
        Mockito.when((Object)this.trashStorage.moveToTrash((Node)node, this.sessionProvider)).thenReturn((Object)trashId);
        Mockito.when((Object)this.trashStorage.getNodeByTrashId(trashId)).thenReturn((Object)node);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)node.getPrimaryNodeType()).thenReturn((Object)nodeType);
        this.jcrDeleteFileStorage.deleteDocument(path, "1", false, true, 0L, userID, currentOwnerId);
        ((ExtendedNode)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).checkPermission(Mockito.anyString());
        Mockito.when((Object)this.trashStorage.isInTrash((Node)node)).thenReturn((Object)true);
        Mockito.when((Object)node.getParent()).thenReturn((Object)node);
        this.jcrDeleteFileStorage.deleteDocument("/document/file1", "1", false, true, 0L, userID, currentOwnerId);
        ((NodeImpl)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).remove();
        ((NodeImpl)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)2))).removeMixin("exo:restoreLocation");
    }
}

