/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.bulkactions;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.ActionData;
import org.exoplatform.documents.model.ActionStatus;
import org.exoplatform.documents.model.ActionType;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.documents.storage.jcr.bulkactions.ActionThread;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.upload.UploadService;
import org.picocontainer.Startable;

public class BulkStorageActionService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)BulkStorageActionService.class.getName());
    private ExecutorService bulkActionThreadPool;
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private static final String ZIP_PREFIX = "downloadzip";
    public static final String TEMP_DOWNLOAD_FOLDER_PREFIX = "temp_download";
    public static final String TEMP_IMPORT_FOLDER_PREFIX = "temp_import";
    private long DEFAULT_ZIP_UPLOAD_LIMIT = 3000L;
    private static final List<ActionData> actionList = new ArrayList<ActionData>();

    public void executeBulkAction(Session session, DocumentFileStorage documentFileStorage, JCRDeleteFileStorage jcrDeleteFileStorage, ListenerService listenerService, UploadService uploadService, List<AbstractNode> items, ActionData actionData, Node parent, Map<String, Object> params, long authenticatedUserId) {
        actionData.setStatus(ActionStatus.STARTED.name());
        actionList.add(actionData);
        this.checkTotalUplaodsLimit(actionData.getIdentity(), true);
        this.bulkActionThreadPool.execute(new ActionThread(documentFileStorage, jcrDeleteFileStorage, this, listenerService, uploadService, actionData, parent, params, session, items, authenticatedUserId));
    }

    public void start() {
        this.bulkActionThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("documents-bulk-action-%d").build());
    }

    public void stop() {
        File temp;
        if (this.bulkActionThreadPool != null) {
            this.bulkActionThreadPool.shutdownNow();
        }
        if (this.cleanTempFiles(temp = new File(System.getProperty(TEMP_DIRECTORY_PATH)))) {
            LOG.info((Object)"All temp files were deleted");
        }
    }

    private boolean cleanTempFiles(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                this.cleanTempFiles(f);
            }
        }
        if (file.getName().startsWith(TEMP_DOWNLOAD_FOLDER_PREFIX) || file.getName().startsWith(TEMP_IMPORT_FOLDER_PREFIX) || file.getName().startsWith(ZIP_PREFIX)) {
            JCRDocumentsUtil.cleanFiles(file);
        }
        return true;
    }

    public ActionData getActionDataById(String id) {
        return actionList.stream().filter(resource -> id.equals(resource.getActionId())).findFirst().orElse(null);
    }

    public void removeActionData(ActionData actionData) {
        actionList.remove(actionData);
        this.checkTotalUplaodsLimit(actionData.getIdentity(), true);
    }

    public boolean checkTotalUplaodsLimit(Identity identity, boolean broadcast) {
        boolean canImport = true;
        ActionData actionData = new ActionData();
        actionData.setIdentity(identity);
        actionData.setActionType(ActionType.IMPORT_ZIP.name());
        if (actionList.isEmpty()) {
            actionData.setStatus(ActionStatus.IMPORT_LIMIT_NOT_EXCEEDED.name());
        } else {
            long totalUploadsLimit;
            try {
                totalUploadsLimit = Long.parseLong(System.getProperty("exo.import.zip.uploads.limit", String.valueOf(this.DEFAULT_ZIP_UPLOAD_LIMIT)));
            }
            catch (Exception e) {
                totalUploadsLimit = this.DEFAULT_ZIP_UPLOAD_LIMIT;
            }
            double total = actionList.stream().mapToDouble(ActionData::getSize).sum();
            if (total > (double)(totalUploadsLimit * 1024L * 1024L)) {
                actionData.setStatus(ActionStatus.IMPORT_LIMIT_EXCEEDED.name());
                canImport = false;
            } else {
                actionData.setStatus(ActionStatus.IMPORT_LIMIT_NOT_EXCEEDED.name());
            }
        }
        if (broadcast) {
            try {
                ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
                listenerService.broadcast("bulk_actions_document_event", (Object)actionData.getIdentity(), (Object)actionData);
            }
            catch (Exception e) {
                LOG.error((Object)"cannot broadcast bulk action event");
            }
        }
        return canImport;
    }
}

