/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.cache;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.exoplatform.documents.storage.jcr.webdav.cache.CachedJcrWebDavService;
import org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.entity.WebDavItemEntity;
import org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.entity.WebDavItemPropertyEntity;
import org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.repository.WebDavItemRepository;
import org.exoplatform.documents.storage.jcr.webdav.cache.listener.WebDavCacheUpdaterAction;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavReadCommandHandler;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavWriteCommandHandler;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.config.ContainerEntry;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.RepositoryServiceImpl;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class CachedJcrWebDavServiceTest {
    private static final String FILE_PATH = "/test";
    private static final String WS_NAME = "test";
    private static final String REPOSITORY_NAME = "repository";
    @Mock
    private WebdavReadCommandHandler readCommandHandler;
    @Mock
    private WebdavWriteCommandHandler writeCommandHandler;
    @Mock
    private RepositoryServiceImpl repositoryService;
    @Mock
    private UserACL userAcl;
    @Mock
    private WebDavItemRepository webDavItemRepository;
    @Mock
    private ManageableRepository repository;
    @Mock
    private RepositoryEntry repositoryEntry;
    @Mock
    private WorkspaceEntry workspaceEntry;
    @Mock
    private Session session;
    @Mock
    private Workspace workspace;
    @Mock
    private NamespaceRegistry nsRegistry;
    @Mock
    private ObservationManager observationManager;
    @Mock
    private RepositoryContainer repositoryContainer;
    @Mock
    private WorkspaceContainer workspaceContainer;
    @Mock
    private ContainerEntry containerEntry;
    @InjectMocks
    private CachedJcrWebDavService service;

    @Before
    public void setup() {
        Mockito.when((Object)this.repositoryService.getDefaultRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)WS_NAME);
        Mockito.when((Object)this.repository.getSystemSession(WS_NAME)).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)this.workspace);
        Mockito.when((Object)this.workspace.getObservationManager()).thenReturn((Object)this.observationManager);
        Mockito.when((Object)this.repositoryService.getRepositoryContainer(REPOSITORY_NAME)).thenReturn((Object)this.repositoryContainer);
        Mockito.when((Object)this.repositoryContainer.getWorkspaceContainer(WS_NAME)).thenReturn((Object)this.workspaceContainer);
        Mockito.when((Object)this.repository.getSystemSession(ArgumentMatchers.anyString())).thenReturn((Object)this.session);
        Mockito.when((Object)this.repository.getNamespaceRegistry()).thenReturn((Object)this.nsRegistry);
        Mockito.when((Object)this.nsRegistry.getPrefixes()).thenReturn((Object)new String[]{"pfx"});
        Mockito.when((Object)this.nsRegistry.getURI("pfx")).thenReturn((Object)"uri");
        Mockito.when((Object)((WorkspaceEntry)this.workspaceContainer.getComponentInstanceOfType(WorkspaceEntry.class, false))).thenReturn((Object)this.workspaceEntry);
        Mockito.when((Object)this.workspaceEntry.getContainer()).thenReturn((Object)this.containerEntry);
        this.service = (CachedJcrWebDavService)Mockito.spy((Object)this.service);
        ((CachedJcrWebDavService)Mockito.doReturn((Object)this.session).when((Object)this.service)).newSession(ArgumentMatchers.anyString(), (ManageableRepository)ArgumentMatchers.any(), (WorkspaceContainer)ArgumentMatchers.any());
        Mockito.when((Object)this.webDavItemRepository.save((Object)((WebDavItemEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0, WebDavItemEntity.class));
    }

    @Test
    public void testInit() {
        this.service.init();
        ((WebDavItemRepository)Mockito.verify((Object)this.webDavItemRepository)).deleteAll();
        for (String path : WebDavCacheUpdaterAction.SUPPORTED_PATHS) {
            ((ObservationManager)Mockito.verify((Object)this.observationManager)).addEventListener((EventListener)ArgumentMatchers.any(WebDavCacheUpdaterAction.class), ArgumentMatchers.eq((int)WebDavCacheUpdaterAction.SUPPORTED_EVENT_TYPES), (String)ArgumentMatchers.eq((Object)path), ArgumentMatchers.eq((boolean)true), (String[])ArgumentMatchers.eq(null), (String[])ArgumentMatchers.eq((Object)((String[])WebDavCacheUpdaterAction.SUPPORTED_NODE_TYPES.toArray(String[]::new))), ArgumentMatchers.eq((boolean)false));
        }
    }

    @Test
    public void testIsFileWhenPathIsBlankShouldReturnFalse() {
        Assert.assertFalse((boolean)this.service.isFile(null));
        Assert.assertFalse((boolean)this.service.isFile(""));
        Assert.assertFalse((boolean)this.service.isFile("/"));
    }

    @Test
    public void testIsFileWhenEntityExistsShouldReturnEntityValue() {
        WebDavItemEntity entity = (WebDavItemEntity)Mockito.mock(WebDavItemEntity.class);
        Mockito.when((Object)entity.isFile()).thenReturn((Object)true);
        Mockito.when((Object)this.webDavItemRepository.findById((Object)FILE_PATH)).thenReturn(Optional.of(entity));
        boolean result = this.service.isFile(FILE_PATH);
        Assert.assertTrue((boolean)result);
        ((WebDavItemRepository)Mockito.verify((Object)this.webDavItemRepository)).findById((Object)FILE_PATH);
    }

    @Test
    public void testGetLastModifiedDateWhenEntityHasProperty() {
        WebDavItemPropertyEntity property = new WebDavItemPropertyEntity();
        property.setName(PropertyConstants.GETLASTMODIFIED.getNamespaceURI() + ":" + PropertyConstants.GETLASTMODIFIED.getLocalPart());
        property.setValue("Thu, 01 Jan 2025 00:00:00 GMT");
        WebDavItemEntity entity = new WebDavItemEntity();
        entity.setProperties(Collections.singletonList(property));
        Mockito.when((Object)this.webDavItemRepository.findById((Object)FILE_PATH)).thenReturn(Optional.of(entity));
        long result = this.service.getLastModifiedDate(FILE_PATH, "1");
        Assert.assertTrue((result > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testGetLastModifiedDateWhenPathIsRootShouldReturnZero() {
        long result = this.service.getLastModifiedDate("/", "1");
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testClearCacheWhenEntityExistsAndDropTrueShouldDelete() {
        WebDavItemEntity entity = new WebDavItemEntity();
        entity.setModified(false);
        Mockito.when((Object)this.webDavItemRepository.findByJcrPath(FILE_PATH)).thenReturn((Object)entity);
        this.service.clearCache(FILE_PATH, true);
        ((WebDavItemRepository)Mockito.verify((Object)this.webDavItemRepository)).delete((Object)entity);
    }

    @Test
    public void testClearCacheWhenEntityExistsAndDropFalseShouldMarkModified() {
        WebDavItemEntity entity = new WebDavItemEntity();
        entity.setModified(false);
        Mockito.when((Object)this.webDavItemRepository.findByJcrPath(FILE_PATH)).thenReturn((Object)entity);
        this.service.clearCache(FILE_PATH, false);
        Assert.assertTrue((boolean)entity.isModified());
        ((WebDavItemRepository)Mockito.verify((Object)this.webDavItemRepository)).save((Object)entity);
    }

    @Test
    public void testGetWhenCacheIsEmptyShouldCallSuper() {
        Mockito.when((Object)this.webDavItemRepository.findById((Object)FILE_PATH)).thenReturn(Optional.empty());
        WebDavItem expectedItem = new WebDavItem();
        expectedItem.setWebDavPath(FILE_PATH);
        Mockito.when((Object)this.readCommandHandler.get((Session)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)expectedItem);
        WebDavItem result = this.service.get(FILE_PATH, "all", Collections.emptySet(), false, 5, "", "user");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)FILE_PATH, (Object)result.getWebDavPath());
    }
}

