/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.cache.elasticsearch.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;

public class WebDavItemPropertyEntity {
    protected String name;
    protected String value;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected List<WebDavItemPropertyEntity> children = new ArrayList<WebDavItemPropertyEntity>();

    public WebDavItemPropertyEntity(WebDavItemProperty property) {
        this.name = String.format("%s:%s", property.getName().getNamespaceURI(), property.getName().getLocalPart());
        this.value = property.getValue();
        this.attributes = property.getAttributes();
        if (CollectionUtils.isNotEmpty((Collection)property.getChildren())) {
            this.children = property.getChildren().stream().map(WebDavItemPropertyEntity::new).toList();
        }
    }

    public WebDavItemProperty toWebDavItemProperty() {
        WebDavItemProperty webDavItemProperty = new WebDavItemProperty(this.name, this.value);
        webDavItemProperty.setAttributes(this.attributes);
        if (this.children != null) {
            webDavItemProperty.setChildren(this.children.stream().map(WebDavItemPropertyEntity::toWebDavItemProperty).toList());
        }
        return webDavItemProperty;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<WebDavItemPropertyEntity> getChildren() {
        return this.children;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setChildren(List<WebDavItemPropertyEntity> children) {
        this.children = children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebDavItemPropertyEntity)) {
            return false;
        }
        WebDavItemPropertyEntity other = (WebDavItemPropertyEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebDavItemPropertyEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WebDavItemPropertyEntity(name=" + this.getName() + ", value=" + this.getValue() + ", attributes=" + String.valueOf(this.getAttributes()) + ", children=" + String.valueOf(this.getChildren()) + ")";
    }

    @Generated
    public WebDavItemPropertyEntity() {
    }

    @Generated
    public WebDavItemPropertyEntity(String name, String value, Map<String, String> attributes, List<WebDavItemPropertyEntity> children) {
        this.name = name;
        this.value = value;
        this.attributes = attributes;
        this.children = children;
    }
}

