/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.listener;

import io.meeds.social.category.model.CategoryObject;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.documents.storage.jcr.listener.CategoryLinkModifiedDocumentListener;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={CategoryLinkModifiedDocumentListener.class})
class CategoryLinkModifiedDocumentListenerTest {
    @MockBean
    private DocumentFileService documentFileService;
    @MockBean
    private RepositoryService repositoryService;
    @MockBean
    private SessionProviderService sessionProviderService;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private Event<Long, CategoryObject> event;
    @Autowired
    private CategoryLinkModifiedDocumentListener listener;

    CategoryLinkModifiedDocumentListenerTest() {
    }

    @Test
    void onEvent() {
        try (MockedStatic mockedStatic = Mockito.mockStatic(JCRDocumentsUtil.class);){
            Node node = (Node)Mockito.mock(Node.class);
            mockedStatic.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)((Session)Mockito.any(Session.class)), (String)Mockito.anyString())).thenReturn((Object)node);
            CategoryObject object = (CategoryObject)Mockito.mock(CategoryObject.class);
            Mockito.when((Object)object.getType()).thenReturn((Object)"document");
            Mockito.when((Object)object.getId()).thenReturn((Object)"documentId");
            Mockito.when((Object)((CategoryObject)this.event.getData())).thenReturn((Object)object);
            ManageableRepository repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
            RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
            Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)repository);
            Mockito.when((Object)repository.getConfiguration()).thenReturn((Object)repositoryEntry);
            SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
            Session session = (Session)Mockito.mock(Session.class);
            Mockito.when((Object)sessionProvider.getSession(Mockito.anyString(), (ManageableRepository)Mockito.any(ManageableRepository.class))).thenReturn((Object)session);
            Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(null)).thenReturn((Object)sessionProvider);
            this.listener.onEvent(this.event);
            ((SessionProviderService)Mockito.verify((Object)this.sessionProviderService, (VerificationMode)Mockito.times((int)1))).getSystemSessionProvider(null);
        }
    }
}

