/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.search;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.storage.jcr.search.DocumentSearchServiceConnector;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DocumentSearchServiceConnectorTest {
    public static final String QUERY_TAG_TERM = "@term@";
    private static final String ES_INDEX = "file_alias";
    private static final String WORKSPACE = "collaboration";
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    public static String SEARCH_QUERY_TERM = "\"must\":{    \"query_string\":{    \"fields\": [\"title.whitespace\"],    \"query\": \"@term@\"  }},";
    private static String SEARCH_QUERY;
    @Mock
    IdentityManager identityManager;
    @Mock
    ElasticSearchingClient client;
    private String searchResult = null;
    private String searchWithReservedCharacterResult = null;
    private ConfigurationManager configurationManager;

    @Before
    public void setUp() throws Exception {
        this.configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        try {
            SEARCH_QUERY = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("documents-search-query.json"));
            this.searchResult = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("document-search-result.json"));
            this.searchWithReservedCharacterResult = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("document-search-reserved-character-result.json"));
            Mockito.reset((Object[])new ConfigurationManager[]{this.configurationManager});
            Mockito.when((Object)this.configurationManager.getInputStream("FILE_PATH")).thenReturn((Object)new ByteArrayInputStream(SEARCH_QUERY.getBytes()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving ES Query content", e);
        }
    }

    private String getSizeAgg(boolean getTotalSize) {
        if (getTotalSize) {
            return "\"aggs\": {\n      \"total_size\": { \"sum\": { \"field\": \"fileSize\" } }\n    },";
        }
        return "";
    }

    public String getLimit(int limit) {
        if (limit > 0) {
            return "\"size\":" + limit + ",";
        }
        return "";
    }

    @Test
    public void searchTest() {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)userIdentity.getUserId()).thenReturn((Object)"1");
        Mockito.when((Object)userIdentity.getMemberships()).thenReturn(new ArrayList());
        DocumentFolderFilter filter = new DocumentFolderFilter(null, null, Long.valueOf(1L), null);
        filter.setExtendedSearch(false);
        filter.setFavorites(Boolean.valueOf(false));
        filter.setIncludeHiddenFiles(false);
        filter.setSortField(DocumentSortField.NAME);
        filter.setAscending(true);
        filter.setQuery("(test OR *test*)");
        int limit = 51;
        int offset = 0;
        String path = "/Groups/spaces/test/Documents/";
        String sort_field = "title";
        String sort_direction = "ASC";
        String expectedQuery = SEARCH_QUERY.replace("@term_query@", SEARCH_QUERY_TERM.replace(QUERY_TAG_TERM, filter.getQuery())).replace("@favorite_query@", "").replace("@category_query@", "").replace("@permissions@", this.getPermissionQuery(userIdentity)).replace("@fileTypes_query@", "").replace("@size_query@", "").replace("@date_query@", "").replace("@path@", path).replace("@workspace@", WORKSPACE).replace("@size_agg@", this.getSizeAgg(false)).replace("@sort_field@", sort_field + ".raw").replace("@sort_direction@", sort_direction).replace("@offset@", String.valueOf(offset)).replace("@limit@", this.getLimit(limit));
        DocumentSearchServiceConnector documentSearchServiceConnector = new DocumentSearchServiceConnector(this.configurationManager, this.identityManager, this.client, this.getParams());
        Assert.assertThrows(IllegalArgumentException.class, () -> DocumentSearchServiceConnectorTest.lambda$searchTest$0(documentSearchServiceConnector, userIdentity, path, (DocumentNodeFilter)filter, offset, limit, sort_field, sort_direction));
        Assert.assertThrows(IllegalArgumentException.class, () -> DocumentSearchServiceConnectorTest.lambda$searchTest$1(documentSearchServiceConnector, path, (DocumentNodeFilter)filter, offset, limit, sort_field, sort_direction));
        filter.setQuery(null);
        Assert.assertThrows(IllegalArgumentException.class, () -> DocumentSearchServiceConnectorTest.lambda$searchTest$2(documentSearchServiceConnector, userIdentity, path, (DocumentNodeFilter)filter, offset, limit, sort_field, sort_direction));
        filter.setQuery("test");
        Mockito.when((Object)this.client.sendRequest(expectedQuery, ES_INDEX)).thenReturn((Object)this.searchResult);
        Collection result = documentSearchServiceConnector.search(userIdentity, WORKSPACE, path, (DocumentNodeFilter)filter, offset, limit, sort_field, sort_direction);
        ((ElasticSearchingClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).sendRequest(expectedQuery, ES_INDEX);
        Assert.assertFalse((boolean)result.isEmpty());
        filter.setQuery("term with reserved - character");
        String esquipedReservedCharactersTermQuery = "(term OR *term*) AND (with OR *with*) AND (reserved OR *reserved*) AND (\\\\- OR *\\\\-*) AND (character OR *character*)";
        String oldSearchedTermQuery = "(test OR *test*)";
        Mockito.when((Object)this.client.sendRequest(expectedQuery.replace(oldSearchedTermQuery, esquipedReservedCharactersTermQuery), ES_INDEX)).thenReturn((Object)this.searchWithReservedCharacterResult);
        result = documentSearchServiceConnector.search(userIdentity, WORKSPACE, path, (DocumentNodeFilter)filter, offset, limit, sort_field, sort_direction);
        ((ElasticSearchingClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).sendRequest(expectedQuery.replace(oldSearchedTermQuery, esquipedReservedCharactersTermQuery), ES_INDEX);
        Assert.assertFalse((boolean)result.isEmpty());
    }

    @Test
    public void buildEscapedQueryWithAndOperatorTest() {
        DocumentSearchServiceConnector documentSearchServiceConnector = new DocumentSearchServiceConnector(this.configurationManager, this.identityManager, this.client, this.getParams());
        String term = documentSearchServiceConnector.escapeReservedCharacters("termquery");
        String escapedQueryWithAndOperator = documentSearchServiceConnector.buildEscapedQueryWithAndOperator(term);
        Assert.assertEquals((Object)"termquery", (Object)escapedQueryWithAndOperator);
        String escapedReservedCharacters = documentSearchServiceConnector.escapeReservedCharacters("test escaped-query");
        escapedQueryWithAndOperator = documentSearchServiceConnector.buildEscapedQueryWithAndOperator(escapedReservedCharacters);
        Assert.assertEquals((Object)"test* AND \\\\*escaped\\\\-query\\\\", (Object)escapedQueryWithAndOperator);
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        propertiesParam.setProperty("index", ES_INDEX);
        ValueParam valueParam = new ValueParam();
        valueParam.setName(SEARCH_QUERY_FILE_PATH_PARAM);
        valueParam.setValue("FILE_PATH");
        params.addParameter((Parameter)propertiesParam);
        params.addParameter((Parameter)valueParam);
        return params;
    }

    private String getPermissionQuery(Identity userIdentity) {
        String permissionQuery = "{\n  \"term\" : { \"permissions\" : \"" + userIdentity.getUserId() + "\" }\n},\n{\n  \"term\" : { \"permissions\" : \"" + IdentityConstants.ANY + "\" }\n}";
        return permissionQuery;
    }

    private static /* synthetic */ void lambda$searchTest$2(DocumentSearchServiceConnector documentSearchServiceConnector, Identity userIdentity, String path, DocumentNodeFilter filter, int offset, int limit, String sort_field, String sort_direction) throws Throwable {
        documentSearchServiceConnector.search(userIdentity, WORKSPACE, path, filter, offset, -limit, sort_field, sort_direction);
    }

    private static /* synthetic */ void lambda$searchTest$1(DocumentSearchServiceConnector documentSearchServiceConnector, String path, DocumentNodeFilter filter, int offset, int limit, String sort_field, String sort_direction) throws Throwable {
        documentSearchServiceConnector.search(null, WORKSPACE, path, filter, offset, limit, sort_field, sort_direction);
    }

    private static /* synthetic */ void lambda$searchTest$0(DocumentSearchServiceConnector documentSearchServiceConnector, Identity userIdentity, String path, DocumentNodeFilter filter, int offset, int limit, String sort_field, String sort_direction) throws Throwable {
        documentSearchServiceConnector.search(userIdentity, WORKSPACE, path, filter, offset, -limit, sort_field, sort_direction);
    }
}

