/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.TrashElementNode;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class JCRDocumentsUtilTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS_UTIL = Mockito.mockStatic(CommonsUtils.class);

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS_UTIL.close();
    }

    @Before
    public void setUp() throws Exception {
        JCRDeleteFileStorage jcrDeleteFileStorage = (JCRDeleteFileStorage)Mockito.mock(JCRDeleteFileStorage.class);
        COMMONS_UTILS_UTIL.when(() -> CommonsUtils.getService(JCRDeleteFileStorage.class)).thenReturn((Object)jcrDeleteFileStorage);
    }

    @Test
    public void testRetrieveFileProperties() throws IOException, RepositoryException {
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Identity aclIdentity = (Identity)Mockito.mock(Identity.class);
        AbstractNode documentNode = (AbstractNode)Mockito.mock(AbstractNode.class);
        SpaceService spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        NodeImpl parentNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)parentNode.getIdentifier()).thenReturn((Object)"identifierOfParentNode");
        Mockito.when((Object)node.getParent()).thenReturn((Object)parentNode);
        Mockito.when((Object)node.getName()).thenReturn((Object)"NodeName.pdf");
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.getACL()).thenReturn((Object)new AccessControlList());
        Mockito.when((Object)node.isNodeType("mix:versionable")).thenReturn((Object)true);
        Version baseVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)baseVersion.getName()).thenReturn((Object)"1");
        Mockito.when((Object)node.getBaseVersion()).thenReturn((Object)baseVersion);
        Mockito.when((Object)node.hasProperty("exo:dateCreated")).thenReturn((Object)true);
        Mockito.when((Object)node.hasProperty("exo:dateModified")).thenReturn((Object)true);
        Property createdDateProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)createdDateProperty.getDate()).thenReturn((Object)Calendar.getInstance());
        Property modifiedDateProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)modifiedDateProperty.getDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)node.getProperty("exo:dateCreated")).thenReturn((Object)createdDateProperty);
        Mockito.when((Object)node.getProperty("exo:dateModified")).thenReturn((Object)modifiedDateProperty);
        Property lasdtModifierProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)lasdtModifierProperty.getString()).thenReturn((Object)"root");
        Mockito.when((Object)node.getProperty("exo:lastModifier")).thenReturn((Object)lasdtModifierProperty);
        Mockito.when((Object)aclIdentity.getUserId()).thenReturn((Object)"root");
        Mockito.when((Object)node.getProperty("dc:description")).thenReturn((Object)property);
        Mockito.when((Object)node.hasProperty("dc:description")).thenReturn((Object)true);
        Mockito.when((Object)node.getProperty("dc:description").getString()).thenThrow(new Throwable[]{new ValueFormatException()});
        try {
            JCRDocumentsUtil.retrieveFileProperties((IdentityManager)identityManager, (Node)node, (Identity)aclIdentity, (AbstractNode)documentNode, (SpaceService)spaceService);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Mockito.when((Object)node.getProperty("dc:description").getValues()).thenReturn((Object)new Value[0]);
        JCRDocumentsUtil.retrieveFileProperties((IdentityManager)identityManager, (Node)node, (Identity)aclIdentity, (AbstractNode)documentNode, (SpaceService)spaceService);
        ((AbstractNode)Mockito.verify((Object)documentNode, (VerificationMode)Mockito.times((int)0))).setDescription(ArgumentMatchers.anyString());
        Mockito.when((Object)node.getProperty("dc:description").getValues()).thenReturn((Object)new Value[1]);
        Value[] descriptionValues = new Value[]{new StringValue("File description !")};
        Mockito.when((Object)node.getProperty("dc:description").getValues()).thenReturn((Object)descriptionValues);
        JCRDocumentsUtil.retrieveFileProperties((IdentityManager)identityManager, (Node)node, (Identity)aclIdentity, (AbstractNode)documentNode, (SpaceService)spaceService);
        ((AbstractNode)Mockito.verify((Object)documentNode, (VerificationMode)Mockito.times((int)1))).setDescription(ArgumentMatchers.anyString());
    }

    @Test
    public void testToFileNodes() throws RepositoryException {
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        Identity aclIdentity = (Identity)Mockito.mock(Identity.class);
        SpaceService spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        NodeImpl file = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl fileContent = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)file.getName()).thenReturn((Object)"document-test.pdf");
        Mockito.when((Object)file.getIdentifier()).thenReturn((Object)"fileIdentifier");
        Mockito.when((Object)file.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)file.getNode("jcr:content")).thenReturn((Object)fileContent);
        Mockito.when((Object)fileContent.hasProperty("dc:description")).thenReturn((Object)false);
        Mockito.when((Object)fileContent.hasProperty("jcr:mimeType")).thenReturn((Object)true);
        Property mimeTypeProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mimeTypeProperty.getString()).thenReturn((Object)"application/pdf");
        Mockito.when((Object)fileContent.getProperty("jcr:mimeType")).thenReturn((Object)mimeTypeProperty);
        Mockito.when((Object)file.hasProperty("jcr:data")).thenReturn((Object)false);
        Mockito.when((Object)file.getACL()).thenReturn((Object)new AccessControlList());
        NodeImpl fileInFolderSymlink = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl fileContentSymlink = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)fileInFolderSymlink.getName()).thenReturn((Object)"second-document-test.pdf");
        Mockito.when((Object)fileInFolderSymlink.getIdentifier()).thenReturn((Object)"fileIdentifierInsideSymlink");
        Mockito.when((Object)fileInFolderSymlink.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)fileInFolderSymlink.getNode("jcr:content")).thenReturn((Object)fileContent);
        Mockito.when((Object)fileContentSymlink.hasProperty("dc:description")).thenReturn((Object)false);
        Mockito.when((Object)fileContentSymlink.hasProperty("jcr:mimeType")).thenReturn((Object)true);
        Mockito.when((Object)fileContentSymlink.getProperty("jcr:mimeType")).thenReturn((Object)mimeTypeProperty);
        Mockito.when((Object)fileInFolderSymlink.hasProperty("jcr:data")).thenReturn((Object)false);
        Mockito.when((Object)fileInFolderSymlink.getACL()).thenReturn((Object)new AccessControlList());
        NodeImpl folderNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)folderNode.getIdentifier()).thenReturn((Object)"folderIdentifier");
        Mockito.when((Object)folderNode.getPath()).thenReturn((Object)"/path/folderNode");
        Mockito.when((Object)folderNode.isNodeType("nt:folder")).thenReturn((Object)true);
        NodeImpl anotherFolderNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)anotherFolderNode.getIdentifier()).thenReturn((Object)"anotherFolderIdentifier");
        Mockito.when((Object)anotherFolderNode.getPath()).thenReturn((Object)"/path/antherFolder/anotherFolderNode");
        Mockito.when((Object)anotherFolderNode.isNodeType("nt:folder")).thenReturn((Object)true);
        NodeType anotherFolderPrimaryNT = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)anotherFolderPrimaryNT.getName()).thenReturn((Object)"nt:folder");
        Mockito.when((Object)anotherFolderNode.getPrimaryNodeType()).thenReturn((Object)anotherFolderPrimaryNT);
        NodeIterator anotherFolderNodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)anotherFolderNodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)anotherFolderNodeIterator.nextNode()).thenReturn((Object)fileInFolderSymlink);
        Mockito.when((Object)anotherFolderNode.getNodes()).thenReturn((Object)anotherFolderNodeIterator);
        NodeImpl anotherFolderLink = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)anotherFolderLink.isNodeType("exo:symlink")).thenReturn((Object)true);
        Property anotherFolderSymlinkUUID = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)anotherFolderSymlinkUUID.getString()).thenReturn((Object)"anotherFolderIdentifier");
        Mockito.when((Object)anotherFolderLink.getProperty("exo:uuid")).thenReturn((Object)anotherFolderSymlinkUUID);
        Mockito.when((Object)anotherFolderLink.getPath()).thenReturn((Object)"/path/folderNode/anotherFolderLink.lnk");
        Mockito.when((Object)anotherFolderLink.getACL()).thenReturn((Object)new AccessControlList());
        NodeImpl folderLink = (NodeImpl)Mockito.mock(NodeImpl.class);
        folderLink.setProperty("exo:uuid", "test");
        Mockito.when((Object)folderLink.isNodeType("exo:symlink")).thenReturn((Object)true);
        Property symlinkUUID = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)symlinkUUID.getString()).thenReturn((Object)"folderIdentifier");
        Mockito.when((Object)folderLink.getProperty("exo:uuid")).thenReturn((Object)symlinkUUID);
        Mockito.when((Object)folderLink.getPath()).thenReturn((Object)"/path/folderNode/folderLink.lnk");
        Mockito.when((Object)folderLink.getACL()).thenReturn((Object)new AccessControlList());
        NodeImpl fileToDelete = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)fileToDelete.getIdentifier()).thenReturn((Object)"fileToDeleteIdentifier");
        NodeIterator folderNodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)folderNodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)folderNodeIterator.nextNode()).thenReturn((Object)file, (Object[])new Node[]{folderLink, anotherFolderLink});
        ExtendedSession session = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        Mockito.when((Object)session.getNodeByIdentifier("folderIdentifier")).thenReturn((Object)folderNode);
        Mockito.when((Object)session.getNodeByIdentifier("anotherFolderIdentifier")).thenReturn((Object)anotherFolderNode);
        List fileNodes = JCRDocumentsUtil.toFileNodes((IdentityManager)identityManager, (NodeIterator)folderNodeIterator, (Identity)aclIdentity, (Session)session, (SpaceService)spaceService, (boolean)false);
        Assert.assertEquals((long)2L, (long)fileNodes.size());
        Assert.assertEquals((Object)"document-test.pdf", (Object)((FileNode)fileNodes.get(0)).getName());
        Assert.assertEquals((Object)"second-document-test.pdf", (Object)((FileNode)fileNodes.get(1)).getName());
    }

    @Test
    public void testToNodes() throws RepositoryException {
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        SpaceService spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        NodeImpl file1 = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl file2 = (NodeImpl)Mockito.mock(NodeImpl.class);
        ExtendedSession extendedSession = (ExtendedSession)Mockito.mock(ExtendedSession.class);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)file1);
        Mockito.when((Object)file1.isNodeType("exo:symlink")).thenReturn((Object)true);
        Property symlinkUUID1 = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)symlinkUUID1.getString()).thenReturn((Object)"file1Identifier");
        Mockito.when((Object)file1.getProperty("exo:uuid")).thenReturn((Object)symlinkUUID1);
        Mockito.when((Object)extendedSession.getNodeByIdentifier("file1Identifier")).thenReturn(null);
        List listNodes1 = JCRDocumentsUtil.toNodes((IdentityManager)identityManager, (Session)extendedSession, (NodeIterator)nodeIterator, (Identity)identity, (SpaceService)spaceService, (boolean)false, null);
        Assert.assertEquals((long)0L, (long)listNodes1.size());
        Mockito.when((Object)file2.isNodeType("exo:symlink")).thenReturn((Object)true);
        Property symlinkUUID2 = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)symlinkUUID2.getString()).thenReturn((Object)"file2Identifier");
        Mockito.when((Object)file2.getProperty("exo:uuid")).thenReturn((Object)symlinkUUID2);
        Mockito.when((Object)extendedSession.getNodeByIdentifier("file2Identifier")).thenReturn((Object)file2);
        Mockito.when((Object)file2.isNodeType("nt:file")).thenReturn((Object)true);
        Mockito.when((Object)file2.getSession()).thenReturn((Object)session);
        NodeType filePrimaryNT = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)file2.getPrimaryNodeType()).thenReturn((Object)filePrimaryNT);
        Mockito.when((Object)file2.getPrimaryNodeType().getName()).thenReturn((Object)"");
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        AccessControlList accessControlList = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)accessControlList.getPermissionEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)file1.getACL()).thenReturn((Object)accessControlList);
        Mockito.when((Object)file2.getACL()).thenReturn((Object)accessControlList);
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)file1, (Object[])new Node[]{file2});
        List listNodes2 = JCRDocumentsUtil.toNodes((IdentityManager)identityManager, (Session)extendedSession, (NodeIterator)nodeIterator, (Identity)identity, (SpaceService)spaceService, (boolean)false, null);
        Assert.assertEquals((long)1L, (long)listNodes2.size());
    }

    @Test
    public void retrieveFileContentProperties() throws RepositoryException, IOException {
        Node contentNode = (Node)Mockito.mock(Node.class);
        FileNode fileNode = (FileNode)Mockito.mock(FileNode.class);
        Mockito.lenient().when((Object)contentNode.hasProperty("dc:description")).thenReturn((Object)true);
        Mockito.lenient().when((Object)contentNode.hasProperty("jcr:mimeType")).thenReturn((Object)true);
        Mockito.lenient().when((Object)contentNode.hasProperty("jcr:data")).thenReturn((Object)true);
        Property descriptionProperty = (Property)Mockito.mock(Property.class);
        Property mimeTypeProperty = (Property)Mockito.mock(Property.class);
        Property dataProperty = (Property)Mockito.mock(Property.class);
        Mockito.lenient().when((Object)contentNode.getProperty("dc:description")).thenReturn((Object)descriptionProperty);
        Mockito.lenient().when((Object)contentNode.getProperty("jcr:mimeType")).thenReturn((Object)mimeTypeProperty);
        Mockito.lenient().when((Object)contentNode.getProperty("jcr:data")).thenReturn((Object)dataProperty);
        Mockito.lenient().when((Object)descriptionProperty.getValues()).thenReturn((Object)new Value[0]);
        Mockito.lenient().when((Object)mimeTypeProperty.getString()).thenReturn((Object)"application/pdf");
        Mockito.lenient().when((Object)dataProperty.getLength()).thenReturn((Object)1024L);
        JCRDocumentsUtil.retrieveFileContentProperties((Node)contentNode, (FileNode)fileNode);
        ((FileNode)Mockito.verify((Object)fileNode, (VerificationMode)Mockito.times((int)0))).setDescription(ArgumentMatchers.anyString());
        ((FileNode)Mockito.verify((Object)fileNode, (VerificationMode)Mockito.times((int)1))).setMimeType(ArgumentMatchers.anyString());
        ((FileNode)Mockito.verify((Object)fileNode, (VerificationMode)Mockito.times((int)1))).setSize(Mockito.anyLong());
        Mockito.lenient().when((Object)descriptionProperty.getValues()).thenReturn((Object)new Value[]{new StringValue("test description")});
        JCRDocumentsUtil.retrieveFileContentProperties((Node)contentNode, (FileNode)fileNode);
        ((FileNode)Mockito.verify((Object)fileNode, (VerificationMode)Mockito.times((int)1))).setDescription(ArgumentMatchers.anyString());
    }

    @Test
    public void isValidDocumentTitle() {
        Assert.assertFalse((boolean)JCRDocumentsUtil.isValidDocumentTitle((String)"   "));
        Assert.assertFalse((boolean)JCRDocumentsUtil.isValidDocumentTitle((String)"   .docx"));
        Assert.assertTrue((boolean)JCRDocumentsUtil.isValidDocumentTitle((String)"test.docx"));
    }

    @Test
    public void hasEditPermission() throws RepositoryException {
        Session session = (Session)Mockito.mock(Session.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"path");
        ((Session)Mockito.doNothing().when((Object)session)).checkPermission("path", "set_property");
        Assert.assertTrue((boolean)JCRDocumentsUtil.hasEditPermission((Session)session, (Node)node));
        ((Session)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)session)).checkPermission("path", "set_property");
        Assert.assertFalse((boolean)JCRDocumentsUtil.hasEditPermission((Session)session, (Node)node));
    }

    @Test
    public void testGroupToIdentity() throws Exception {
        OrganizationService organizationService = (OrganizationService)Mockito.mock(OrganizationService.class);
        Group group = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)group.getGroupName()).thenReturn((Object)"users");
        Mockito.when((Object)group.getLabel()).thenReturn((Object)"Users");
        Mockito.when((Object)group.getId()).thenReturn((Object)"/platform/users");
        COMMONS_UTILS_UTIL.when(() -> CommonsUtils.getService(OrganizationService.class)).thenReturn((Object)organizationService);
        GroupHandler groupHandler = (GroupHandler)Mockito.mock(GroupHandler.class);
        Mockito.when((Object)organizationService.getGroupHandler()).thenReturn((Object)groupHandler);
        Mockito.when((Object)groupHandler.findGroupById("/platform/users")).thenReturn((Object)group);
        org.exoplatform.social.core.identity.model.Identity identity = JCRDocumentsUtil.groupToIdentity((String)group.getId());
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((Object)"group:users", (Object)identity.getId());
        Assert.assertEquals((Object)group.getId(), (Object)identity.getRemoteId());
        Assert.assertEquals((Object)"group", (Object)identity.getProviderId());
    }

    @Test
    public void testCleanName() {
        String fileName = "fileName.text";
        String folderName = "folderName";
        Assert.assertEquals((Object)fileName, (Object)JCRDocumentsUtil.cleanName((String)fileName, (String)"nt:file"));
        Assert.assertEquals((Object)folderName, (Object)JCRDocumentsUtil.cleanName((String)folderName, (String)"nt:folder"));
        String illeglFileName = "illegal&file#Name.text";
        String illegalFolderName = "illegal&folder#Name";
        Assert.assertEquals((Object)"illegal_file_Name.text", (Object)JCRDocumentsUtil.cleanName((String)illeglFileName, (String)"nt:file"));
        Assert.assertEquals((Object)"illegal_folder_Name", (Object)JCRDocumentsUtil.cleanName((String)illegalFolderName, (String)"nt:folder"));
        String folderNameWithPointChar = "folderNameWithPoint.char";
        Assert.assertEquals((Object)"folderNameWithPoint_char", (Object)JCRDocumentsUtil.cleanName((String)folderNameWithPointChar, (String)"nt:folder"));
        String folderNameWithPointfollowedBySpChar = "folder&Name.followedBy#character";
        Assert.assertEquals((Object)"folder_Name_followedBy_character", (Object)JCRDocumentsUtil.cleanName((String)folderNameWithPointfollowedBySpChar, (String)"nt:folder"));
    }

    @Test
    public void testToFileVersionWithSystemAuthor() throws RepositoryException {
        Version version = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)version.getName()).thenReturn((Object)"1");
        Mockito.when((Object)version.getCreated()).thenReturn((Object)Calendar.getInstance());
        Version baseVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)baseVersion.getName()).thenReturn((Object)"baseVersionName");
        Node frozenNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)version.getNode("jcr:frozenNode")).thenReturn((Object)frozenNode);
        Value value = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)value.getString()).thenReturn((Object)"__system");
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getValue()).thenReturn((Object)value);
        Mockito.when((Object)frozenNode.getProperty("exo:lastModifier")).thenReturn((Object)property);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.hasProperty("exo:title")).thenReturn((Object)false);
        Mockito.when((Object)node.getName()).thenReturn((Object)"nodeName");
        Mockito.when((Object)node.getBaseVersion()).thenReturn((Object)baseVersion);
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        String[] versionLabels = new String[]{"versionLabel"};
        Mockito.when((Object)versionHistory.getVersionLabels(version)).thenReturn((Object)versionLabels);
        Mockito.when((Object)node.getVersionHistory()).thenReturn((Object)versionHistory);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        Mockito.when((Object)identityManager.getOrCreateIdentity("organization", "__system")).thenReturn(null);
        FileVersion fileVersion = JCRDocumentsUtil.toFileVersion((Version)version, (Node)node, (IdentityManager)identityManager);
        Assert.assertEquals((Object)"__system", (Object)fileVersion.getAuthor());
        Assert.assertEquals((Object)"__system", (Object)fileVersion.getAuthorFullName());
    }

    @Test
    public void testCleanNameWithAccents() {
        String fileName = "filName";
        String fileNameWithAccent = "fileNameWithAcc\u00e9nt";
        Assert.assertEquals((Object)"filName", (Object)JCRDocumentsUtil.cleanNameWithAccents((String)fileName, (String)"nt:file"));
        Assert.assertEquals((Object)"fileNameWithAccent", (Object)JCRDocumentsUtil.cleanNameWithAccents((String)fileNameWithAccent, (String)"nt:file"));
        String folderNameWithPointFollowedByAccent = "folderName.followedByAcc\u00e9nt";
        Assert.assertEquals((Object)"folderName.followedByAccent", (Object)JCRDocumentsUtil.cleanNameWithAccents((String)folderNameWithPointFollowedByAccent, (String)"nt:folder"));
    }

    @Test
    public void testRetrieveTrashElementProperties() throws RepositoryException {
        NodeImpl mockNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        Node contentNode = (Node)Mockito.mock(Node.class);
        Property mockProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockNode.hasProperty("exo:title")).thenReturn((Object)true);
        Mockito.when((Object)mockNode.getProperty("exo:title")).thenReturn((Object)mockProperty);
        Mockito.when((Object)mockNode.hasProperty("exo:lastModifiedDate")).thenReturn((Object)true);
        Mockito.when((Object)mockNode.getProperty("exo:lastModifiedDate")).thenReturn((Object)mockProperty);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2023, 0, 1);
        Mockito.when((Object)mockProperty.getDate()).thenReturn((Object)calendar);
        Mockito.when((Object)mockNode.hasProperty("exo:restorePath")).thenReturn((Object)true);
        Mockito.when((Object)mockNode.getProperty("exo:restorePath")).thenReturn((Object)mockProperty);
        Mockito.when((Object)mockNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)mockNode.getNode("jcr:content")).thenReturn((Object)contentNode);
        Mockito.when((Object)contentNode.hasProperty("jcr:mimeType")).thenReturn((Object)true);
        Mockito.when((Object)contentNode.getProperty("jcr:mimeType")).thenReturn((Object)mockProperty);
        Mockito.when((Object)contentNode.hasProperty("jcr:data")).thenReturn((Object)true);
        Mockito.when((Object)contentNode.getProperty("jcr:data")).thenReturn((Object)mockProperty);
        Mockito.when((Object)mockProperty.getLength()).thenReturn((Object)1234L);
        Mockito.when((Object)mockProperty.getString()).thenReturn((Object)"Test Title").thenReturn((Object)"/restore/path").thenReturn((Object)"text/plain");
        Mockito.when((Object)mockNode.getName()).thenReturn((Object)"Test Node");
        Mockito.when((Object)mockNode.isNodeType("nt:folder")).thenReturn((Object)true);
        TrashElementNode result = new TrashElementNode();
        JCRDocumentsUtil.retrieveTrashElementProperties((Node)mockNode, (TrashElementNode)result);
        Assert.assertEquals((Object)"Test Title", (Object)result.getName());
        Assert.assertEquals((long)calendar.getTimeInMillis(), (long)result.getModifiedDate());
        Assert.assertEquals((Object)"/restore/path", (Object)result.getRestorePath());
        Assert.assertTrue((boolean)result.isFolder());
        Assert.assertEquals((Object)"text/plain", (Object)result.getMimeType());
        Assert.assertEquals((long)1234L, (long)result.getSize());
    }
}

