/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.plugin;

import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.documents.storage.jcr.util.ACLProperties;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.documents.storage.jcr.webdav.model.JcrNamespaceContext;
import org.exoplatform.documents.storage.jcr.webdav.plugin.PathCommandHandler;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavFileDownload;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.model.constant.FileConstants;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.stereotype.Component;

@Component
public class WebdavReadCommandHandler {
    private static final String VERSION_QUERY_PARAM = "?version=";
    private static final String IDENTITY_ID_PREFIX = "%20(";
    private static final String IDENTITY_ID_SUFFIX = ")";
    private static final String EXO_HIDDEN_PROPERTY = "exo:hidden";
    private static final String WINDOWS_HIDDEN_PROPERTY = "lp1:win32FileAttributes";
    private static final Set<QName> SEARCH_PROPERTIES = new HashSet<QName>(Arrays.asList(PropertyConstants.DISPLAYNAME, PropertyConstants.RESOURCETYPE, PropertyConstants.CREATIONDATE, PropertyConstants.GETLASTMODIFIED, PropertyConstants.GETCONTENTLENGTH, PropertyConstants.GETCONTENTTYPE));
    private PathCommandHandler pathCommandHandler;
    private IdentityManager identityManager;
    private SpaceService spaceService;

    public WebdavReadCommandHandler(IdentityManager identityManager, SpaceService spaceService, PathCommandHandler pathCommandHandler) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.pathCommandHandler = pathCommandHandler;
    }

    public WebDavItem get(Session session, String webDavPath, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String baseUri, String username) throws WebDavException {
        if (StringUtils.equals((CharSequence)"/", (CharSequence)webDavPath)) {
            WebDavItem result = new WebDavItem();
            result.setJcrPath("/");
            result.setWebDavPath("/");
            result.setFile(false);
            result.setIdentifier(this.getBaseUri(baseUri));
            result.addProperty(PropertyConstants.getIsFolderItemProperty());
            result.addProperty(ACLProperties.getReadOnlyACL());
            if (depth > 0) {
                this.addWebDavUserItem(session, requestedPropertyNames, requestPropertyNamesOnly, depth - 1, baseUri, username, result);
                this.addWebDavSpaceItems(session, requestedPropertyNames, requestPropertyNamesOnly, depth - 1, baseUri, username, result);
            }
            return result;
        }
        if (this.pathCommandHandler.isIdentityRootWebDavPath(webDavPath)) {
            Identity identity = this.getIdentityFromWebDavPath(webDavPath);
            if (identity == null) {
                throw new WebDavException(404, String.format("Can't find an identity Id from path %s", webDavPath));
            }
            return this.getWebDavIdentityItem(session, identity.getIdentityId(), identity.getProfile().getFullName(), requestedPropertyNames, requestPropertyNamesOnly, depth, baseUri);
        }
        Identity identity = this.getIdentityFromWebDavPath(webDavPath);
        if (identity == null) {
            throw new WebDavException(404, String.format("Can't find an identity Id from path %s", webDavPath));
        }
        return this.get(this.getNode(session, this.pathCommandHandler.transformToJcrPath(webDavPath)), this.pathCommandHandler.getIdentityBaseJcrPath(webDavPath), identity.getIdentityId(), identity.getProfile().getFullName(), requestedPropertyNames, requestPropertyNamesOnly, depth, this.getIdentityBaseUri(baseUri, webDavPath));
    }

    public WebDavFileDownload download(Session session, String webDavPath, String version) {
        Node node = this.getNode(session, this.pathCommandHandler.transformToJcrPath(webDavPath), version);
        Calendar lastModifiedDate = this.getLastModifiedDate(node);
        String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        InputStream inputStream = node.getNode("jcr:content").getProperty("jcr:data").getStream();
        return new WebDavFileDownload(node.getName(), (long)inputStream.available(), lastModifiedDate == null ? 0L : lastModifiedDate.getTimeInMillis(), mimeType, inputStream);
    }

    public List<WebDavItem> search(Session session, String queryLanguage, String query, String baseUri, String username) {
        NodeIterator nodes = session.getWorkspace().getQueryManager().createQuery(query, queryLanguage).execute().getNodes();
        Iterable iterable = () -> nodes;
        return StreamSupport.stream(iterable.spliterator(), false).map(node -> this.get((Node)node, SEARCH_PROPERTIES, baseUri, username)).filter(Objects::nonNull).toList();
    }

    public List<WebDavItem> getVersions(Session session, String webDavPath, Set<QName> requestedPropertyNames, String baseUri) {
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        Node node = this.getNode(session, jcrPath);
        if (node.isNodeType("mix:versionable")) {
            VersionIterator versions = node.getVersionHistory().getAllVersions();
            Iterable iterable = () -> versions;
            Identity identity = this.getIdentityFromWebDavPath(webDavPath);
            String identityBaseJcrPath = this.pathCommandHandler.getIdentityBaseJcrPath(webDavPath);
            String identityBaseUri = this.getIdentityBaseUri(baseUri, webDavPath);
            return StreamSupport.stream(iterable.spliterator(), false).filter(version -> !this.isRootVersion((Version)version)).map(version -> this.get(this.getVersionNode((Version)version), identityBaseJcrPath, identity.getIdentityId(), identity.getProfile().getFullName(), requestedPropertyNames, false, 0, identityBaseUri)).filter(Objects::nonNull).toList();
        }
        return Collections.emptyList();
    }

    public boolean isFile(Session session, String webDavPath) {
        Item item;
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        if (session.itemExists(jcrPath) && (item = session.getItem(jcrPath)) instanceof Node) {
            Node node = (Node)item;
            return this.isFile(node);
        }
        return false;
    }

    public long getLastModifiedDate(Session session, String webDavPath, String version) {
        String jcrPath = this.pathCommandHandler.transformToJcrPath(webDavPath);
        Node node = this.getNode(session, jcrPath, version);
        Calendar lastModifiedDate = this.getLastModifiedDate(node);
        return lastModifiedDate == null ? 0L : lastModifiedDate.getTimeInMillis();
    }

    private Calendar getLastModifiedDate(Node node) {
        Node contentNode;
        Calendar modifiedCalendar = null;
        if (this.isFile(node) && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:lastModified")) {
            modifiedCalendar = contentNode.getProperty("jcr:lastModified").getDate();
        }
        if (modifiedCalendar == null) {
            if (node.hasProperty("exo:dateModified")) {
                modifiedCalendar = node.getProperty("exo:dateModified").getDate();
            } else if (node.hasProperty("exo:lastModifiedDate")) {
                modifiedCalendar = node.getProperty("exo:lastModifiedDate").getDate();
            }
        }
        return modifiedCalendar;
    }

    private Calendar getCreatedDate(Node node) {
        Calendar createdCalendar = null;
        if (node.hasProperty("jcr:created")) {
            createdCalendar = node.getProperty("jcr:created").getDate();
        } else if (node.hasProperty("exo:dateCreated")) {
            createdCalendar = node.getProperty("exo:dateCreated").getDate();
        }
        return createdCalendar;
    }

    private Node getNode(Session session, String jcrPath) throws WebDavException {
        return this.getNode(session, jcrPath, null);
    }

    private Node getNode(Session session, String jcrPath, String version) throws WebDavException {
        if (version == null && jcrPath.contains(VERSION_QUERY_PARAM)) {
            version = jcrPath.substring(jcrPath.indexOf(VERSION_QUERY_PARAM) + VERSION_QUERY_PARAM.length());
            jcrPath = jcrPath.substring(0, jcrPath.indexOf(VERSION_QUERY_PARAM));
        }
        if (!session.itemExists(jcrPath)) {
            throw new WebDavException(404, String.format("Resource with path '%s' not found", jcrPath));
        }
        Item item = session.getItem(jcrPath);
        if (!(item instanceof Node)) {
            throw new WebDavException(400, String.format("Resource with path '%s' isn't a node", jcrPath));
        }
        Node node = (Node)item;
        if (version != null) {
            Version nodeVersion = node.getVersionHistory().getVersion(version);
            node = this.getVersionNode(nodeVersion);
        }
        return node;
    }

    private WebDavItem get(Node node, Set<QName> requestedPropertyNames, String baseUri, String username) {
        Long identityId = this.pathCommandHandler.getIdentityIdFromJcrPath(node.getPath(), username);
        if (identityId == null) {
            return null;
        }
        Identity identity = this.identityManager.getIdentity(identityId.longValue());
        return this.get(node, this.pathCommandHandler.getIdentityBaseJcrPath(identityId), identity.getIdentityId(), identity.getProfile().getFullName(), requestedPropertyNames, false, 0, this.getIdentityBaseUri(baseUri, identityId));
    }

    private WebDavItem get(Node node, String identityBaseJcrPath, long identityId, String displayName, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String identityBaseUri) {
        if (FileConstants.BLOCKED_FILES_PATTERN.matcher(node.getName()).find()) {
            return null;
        }
        WebDavItem result = new WebDavItem();
        result.setFile(this.isFile(node));
        result.setIdentifier(new URI(this.getNodeUri(node, identityBaseJcrPath, identityBaseUri)));
        result.setWebDavPath(this.getRelativeNodeUri(node, identityBaseJcrPath, identityId, displayName));
        result.setJcrPath(node.getPath());
        this.addChildren(result, node, identityBaseJcrPath, identityId, displayName, requestedPropertyNames, requestPropertyNamesOnly, depth, identityBaseUri);
        this.addProperties(result, node, requestedPropertyNames, null, requestPropertyNamesOnly);
        return result;
    }

    private void addChildren(WebDavItem webDavItem, Node node, String identityBaseJcrPath, long identityId, String displayName, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String identityBaseUri) throws RepositoryException {
        if (depth > 0 && node.hasNodes()) {
            NodeIterator nodes = node.getNodes();
            Iterable iterable = () -> nodes;
            StreamSupport.stream(iterable.spliterator(), false).filter(childNode -> (this.isFile((Node)childNode) || this.isFolder((Node)childNode)) && !this.isHidden((Node)childNode)).map(childNode -> this.get((Node)childNode, identityBaseJcrPath, identityId, displayName, requestedPropertyNames, requestPropertyNamesOnly, depth - 1, identityBaseUri)).filter(Objects::nonNull).forEach(arg_0 -> ((WebDavItem)webDavItem).addChild(arg_0));
        }
    }

    protected WebDavItemProperty getWebDavPropertyNoException(Node node, URI nodeIdentifier, Version version, QName name) {
        try {
            return this.getWebDavProperty(node, nodeIdentifier, version, name);
        }
        catch (Exception e) {
            if (PathCommandHandler.LOG.isTraceEnabled()) {
                PathCommandHandler.LOG.warn("Error retrieving property from path '{}' with name '{}'", new Object[]{node.getPath(), name, e});
            } else {
                PathCommandHandler.LOG.warn("Error retrieving property from path '{}' with name '{}': {}", new Object[]{node.getPath(), name, e.getMessage()});
            }
            return null;
        }
    }

    private WebDavItemProperty getWebDavProperty(Node node, URI nodeIdentifier, Version version, QName name) {
        if (name.equals(PropertyConstants.DISPLAYNAME)) {
            return version == null ? new WebDavItemProperty(name, String.format("%s%s", Utils.decodeString(node.getName()), this.getNodeIndexSuffix(node))) : new WebDavItemProperty(name, Utils.decodeString(version.getName()));
        }
        if (PropertyConstants.VERSIONNAME.equals(name)) {
            if (version != null) {
                return new WebDavItemProperty(name, version.getName());
            }
        } else {
            if (PropertyConstants.VERSIONHISTORY.equals(name)) {
                return new WebDavItemProperty(name);
            }
            if (PropertyConstants.CHECKEDIN.equals(name)) {
                WebDavItemProperty checkedInProperty = new WebDavItemProperty(name);
                WebDavItemProperty href = checkedInProperty.addChild(new WebDavItemProperty(PropertyConstants.HREF));
                href.setValue(nodeIdentifier.toASCIIString());
                return checkedInProperty;
            }
            if (PropertyConstants.CHECKEDOUT.equals(name)) {
                if (node.isCheckedOut()) {
                    return new WebDavItemProperty(name);
                }
            } else if (PropertyConstants.PREDECESSORSET.equals(name)) {
                if (version != null) {
                    Version[] predecessors = version.getPredecessors();
                    WebDavItemProperty predecessorsProperty = new WebDavItemProperty(name);
                    for (Version curVersion : predecessors) {
                        if ("jcr:rootVersion".equals(curVersion.getName())) continue;
                        String versionHref = nodeIdentifier.toASCIIString() + "/?version=" + curVersion.getName();
                        WebDavItemProperty href = predecessorsProperty.addChild(new WebDavItemProperty(PropertyConstants.HREF));
                        href.setValue(versionHref);
                    }
                    return predecessorsProperty;
                }
            } else if (PropertyConstants.SUCCESSORSET.equals(name)) {
                if (version != null) {
                    Version[] successors = version.getSuccessors();
                    WebDavItemProperty successorsProperty = new WebDavItemProperty(name);
                    for (Version curVersion : successors) {
                        String versionHref = nodeIdentifier.toASCIIString() + "/?version=" + curVersion.getName();
                        WebDavItemProperty href = successorsProperty.addChild(new WebDavItemProperty(PropertyConstants.HREF));
                        href.setValue(versionHref);
                    }
                    return successorsProperty;
                }
            } else if (name.equals(PropertyConstants.CREATIONDATE)) {
                Calendar createdDate = this.getCreatedDate(node);
                if (createdDate != null) {
                    WebDavItemProperty creationDate = new WebDavItemProperty(name, createdDate, "yyyy-MM-dd'T'HH:mm:ss'Z'");
                    creationDate.setAttribute("b:dt", "dateTime.tz");
                    return creationDate;
                }
            } else if (name.equals(PropertyConstants.GETLASTMODIFIED)) {
                Calendar lastModifiedDate = this.getLastModifiedDate(node);
                if (lastModifiedDate != null) {
                    return this.getWebDavDateProperty(name, lastModifiedDate);
                }
            } else if (name.equals(PropertyConstants.GET_ETAG)) {
                Calendar lastModifiedDate = this.getLastModifiedDate(node);
                if (lastModifiedDate != null) {
                    return new WebDavItemProperty(name, String.format("W/%s", lastModifiedDate.getTimeInMillis()));
                }
            } else if (name.equals(PropertyConstants.CHILDCOUNT)) {
                if (this.isFolder(node)) {
                    return new WebDavItemProperty(name, String.valueOf(node.getNodes().getSize()));
                }
            } else if (name.equals(PropertyConstants.GETCONTENTLENGTH)) {
                if (this.isFile(node)) {
                    return new WebDavItemProperty(name, String.valueOf(node.getNode("jcr:content").getProperty("jcr:data").getLength()));
                }
            } else if (name.equals(PropertyConstants.GETCONTENTTYPE)) {
                Node contentNode;
                if (this.isFile(node) && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:mimeType")) {
                    String mimeType = contentNode.getProperty("jcr:mimeType").getString();
                    String encoding = null;
                    if (contentNode.hasProperty("jcr:encoding")) {
                        encoding = contentNode.getProperty("jcr:encoding").getString();
                    }
                    return StringUtils.isBlank(encoding) ? new WebDavItemProperty(name, mimeType) : new WebDavItemProperty(name, mimeType + "; charset=" + encoding);
                }
            } else {
                if (name.equals(PropertyConstants.HASCHILDREN)) {
                    return new WebDavItemProperty(name, this.isFolder(node) && node.hasNodes() ? "1" : "0");
                }
                if (name.equals(PropertyConstants.ISCOLLECTION)) {
                    return new WebDavItemProperty(name, this.isFolder(node) ? "1" : "0");
                }
                if (name.equals(PropertyConstants.ISFOLDER)) {
                    return new WebDavItemProperty(name, this.isFolder(node) ? "1" : "0");
                }
                if (name.equals(PropertyConstants.ISROOT)) {
                    return new WebDavItemProperty(name, node.getPath().equals("/") ? "1" : "0");
                }
                if (name.equals(PropertyConstants.PARENTNAME)) {
                    return new WebDavItemProperty(name, node.getParent().getName());
                }
                if (name.equals(PropertyConstants.RESOURCETYPE)) {
                    if (this.isFolder(node)) {
                        return PropertyConstants.getIsFolderItemProperty();
                    }
                    return new WebDavItemProperty(name);
                }
                if (name.equals(PropertyConstants.SUPPORTEDLOCK)) {
                    if (node.canAddMixin("mix:lockable")) {
                        return PropertyConstants.getSupportedLock();
                    }
                } else if (name.equals(PropertyConstants.LOCKDISCOVERY)) {
                    if (node.isLocked()) {
                        String token = node.getLock().getLockToken();
                        String owner = node.getLock().getLockOwner();
                        return PropertyConstants.getLockDiscovery((String)token, (String)owner, (String)"86400");
                    }
                } else {
                    if (name.equals(PropertyConstants.ISVERSIONED)) {
                        return new WebDavItemProperty(name, "0");
                    }
                    if (name.equals(PropertyConstants.SUPPORTEDMETHODSET)) {
                        return PropertyConstants.getSupportedMethodSet();
                    }
                    if (name.equals(ACLProperties.ACL)) {
                        return ACLProperties.getACL((NodeImpl)node);
                    }
                    if (name.equals(PropertyConstants.OWNER)) {
                        return ACLProperties.getOwner((NodeImpl)node);
                    }
                    String propName = JcrNamespaceContext.createName(name);
                    PathCommandHandler.LOG.debug("Prop with name '{}' not recognized, attempt to retrieve it from Node as prop name '{}'", new Object[]{name, propName});
                    if (node.hasProperty(propName)) {
                        return new WebDavItemProperty(name, Utils.getStringProperty(node, propName));
                    }
                    if (this.isFile(node) && node.getNode("jcr:content").hasProperty(propName)) {
                        return new WebDavItemProperty(name, Utils.getStringProperty(node.getNode("jcr:content"), propName));
                    }
                }
            }
        }
        return null;
    }

    private WebDavItemProperty getWebDavDateProperty(QName name, Calendar lastModifiedDate) {
        WebDavItemProperty lastModified = new WebDavItemProperty(name, lastModifiedDate, "EEE, dd MMM yyyy HH:mm:ss z");
        lastModified.setAttribute("b:dt", "dateTime.rfc1123");
        return lastModified;
    }

    private boolean isFolder(Node node) {
        return node.isNodeType("nt:unstructured") || node.isNodeType("nt:folder");
    }

    private boolean isFile(Node node) {
        return node.isNodeType("nt:file");
    }

    private Node getVersionNode(Version version) {
        return version.getNode("jcr:frozenNode");
    }

    private boolean isRootVersion(Version version) {
        return "jcr:rootVersion".equals(version.getName());
    }

    private boolean isHidden(Node node) {
        return node.isNodeType("exo:hiddenable");
    }

    private void addWebDavUserItem(Session session, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String baseUri, String username, WebDavItem result) {
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        WebDavItem webDavIdentityItem = this.getWebDavIdentityItem(session, userIdentity.getIdentityId(), userIdentity.getProfile().getFullName(), requestedPropertyNames, requestPropertyNamesOnly, depth, baseUri);
        if (webDavIdentityItem != null) {
            result.addChild(webDavIdentityItem);
        }
    }

    private void addWebDavSpaceItems(Session session, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String baseUri, String username, WebDavItem result) {
        ListAccess memberSpacesListAccess = this.spaceService.getMemberSpaces(username);
        int memberSpacesSize = memberSpacesListAccess.getSize();
        if (memberSpacesSize > 0) {
            List memberSpacesIds = this.spaceService.getMemberSpacesIds(username, 0, memberSpacesSize);
            for (String spaceId : memberSpacesIds) {
                Space space = this.spaceService.getSpaceById(spaceId);
                Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
                spaceIdentity.getProfile().setProperty("fullName", (Object)space.getDisplayName());
                WebDavItem webDavIdentityItem = this.getWebDavIdentityItem(session, spaceIdentity, requestedPropertyNames, requestPropertyNamesOnly, depth, baseUri);
                if (webDavIdentityItem == null) continue;
                result.addChild(webDavIdentityItem);
            }
        }
    }

    private WebDavItem getWebDavIdentityItem(Session session, Identity identity, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String baseUri) {
        return this.getWebDavIdentityItem(session, identity.getIdentityId(), identity.getProfile().getFullName(), requestedPropertyNames, requestPropertyNamesOnly, depth, baseUri);
    }

    private WebDavItem getWebDavIdentityItem(Session session, long identityId, String displayName, Set<QName> requestedPropertyNames, boolean requestPropertyNamesOnly, int depth, String baseUri) {
        if (StringUtils.isBlank((CharSequence)displayName)) {
            displayName = this.getDisplayName(identityId);
        }
        WebDavItem identityWebDavItem = new WebDavItem();
        String identityBaseUri = String.format("%s/%s%s%s%s", baseUri, this.encodeUrlString(displayName), IDENTITY_ID_PREFIX, identityId, IDENTITY_ID_SUFFIX);
        identityWebDavItem.setIdentifier(new URI(identityBaseUri));
        identityWebDavItem.setFile(false);
        identityWebDavItem.addProperty(new WebDavItemProperty(PropertyConstants.DISPLAYNAME, displayName));
        String identityBaseJcrPath = this.pathCommandHandler.getIdentityBaseJcrPath(identityId);
        if (session.itemExists(identityBaseJcrPath)) {
            Node identityParentNode = (Node)session.getItem(identityBaseJcrPath);
            identityWebDavItem.setJcrPath(identityParentNode.getPath());
            identityWebDavItem.setWebDavPath(this.getRelativeNodeUri(identityParentNode, identityBaseJcrPath, identityId, displayName));
            this.addProperties(identityWebDavItem, identityParentNode, requestedPropertyNames, Collections.singleton(PropertyConstants.DISPLAYNAME), requestPropertyNamesOnly);
            this.addChildren(identityWebDavItem, identityParentNode, identityBaseJcrPath, identityId, displayName, requestedPropertyNames, requestPropertyNamesOnly, depth, identityBaseUri);
            return identityWebDavItem;
        }
        return null;
    }

    private void addProperties(WebDavItem result, Node node, Set<QName> requestedPropertyNames, Set<QName> excludePropertyNames, boolean requestPropertyNamesOnly) {
        Collection<QName> propertyNames = requestedPropertyNames == null ? PathCommandHandler.PROPERTY_NAMES : requestedPropertyNames;
        propertyNames.stream().filter(name -> excludePropertyNames == null || !excludePropertyNames.contains(name)).map(name -> requestPropertyNamesOnly ? new WebDavItemProperty(name) : this.getWebDavPropertyNoException(node, result.getIdentifier(), null, (QName)name)).filter(Objects::nonNull).forEach(arg_0 -> ((WebDavItem)result).addProperty(arg_0));
        if (node.isNodeType("exo:hiddenable")) {
            result.addProperty(new WebDavItemProperty(WINDOWS_HIDDEN_PROPERTY, "2"));
            result.addProperty(new WebDavItemProperty(EXO_HIDDEN_PROPERTY, "1"));
        }
    }

    private String getNodeUri(Node node, String identityBaseJcrPath, String identityBaseUri) {
        String nodeRelativePath = node.getPath().replaceFirst(identityBaseJcrPath, "");
        if (StringUtils.isBlank((CharSequence)nodeRelativePath)) {
            return identityBaseUri;
        }
        String encodedNodeRelativePath = Arrays.stream(nodeRelativePath.split("/")).filter(StringUtils::isNotBlank).map(s -> URLDecoder.decode(s, StandardCharsets.UTF_8)).map(this::encodeUrlString).collect(Collectors.joining("/"));
        return String.format("%s/%s", identityBaseUri, encodedNodeRelativePath);
    }

    private String getRelativeNodeUri(Node node, String identityBaseJcrPath, long identityId, String displayName) {
        String nodeRelativePath = node.getPath().replaceFirst(identityBaseJcrPath, "");
        if (StringUtils.isBlank((CharSequence)nodeRelativePath)) {
            return String.format("/%s%s%s%s", this.encodeUrlString(displayName), IDENTITY_ID_PREFIX, identityId, IDENTITY_ID_SUFFIX);
        }
        String encodedNodeRelativePath = Arrays.stream(nodeRelativePath.split("/")).filter(StringUtils::isNotBlank).map(s -> URLDecoder.decode(s, StandardCharsets.UTF_8)).map(this::encodeUrlString).collect(Collectors.joining("/"));
        return String.format("/%s%s%s%s/%s", this.encodeUrlString(displayName), IDENTITY_ID_PREFIX, identityId, IDENTITY_ID_SUFFIX, encodedNodeRelativePath);
    }

    private Identity getIdentityFromWebDavPath(String webDavPath) {
        Long identityId = this.pathCommandHandler.getIdentityIdFromWebDavPath(webDavPath);
        return identityId == null ? null : this.identityManager.getIdentity(identityId.longValue());
    }

    private String getIdentityBaseUri(String baseUri, String webDavPath) {
        Long identityId = this.pathCommandHandler.getIdentityIdFromWebDavPath(webDavPath);
        return this.getIdentityBaseUri(baseUri, identityId);
    }

    private String getIdentityBaseUri(String baseUri, long identityId) {
        Identity identity = this.identityManager.getIdentity(identityId);
        return this.getIdentityBaseUri(baseUri, identity);
    }

    private String getIdentityBaseUri(String baseUri, Identity identity) {
        return String.format("%s/%s%s%s%s", baseUri, this.encodeUrlString(identity.getProfile().getFullName()), IDENTITY_ID_PREFIX, identity.getId(), IDENTITY_ID_SUFFIX);
    }

    private String getNodeIndexSuffix(Node node) throws RepositoryException {
        return node.getIndex() > 1 ? String.format("[%s]", node.getIndex()) : "";
    }

    private URI getBaseUri(String baseUri) {
        return new URI(baseUri + "/");
    }

    private String encodeUrlString(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8).replace("+", "%20");
    }

    private String getDisplayName(long identityId) {
        Identity identity = this.identityManager.getIdentity(identityId);
        if (identity.isSpace()) {
            Space space = this.spaceService.getSpaceByPrettyName(identity.getRemoteId());
            return space.getDisplayName();
        }
        return identity.getProfile().getFullName();
    }
}

