/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.plugin;

import java.io.ByteArrayInputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.xml.namespace.QName;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.documents.storage.jcr.webdav.plugin.PathCommandHandler;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavReadCommandHandler;
import org.exoplatform.documents.webdav.model.WebDavFileDownload;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class WebdavReadCommandHandlerTest {
    private static final String IDENTITY_PATH = "/Users/r/root/Private";
    private static final String JCR_RELATIVE_PATH = "/path/to/file";
    private static final String WEBDAV_PATH = "/John Doe (1)/path/to/file";
    private static final String JCR_PATH = "/Users/r/root/Private/path/to/file";
    private static final String USERNAME = "username";
    private static final String BASE_URI = "baseUri";
    private static final Set<QName> REQUESTED_PROPERTY_NAMES = Collections.singleton(PropertyConstants.DISPLAYNAME);
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private PathCommandHandler pathCommandHandler;
    @Mock
    private Session session;
    @Mock
    private Node node;
    @Mock
    private Node contentNode;
    @Mock
    private Property property;
    @Mock
    private Version version;
    @Mock
    private VersionHistory versionHistory;
    @Mock
    private VersionIterator versionIterator;
    @Mock
    private NodeIterator nodeIterator;
    @Mock
    private Identity identity;
    @Mock
    private Profile profile;
    @Mock
    private ListAccess<Space> memberSpacesListAccess;
    private WebdavReadCommandHandler handler;

    @Before
    public void setUp() {
        this.handler = new WebdavReadCommandHandler(this.identityManager, this.spaceService, this.pathCommandHandler);
        Mockito.when((Object)this.pathCommandHandler.transformToJcrPath(ArgumentMatchers.anyString())).thenReturn((Object)"/jcr/path");
        Mockito.when((Object)this.session.itemExists(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.session.getItem("/jcr/path")).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isNodeType(ArgumentMatchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.node.getName()).thenReturn((Object)"path");
        Mockito.when((Object)this.node.getNode("jcr:content")).thenReturn((Object)this.contentNode);
        Mockito.when((Object)this.contentNode.hasProperty(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.contentNode.getProperty(ArgumentMatchers.anyString())).thenReturn((Object)this.property);
        Mockito.when((Object)this.property.getString()).thenReturn((Object)"text/plain");
        Mockito.when((Object)this.property.getStream()).thenReturn((Object)new ByteArrayInputStream("data".getBytes()));
        Mockito.when((Object)this.property.getLength()).thenReturn((Object)4L);
        Calendar cal = Calendar.getInstance();
        Mockito.when((Object)this.contentNode.getProperty("jcr:lastModified")).thenReturn((Object)this.property);
        Mockito.when((Object)this.property.getDate()).thenReturn((Object)cal);
        Mockito.when((Object)this.identity.getProfile()).thenReturn((Object)this.profile);
        Mockito.when((Object)this.profile.getFullName()).thenReturn((Object)"John Doe");
        Mockito.when((Object)this.identity.getIdentityId()).thenReturn((Object)1L);
        Mockito.when((Object)this.identityManager.getIdentity(ArgumentMatchers.anyLong())).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)this.identity);
        Mockito.when((Object)this.spaceService.getMemberSpaces(USERNAME)).thenReturn(this.memberSpacesListAccess);
        Mockito.when((Object)this.node.getPath()).thenReturn((Object)JCR_PATH);
        Mockito.when((Object)this.pathCommandHandler.getIdentityBaseJcrPath(WEBDAV_PATH)).thenReturn((Object)IDENTITY_PATH);
    }

    @Test
    public void testGetRootPath() {
        WebDavItem webDavItem = this.handler.get(this.session, "/", REQUESTED_PROPERTY_NAMES, false, 5, BASE_URI, USERNAME);
        Assert.assertNotNull((Object)webDavItem);
        Assert.assertEquals((Object)"/", (Object)webDavItem.getJcrPath());
        Assert.assertEquals((Object)"/", (Object)webDavItem.getWebDavPath());
        Assert.assertFalse((boolean)webDavItem.isFile());
        Assert.assertNotNull((Object)webDavItem.getIdentifier());
        Assert.assertNotNull((Object)webDavItem.getProperties());
    }

    @Test
    public void testGetWithNodePath() {
        WebDavItem webDavItem = this.handler.get(this.session, WEBDAV_PATH, REQUESTED_PROPERTY_NAMES, false, 5, BASE_URI, USERNAME);
        Assert.assertNotNull((Object)webDavItem);
        Assert.assertEquals((Object)JCR_PATH, (Object)webDavItem.getJcrPath());
        Assert.assertEquals((Object)WEBDAV_PATH.replace(" ", "%20"), (Object)webDavItem.getWebDavPath());
        Assert.assertFalse((boolean)webDavItem.isFile());
        Assert.assertNotNull((Object)webDavItem.getIdentifier());
    }

    @Test
    public void testIsFileTrue() {
        Mockito.when((Object)this.node.isNodeType("nt:file")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.handler.isFile(this.session, WEBDAV_PATH));
    }

    @Test
    public void testIsFileFalse() {
        Mockito.when((Object)this.node.isNodeType("nt:file")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.handler.isFile(this.session, WEBDAV_PATH));
    }

    @Test
    public void testGetLastModifiedDate() {
        Mockito.when((Object)this.node.isNodeType("nt:file")).thenReturn((Object)true);
        long ts = this.handler.getLastModifiedDate(this.session, WEBDAV_PATH, null);
        Assert.assertTrue((ts > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testDownload() {
        Mockito.when((Object)this.node.isNodeType("nt:file")).thenReturn((Object)true);
        WebDavFileDownload dl = this.handler.download(this.session, WEBDAV_PATH, null);
        Assert.assertEquals((Object)"text/plain", (Object)dl.getMimeType());
        Assert.assertNotNull((Object)dl.getInputStream());
    }

    @Test
    public void testGetVersionsEmptyWhenNotVersionable() {
        Mockito.when((Object)this.node.isNodeType("mix:versionable")).thenReturn((Object)false);
        List result = this.handler.getVersions(this.session, WEBDAV_PATH, Collections.emptySet(), BASE_URI);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGetVersionsWithVersionableNode() {
        Mockito.when((Object)this.node.isNodeType("mix:versionable")).thenReturn((Object)true);
        Mockito.when((Object)this.node.getVersionHistory()).thenReturn((Object)this.versionHistory);
        Mockito.when((Object)this.versionHistory.getAllVersions()).thenReturn((Object)this.versionIterator);
        Mockito.when((Object)this.versionIterator.hasNext()).thenReturn((Object)false);
        List result = this.handler.getVersions(this.session, WEBDAV_PATH, Collections.emptySet(), BASE_URI);
        Assert.assertNotNull((Object)result);
    }
}

