/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav.plugin;

import javax.jcr.Node;
import org.exoplatform.documents.storage.jcr.webdav.plugin.PathCommandHandler;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PathCommandHandlerTest {
    private static final String IDENTITY_PATH = "/(123)";
    private static final String USER1 = "user1";
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private NodeHierarchyCreator nodeHierarchyCreator;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private Identity identity;
    @Mock
    private Node userNode;
    @Mock
    private Node privateNode;
    @Mock
    private Space space;
    @Mock
    private SessionProvider sessionProvider;
    @InjectMocks
    private PathCommandHandler handler;

    @Before
    public void setUp() {
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(null)).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.nodeHierarchyCreator.getUserNode(this.sessionProvider, USER1)).thenReturn((Object)this.userNode);
        Mockito.when((Object)this.userNode.getNode("Private")).thenReturn((Object)this.privateNode);
        Mockito.when((Object)this.privateNode.getPath()).thenReturn((Object)"/users/user1/Private");
        Mockito.when((Object)this.nodeHierarchyCreator.getJcrPath("groupsPath")).thenReturn((Object)"/groups");
        Mockito.when((Object)this.nodeHierarchyCreator.getJcrPath("usersPath")).thenReturn((Object)"/users");
    }

    @Test
    public void testGetIdentityBaseJcrPathByWebDavPathUser() {
        Mockito.when((Object)this.identityManager.getIdentity(123L)).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.isUser()).thenReturn((Object)true);
        Mockito.when((Object)this.identity.getRemoteId()).thenReturn((Object)USER1);
        String result = this.handler.getIdentityBaseJcrPath(IDENTITY_PATH);
        Assert.assertEquals((Object)"/users/user1/Private", (Object)result);
    }

    @Test(expected=WebDavException.class)
    public void testGetIdentityBaseJcrPathByWebDavPathNoIdentity() {
        Mockito.when((Object)this.identityManager.getIdentity(123L)).thenReturn(null);
        this.handler.getIdentityBaseJcrPath(IDENTITY_PATH);
    }

    @Test
    public void testGetIdentityBaseJcrPathByWebDavPathSpace() {
        Mockito.when((Object)this.identityManager.getIdentity(456L)).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.isUser()).thenReturn((Object)false);
        Mockito.when((Object)this.identity.isSpace()).thenReturn((Object)true);
        Mockito.when((Object)this.identity.getRemoteId()).thenReturn((Object)"spacePretty");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("spacePretty")).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getGroupId()).thenReturn((Object)"/spaces/spacePretty");
        String result = this.handler.getIdentityBaseJcrPath("/(456)");
        Assert.assertEquals((Object)"/groups/spaces/spacePretty/Documents", (Object)result);
    }

    @Test(expected=WebDavException.class)
    public void testGetIdentityBaseJcrPathSpaceNotFound() {
        Mockito.when((Object)this.identityManager.getIdentity(456L)).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.isSpace()).thenReturn((Object)true);
        Mockito.when((Object)this.identity.getRemoteId()).thenReturn((Object)"missing");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("missing")).thenReturn(null);
        this.handler.getIdentityBaseJcrPath("/(456)");
    }

    @Test
    public void testGetIdentityIdFromJcrPathSpace() {
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/spaces/space1")).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getPrettyName()).thenReturn((Object)"space1");
        Identity spaceIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity("space1")).thenReturn((Object)spaceIdentity);
        Mockito.when((Object)spaceIdentity.getIdentityId()).thenReturn((Object)999L);
        Long id = this.handler.getIdentityIdFromJcrPath("/groups/spaces/space1/doc", "userX");
        Assert.assertEquals((Object)999L, (Object)id);
    }

    @Test
    public void testGetIdentityIdFromJcrPathUser() {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USER1)).thenReturn((Object)userIdentity);
        Mockito.when((Object)userIdentity.getIdentityId()).thenReturn((Object)111L);
        Long id = this.handler.getIdentityIdFromJcrPath("/users/user1/doc", USER1);
        Assert.assertEquals((Object)111L, (Object)id);
    }

    @Test
    public void testGetIdentityIdFromJcrPathNoMatch() {
        Assert.assertNull((Object)this.handler.getIdentityIdFromJcrPath("/random/path", USER1));
    }

    @Test
    public void testGetIdentityIdFromWebDavPathValid() {
        Assert.assertEquals((Object)123L, (Object)this.handler.getIdentityIdFromWebDavPath("/folder(123)"));
    }

    @Test
    public void testGetIdentityIdFromWebDavPathInvalid() {
        Assert.assertNull((Object)this.handler.getIdentityIdFromWebDavPath("/"));
    }

    @Test
    public void testTransformToJcrPathNoIdentityId() {
        Assert.assertEquals((Object)"/", (Object)this.handler.transformToJcrPath("/"));
    }

    @Test
    public void testTransformToJcrPathWithRelativePath() {
        Mockito.when((Object)this.identityManager.getIdentity(123L)).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.isUser()).thenReturn((Object)true);
        Mockito.when((Object)this.identity.getRemoteId()).thenReturn((Object)USER1);
        String path = this.handler.transformToJcrPath("/folder(123)/subdir");
        Assert.assertTrue((boolean)path.contains("subdir"));
    }

    @Test
    public void testIsIdentityRootWebDavPath() {
        Assert.assertTrue((boolean)this.handler.isIdentityRootWebDavPath(IDENTITY_PATH));
        Assert.assertFalse((boolean)this.handler.isIdentityRootWebDavPath("/(123)/subdir"));
    }
}

