/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.configuration;

import io.meeds.spring.web.security.GrantedAuthorityDefaults;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.ServletContextAware;

@Configuration
@EnableWebSecurity
public class WebSecurityConfiguration
implements ServletContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(WebSecurityConfiguration.class);
    private ServletContext servletContext;

    @Bean
    public static GrantedAuthorityDefaults grantedAuthorityDefaults() {
        return new GrantedAuthorityDefaults();
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, PortalAuthenticationManager authenticationProvider, @Qualifier(value="restRequestMatcher") RequestMatcher restRequestMatcher, @Qualifier(value="staticResourcesRequestMatcher") RequestMatcher staticResourcesRequestMatcher, @Qualifier(value="accessDeniedHandler") AccessDeniedHandler accessDeniedHandler, @Qualifier(value="requestAuthorizationManager") AuthorizationManager<RequestAuthorizationContext> requestAuthorizationManager) throws Exception {
        return (SecurityFilterChain)http.authenticationProvider((AuthenticationProvider)authenticationProvider).jee(SecurityConfigurerAdapter::and).csrf(AbstractHttpConfigurer::disable).headers(AbstractHttpConfigurer::disable).authorizeHttpRequests(customizer -> {
            try {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{restRequestMatcher})).access(requestAuthorizationManager);
            }
            catch (Exception e) {
                LOG.error("Error configuring REST endpoints security manager", (Throwable)e);
            }
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{staticResourcesRequestMatcher})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.INCLUDE, DispatcherType.FORWARD})).permitAll();
        }).exceptionHandling(exceptionCustomizer -> exceptionCustomizer.accessDeniedHandler(accessDeniedHandler)).build();
    }

    @Bean(value={"restRequestMatcher"})
    public RequestMatcher restRequestMatcher() {
        return request -> StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)(this.servletContext.getContextPath() + "/rest/"));
    }

    @Bean(value={"staticResourcesRequestMatcher"})
    public RequestMatcher staticResourcesRequestMatcher() {
        return request -> !StringUtils.startsWith((CharSequence)request.getRequestURI(), (CharSequence)(this.servletContext.getContextPath() + "/rest/"));
    }

    @Bean(value={"accessDeniedHandler"})
    public AccessDeniedHandler accessDeniedHandler() {
        return (request, response, accessDeniedException) -> {
            LOG.warn("Access denied for path {} and method {}", new Object[]{request.getRequestURI(), request.getMethod(), accessDeniedException});
            if (!response.isCommitted()) {
                request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
                response.setStatus(HttpStatus.FORBIDDEN.value());
            }
        };
    }

    @Bean(value={"requestAuthorizationManager"})
    public AuthorizationManager<RequestAuthorizationContext> requestAuthorizationManager() {
        return (authentication, object) -> {
            Authentication userAuthentication = (Authentication)authentication.get();
            return userAuthentication.isAuthenticated() ? new AuthorizationDecision(true) : new AuthorizationDecision(false);
        };
    }

    @Bean
    public StrictHttpFirewall httpFirewall() {
        StrictHttpFirewall firewall = new StrictHttpFirewall();
        firewall.setAllowedHttpMethods((Collection)PropertyConstants.ALLOW_METHODS_LIST);
        return firewall;
    }

    @Bean
    public PortalAuthenticationManager authenticationManager() {
        return new PortalAuthenticationManager();
    }

    @Generated
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

