/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.service;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;
import org.exoplatform.documents.webdav.plugin.impl.WebDavErrorHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebDavHttpMethodDispatcher {
    protected static final Log LOG = ExoLogger.getLogger(WebDavHttpMethodDispatcher.class);
    @Autowired
    private List<WebDavHttpMethodPlugin> handlers;
    @Autowired
    private WebDavErrorHandler errorHandler;
    private Map<String, WebDavHttpMethodPlugin> handlersByMethod;

    @PostConstruct
    protected void init() {
        this.handlersByMethod = this.handlers.stream().collect(Collectors.toMap(WebDavHttpMethodPlugin::getMethod, Function.identity()));
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        block6: {
            try {
                ((WebDavHttpMethodPlugin)this.handlersByMethod.getOrDefault(httpRequest.getMethod().toUpperCase(), this.errorHandler)).handle(httpRequest, httpResponse);
            }
            catch (WebDavException e) {
                this.handleWebDavException(httpRequest, httpResponse, e);
            }
            catch (Exception e) {
                WebDavException webDavException = this.getWebDavException((Throwable)e);
                if (webDavException == null) {
                    LOG.warn("Unknown error while handling WebDav method '{}' and URI '{}'", new Object[]{httpRequest.getMethod(), httpRequest.getRequestURI(), e});
                    httpResponse.setHeader("Cache-Control", "no-cache");
                    httpResponse.sendError(500, e.getMessage());
                    break block6;
                }
                this.handleWebDavException(httpRequest, httpResponse, webDavException);
            }
        }
    }

    private void handleWebDavException(HttpServletRequest httpRequest, HttpServletResponse httpResponse, WebDavException e) throws IOException {
        if (e.getHttpError() != 404 && e.getHttpError() != 403) {
            LOG.warn("Bad Request sent to WebDav using method '{}' and URI '{}'", new Object[]{httpRequest.getMethod(), httpRequest.getRequestURI(), e});
        }
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.sendError(e.getHttpError(), e.getMessage());
    }

    private WebDavException getWebDavException(Throwable e) {
        WebDavException webDavException;
        if (e.getCause() == null) {
            return null;
        }
        Throwable throwable = e.getCause();
        return throwable instanceof WebDavException ? (webDavException = (WebDavException)throwable) : this.getWebDavException(e.getCause());
    }
}

