/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.plugin.impl;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;
import org.exoplatform.documents.webdav.util.PropertyWriteUtil;
import org.springframework.stereotype.Component;

@Component
public class PropPatchWebDavHandler
extends WebDavHttpMethodPlugin {
    public PropPatchWebDavHandler() {
        super("PROPPATCH");
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws WebDavException {
        String resourcePath = this.getResourcePath(httpRequest);
        WebDavItemProperty body = this.parseRequestBodyAsWebDavItemProperty(httpRequest);
        Map result = this.documentWebDavService.saveProperties(resourcePath, this.getPropertiesToSave(body), this.getPropertiesToRemove(body), this.getLockTokens(httpRequest), httpRequest.getRemoteUser());
        this.writeResponse(result, this.getResourceUri(httpRequest), httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(Map<String, Collection<WebDavItemProperty>> result, URI uri, HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "text/xml");
        httpResponse.setStatus(207);
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();
             XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)outputStream, DEFAULT_XML_ENCODING);){
            xmlStreamWriter.setNamespaceContext(this.documentWebDavService.getNamespaceContext());
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            xmlStreamWriter.writeStartElement("DAV:", "response");
            xmlStreamWriter.writeStartElement("DAV:", "href");
            xmlStreamWriter.writeCharacters(uri.toASCIIString());
            xmlStreamWriter.writeEndElement();
            PropertyWriteUtil.writePropStats((XMLStreamWriter)xmlStreamWriter, result);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
    }

    private List<WebDavItemProperty> getPropertiesToSave(WebDavItemProperty body) {
        WebDavItemProperty requestPropSave = body.getChild(new QName("DAV:", "set"));
        return requestPropSave == null ? Collections.emptyList() : requestPropSave.getChild(new QName("DAV:", "prop")).getChildren();
    }

    private List<WebDavItemProperty> getPropertiesToRemove(WebDavItemProperty body) {
        WebDavItemProperty requestPropRemove = body.getChild(new QName("DAV:", "remove"));
        return requestPropRemove == null ? Collections.emptyList() : requestPropRemove.getChild(new QName("DAV:", "prop")).getChildren();
    }
}

