/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.plugin.impl;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.documents.webdav.model.Range;
import org.exoplatform.documents.webdav.model.RangedInputStream;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavFileDownload;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

@Component
public class GetWebDavHandler
extends WebDavHttpMethodPlugin
implements ServletContextAware {
    private static final String IMAGE_FILE_PATH = "/documents-portlet/images/file.png";
    private static final String IMAGE_FOLDER_PATH = "/documents-portlet/images/folder.png";
    private static final String HTML_LISTING_FILE = "/html/get-content.html";
    private static final String ACCEPT_RANGES_BYTES = "bytes";
    public static final String BOUNDARY = "1234567890";
    private ServletContext servletContext;
    @Value(value="${webdav.cacheControl:no-cache}")
    private String cacheControl;
    private String listingHtmlTemplate;

    public GetWebDavHandler() {
        super("GET");
    }

    @PostConstruct
    public void init() {
        block8: {
            URL resource = this.servletContext.getResource(HTML_LISTING_FILE);
            if (resource == null) break block8;
            try (InputStream is = resource.openStream();){
                this.listingHtmlTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
        }
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws WebDavException {
        this.setAccessControlHeaders(httpResponse);
        String resourcePath = this.getResourcePath(httpRequest);
        String version = httpRequest.getParameter("version");
        List ranges = this.parseRanges(httpRequest, httpResponse);
        if (ranges == null) {
            return;
        }
        if (!this.checkModified(httpRequest, resourcePath, version)) {
            httpResponse.setStatus(304);
            return;
        }
        if (this.documentWebDavService.isFile(resourcePath)) {
            WebDavFileDownload fileDownload = this.documentWebDavService.download(resourcePath, version, this.getBaseUrl(httpRequest), httpRequest.getRemoteUser());
            long lastModifiedDate = fileDownload.getLastModifiedDate();
            long contentLength = fileDownload.getContentLength();
            String contentType = fileDownload.getMimeType();
            if (contentLength == 0L || ranges.isEmpty()) {
                httpResponse.setHeader("Content-Length", String.valueOf(contentLength));
                this.setAcceptRangesHeader(httpResponse);
                this.setContentTypeHeader(httpResponse, contentType);
                this.setCacheHeaders(httpResponse, lastModifiedDate);
                httpResponse.setStatus(200);
                this.writeResponseStream(httpResponse, fileDownload);
            } else if (ranges.size() == 1) {
                Range range = (Range)ranges.get(0);
                if (!this.validateRange(range, contentLength)) {
                    httpResponse.setHeader("Content-Range", "bytes */" + contentLength);
                    httpResponse.setStatus(416);
                } else {
                    httpResponse.setHeader("Content-Length", String.valueOf(range.getEnd() - range.getStart() + 1L));
                    httpResponse.setHeader("Content-Range", "bytes " + range.getStart() + "-" + range.getEnd() + "/" + contentLength);
                    this.setAcceptRangesHeader(httpResponse);
                    this.setContentTypeHeader(httpResponse, contentType);
                    this.setCacheHeaders(httpResponse, lastModifiedDate);
                    httpResponse.setStatus(206);
                    this.writeResponseRange(httpResponse, fileDownload, range);
                }
            } else {
                httpResponse.setHeader("Content-Type", "multipart/byteranges; boundary=1234567890");
                httpResponse.setDateHeader("Last-Modified", lastModifiedDate);
                this.setAcceptRangesHeader(httpResponse);
                this.writeResponseRanges(httpResponse, fileDownload, ranges);
            }
        } else {
            WebDavItem webDavItem = this.documentWebDavService.get(resourcePath, "include", Collections.singleton(PropertyConstants.DISPLAYNAME), false, 1, this.getBaseUrl(httpRequest), httpRequest.getRemoteUser());
            httpResponse.setHeader("Content-Type", "text/html");
            httpResponse.setStatus(200);
            this.writeResponseHtml(httpResponse, webDavItem);
        }
    }

    private void writeResponseHtml(HttpServletResponse httpResponse, WebDavItem webDavItem) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("<a href=\"./..\"><img src=\"%s\" alt=\"\"> ..</a>", IMAGE_FOLDER_PATH));
        builder.append("<br>");
        if (CollectionUtils.isNotEmpty((Collection)webDavItem.getChildren())) {
            webDavItem.getChildren().stream().map(item -> String.format("<a href=\"%s\"><img src=\"%s\" alt=\"\"> %s</a><br>", item.getIdentifier(), item.isFile() ? IMAGE_FILE_PATH : IMAGE_FOLDER_PATH, item.getProperty(PropertyConstants.DISPLAYNAME).getValue())).forEach(builder::append);
        }
        String content = this.listingHtmlTemplate.replace("@Content@", builder.toString());
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();){
            IOUtils.write((String)content, (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
        }
    }

    private void writeResponseStream(HttpServletResponse httpResponse, WebDavFileDownload fileDownload) throws IOException {
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();
             InputStream inputStream = fileDownload.getInputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    private void writeResponseRanges(HttpServletResponse httpResponse, WebDavFileDownload fileDownload, List<Range> ranges) throws IOException {
        String contentType = fileDownload.getMimeType();
        long contentLength = fileDownload.getContentLength();
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();
             InputStream inputStream = fileDownload.getInputStream();){
            if (ranges.stream().anyMatch(range -> !this.validateRange(range, contentLength))) {
                httpResponse.setHeader("Content-Range", "bytes */" + contentLength);
                httpResponse.setStatus(416);
            } else {
                httpResponse.setStatus(206);
                this.writeResponseRanges(inputStream, (OutputStream)outputStream, contentLength, contentType, ranges);
            }
        }
    }

    private void writeResponseRange(HttpServletResponse httpResponse, WebDavFileDownload fileDownload, Range range) throws IOException {
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();
             InputStream inputStream = fileDownload.getInputStream();){
            IOUtils.copy((InputStream)new RangedInputStream(inputStream, range.getStart(), range.getEnd()), (OutputStream)outputStream);
        }
    }

    public void writeResponseRanges(InputStream inputStream, OutputStream outputStream, long contentLength, String contentType, List<Range> ranges) throws IOException {
        for (Range range : ranges) {
            this.println(outputStream);
            this.print("--1234567890", outputStream);
            this.println(outputStream);
            this.print("Content-Type: " + contentType, outputStream);
            this.println(outputStream);
            this.print("Content-Range: bytes " + range.getStart() + "-" + range.getEnd() + "/" + contentLength, outputStream);
            this.println(outputStream);
            this.println(outputStream);
            RangedInputStream rangedInputStream = new RangedInputStream(inputStream, range.getStart(), range.getEnd());
            byte[] buff = new byte[4132];
            int rd = -1;
            while ((rd = rangedInputStream.read(buff)) != -1) {
                outputStream.write(buff, 0, rd);
            }
            rangedInputStream.close();
        }
        this.println(outputStream);
        this.print("--1234567890--", outputStream);
        this.println(outputStream);
    }

    private void setAccessControlHeaders(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        httpResponse.setHeader("Access-Control-Allow-Methods", "CANCELUPLOAD, CHECKIN, CHECKOUT, COPY, DELETE, GET, HEAD, LOCK, MKCALENDAR, MKCOL, MOVE, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, REPORT, SEARCH, UNCHECKOUT, UNLOCK, UPDATE, VERSION-CONTROL");
        httpResponse.setHeader("Access-Control-Allow-Headers", "*");
        httpResponse.setHeader("Access-Control-Expose-Header", "DAV, content-length, Allow");
        httpResponse.setHeader("Access-Control-Max-Age", "3600");
    }

    private void setAcceptRangesHeader(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Accept-Ranges", ACCEPT_RANGES_BYTES);
    }

    private void setContentTypeHeader(HttpServletResponse httpResponse, String contentType) {
        httpResponse.setHeader("Content-Type", contentType);
    }

    private void setCacheHeaders(HttpServletResponse httpResponse, long lastModifiedDate) {
        httpResponse.setHeader("ETag", String.format("W/%s", lastModifiedDate));
        httpResponse.setHeader("Cache-Control", this.cacheControl);
        httpResponse.setDateHeader("Last-Modified", lastModifiedDate);
    }

    private void print(String s, OutputStream ostream) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            ostream.write(c);
        }
    }

    private void println(OutputStream ostream) throws IOException {
        ostream.write(13);
        ostream.write(10);
    }

    private List<Range> parseRanges(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String rangeHeader = httpRequest.getHeader("Range");
        if (StringUtils.startsWith((CharSequence)rangeHeader, (CharSequence)"bytes=")) {
            String[] tokens;
            ArrayList<Range> ranges = new ArrayList<Range>();
            String rangeString = rangeHeader.substring(rangeHeader.indexOf("=") + 1);
            for (String token : tokens = rangeString.split(",")) {
                Range range = new Range();
                int dash = (token = token.trim()).indexOf("-");
                if (dash == -1) {
                    this.writeResponse(httpResponse, 416, "Requested Range Not Satisfiable");
                    return null;
                }
                if (dash == 0) {
                    range.setStart(Long.parseLong(token));
                    range.setEnd(-1L);
                } else if (dash > 0) {
                    range.setStart(Long.parseLong(token.substring(0, dash)));
                    if (dash < token.length() - 1) {
                        range.setEnd(Long.parseLong(token.substring(dash + 1, token.length())));
                    } else {
                        range.setEnd(-1L);
                    }
                }
                ranges.add(range);
            }
            return ranges;
        }
        return Collections.emptyList();
    }

    private boolean validateRange(Range range, long contentLength) {
        long start = range.getStart();
        long end = range.getEnd();
        if (start < 0L && end == -1L) {
            if (-1L * start >= contentLength) {
                start = 0L;
                end = contentLength - 1L;
            } else {
                start = contentLength + start;
                end = contentLength - 1L;
            }
        }
        if (start >= 0L && end == -1L) {
            end = contentLength - 1L;
        }
        if (end >= contentLength) {
            end = contentLength - 1L;
        }
        if (start >= 0L && end >= 0L && start <= end) {
            range.setStart(start);
            range.setEnd(end);
            return true;
        }
        return false;
    }

    @Generated
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

