/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.plugin.impl;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.model.WebDavLockResponse;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;
import org.exoplatform.documents.webdav.util.PropertyWriteUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LockWebDavHandler
extends WebDavHttpMethodPlugin {
    @Value(value="${webdav.lockTimeout:86400}")
    private int lockTimeout;

    public LockWebDavHandler() {
        super("LOCK");
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws WebDavException {
        WebDavItemProperty itemProperty = this.parseRequestBodyAsWebDavItemProperty(httpRequest);
        WebDavLockResponse lockResponse = this.documentWebDavService.lock(this.getResourcePath(httpRequest), this.getDepthInt(httpRequest), this.lockTimeout, itemProperty == null, this.getLockTokens(httpRequest), httpRequest.getRemoteUser());
        this.writeResponse(String.format("%s:%s", "opaquelocktoken", lockResponse.getToken()), lockResponse.getOwner(), itemProperty == null, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(String lockToken, String lockOwner, boolean bodyIsEmpty, HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "text/xml");
        if (bodyIsEmpty) {
            httpResponse.setHeader("lock-token", "<" + lockToken + ">");
        }
        httpResponse.setStatus(200);
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();
             XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)outputStream, DEFAULT_XML_ENCODING);){
            xmlStreamWriter.setNamespaceContext(this.documentWebDavService.getNamespaceContext());
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "prop", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            WebDavItemProperty lockDiscovery = this.lockDiscovery(lockToken, lockOwner, (long)this.lockTimeout);
            PropertyWriteUtil.writeProperty((XMLStreamWriter)xmlStreamWriter, (WebDavItemProperty)lockDiscovery);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
    }

    public WebDavItemProperty lockDiscovery(String token, String lockOwner, long timeOut) {
        WebDavItemProperty lockDiscovery = new WebDavItemProperty(new QName("DAV:", "lockdiscovery"));
        WebDavItemProperty activeLock = lockDiscovery.addChild(new WebDavItemProperty(new QName("DAV:", "activelock")));
        WebDavItemProperty lockType = activeLock.addChild(new WebDavItemProperty(new QName("DAV:", "locktype")));
        lockType.addChild(new WebDavItemProperty(new QName("DAV:", "write")));
        WebDavItemProperty lockScope = activeLock.addChild(new WebDavItemProperty(new QName("DAV:", "lockscope")));
        lockScope.addChild(new WebDavItemProperty(new QName("DAV:", "exclusive")));
        WebDavItemProperty depth = activeLock.addChild(new WebDavItemProperty(new QName("DAV:", "depth")));
        depth.setValue("Infinity");
        if (lockOwner != null) {
            WebDavItemProperty owner = activeLock.addChild(new WebDavItemProperty(new QName("DAV:", "owner")));
            owner.setValue(lockOwner);
        }
        WebDavItemProperty timeout = activeLock.addChild(new WebDavItemProperty(new QName("DAV:", "timeout")));
        timeout.setValue("Second-" + timeOut);
        if (token != null) {
            WebDavItemProperty lockToken = activeLock.addChild(new WebDavItemProperty(new QName("DAV:", "locktoken")));
            WebDavItemProperty lockHref = lockToken.addChild(new WebDavItemProperty(new QName("DAV:", "href")));
            lockHref.setValue(token);
        }
        return lockDiscovery;
    }
}

