/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.workflow;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UIPermissionSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.plugins.workflow.WorkflowPublicationConfig;
import org.exoplatform.services.ecm.publication.plugins.workflow.WorkflowPublicationPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:resources/templates/workflow/workflowPublicationDialog.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddDestPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddBackupPathActionListener.class}, phase=Event.Phase.DECODE)})
public class UIWorkflowPublicationActionForm
extends UIForm
implements UISelectable {
    private Node currentNode;
    private boolean isEdit = false;
    private String repositoryName;
    private String workspaceName;
    private String lifecycle;
    private final String FIELD_VALIDATOR = "fieldValidator";
    private final String FIELD_DESTPATH = "fieldDestPath";
    private final String FIELD_WORKSPACE = "fieldWorkspace";
    private final String FIELD_BACKUP = "fieldBackup";
    private final String FIELD_BACKUP_WORKSPACE = "fieldBackupWorkspace";
    private final String WORKFLOW_VALIDATOR = "workflow_validator";
    private final String WORKFLOW_DESTPATH = "workflow_destpath";
    private final String WORKFLOW_BACUP = "workflow_backuppath";
    private RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
    private final String FIELD_VALIDATOR_EDIT = "fieldValidatorEdit";
    private final String FIELD_DESTPATH_EDIT = "fieldDestPathEdit";
    private final String FIELD_BACKUPWORKSPACE_EDIT = "fieldBackupWorkspaceEdit";
    private final String FIELD_BACKUP_EDIT = "fieldBackupEdit";

    public UIWorkflowPublicationActionForm() throws Exception {
        this.repositoryName = this.repositoryService.getDefaultRepository().getConfiguration().getName();
    }

    private void initSelectBox(UIFormSelectBox selectBox) throws Exception {
        String[] wsNames = this.repositoryService.getRepository(this.repositoryName).getWorkspaceNames();
        ArrayList<SelectItemOption> workspaceList = new ArrayList<SelectItemOption>();
        for (String wsName : wsNames) {
            workspaceList.add(new SelectItemOption(wsName, (Object)wsName));
        }
        selectBox.setOptions(workspaceList);
    }

    public void setWorkspaceName(String workspace) {
        this.workspaceName = workspace;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setIsEdit(boolean isEdit_) {
        this.isEdit = isEdit_;
    }

    public boolean getIsEdit() {
        return this.isEdit;
    }

    public Session getSession() throws Exception {
        return this.getCurrentNode().getSession();
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public WorkflowPublicationConfig getConfig() {
        return WorkflowPublicationPlugin.config;
    }

    public String getLinkStateImage(Locale locale) {
        try {
            DownloadService dS = (DownloadService)this.getApplicationComponent(DownloadService.class);
            PublicationService service = (PublicationService)this.getApplicationComponent(PublicationService.class);
            byte[] bytes = service.getStateImage(this.getCurrentNode(), locale);
            ByteArrayInputStream iS = new ByteArrayInputStream(bytes);
            String id = dS.addDownloadResource((DownloadResource)new InputStreamDownloadResource((InputStream)iS, "image/gif"));
            return dS.getDownloadLink(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error in getStateImage";
        }
    }

    public void createNewAction(Node node, String lifecycle_, boolean isEdit_) throws Exception {
        this.reset();
        this.currentNode = node;
        this.lifecycle = lifecycle_;
        this.isEdit = isEdit_;
        this.setActions(new String[]{"Save", "Back"});
        if (WorkflowPublicationPlugin.config.isDestPath_currentFolder()) {
            WorkflowPublicationPlugin.config.setDestPath(this.currentNode.getParent().getPath());
        }
        if (WorkflowPublicationPlugin.config.isEditable()) {
            UIFormInputSetWithAction inputSetValidator = new UIFormInputSetWithAction("workflow_validator");
            UIFormStringInput validatorStringInput = new UIFormStringInput("fieldValidator", "fieldValidator", null);
            validatorStringInput.setEditable(false);
            validatorStringInput.setValue((Object)WorkflowPublicationPlugin.config.getValidator());
            inputSetValidator.addUIFormInput((UIFormInput)validatorStringInput);
            inputSetValidator.setActionInfo("fieldValidator", new String[]{"AddPermission"});
            this.addUIComponentInput((UIComponent)inputSetValidator);
            UIFormSelectBox selectBoxWorkspace = new UIFormSelectBox("fieldWorkspace", "fieldWorkspace", null);
            this.initSelectBox(selectBoxWorkspace);
            selectBoxWorkspace.setValue(WorkflowPublicationPlugin.config.getTo_workspace());
            this.addUIFormInput((UIFormInput)selectBoxWorkspace);
            UIFormInputSetWithAction inputSetDestPath = new UIFormInputSetWithAction("workflow_destpath");
            UIFormStringInput destPathStringInput = new UIFormStringInput("fieldDestPath", "fieldDestPath", null);
            destPathStringInput.setEditable(false);
            destPathStringInput.setValue((Object)WorkflowPublicationPlugin.config.getDestPath());
            inputSetDestPath.addUIFormInput((UIFormInput)destPathStringInput);
            inputSetDestPath.setActionInfo("fieldDestPath", new String[]{"AddDestPath"});
            this.addUIComponentInput((UIComponent)inputSetDestPath);
            UIFormSelectBox selectBoxBackupWorkspace = new UIFormSelectBox("fieldBackupWorkspace", "fieldBackupWorkspace", null);
            this.initSelectBox(selectBoxBackupWorkspace);
            selectBoxBackupWorkspace.setValue(WorkflowPublicationPlugin.config.getBackupWorkflow());
            this.addUIFormInput((UIFormInput)selectBoxBackupWorkspace);
            UIFormInputSetWithAction inputSetBackup = new UIFormInputSetWithAction("workflow_backuppath");
            UIFormStringInput backupPathStringInput = new UIFormStringInput("fieldBackup", "fieldBackup", null);
            backupPathStringInput.setEditable(false);
            backupPathStringInput.setValue((Object)WorkflowPublicationPlugin.config.getBackupPath());
            inputSetBackup.addUIFormInput((UIFormInput)backupPathStringInput);
            inputSetBackup.setActionInfo("fieldBackup", new String[]{"AddBackupPath"});
            this.addUIComponentInput((UIComponent)inputSetBackup);
        } else {
            UIFormStringInput validatorStringInput = new UIFormStringInput("fieldValidatorEdit", "fieldValidatorEdit", null);
            validatorStringInput.setEditable(false);
            validatorStringInput.setValue((Object)WorkflowPublicationPlugin.config.getValidator());
            this.addUIFormInput((UIFormInput)validatorStringInput);
            UIFormSelectBox selectBoxWorkspace = new UIFormSelectBox("fieldWorkspace", "fieldWorkspace", null);
            this.initSelectBox(selectBoxWorkspace);
            selectBoxWorkspace.setValue(WorkflowPublicationPlugin.config.getTo_workspace());
            selectBoxWorkspace.setDisabled(true);
            this.addUIFormInput((UIFormInput)selectBoxWorkspace);
            UIFormStringInput destPathStringInput = new UIFormStringInput("fieldDestPathEdit", "fieldDestPathEdit", null);
            destPathStringInput.setEditable(false);
            destPathStringInput.setValue((Object)WorkflowPublicationPlugin.config.getDestPath());
            this.addUIFormInput((UIFormInput)destPathStringInput);
            UIFormSelectBox selectBoxBackupWorkspace = new UIFormSelectBox("fieldBackupWorkspaceEdit", "fieldBackupWorkspaceEdit", null);
            this.initSelectBox(selectBoxBackupWorkspace);
            selectBoxBackupWorkspace.setValue(WorkflowPublicationPlugin.config.getBackupWorkflow());
            selectBoxBackupWorkspace.setDisabled(true);
            this.addUIFormInput((UIFormInput)selectBoxBackupWorkspace);
            UIFormStringInput backupPathStringInput = new UIFormStringInput("fieldBackupEdit", "fieldBackupEdit", null);
            backupPathStringInput.setEditable(false);
            backupPathStringInput.setValue((Object)WorkflowPublicationPlugin.config.getBackupPath());
            this.addUIFormInput((UIFormInput)backupPathStringInput);
        }
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)value.toString());
        UIContainer container = null;
        if (this.getIsEdit()) {
            UIPopupWindow popupWindow = (UIPopupWindow)this.getParent();
            container = (UIContainer)popupWindow.getParent();
            container.removeChildById("PopupComponent");
        } else {
            container = (UIContainer)this.getParent();
            container.removeChildById("PopupComponent");
        }
    }

    public String getRepositoryName() throws Exception {
        return this.repositoryName;
    }

    public void initPopupPermission(UIContainer uiContainer, String membership) throws Exception {
        if (uiContainer.getChildById("PopupComponent") != null) {
            uiContainer.removeChildById("PopupComponent");
        }
        UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.addChild(UIPopupWindow.class, null, "PopupComponent");
        uiPopup.setWindowSize(560, 350);
        UIPermissionSelector uiECMPermission = (UIPermissionSelector)uiContainer.createUIComponent(UIPermissionSelector.class, null, null);
        uiECMPermission.setSelectedMembership(true);
        if (membership != null && membership.indexOf(":/") > -1) {
            String[] arrMember = membership.split(":/");
            uiECMPermission.setCurrentPermission("/" + arrMember[1]);
        }
        uiPopup.setUIComponent((UIComponent)uiECMPermission);
        UIWorkflowPublicationActionForm workflowForm = (UIWorkflowPublicationActionForm)this.findFirstComponentOfType(UIWorkflowPublicationActionForm.class);
        if (WorkflowPublicationPlugin.config.isEditable()) {
            uiECMPermission.setSourceComponent((UIComponent)workflowForm, new String[]{"fieldValidator"});
        } else {
            uiECMPermission.setSourceComponent((UIComponent)workflowForm, new String[]{"fieldValidatorEdit"});
        }
        uiPopup.setShow(true);
    }

    private String getSystemWorkspaceName(String repository) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        return manageableRepository.getConfiguration().getSystemWorkspaceName();
    }

    public String getLabel(String fieldName, String type) throws Exception {
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        WorkflowPublicationPlugin plugin = (WorkflowPublicationPlugin)((Object)publicationService.getPublicationPlugins().get(this.getLifecycle()));
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        try {
            return plugin.getLocalizedAndSubstituteMessage(locale, this.getId() + "." + type + "." + fieldName, null);
        }
        catch (Exception e) {
            return fieldName;
        }
    }

    public void initPopupJCRBrowser(UIContainer uiContainer, String workspace, boolean isDisable, String sourceComponent) throws Exception {
        if (uiContainer.getChildById("PopupComponent") != null) {
            uiContainer.removeChildById("PopupComponent");
        }
        String repository = this.getRepositoryName();
        UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.addChild(UIPopupWindow.class, null, "PopupComponent");
        uiPopup.setWindowSize(610, 300);
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)uiContainer.createUIComponent(UIOneNodePathSelector.class, null, null);
        uiOneNodePathSelector.setIsDisable(workspace, isDisable);
        uiOneNodePathSelector.setShowRootPathSelect(true);
        uiOneNodePathSelector.setRootNodeLocation(repository, workspace, "/");
        if (SessionProviderFactory.isAnonim()) {
            uiOneNodePathSelector.init(SessionProviderFactory.createAnonimProvider());
        } else if (workspace.equals(this.getSystemWorkspaceName(repository))) {
            uiOneNodePathSelector.init(SessionProviderFactory.createSystemProvider());
        } else {
            uiOneNodePathSelector.init(SessionProviderFactory.createSessionProvider());
        }
        uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
        UIWorkflowPublicationActionForm workflowForm = (UIWorkflowPublicationActionForm)this.findFirstComponentOfType(UIWorkflowPublicationActionForm.class);
        uiOneNodePathSelector.setSourceComponent((UIComponent)workflowForm, new String[]{sourceComponent});
        uiPopup.setShow(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIWorkflowPublicationActionForm> {
        public void execute(Event<UIWorkflowPublicationActionForm> event) throws Exception {
            UIWorkflowPublicationActionForm uiForm = (UIWorkflowPublicationActionForm)((Object)event.getSource());
            if (uiForm.getIsEdit()) {
                UIPopupWindow popupWindow = (UIPopupWindow)uiForm.getParent();
                UIContainer uicontainer = (UIContainer)popupWindow.getParent();
                popupWindow.setRendered(false);
                if (uicontainer.getChildById("PopupEditWorkflow") != null) {
                    uicontainer.removeChildById("PopupEditWorkflow");
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uicontainer);
                return;
            }
            UIContainer container = (UIContainer)uiForm.getParent();
            UIPopupWindow popupWindow = (UIPopupWindow)container.getParent();
            popupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(popupWindow.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddBackupPathActionListener
    extends EventListener<UIWorkflowPublicationActionForm> {
        public void execute(Event<UIWorkflowPublicationActionForm> event) throws Exception {
            UIWorkflowPublicationActionForm workflowForm = (UIWorkflowPublicationActionForm)((Object)event.getSource());
            UIContainer uiContainer = null;
            if (workflowForm.getIsEdit()) {
                UIPopupWindow popupWindow = (UIPopupWindow)workflowForm.getParent();
                uiContainer = (UIContainer)popupWindow.getParent();
            } else {
                uiContainer = (UIContainer)workflowForm.getParent();
            }
            if (WorkflowPublicationPlugin.config.isEditable()) {
                workflowForm.initPopupJCRBrowser(uiContainer, "backup", true, "fieldBackup");
            } else {
                workflowForm.initPopupJCRBrowser(uiContainer, "backup", true, "fieldBackupEdit");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddDestPathActionListener
    extends EventListener<UIWorkflowPublicationActionForm> {
        public void execute(Event<UIWorkflowPublicationActionForm> event) throws Exception {
            UIWorkflowPublicationActionForm workflowForm = (UIWorkflowPublicationActionForm)((Object)event.getSource());
            UIContainer uiContainer = null;
            String workspace = (String)workflowForm.getUIFormSelectBox("fieldWorkspace").getValue();
            if (workflowForm.getIsEdit()) {
                UIPopupWindow popupWindow = (UIPopupWindow)workflowForm.getParent();
                uiContainer = (UIContainer)popupWindow.getParent();
            } else {
                uiContainer = (UIContainer)workflowForm.getParent();
            }
            if (WorkflowPublicationPlugin.config.isEditable()) {
                workflowForm.initPopupJCRBrowser(uiContainer, workspace, true, "fieldDestPath");
            } else {
                workflowForm.initPopupJCRBrowser(uiContainer, workspace, true, "fieldDestPathEdit");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPermissionActionListener
    extends EventListener<UIWorkflowPublicationActionForm> {
        public void execute(Event<UIWorkflowPublicationActionForm> event) throws Exception {
            UIWorkflowPublicationActionForm workflowForm = (UIWorkflowPublicationActionForm)((Object)event.getSource());
            UIContainer uiContainer = null;
            String membership = WorkflowPublicationPlugin.config.isEditable() ? (String)workflowForm.getUIStringInput("fieldValidator").getValue() : (String)workflowForm.getUIStringInput("fieldValidatorEdit").getValue();
            if (workflowForm.getIsEdit()) {
                UIPopupWindow popupWindow = (UIPopupWindow)workflowForm.getParent();
                uiContainer = (UIContainer)popupWindow.getParent();
            } else {
                uiContainer = (UIContainer)workflowForm.getParent();
            }
            workflowForm.initPopupPermission(uiContainer, membership);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIWorkflowPublicationActionForm> {
        public void execute(Event<UIWorkflowPublicationActionForm> event) throws Exception {
            String backupWorkspace;
            String backupPath;
            String destPath;
            String validator;
            UIWorkflowPublicationActionForm workflowForm = (UIWorkflowPublicationActionForm)((Object)event.getSource());
            PublicationService publicationService = (PublicationService)workflowForm.getApplicationComponent(PublicationService.class);
            String destWorkspace = (String)workflowForm.getUIFormSelectBox("fieldWorkspace").getValue();
            if (WorkflowPublicationPlugin.config.isEditable()) {
                validator = (String)workflowForm.getUIStringInput("fieldValidator").getValue();
                destPath = (String)workflowForm.getUIStringInput("fieldDestPath").getValue();
                backupPath = (String)workflowForm.getUIStringInput("fieldBackup").getValue();
                backupWorkspace = (String)workflowForm.getUIStringInput("fieldBackupWorkspace").getValue();
                if (validator == null || validator.trim().equals("") || destPath == null || destPath.trim().equals("") || backupPath == null || backupPath.trim().equals("")) {
                    WorkflowPublicationPlugin plugin = (WorkflowPublicationPlugin)((Object)publicationService.getPublicationPlugins().get("Workflow"));
                    Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
                    String msg = plugin.getLocalizedAndSubstituteMessage(locale, "UIWorkflowPublicationActionForm.msg.fillfield", null);
                    UIApplication uiApp = (UIApplication)workflowForm.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage(msg, null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            } else {
                validator = (String)workflowForm.getUIStringInput("fieldValidatorEdit").getValue();
                destPath = (String)workflowForm.getUIStringInput("fieldDestPathEdit").getValue();
                backupPath = (String)workflowForm.getUIStringInput("fieldBackupEdit").getValue();
                backupWorkspace = (String)workflowForm.getUIStringInput("fieldBackupWorkspaceEdit").getValue();
            }
            HashMap<String, String> contextMap = new HashMap<String, String>();
            contextMap.put(WorkflowPublicationPlugin.VALIDATOR, validator);
            contextMap.put(WorkflowPublicationPlugin.DEST_WORKSPACE, destWorkspace);
            contextMap.put(WorkflowPublicationPlugin.DESTPATH, destPath);
            contextMap.put(WorkflowPublicationPlugin.BACUP_PATH, backupPath);
            contextMap.put(WorkflowPublicationPlugin.BACUP_WORKSPACE, backupWorkspace);
            ((PublicationPlugin)publicationService.getPublicationPlugins().get(workflowForm.getLifecycle())).changeState(workflowForm.getCurrentNode(), "content publishing", contextMap);
            if (workflowForm.getIsEdit()) {
                UIPopupWindow popupWindow = (UIPopupWindow)workflowForm.getParent();
                UIContainer uicontainer = (UIContainer)popupWindow.getParent();
                popupWindow.setRendered(false);
                if (uicontainer.getChildById("PopupEditWorkflow") != null) {
                    uicontainer.removeChildById("PopupEditWorkflow");
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uicontainer);
                return;
            }
            UIContainer container = (UIContainer)workflowForm.getAncestorOfType(UIContainer.class);
            UIComponent component = container.getParent();
            if (component != null) {
                component.setRendered(false);
                event.getRequestContext().addUIComponentToUpdateByAjax(component.getParent());
            }
        }
    }
}

