/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.application;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.lock.LockManager;

public class LockManagerListener
implements HttpSessionListener {
    public void sessionCreated(HttpSessionEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            HttpSession httpSession = event.getSession();
            Map lockedNodes = (Map)httpSession.getAttribute(LockManager.class.getName());
            if (lockedNodes == null || lockedNodes.values().isEmpty()) {
                return;
            }
            ExoContainer eXoContainer = ExoContainerContext.getCurrentContainer();
            RepositoryService repositoryService = (RepositoryService)eXoContainer.getComponentInstanceOfType(RepositoryService.class);
            String key = null;
            String nodePath = null;
            String repoName = null;
            String workspaceName = null;
            String lockToken = null;
            String[] temp = null;
            String[] location = null;
            Session session = null;
            Iterator iter = lockedNodes.keySet().iterator();
            while (iter.hasNext()) {
                try {
                    key = (String)iter.next();
                    temp = key.split(":/:");
                    nodePath = temp[1];
                    location = temp[0].split("/::/");
                    repoName = location[0];
                    workspaceName = location[1];
                    session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repoName));
                    lockToken = (String)lockedNodes.get(key);
                    session.addLockToken(lockToken);
                    Node node = (Node)session.getItem(nodePath);
                    node.unlock();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            sessionProvider.close();
        }
    }
}

