/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.drives.impl.ManageDrivePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageDriveServiceImpl
implements ManageDriveService,
Startable {
    private static String WORKSPACE = "exo:workspace".intern();
    private static String PERMISSIONS = "exo:accessPermissions".intern();
    private static String VIEWS = "exo:views".intern();
    private static String ICON = "exo:icon".intern();
    private static String PATH = "exo:path".intern();
    private static String VIEW_REFERENCES = "exo:viewPreferences".intern();
    private static String VIEW_NON_DOCUMENT = "exo:viewNonDocument".intern();
    private static String VIEW_SIDEBAR = "exo:viewSideBar".intern();
    private static String SHOW_HIDDEN_NODE = "exo:showHiddenNode".intern();
    private static String ALLOW_CREATE_FOLDER = "exo:allowCreateFolder".intern();
    private List<ManageDrivePlugin> drivePlugins_ = new ArrayList<ManageDrivePlugin>();
    private RepositoryService repositoryService_;
    private String baseDrivePath_;
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public ManageDriveServiceImpl(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.repositoryService_ = jcrService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.baseDrivePath_ = this.nodeHierarchyCreator_.getJcrPath("exoDrivesPath");
    }

    public void start() {
        try {
            for (ManageDrivePlugin plugin : this.drivePlugins_) {
                plugin.init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        for (ManageDrivePlugin plugin : this.drivePlugins_) {
            plugin.init(repository);
        }
    }

    public void setManageDrivePlugin(ManageDrivePlugin drivePlugin) {
        this.drivePlugins_.add(drivePlugin);
    }

    @Override
    public List<DriveData> getAllDrives(String repository) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        NodeIterator itr = driveHome.getNodes();
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        while (itr.hasNext()) {
            DriveData data = new DriveData();
            Node drive = itr.nextNode();
            data.setName(drive.getName());
            data.setWorkspace(drive.getProperty(WORKSPACE).getString());
            data.setHomePath(drive.getProperty(PATH).getString());
            data.setPermissions(drive.getProperty(PERMISSIONS).getString());
            data.setViews(drive.getProperty(VIEWS).getString());
            data.setIcon(drive.getProperty(ICON).getString());
            data.setViewPreferences(Boolean.parseBoolean(drive.getProperty(VIEW_REFERENCES).getString()));
            data.setViewNonDocument(Boolean.parseBoolean(drive.getProperty(VIEW_NON_DOCUMENT).getString()));
            data.setViewSideBar(Boolean.parseBoolean(drive.getProperty(VIEW_SIDEBAR).getString()));
            data.setShowHiddenNode(Boolean.parseBoolean(drive.getProperty(SHOW_HIDDEN_NODE).getString()));
            data.setAllowCreateFolder(drive.getProperty(ALLOW_CREATE_FOLDER).getString());
            driveList.add(data);
        }
        session.logout();
        return driveList;
    }

    @Override
    public DriveData getDriveByName(String name, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (driveHome.hasNode(name)) {
            Node drive = driveHome.getNode(name);
            DriveData data = new DriveData();
            data.setName(drive.getName());
            data.setWorkspace(drive.getProperty(WORKSPACE).getString());
            data.setHomePath(drive.getProperty(PATH).getString());
            data.setPermissions(drive.getProperty(PERMISSIONS).getString());
            data.setViews(drive.getProperty(VIEWS).getString());
            data.setIcon(drive.getProperty(ICON).getString());
            data.setViewPreferences(Boolean.parseBoolean(drive.getProperty(VIEW_REFERENCES).getString()));
            data.setViewNonDocument(Boolean.parseBoolean(drive.getProperty(VIEW_NON_DOCUMENT).getString()));
            data.setViewSideBar(Boolean.parseBoolean(drive.getProperty(VIEW_SIDEBAR).getString()));
            data.setShowHiddenNode(Boolean.parseBoolean(drive.getProperty(SHOW_HIDDEN_NODE).getString()));
            data.setAllowCreateFolder(drive.getProperty(ALLOW_CREATE_FOLDER).getString());
            session.logout();
            return data;
        }
        session.logout();
        return null;
    }

    @Override
    public void addDrive(String name, String workspace, String permissions, String homePath, String views, String icon, boolean viewReferences, boolean viewNonDocument, boolean viewSideBar, boolean showHiddenNode, String repository, String allowCreateFolder) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (!driveHome.hasNode(name)) {
            Node driveNode = driveHome.addNode(name, "exo:drive");
            driveNode.setProperty(WORKSPACE, workspace);
            driveNode.setProperty(PERMISSIONS, permissions);
            driveNode.setProperty(PATH, homePath);
            driveNode.setProperty(VIEWS, views);
            driveNode.setProperty(ICON, icon);
            driveNode.setProperty(VIEW_REFERENCES, Boolean.toString(viewReferences));
            driveNode.setProperty(VIEW_NON_DOCUMENT, Boolean.toString(viewNonDocument));
            driveNode.setProperty(VIEW_SIDEBAR, Boolean.toString(viewSideBar));
            driveNode.setProperty(ALLOW_CREATE_FOLDER, allowCreateFolder);
            driveNode.setProperty(SHOW_HIDDEN_NODE, Boolean.toString(showHiddenNode));
            driveHome.save();
        } else {
            Node driveNode = driveHome.getNode(name);
            driveNode.setProperty(WORKSPACE, workspace);
            driveNode.setProperty(PERMISSIONS, permissions);
            driveNode.setProperty(PATH, homePath);
            driveNode.setProperty(VIEWS, views);
            driveNode.setProperty(ICON, icon);
            driveNode.setProperty(VIEW_REFERENCES, Boolean.toString(viewReferences));
            driveNode.setProperty(VIEW_NON_DOCUMENT, Boolean.toString(viewNonDocument));
            driveNode.setProperty(VIEW_SIDEBAR, Boolean.toString(viewSideBar));
            driveNode.setProperty(ALLOW_CREATE_FOLDER, allowCreateFolder);
            driveNode.setProperty(SHOW_HIDDEN_NODE, Boolean.toString(showHiddenNode));
            driveNode.save();
        }
        session.save();
        session.logout();
    }

    @Override
    public List<DriveData> getAllDriveByPermission(String permission, String repository) throws Exception {
        ArrayList<DriveData> driveByPermission = new ArrayList<DriveData>();
        try {
            List<DriveData> driveList = this.getAllDrives(repository);
            for (DriveData drive : driveList) {
                if (!drive.hasPermission(drive.getAllPermissions(), permission)) continue;
                driveByPermission.add(drive);
            }
            if (this.getDriveByName("Private", repository) != null) {
                driveByPermission.add(this.getDriveByName("Private", repository));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return driveByPermission;
    }

    @Override
    public void removeDrive(String driveName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (driveHome.hasNode(driveName)) {
            driveHome.getNode(driveName).remove();
            driveHome.save();
        }
        session.logout();
    }

    private Session getSession(String repository) throws Exception {
        ManageableRepository manaRepository = this.repositoryService_.getRepository(repository);
        return manaRepository.getSystemSession(manaRepository.getConfiguration().getSystemWorkspaceName());
    }

    @Override
    public boolean isUsedView(String viewName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        NodeIterator iter = driveHome.getNodes();
        while (iter.hasNext()) {
            String[] views;
            Node drive = iter.nextNode();
            for (String view : views = drive.getProperty("exo:views").getString().split(",")) {
                if (!viewName.equals(view)) continue;
                session.logout();
                return true;
            }
        }
        session.logout();
        return false;
    }
}

