/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.info;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionForm;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CloseActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectUserActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectMemberActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddAnyActionListener.class})})
public class UIPermissionForm
extends UIForm
implements UISelectable {
    public static final String PERMISSION = "permission";
    public static final String POPUP_SELECT = "SelectUserOrGroup";
    private Node currentNode;

    public UIPermissionForm() throws Exception {
        this.addChild((UIComponent)new UIPermissionInputSet(PERMISSION));
        this.setActions(new String[]{"Save", "Reset", "Close"});
    }

    private void refresh() {
        this.reset();
        this.checkAll(false);
    }

    private void checkAll(boolean check) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        for (String perm : PermissionType.ALL) {
            uiInputSet.getUIFormCheckBoxInput(perm).setChecked(check);
        }
    }

    protected boolean isEditable(Node node) throws Exception {
        return PermissionUtil.canChangePermission((Node)node);
    }

    public void fillForm(String user, ExtendedNode node) throws Exception {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        this.refresh();
        uiInputSet.getUIStringInput("userOrGroup").setValue((Object)user);
        if (user.equals(Utils.getNodeOwner((Node)node))) {
            for (String perm : PermissionType.ALL) {
                uiInputSet.getUIFormCheckBoxInput(perm).setChecked(true);
            }
        } else {
            List permsList = node.getACL().getPermissionEntries();
            Iterator perIter = permsList.iterator();
            StringBuilder userPermission = new StringBuilder();
            while (perIter.hasNext()) {
                AccessControlEntry accessControlEntry = (AccessControlEntry)perIter.next();
                if (!user.equals(accessControlEntry.getIdentity())) continue;
                userPermission.append(accessControlEntry.getPermission()).append(" ");
            }
            for (String perm : PermissionType.ALL) {
                boolean isCheck = userPermission.toString().contains(perm);
                uiInputSet.getUIFormCheckBoxInput(perm).setChecked(isCheck);
            }
        }
    }

    protected void lockForm(boolean isLock) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        if (isLock) {
            this.setActions(new String[]{"Reset", "Close"});
            uiInputSet.setActionInfo("userOrGroup", null);
        } else {
            this.setActions(new String[]{"Save", "Reset", "Close"});
            uiInputSet.setActionInfo("userOrGroup", new String[]{"SelectUser", "SelectMember", "AddAny"});
        }
        for (String perm : PermissionType.ALL) {
            uiInputSet.getUIFormCheckBoxInput(perm).setEnable(!isLock);
        }
    }

    public void doSelect(String selectField, Object value) {
        this.getUIStringInput(selectField).setValue((Object)value.toString());
        this.checkAll(false);
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    static /* synthetic */ void access$000(UIPermissionForm x0) {
        x0.refresh();
    }

    static /* synthetic */ void access$100(UIPermissionForm x0, boolean x1) {
        x0.checkAll(x1);
    }
}

