/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionInfo;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionInfo.msg.confirm-delete-permission"), @EventConfig(listeners={EditActionListener.class})})
public class UIPermissionInfo
extends UIContainer {
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups", "read", "addNode", "setProperty", "remove"};
    private static String[] PERMISSION_ACTION = new String[]{"Edit", "Delete"};
    private Node currentNode = null;
    private int sizeOfListPermission = 0;

    public UIPermissionInfo() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, "PermissionInfo");
        this.addChild((UIComponent)uiGrid);
        uiGrid.getUIPageIterator().setId("PermissionInfoIterator");
        uiGrid.configure("usersOrGroups", PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    private String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner((Node)node);
    }

    public void updateGrid() throws Exception {
        ArrayList<PermissionBean> permBeans = new ArrayList<PermissionBean>();
        ExtendedNode node = (ExtendedNode)this.currentNode;
        List permsList = node.getACL().getPermissionEntries();
        HashMap permsMap = new HashMap();
        for (AccessControlEntry accessControlEntry : permsList) {
            String currentIdentity = accessControlEntry.getIdentity();
            String currentPermission = accessControlEntry.getPermission();
            ArrayList<String> currentPermissionsList = (ArrayList<String>)permsMap.get(currentIdentity);
            if (!permsMap.containsKey(currentIdentity)) {
                permsMap.put(currentIdentity, null);
            }
            if (currentPermissionsList == null) {
                currentPermissionsList = new ArrayList<String>();
            }
            if (!currentPermissionsList.contains(currentPermission)) {
                currentPermissionsList.add(currentPermission);
            }
            permsMap.put(currentIdentity, currentPermissionsList);
        }
        Set keys = permsMap.keySet();
        Iterator keysIter = keys.iterator();
        String owner = SystemIdentity.SYSTEM;
        if (this.getExoOwner((Node)node) != null) {
            owner = this.getExoOwner((Node)node);
        }
        PermissionBean permOwnerBean = new PermissionBean(this);
        if (!permsMap.containsKey(owner)) {
            permOwnerBean.setUsersOrGroups(owner);
            permOwnerBean.setRead(true);
            permOwnerBean.setAddNode(true);
            permOwnerBean.setSetProperty(true);
            permOwnerBean.setRemove(true);
            permBeans.add(permOwnerBean);
        }
        while (keysIter.hasNext()) {
            String userOrGroup = (String)keysIter.next();
            List permissions = (List)permsMap.get(userOrGroup);
            PermissionBean permBean = new PermissionBean(this);
            permBean.setUsersOrGroups(userOrGroup);
            for (String perm : permissions) {
                if ("read".equals(perm)) {
                    permBean.setRead(true);
                    continue;
                }
                if ("add_node".equals(perm)) {
                    permBean.setAddNode(true);
                    continue;
                }
                if ("set_property".equals(perm)) {
                    permBean.setSetProperty(true);
                    continue;
                }
                if (!"remove".equals(perm)) continue;
                permBean.setRemove(true);
            }
            permBeans.add(permBean);
        }
        this.sizeOfListPermission = permBeans.size();
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        ObjectPageList objPageList = new ObjectPageList(permBeans, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
    }

    private Session getSession() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String systemWorkspace = repositoryService.getCurrentRepository().getConfiguration().getSystemWorkspaceName();
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Session session = SessionProviderFactory.createSystemProvider().getSession(systemWorkspace, manageableRepository);
        return session;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    public int getSizeOfListPermission() {
        return this.sizeOfListPermission;
    }

    public void setSizeOfListPermission(int sizeOfListPermission) {
        this.sizeOfListPermission = sizeOfListPermission;
    }

    static /* synthetic */ String access$000(UIPermissionInfo x0, Node x1) throws Exception {
        return x0.getExoOwner(x1);
    }

    static /* synthetic */ Session access$100(UIPermissionInfo x0) throws Exception {
        return x0.getSession();
    }
}

