/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.comparator.ItemOptionNameComparator;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentPortlet;
import org.exoplatform.ecm.webui.component.browsecontent.UIConfigContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UIDocumentConfig;
import org.exoplatform.ecm.webui.component.browsecontent.UINewConfigForm;
import org.exoplatform.ecm.webui.component.browsecontent.UIPathConfig;
import org.exoplatform.ecm.webui.component.browsecontent.UIQueryConfig;
import org.exoplatform.ecm.webui.component.browsecontent.UIScriptConfig;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIConfigTabPane
extends UIContainer {
    public static final String PATH_SELECTOR = "pathSelector";
    public static final String DOCUMENT_SELECTOR = "documentSelector";
    public static final String CONFIGTYPE = "configType";
    private boolean isNewConfig_ = false;
    private boolean isChanged_ = false;

    public UIConfigTabPane() throws Exception {
        ((UINewConfigForm)this.addChild(UINewConfigForm.class, null, null)).setRendered(false);
        this.addChild(UIConfigContainer.class, null, null);
    }

    protected boolean isNewConfig() {
        return this.isNewConfig_;
    }

    protected void setNewConfig(boolean isNew) {
        this.isNewConfig_ = isNew;
    }

    public List<SelectItemOption<String>> getWorkSpaceOption() throws Exception {
        String[] workspaceNames;
        ArrayList<SelectItemOption<String>> Options = new ArrayList<SelectItemOption<String>>();
        String repository = ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPreferenceRepository();
        for (String workspace : workspaceNames = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getWorkspaceNames()) {
            Options.add((SelectItemOption<String>)new SelectItemOption(workspace, (Object)workspace));
        }
        return Options;
    }

    public List<SelectItemOption<String>> getBoxTemplateOption(String repository) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List docTemplates = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllTemplates("cbDetaiViewTemplates", repository, SessionProviderFactory.createSystemProvider());
        for (Node template : docTemplates) {
            options.add((SelectItemOption<String>)new SelectItemOption(template.getName(), (Object)template.getName()));
        }
        Collections.sort(options, new ItemOptionNameComparator());
        return options;
    }

    public void setIsChangeValue(boolean isChanged) {
        this.isChanged_ = isChanged;
    }

    public void getCurrentConfig() throws Exception {
        PortletPreferences preference = ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPortletPreferences();
        UINewConfigForm uiConfigForm = (UINewConfigForm)this.getChild(UINewConfigForm.class);
        uiConfigForm.setRendered(false);
        UIConfigContainer uiConfigContainer = (UIConfigContainer)this.getChild(UIConfigContainer.class);
        String repository = preference.getValue(Utils.REPOSITORY, "");
        String usecase = preference.getValue(Utils.CB_USECASE, "");
        String workspace = preference.getValue(Utils.WORKSPACE_NAME, "");
        if (usecase.equals(Utils.CB_USE_FROM_PATH)) {
            UIPathConfig uiPathConfig = (UIPathConfig)uiConfigContainer.getChild(UIPathConfig.class);
            if (uiPathConfig == null) {
                uiPathConfig = (UIPathConfig)uiConfigContainer.addChild(UIPathConfig.class, null, null);
            }
            if (!this.isChanged_) {
                uiPathConfig.initForm(preference, repository, workspace, false);
            }
            uiConfigContainer.setRenderedChild(UIPathConfig.class);
        } else if (usecase.equals(Utils.CB_USE_JCR_QUERY)) {
            UIQueryConfig uiQueryConfig = (UIQueryConfig)uiConfigContainer.getChild(UIQueryConfig.class);
            if (uiQueryConfig == null) {
                uiQueryConfig = (UIQueryConfig)uiConfigContainer.addChild(UIQueryConfig.class, null, null);
            }
            uiQueryConfig.initForm(preference, repository, workspace, false);
            uiConfigContainer.setRenderedChild(UIQueryConfig.class);
        } else if (usecase.equals(Utils.CB_USE_SCRIPT)) {
            UIScriptConfig uiScriptConfig = (UIScriptConfig)uiConfigContainer.getChild(UIScriptConfig.class);
            if (uiScriptConfig == null) {
                uiScriptConfig = (UIScriptConfig)uiConfigContainer.addChild(UIScriptConfig.class, null, null);
            }
            uiScriptConfig.initForm(preference, repository, workspace, false);
            uiConfigContainer.setRenderedChild(UIScriptConfig.class);
        } else if (usecase.equals(Utils.CB_USE_DOCUMENT)) {
            UIDocumentConfig uiDocumentConfig = (UIDocumentConfig)uiConfigContainer.getChild(UIDocumentConfig.class);
            if (uiDocumentConfig == null) {
                uiDocumentConfig = (UIDocumentConfig)uiConfigContainer.addChild(UIDocumentConfig.class, null, null);
            }
            uiDocumentConfig.initForm(preference, repository, workspace, false);
            uiConfigContainer.setRenderedChild(UIDocumentConfig.class);
        }
        uiConfigContainer.setRendered(true);
    }

    public void showNewConfigForm(boolean isAddNew) throws Exception {
        UINewConfigForm uiConfigForm = (UINewConfigForm)this.getChild(UINewConfigForm.class);
        UIConfigContainer uiConfigContainer = (UIConfigContainer)this.getChild(UIConfigContainer.class);
        if (isAddNew) {
            uiConfigForm.resetForm();
        }
        uiConfigForm.setRendered(true);
        uiConfigContainer.setRendered(false);
    }

    public void initNewConfig(String usercase, String repository, String workSpace) throws Exception {
        UINewConfigForm uiConfigForm = (UINewConfigForm)this.getChild(UINewConfigForm.class);
        uiConfigForm.setRendered(false);
        UIConfigContainer uiConfigContainer = (UIConfigContainer)this.getChild(UIConfigContainer.class);
        uiConfigContainer.initNewConfig(usercase, repository, workSpace);
        uiConfigContainer.setRendered(true);
    }

    public void initPopupPathSelect(UIForm uiForm, String repo, String workSpace, String fieldName, boolean isDisable) throws Exception {
        this.removeChildById(PATH_SELECTOR);
        this.removeChildById(DOCUMENT_SELECTOR);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, PATH_SELECTOR);
        uiPopup.setWindowSize(610, 300);
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)this.createUIComponent(UIOneNodePathSelector.class, null, null);
        if (isDisable) {
            uiOneNodePathSelector.setIsDisable(workSpace, true);
        }
        String[] filterType = new String[]{"nt:folder", "nt:unstructured", "exo:taxonomy"};
        uiOneNodePathSelector.setAcceptedNodeTypesInPathPanel(filterType);
        uiOneNodePathSelector.setShowRootPathSelect(true);
        uiOneNodePathSelector.setRootNodeLocation(repo, workSpace, "/");
        if (SessionProviderFactory.isAnonim()) {
            uiOneNodePathSelector.init(SessionProviderFactory.createAnonimProvider());
        } else {
            uiOneNodePathSelector.init(SessionProviderFactory.createSessionProvider());
        }
        uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
        uiOneNodePathSelector.setSourceComponent((UIComponent)uiForm, new String[]{fieldName});
        uiPopup.setShow(true);
    }

    public void initPopupPathSelect(UIForm uiForm, String repo, String workSpace, String fieldName, boolean isDisable, boolean isAllowPublish) throws Exception {
        this.removeChildById(PATH_SELECTOR);
        this.removeChildById(DOCUMENT_SELECTOR);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, PATH_SELECTOR);
        uiPopup.setWindowSize(610, 300);
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)this.createUIComponent(UIOneNodePathSelector.class, null, null);
        if (isDisable) {
            uiOneNodePathSelector.setIsDisable(workSpace, true);
        }
        String[] filterType = new String[]{"nt:folder", "nt:unstructured", "exo:taxonomy"};
        uiOneNodePathSelector.setAcceptedNodeTypesInPathPanel(filterType);
        uiOneNodePathSelector.setAllowPublish(isAllowPublish);
        uiOneNodePathSelector.setShowRootPathSelect(true);
        uiOneNodePathSelector.setRootNodeLocation(repo, workSpace, "/");
        if (SessionProviderFactory.isAnonim()) {
            uiOneNodePathSelector.init(SessionProviderFactory.createAnonimProvider());
        } else {
            uiOneNodePathSelector.init(SessionProviderFactory.createSessionProvider());
        }
        uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
        uiOneNodePathSelector.setSourceComponent((UIComponent)uiForm, new String[]{fieldName});
        uiPopup.setShow(true);
    }

    public void initPopupDocumentSelect(UIForm uiForm, String repo, String workSpace, String path, boolean isAllowPublish) throws Exception {
        this.removeChildById(PATH_SELECTOR);
        this.removeChildById(DOCUMENT_SELECTOR);
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, DOCUMENT_SELECTOR);
        uiPopup.setWindowSize(610, 300);
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)this.createUIComponent(UIOneNodePathSelector.class, null, null);
        uiOneNodePathSelector.setIsDisable(workSpace, true);
        uiOneNodePathSelector.setRootNodeLocation(repo, workSpace, path);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documents = templateService.getDocumentTemplates(repo);
        String[] filterType = new String[documents.size()];
        documents.toArray(filterType);
        uiOneNodePathSelector.setAcceptedNodeTypesInPathPanel(filterType);
        uiOneNodePathSelector.setAllowPublish(isAllowPublish);
        if (SessionProviderFactory.isAnonim()) {
            uiOneNodePathSelector.init(SessionProviderFactory.createAnonimProvider());
        } else {
            uiOneNodePathSelector.init(SessionProviderFactory.createSessionProvider());
        }
        uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
        uiOneNodePathSelector.setSourceComponent((UIComponent)uiForm, new String[]{"docName"});
        uiPopup.setShow(true);
    }
}

