/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.comparator.ItemOptionNameComparator;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentPortlet;
import org.exoplatform.ecm.webui.component.browsecontent.UIConfigTabPane;
import org.exoplatform.ecm.webui.component.browsecontent.UINewConfigForm;
import org.exoplatform.ecm.webui.component.browsecontent.UIPathConfig;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddPathActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeRepoActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeWorkspaceActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EnableSearchActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddSearchLocationActionListener.class})})
public class UIPathConfig
extends UIForm
implements UISelectable {
    public static final String FIELD_PATHSELECT = "path";
    public static final String FIELD_SEARCH_PATHSELECT = "searchPath";
    private static final String FIELD_SEARCH_EXPLAIN = "explain";
    protected boolean isEdit_ = false;
    private List<String> repoNames_ = new ArrayList();
    private List<String> wsNames_ = new ArrayList();

    public UIPathConfig() throws Exception {
        ArrayList Options = new ArrayList();
        ArrayList repositories = new ArrayList();
        ArrayList workspaces = new ArrayList();
        UIFormSelectBox repository = new UIFormSelectBox("repository", "repository", repositories);
        repository.setOnChange("ChangeRepo");
        this.addChild((UIComponent)repository);
        UIFormSelectBox workspace = new UIFormSelectBox("workspace", "workspace", workspaces);
        workspace.setOnChange("ChangeWorkspace");
        this.addChild((UIComponent)workspace);
        UIFormInputSetWithAction categoryPathSelect = new UIFormInputSetWithAction(FIELD_PATHSELECT);
        categoryPathSelect.addUIFormInput((UIFormInput)new UIFormStringInput("categoryPath", null, null));
        this.addUIComponentInput((UIComponent)categoryPathSelect);
        UIFormCheckBoxInput uiEnableSearch = new UIFormCheckBoxInput("searchEnable", null, null);
        uiEnableSearch.setOnChange("EnableSearch");
        this.addChild((UIComponent)uiEnableSearch);
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String explainMsg = res.getString("UIPathConfig.msg.explain");
        UIFormInputSetWithAction uiSearchPathSelect = new UIFormInputSetWithAction(FIELD_SEARCH_PATHSELECT);
        uiSearchPathSelect.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_SEARCH_EXPLAIN, null, explainMsg));
        uiSearchPathSelect.addUIFormInput((UIFormInput)new UIFormStringInput("searchLocation", null, null).setEditable(false));
        this.addUIComponentInput((UIComponent)uiSearchPathSelect);
        this.addChild((UIComponent)new UIFormCheckBoxInput("filterCategory", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput(UINewConfigForm.FIELD_ALLOW_PUBLISH, null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableRefDoc", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableChildDoc", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableTagMap", null, null));
        this.addChild((UIComponent)new UIFormSelectBox("template", null, Options));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableToolBar", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableComment", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableVote", null, null));
        this.addChild((UIComponent)new UIFormStringInput("itemPerPage", null, null));
        this.addChild((UIComponent)new UIFormSelectBox("detailBoxTemp", null, Options));
        this.setActions(UINewConfigForm.DEFAULT_ACTION);
    }

    public List<SelectItemOption<String>> getWorkSpaceOption() throws Exception {
        UIConfigTabPane uiTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        return uiTabPane.getWorkSpaceOption();
    }

    public PortletPreferences getPortletPreferences() {
        return ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPortletPreferences();
    }

    private List<SelectItemOption<String>> getRepoOption() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        this.repoNames_.clear();
        for (RepositoryEntry repo : repositoryService.getConfig().getRepositoryConfigurations()) {
            this.repoNames_.add(repo.getName());
            options.add((SelectItemOption<String>)new SelectItemOption(repo.getName(), (Object)repo.getName()));
        }
        return options;
    }

    private ManageableRepository getRepository(String repositoryName) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(repositoryName);
    }

    private List<SelectItemOption<String>> getWorkSpaceOption(String repository) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        String[] workspaceNames = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getWorkspaceNames();
        this.wsNames_.clear();
        for (String workspace : workspaceNames) {
            Session session = SessionProviderFactory.createSessionProvider().getSession(workspace, this.getRepository(repository));
            try {
                session.getRootNode();
                this.wsNames_.add(workspace);
                options.add((SelectItemOption<String>)new SelectItemOption(workspace, (Object)workspace));
            }
            catch (AccessDeniedException ace) {
                // empty catch block
            }
        }
        return options;
    }

    public void initForm(PortletPreferences preference, String repository, String workSpace, boolean isAddNew) throws Exception {
        String searchLocationValue;
        String path = preference.getValue(Utils.JCR_PATH, "");
        boolean isAllowPublish = Boolean.parseBoolean(preference.getValue(Utils.CB_ALLOW_PUBLISH, ""));
        String hasSearchLocation = preference.getValue(Utils.CB_ENABLE_SEARCH_LOCATION, "");
        if (hasSearchLocation == null || hasSearchLocation.length() < 1) {
            hasSearchLocation = "false";
        }
        String hasToolBar = "true";
        String filterCategory = "true";
        String hasRefDoc = "true";
        String hasChildDoc = "true";
        String hasTagMap = "true";
        String hasComment = "true";
        String hasVote = "true";
        String itemPerPage = "20";
        String template = "";
        String detailTemp = "";
        UIFormInputSetWithAction searchPathSelect = (UIFormInputSetWithAction)this.getChildById(FIELD_SEARCH_PATHSELECT);
        UIFormStringInput searchLocationInput = (UIFormStringInput)this.findComponentById("searchLocation");
        if (Boolean.parseBoolean(hasSearchLocation) && (searchLocationValue = preference.getValue(Utils.CB_SEARCH_LOCATION, "")) != null && searchLocationValue.length() > 0) {
            searchLocationInput.setValue((Object)searchLocationValue);
        }
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String currentRepositoryName = repositoryService.getCurrentRepository().getConfiguration().getName();
        UIFormSelectBox repositoryField = (UIFormSelectBox)this.getChildById("repository");
        repositoryField.setOptions(this.getRepoOption());
        if (!this.repoNames_.contains(repository)) {
            repository = (String)((SelectItemOption)this.getRepoOption().get(0)).getValue();
        }
        repositoryField.setValue(repository);
        UIFormSelectBox workSpaceField = (UIFormSelectBox)this.getChildById("workspace");
        workSpaceField.setOptions(this.getWorkSpaceOption(repository));
        if (!this.wsNames_.contains(workSpace)) {
            workSpace = repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        workSpaceField.setValue(workSpace);
        UIFormInputSetWithAction categoryPathSelect = (UIFormInputSetWithAction)this.getChildById(FIELD_PATHSELECT);
        UIFormStringInput categoryPathField = (UIFormStringInput)categoryPathSelect.getChildById("categoryPath");
        categoryPathField.setEditable(false);
        UIFormSelectBox templateField = (UIFormSelectBox)this.getChildById("template");
        UIFormStringInput numbPerPageField = (UIFormStringInput)this.getChildById("itemPerPage");
        UIFormSelectBox detailtemField = (UIFormSelectBox)this.getChildById("detailBoxTemp");
        UIConfigTabPane uiConfigTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        UIFormCheckBoxInput enableFilterCategory = (UIFormCheckBoxInput)this.getChildById("filterCategory");
        UIFormCheckBoxInput enableToolBarField = (UIFormCheckBoxInput)this.getChildById("enableToolBar");
        UIFormCheckBoxInput enablePublishField = (UIFormCheckBoxInput)this.getChildById(UINewConfigForm.FIELD_ALLOW_PUBLISH);
        UIFormCheckBoxInput enableRefDocField = (UIFormCheckBoxInput)this.getChildById("enableRefDoc");
        UIFormCheckBoxInput enableChildDocField = (UIFormCheckBoxInput)this.getChildById("enableChildDoc");
        UIFormCheckBoxInput enableTagMapField = (UIFormCheckBoxInput)this.getChildById("enableTagMap");
        UIFormCheckBoxInput enableCommentField = (UIFormCheckBoxInput)this.getChildById("enableComment");
        UIFormCheckBoxInput enableVoteField = (UIFormCheckBoxInput)this.getChildById("enableVote");
        UIFormCheckBoxInput enableSearchLocation = (UIFormCheckBoxInput)this.getChildById("searchEnable");
        if (this.isEdit_) {
            categoryPathSelect.setActionInfo("categoryPath", new String[]{"AddPath"});
            if (enableSearchLocation.isChecked()) {
                searchPathSelect.setActionInfo("searchLocation", new String[]{"AddSearchLocation"});
            } else {
                searchPathSelect.setActionInfo("searchLocation", null);
            }
            if (isAddNew) {
                templateField.setOptions(this.getTemplateOption(repository));
                detailtemField.setOptions(uiConfigTabPane.getBoxTemplateOption(repository));
                enableFilterCategory.setChecked(Boolean.parseBoolean(filterCategory));
                enableToolBarField.setChecked(Boolean.parseBoolean(hasToolBar));
                enablePublishField.setChecked(isAllowPublish);
                enableRefDocField.setChecked(Boolean.parseBoolean(hasRefDoc));
                enableChildDocField.setChecked(Boolean.parseBoolean(hasChildDoc));
                enableTagMapField.setChecked(Boolean.parseBoolean(hasTagMap));
                enableCommentField.setChecked(Boolean.parseBoolean(hasComment));
                enableVoteField.setChecked(Boolean.parseBoolean(hasVote));
                enableSearchLocation.setChecked(Boolean.parseBoolean(hasSearchLocation));
                numbPerPageField.setValue((Object)itemPerPage);
                this.setActions(UINewConfigForm.ADD_NEW_ACTION);
            } else {
                this.setActions(UINewConfigForm.NORMAL_ACTION);
            }
        } else {
            categoryPathSelect.setActionInfo("categoryPath", null);
            searchPathSelect.setActionInfo("searchLocation", null);
            this.setActions(UINewConfigForm.DEFAULT_ACTION);
            repository = preference.getValue(Utils.REPOSITORY, "");
            workSpace = preference.getValue(Utils.WORKSPACE_NAME, "");
            template = preference.getValue("template", "");
            filterCategory = preference.getValue(Utils.CB_FILTER_CATEGORY, "");
            hasToolBar = preference.getValue(Utils.CB_VIEW_TOOLBAR, "");
            hasRefDoc = preference.getValue(Utils.CB_REF_DOCUMENT, "");
            hasChildDoc = preference.getValue(Utils.CB_CHILD_DOCUMENT, "");
            hasTagMap = preference.getValue(Utils.CB_VIEW_TAGMAP, "");
            hasComment = preference.getValue(Utils.CB_VIEW_COMMENT, "");
            hasVote = preference.getValue(Utils.CB_VIEW_VOTE, "");
            hasSearchLocation = preference.getValue(Utils.CB_ENABLE_SEARCH_LOCATION, "");
            itemPerPage = preference.getValue(Utils.CB_NB_PER_PAGE, "");
            detailTemp = preference.getValue(Utils.CB_BOX_TEMPLATE, "");
            if (!this.repoNames_.contains(repository)) {
                repository = currentRepositoryName;
            }
            templateField.setOptions(this.getTemplateOption(repository));
            templateField.setValue(template);
            detailtemField.setOptions(uiConfigTabPane.getBoxTemplateOption(repository));
            detailtemField.setValue(detailTemp);
            repositoryField.setValue(repository);
            workSpaceField.setValue(workSpace);
            enableFilterCategory.setChecked(Boolean.parseBoolean(filterCategory));
            enableToolBarField.setChecked(Boolean.parseBoolean(hasToolBar));
            enablePublishField.setChecked(isAllowPublish);
            enableRefDocField.setChecked(Boolean.parseBoolean(hasRefDoc));
            enableChildDocField.setChecked(Boolean.parseBoolean(hasChildDoc));
            enableTagMapField.setChecked(Boolean.parseBoolean(hasTagMap));
            enableCommentField.setChecked(Boolean.parseBoolean(hasComment));
            enableVoteField.setChecked(Boolean.parseBoolean(hasVote));
            enableSearchLocation.setChecked(Boolean.parseBoolean(hasSearchLocation));
            categoryPathField.setValue((Object)path);
            numbPerPageField.setValue((Object)itemPerPage);
        }
        templateField.setEnable(this.isEdit_);
        enableFilterCategory.setEnable(this.isEdit_);
        detailtemField.setEnable(this.isEdit_);
        enableToolBarField.setEnable(this.isEdit_);
        enablePublishField.setEnable(this.isEdit_);
        enableRefDocField.setEnable(this.isEdit_);
        enableCommentField.setEnable(this.isEdit_);
        enableVoteField.setEnable(this.isEdit_);
        enableSearchLocation.setEnable(this.isEdit_);
        enableTagMapField.setEnable(this.isEdit_);
        numbPerPageField.setEditable(this.isEdit_);
        enableChildDocField.setEnable(this.isEdit_);
        repositoryField.setEnable(this.isEdit_);
        workSpaceField.setEnable(this.isEdit_);
    }

    public List<SelectItemOption<String>> getTemplateOption(String repository) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ManageViewService viewService = (ManageViewService)PortalContainer.getComponent(ManageViewService.class);
        List scriptTemplates = viewService.getAllTemplates("cbPathTemplates", repository, SessionProviderFactory.createSystemProvider());
        for (Node template : scriptTemplates) {
            options.add((SelectItemOption<String>)new SelectItemOption(template.getName(), (Object)template.getName()));
        }
        Collections.sort(options, new ItemOptionNameComparator());
        return options;
    }

    public void doSelect(String selectField, Object value) {
        UIFormStringInput uiPath = (UIFormStringInput)this.findComponentById(selectField);
        uiPath.setValue((Object)value.toString());
        UIConfigTabPane uiConfigTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        UIPopupWindow uiPopupWindow = (UIPopupWindow)uiConfigTabPane.getChild(UIPopupWindow.class);
        uiPopupWindow.setShow(false);
        this.isEdit_ = true;
        uiConfigTabPane.setNewConfig(true);
    }

    static /* synthetic */ List access$000(UIPathConfig x0, String x1) throws Exception {
        return x0.getWorkSpaceOption(x1);
    }
}

